/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRResourcesUtil;

public class JRImageLoader {
    public static final byte NO_IMAGE = 1;
    public static final byte SUBREPORT_IMAGE = 2;
    public static final byte CHART_IMAGE = 3;
    public static final byte CROSSTAB_IMAGE = 4;
    private static final String str_NO_IMAGE = "net/sf/jasperreports/engine/images/noimage.GIF";
    private static final String str_SUBREPORT_IMAGE = "net/sf/jasperreports/engine/images/subreport.GIF";
    private static final String str_CHART_IMAGE = "net/sf/jasperreports/engine/images/chart.GIF";
    private static final String str_CROSSTAB_IMAGE = "net/sf/jasperreports/engine/images/crosstab.GIF";
    private static Image img_NO_IMAGE = null;
    private static Image img_SUBREPORT_IMAGE = null;
    private static Image img_CHART_IMAGE = null;
    private static Image img_CROSSTAB_IMAGE = null;

    public static byte[] loadImageDataFromFile(File file) throws JRException {
        try {
            return JRLoader.loadBytes(file);
        }
        catch (JRException jRException) {
            throw new JRException("Error loading image data : " + file, jRException);
        }
    }

    public static byte[] loadImageDataFromURL(URL uRL) throws JRException {
        try {
            return JRLoader.loadBytes(uRL);
        }
        catch (JRException jRException) {
            throw new JRException("Error loading image data : " + uRL, jRException);
        }
    }

    public static byte[] loadImageDataFromInputStream(InputStream inputStream) throws JRException {
        try {
            return JRLoader.loadBytes(inputStream);
        }
        catch (JRException jRException) {
            throw new JRException("Error loading image data from input stream.", jRException);
        }
    }

    public static byte[] loadImageDataFromLocation(String string) throws JRException {
        return JRImageLoader.loadImageDataFromLocation(string, null, null);
    }

    public static byte[] loadImageDataFromLocation(String string, ClassLoader classLoader) throws JRException {
        return JRImageLoader.loadImageDataFromLocation(string, classLoader, null);
    }

    public static byte[] loadImageDataFromLocation(String string, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) throws JRException {
        URL uRL = JRResourcesUtil.createURL(string, uRLStreamHandlerFactory);
        if (uRL != null) {
            return JRImageLoader.loadImageDataFromURL(uRL);
        }
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            return JRImageLoader.loadImageDataFromFile(file);
        }
        uRL = JRResourcesUtil.findClassLoaderResource(string, classLoader, JRImageLoader.class);
        if (uRL != null) {
            return JRImageLoader.loadImageDataFromURL(uRL);
        }
        throw new JRException("Image not found : " + string);
    }

    public static byte[] loadImageDataFromAWTImage(BufferedImage bufferedImage) throws JRException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder(byteArrayOutputStream);
            JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
            jPEGEncodeParam.setQuality(1.0f, true);
            jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
        }
        catch (IOException iOException) {
            throw new JRException("Error trying to load image data from AWT image.", iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] loadImageDataFromAWTImage(Image image) throws JRException {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return JRImageLoader.loadImageDataFromAWTImage(bufferedImage);
    }

    public static Image getImage(byte by) throws JRException {
        Image image = null;
        switch (by) {
            case 1: {
                if (img_NO_IMAGE == null) {
                    img_NO_IMAGE = JRImageLoader.loadImage(str_NO_IMAGE);
                }
                image = img_NO_IMAGE;
                break;
            }
            case 2: {
                if (img_SUBREPORT_IMAGE == null) {
                    img_SUBREPORT_IMAGE = JRImageLoader.loadImage(str_SUBREPORT_IMAGE);
                }
                image = img_SUBREPORT_IMAGE;
                break;
            }
            case 3: {
                if (img_CHART_IMAGE == null) {
                    img_CHART_IMAGE = JRImageLoader.loadImage(str_CHART_IMAGE);
                }
                image = img_CHART_IMAGE;
                break;
            }
            case 4: {
                if (img_CROSSTAB_IMAGE == null) {
                    img_CROSSTAB_IMAGE = JRImageLoader.loadImage(str_CROSSTAB_IMAGE);
                }
                image = img_CROSSTAB_IMAGE;
            }
        }
        return image;
    }

    public static Image loadImage(byte[] byArray) throws JRException {
        Image image = Toolkit.getDefaultToolkit().createImage(byArray);
        MediaTracker mediaTracker = new MediaTracker(new Panel());
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (Exception exception) {
            throw new JRException(exception);
        }
        if (mediaTracker.isErrorID(0)) {
            throw new JRException("Image failed to load.");
        }
        return image;
    }

    protected static Image loadImage(String string) throws JRException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            classLoader = JRImageLoader.class.getClassLoader();
        }
        InputStream inputStream = classLoader == null ? JRImageLoader.class.getResourceAsStream("/" + string) : classLoader.getResourceAsStream(string);
        return JRImageLoader.loadImage(JRImageLoader.loadImageDataFromInputStream(inputStream));
    }
}

