/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.renderers;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRImageMapRenderer;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImageArea;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.renderers.JFreeChartRenderer;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;

public abstract class JRAbstractChartImageMapRenderer
extends JFreeChartRenderer
implements JRImageMapRenderer {
    private static final long serialVersionUID = 10200L;

    public JRAbstractChartImageMapRenderer(JFreeChart jFreeChart) {
        super(jFreeChart);
    }

    public List getImageAreaHyperlinks(Rectangle2D rectangle2D) throws JRException {
        ChartRenderingInfo chartRenderingInfo = new ChartRenderingInfo();
        this.getChart().createBufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), chartRenderingInfo);
        EntityCollection entityCollection = chartRenderingInfo.getEntityCollection();
        ArrayList<JRPrintImageAreaHyperlink> arrayList = null;
        if (entityCollection != null && entityCollection.getEntityCount() > 0) {
            arrayList = new ArrayList<JRPrintImageAreaHyperlink>(entityCollection.getEntityCount());
            Iterator iterator = entityCollection.iterator();
            while (iterator.hasNext()) {
                ChartEntity chartEntity = (ChartEntity)iterator.next();
                JRPrintHyperlink jRPrintHyperlink = this.getEntityHyperlink(chartEntity);
                if (jRPrintHyperlink == null) continue;
                JRPrintImageArea jRPrintImageArea = this.getImageArea(chartEntity);
                JRPrintImageAreaHyperlink jRPrintImageAreaHyperlink = new JRPrintImageAreaHyperlink();
                jRPrintImageAreaHyperlink.setArea(jRPrintImageArea);
                jRPrintImageAreaHyperlink.setHyperlink(jRPrintHyperlink);
                arrayList.add(jRPrintImageAreaHyperlink);
            }
        }
        return arrayList;
    }

    protected JRPrintImageArea getImageArea(ChartEntity chartEntity) {
        JRPrintImageArea jRPrintImageArea = new JRPrintImageArea();
        jRPrintImageArea.setShape(JRPrintImageArea.getShape(chartEntity.getShapeType()));
        int[] nArray = this.getCoordinates(chartEntity);
        if (nArray != null) {
            jRPrintImageArea.setCoordinates(nArray);
        }
        return jRPrintImageArea;
    }

    protected int[] getCoordinates(ChartEntity chartEntity) {
        int[] nArray = null;
        String string = chartEntity.getShapeCoords();
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            nArray = new int[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                nArray[n] = Integer.parseInt(string2);
                ++n;
            }
        }
        return nArray;
    }

    protected abstract JRPrintHyperlink getEntityHyperlink(ChartEntity var1);
}

