/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.renderer.Outlier;
import org.jfree.chart.renderer.OutlierList;
import org.jfree.chart.renderer.OutlierListCollection;
import org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class BoxAndWhiskerRenderer
extends AbstractCategoryItemRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 632027470694481177L;
    private transient Paint artifactPaint = Color.black;
    private boolean fillBox = true;
    private double itemMargin = 0.2;

    public Paint getArtifactPaint() {
        return this.artifactPaint;
    }

    public void setArtifactPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.artifactPaint = paint;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getFillBox() {
        return this.fillBox;
    }

    public void setFillBox(boolean bl) {
        this.fillBox = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public double getItemMargin() {
        return this.itemMargin;
    }

    public void setItemMargin(double d) {
        this.itemMargin = d;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public LegendItem getLegendItem(int n, int n2) {
        String string;
        CategoryPlot categoryPlot = this.getPlot();
        if (categoryPlot == null) {
            return null;
        }
        CategoryDataset categoryDataset = categoryPlot.getDataset(n);
        String string2 = string = this.getLegendItemLabelGenerator().generateLabel(categoryDataset, n2);
        String string3 = null;
        if (this.getLegendItemToolTipGenerator() != null) {
            string3 = this.getLegendItemToolTipGenerator().generateLabel(categoryDataset, n2);
        }
        String string4 = null;
        if (this.getLegendItemURLGenerator() != null) {
            string4 = this.getLegendItemURLGenerator().generateLabel(categoryDataset, n2);
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0);
        Paint paint = this.getSeriesPaint(n2);
        Paint paint2 = this.getSeriesOutlinePaint(n2);
        Stroke stroke = this.getSeriesOutlineStroke(n2);
        return new LegendItem(string, string2, string3, string4, (Shape)double_, paint, stroke, paint2);
    }

    public CategoryItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, int n, PlotRenderingInfo plotRenderingInfo) {
        CategoryItemRendererState categoryItemRendererState = super.initialise(graphics2D, rectangle2D, categoryPlot, n, plotRenderingInfo);
        CategoryAxis categoryAxis = this.getDomainAxis(categoryPlot, n);
        CategoryDataset categoryDataset = categoryPlot.getDataset(n);
        if (categoryDataset != null) {
            int n2 = categoryDataset.getColumnCount();
            int n3 = categoryDataset.getRowCount();
            double d = 0.0;
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d = rectangle2D.getHeight();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d = rectangle2D.getWidth();
            }
            double d2 = 0.0;
            double d3 = 0.0;
            if (n2 > 1) {
                d2 = categoryAxis.getCategoryMargin();
            }
            if (n3 > 1) {
                d3 = this.getItemMargin();
            }
            double d4 = d * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d2 - d3);
            if (n3 * n2 > 0) {
                categoryItemRendererState.setBarWidth(d4 / (double)(categoryDataset.getColumnCount() * categoryDataset.getRowCount()));
            } else {
                categoryItemRendererState.setBarWidth(d4);
            }
        }
        return categoryItemRendererState;
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        if (!(categoryDataset instanceof BoxAndWhiskerCategoryDataset)) {
            throw new IllegalArgumentException("BoxAndWhiskerRenderer.drawItem() : the data should be of type BoxAndWhiskerCategoryDataset only.");
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            this.drawHorizontalItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            this.drawVerticalItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2);
        }
    }

    public void drawHorizontalItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        EntityCollection entityCollection;
        Number number;
        Object object;
        double d;
        double d2;
        double d3;
        BoxAndWhiskerCategoryDataset boxAndWhiskerCategoryDataset = (BoxAndWhiskerCategoryDataset)categoryDataset;
        double d4 = categoryAxis.getCategoryEnd(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d5 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d6 = Math.abs(d4 - d5);
        double d7 = d5;
        int n3 = this.getRowCount();
        int n4 = this.getColumnCount();
        if (n3 > 1) {
            d3 = rectangle2D.getWidth() * this.getItemMargin() / (double)(n4 * (n3 - 1));
            double d8 = categoryItemRendererState.getBarWidth() * (double)n3 + d3 * (double)(n3 - 1);
            double d9 = (d6 - d8) / 2.0;
            d7 = d7 + d9 + (double)n * (categoryItemRendererState.getBarWidth() + d3);
        } else {
            d3 = (d6 - categoryItemRendererState.getBarWidth()) / 2.0;
            d7 += d3;
        }
        Paint paint = this.getItemPaint(n, n2);
        if (paint != null) {
            graphics2D.setPaint(paint);
        }
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setStroke(stroke);
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        Number number2 = boxAndWhiskerCategoryDataset.getQ1Value(n, n2);
        Number number3 = boxAndWhiskerCategoryDataset.getQ3Value(n, n2);
        Number number4 = boxAndWhiskerCategoryDataset.getMaxRegularValue(n, n2);
        Number number5 = boxAndWhiskerCategoryDataset.getMinRegularValue(n, n2);
        Rectangle2D.Double double_ = null;
        if (number2 != null && number3 != null && number4 != null && number5 != null) {
            d2 = valueAxis.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
            double d10 = valueAxis.valueToJava2D(number3.doubleValue(), rectangle2D, rectangleEdge);
            d = valueAxis.valueToJava2D(number4.doubleValue(), rectangle2D, rectangleEdge);
            double d11 = valueAxis.valueToJava2D(number5.doubleValue(), rectangle2D, rectangleEdge);
            double d12 = d7 + categoryItemRendererState.getBarWidth() / 2.0;
            graphics2D.draw(new Line2D.Double(d, d12, d10, d12));
            graphics2D.draw(new Line2D.Double(d, d7, d, d7 + categoryItemRendererState.getBarWidth()));
            graphics2D.draw(new Line2D.Double(d11, d12, d2, d12));
            graphics2D.draw(new Line2D.Double(d11, d7, d11, d7 + categoryItemRendererState.getBarWidth()));
            double_ = new Rectangle2D.Double(Math.min(d2, d10), d7, Math.abs(d2 - d10), categoryItemRendererState.getBarWidth());
            if (this.fillBox) {
                graphics2D.fill(double_);
            }
            graphics2D.draw(double_);
        }
        graphics2D.setPaint(this.artifactPaint);
        d2 = 0.0;
        Number number6 = boxAndWhiskerCategoryDataset.getMeanValue(n, n2);
        if (number6 != null) {
            double d13 = valueAxis.valueToJava2D(number6.doubleValue(), rectangle2D, rectangleEdge);
            d2 = categoryItemRendererState.getBarWidth() / 4.0;
            object = new Ellipse2D.Double(d13 - d2, d7 + d2, d2 * 2.0, d2 * 2.0);
            graphics2D.fill((Shape)object);
            graphics2D.draw((Shape)object);
        }
        if ((number = boxAndWhiskerCategoryDataset.getMedianValue(n, n2)) != null) {
            d = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
            graphics2D.draw(new Line2D.Double(d, d7, d, d7 + categoryItemRendererState.getBarWidth()));
        }
        if (categoryItemRendererState.getInfo() != null && double_ != null && (entityCollection = categoryItemRendererState.getEntityCollection()) != null) {
            object = null;
            CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (categoryToolTipGenerator != null) {
                object = categoryToolTipGenerator.generateToolTip(categoryDataset, n, n2);
            }
            String string = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                string = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, (String)object, string, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
            entityCollection.add(categoryItemEntity);
        }
    }

    public void drawVerticalItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        Serializable serializable2;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        BoxAndWhiskerCategoryDataset boxAndWhiskerCategoryDataset = (BoxAndWhiskerCategoryDataset)categoryDataset;
        double d6 = categoryAxis.getCategoryEnd(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d7 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d8 = d6 - d7;
        double d9 = d7;
        int n3 = this.getRowCount();
        int n4 = this.getColumnCount();
        if (n3 > 1) {
            d5 = rectangle2D.getWidth() * this.getItemMargin() / (double)(n4 * (n3 - 1));
            d4 = categoryItemRendererState.getBarWidth() * (double)n3 + d5 * (double)(n3 - 1);
            double d10 = (d8 - d4) / 2.0;
            d9 = d9 + d10 + (double)n * (categoryItemRendererState.getBarWidth() + d5);
        } else {
            d5 = (d8 - categoryItemRendererState.getBarWidth()) / 2.0;
            d9 += d5;
        }
        d5 = 0.0;
        Paint paint = this.getItemPaint(n, n2);
        if (paint != null) {
            graphics2D.setPaint(paint);
        }
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setStroke(stroke);
        double d11 = 0.0;
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        Number number = boxAndWhiskerCategoryDataset.getQ1Value(n, n2);
        Number number2 = boxAndWhiskerCategoryDataset.getQ3Value(n, n2);
        Number number3 = boxAndWhiskerCategoryDataset.getMaxRegularValue(n, n2);
        Number number4 = boxAndWhiskerCategoryDataset.getMinRegularValue(n, n2);
        Rectangle2D.Double double_ = null;
        if (number != null && number2 != null && number3 != null && number4 != null) {
            double d12 = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
            d3 = valueAxis.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
            d2 = valueAxis.valueToJava2D(number3.doubleValue(), rectangle2D, rectangleEdge);
            d = valueAxis.valueToJava2D(number4.doubleValue(), rectangle2D, rectangleEdge);
            double d13 = d9 + categoryItemRendererState.getBarWidth() / 2.0;
            graphics2D.draw(new Line2D.Double(d13, d2, d13, d3));
            graphics2D.draw(new Line2D.Double(d9, d2, d9 + categoryItemRendererState.getBarWidth(), d2));
            graphics2D.draw(new Line2D.Double(d13, d, d13, d12));
            graphics2D.draw(new Line2D.Double(d9, d, d9 + categoryItemRendererState.getBarWidth(), d));
            double_ = new Rectangle2D.Double(d9, Math.min(d12, d3), categoryItemRendererState.getBarWidth(), Math.abs(d12 - d3));
            if (this.fillBox) {
                graphics2D.fill(double_);
            }
            graphics2D.draw(double_);
        }
        graphics2D.setPaint(this.artifactPaint);
        Number number5 = boxAndWhiskerCategoryDataset.getMeanValue(n, n2);
        if (number5 != null) {
            d5 = valueAxis.valueToJava2D(number5.doubleValue(), rectangle2D, rectangleEdge);
            d11 = categoryItemRendererState.getBarWidth() / 4.0;
            serializable2 = new Ellipse2D.Double(d9 + d11, d5 - d11, d11 * 2.0, d11 * 2.0);
            graphics2D.fill((Shape)((Object)serializable2));
            graphics2D.draw((Shape)((Object)serializable2));
        }
        if ((serializable2 = boxAndWhiskerCategoryDataset.getMedianValue(n, n2)) != null) {
            d3 = valueAxis.valueToJava2D(serializable2.doubleValue(), rectangle2D, rectangleEdge);
            graphics2D.draw(new Line2D.Double(d9, d3, d9 + categoryItemRendererState.getBarWidth(), d3));
        }
        d3 = valueAxis.valueToJava2D(valueAxis.getUpperBound(), rectangle2D, rectangleEdge) + d11;
        d2 = valueAxis.valueToJava2D(valueAxis.getLowerBound(), rectangle2D, rectangleEdge) - d11;
        graphics2D.setPaint(paint);
        d = categoryItemRendererState.getBarWidth() / 3.0;
        ArrayList<Outlier> arrayList = new ArrayList<Outlier>();
        OutlierListCollection outlierListCollection = new OutlierListCollection();
        List list = boxAndWhiskerCategoryDataset.getOutliers(n, n2);
        if (list != null) {
            int n5 = 0;
            while (n5 < list.size()) {
                double d14 = ((Number)list.get(n5)).doubleValue();
                object3 = boxAndWhiskerCategoryDataset.getMinOutlier(n, n2);
                serializable = boxAndWhiskerCategoryDataset.getMaxOutlier(n, n2);
                Number number6 = boxAndWhiskerCategoryDataset.getMinRegularValue(n, n2);
                Number number7 = boxAndWhiskerCategoryDataset.getMaxRegularValue(n, n2);
                if (d14 > serializable.doubleValue()) {
                    outlierListCollection.setHighFarOut(true);
                } else if (d14 < ((Number)object3).doubleValue()) {
                    outlierListCollection.setLowFarOut(true);
                } else if (d14 > number7.doubleValue()) {
                    d4 = valueAxis.valueToJava2D(d14, rectangle2D, rectangleEdge);
                    arrayList.add(new Outlier(d9 + categoryItemRendererState.getBarWidth() / 2.0, d4, d));
                } else if (d14 < number6.doubleValue()) {
                    d4 = valueAxis.valueToJava2D(d14, rectangle2D, rectangleEdge);
                    arrayList.add(new Outlier(d9 + categoryItemRendererState.getBarWidth() / 2.0, d4, d));
                }
                Collections.sort(arrayList);
                ++n5;
            }
            for (Outlier outlier : arrayList) {
                outlierListCollection.add(outlier);
            }
            object2 = outlierListCollection.iterator();
            while (object2.hasNext()) {
                OutlierList outlierList = (OutlierList)object2.next();
                object = outlierList.getAveragedOutlier();
                object3 = ((Outlier)object).getPoint();
                if (outlierList.isMultiple()) {
                    this.drawMultipleEllipse((Point2D)object3, categoryItemRendererState.getBarWidth(), d, graphics2D);
                    continue;
                }
                this.drawEllipse((Point2D)object3, d, graphics2D);
            }
            if (outlierListCollection.isHighFarOut()) {
                this.drawHighFarOut(d11 / 2.0, graphics2D, d9 + categoryItemRendererState.getBarWidth() / 2.0, d3);
            }
            if (outlierListCollection.isLowFarOut()) {
                this.drawLowFarOut(d11 / 2.0, graphics2D, d9 + categoryItemRendererState.getBarWidth() / 2.0, d2);
            }
        }
        if (categoryItemRendererState.getInfo() != null && double_ != null && (object2 = categoryItemRendererState.getEntityCollection()) != null) {
            String string = null;
            object = this.getToolTipGenerator(n, n2);
            if (object != null) {
                string = object.generateToolTip(categoryDataset, n, n2);
            }
            object3 = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                object3 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
            }
            serializable = new CategoryItemEntity(double_, string, (String)object3, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
            object2.add((ChartEntity)serializable);
        }
    }

    private void drawEllipse(Point2D point2D, double d, Graphics2D graphics2D) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(point2D.getX() + d / 2.0, point2D.getY(), d, d);
        graphics2D.draw(double_);
    }

    private void drawMultipleEllipse(Point2D point2D, double d, double d2, Graphics2D graphics2D) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(point2D.getX() - d / 2.0 + d2, point2D.getY(), d2, d2);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(point2D.getX() + d / 2.0, point2D.getY(), d2, d2);
        graphics2D.draw(double_);
        graphics2D.draw(double_2);
    }

    private void drawHighFarOut(double d, Graphics2D graphics2D, double d2, double d3) {
        double d4 = d * 2.0;
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 + d4, d2 + d4, d3 + d4));
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 + d4, d2, d3));
        graphics2D.draw(new Line2D.Double(d2 + d4, d3 + d4, d2, d3));
    }

    private void drawLowFarOut(double d, Graphics2D graphics2D, double d2, double d3) {
        double d4 = d * 2.0;
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 - d4, d2 + d4, d3 - d4));
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 - d4, d2, d3));
        graphics2D.draw(new Line2D.Double(d2 + d4, d3 - d4, d2, d3));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BoxAndWhiskerRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        BoxAndWhiskerRenderer boxAndWhiskerRenderer = (BoxAndWhiskerRenderer)object;
        if (!PaintUtilities.equal(this.artifactPaint, boxAndWhiskerRenderer.artifactPaint)) {
            return false;
        }
        if (this.fillBox != boxAndWhiskerRenderer.fillBox) {
            return false;
        }
        return this.itemMargin == boxAndWhiskerRenderer.itemMargin;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.artifactPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.artifactPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

