/*
 * Decompiled with CFR 0.152.
 */
package org.swixml;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.swixml.ConverterLibrary;
import org.swixml.Factory;

public final class DefaultFactory
implements Factory {
    private final Collection setters = new ArrayList();
    private final Class template;
    protected Class[] parameterPriority = new Class[]{String.class, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE, Long.TYPE, Byte.TYPE, Integer.TYPE};

    public DefaultFactory(Class clazz) {
        this.template = clazz;
        this.registerSetters();
    }

    protected int priority(Class clazz) {
        int n = 0;
        while (n < this.parameterPriority.length) {
            if (clazz.isAssignableFrom(this.parameterPriority[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected void registerSetters() {
        Method[] methodArray = this.template.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            String string = methodArray[n].getName();
            if (string.startsWith("set") && methodArray[n].getParameterTypes().length == 1) {
                Class<?> clazz = methodArray[n].getParameterTypes()[0];
                if (ConverterLibrary.getInstance().hasConverter(clazz)) {
                    Method method = this.getSetter(string);
                    if (method != null) {
                        Class<?> clazz2;
                        Class<?> clazz3 = method.getDeclaringClass();
                        if (clazz3.equals(clazz2 = methodArray[n].getDeclaringClass())) {
                            Class<?> clazz4 = method.getParameterTypes()[0];
                            if (this.priority(clazz4) < this.priority(clazz)) {
                                this.setters.remove(method);
                                this.setters.add(methodArray[n]);
                            }
                        } else if (clazz3.isAssignableFrom(clazz2)) {
                            this.setters.remove(method);
                            this.setters.add(methodArray[n]);
                        }
                    } else {
                        this.setters.add(methodArray[n]);
                    }
                }
            }
            ++n;
        }
    }

    public Object newInstance() throws Exception {
        return this.template.newInstance();
    }

    public Object newInstance(Object object) throws Exception {
        Class<?> clazz = object.getClass();
        Constructor<?>[] constructorArray = this.template.getConstructors();
        int n = 0;
        while (n < constructorArray.length) {
            Class<?>[] classArray = constructorArray[n].getParameterTypes();
            if (classArray.length > 0 && classArray[0].isAssignableFrom(clazz)) {
                return constructorArray[n].newInstance(object);
            }
            ++n;
        }
        return this.template.newInstance();
    }

    public Object newInstance(Object[] objectArray) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (objectArray != null) {
            Class[] classArray = new Class[objectArray.length];
            Constructor<?>[] constructorArray = this.template.getConstructors();
            Constructor<?> constructor = null;
            int n = 0;
            while (n < classArray.length) {
                classArray[n] = objectArray[n].getClass();
                ++n;
            }
            n = 0;
            while (constructor == null && n < constructorArray.length) {
                Class<?>[] classArray2 = constructorArray[n].getParameterTypes();
                if (classArray2.length == classArray.length) {
                    constructor = constructorArray[n];
                    int n2 = 0;
                    while (constructor != null && n2 < classArray2.length) {
                        if (classArray2[n2].equals(Object.class)) {
                            if (!classArray2[n2].equals(classArray[n2])) {
                                constructor = null;
                            }
                        } else if (!classArray2[n2].isAssignableFrom(classArray[n2])) {
                            constructor = null;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            if (constructor != null) {
                return constructor.newInstance(objectArray);
            }
            throw new IllegalArgumentException("unable to find constructor, accepting:" + classArray);
        }
        return this.template.newInstance();
    }

    public Class getTemplate() {
        return this.template;
    }

    public Collection getSetters() {
        return this.setters;
    }

    public Method getSetter(Class clazz) {
        Method method = null;
        Iterator iterator = this.setters.iterator();
        while (iterator != null && iterator.hasNext()) {
            Method method2 = (Method)iterator.next();
            Class<?>[] classArray = method2.getParameterTypes();
            if (classArray == null || classArray.length <= 0 || !clazz.equals(classArray[0])) continue;
            method = method2;
            break;
        }
        return method;
    }

    public Method getSetter(String string) {
        Method method = null;
        Iterator iterator = this.setters.iterator();
        while (iterator != null && iterator.hasNext()) {
            Method method2 = (Method)iterator.next();
            if (!method2.getName().equals(string)) continue;
            method = method2;
            break;
        }
        return method;
    }

    public Method guessSetter(String string) {
        Method method = null;
        Iterator iterator = this.setters.iterator();
        string = ("set" + string).toLowerCase();
        while (iterator != null && iterator.hasNext()) {
            Method method2 = (Method)iterator.next();
            if (!method2.getName().toLowerCase().equals(string)) continue;
            method = method2;
            break;
        }
        return method;
    }

    public void removeSetter(Method method) {
        this.setters.remove(method);
    }
}

