/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.util.List;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractArrayConverter;

public final class CharacterArrayConverter
extends AbstractArrayConverter {
    private static char[] model = new char[0];

    public CharacterArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public CharacterArrayConverter(Object object) {
        this.defaultValue = object;
        this.useDefault = true;
    }

    public Object convert(Class clazz, Object object) {
        if (object == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (model.getClass() == object.getClass()) {
            return object;
        }
        if (strings.getClass() == object.getClass()) {
            try {
                String[] stringArray = (String[])object;
                char[] cArray = new char[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    cArray[n] = stringArray[n].charAt(0);
                    ++n;
                }
                return cArray;
            }
            catch (Exception exception) {
                if (this.useDefault) {
                    return this.defaultValue;
                }
                throw new ConversionException(object.toString(), exception);
            }
        }
        try {
            List list = this.parseElements(object.toString());
            char[] cArray = new char[list.size()];
            int n = 0;
            while (n < cArray.length) {
                cArray[n] = ((String)list.get(n)).charAt(0);
                ++n;
            }
            return cArray;
        }
        catch (Exception exception) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(object.toString(), exception);
        }
    }
}

