/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

public final class HashtableOfInt {
    public int[] keyTable;
    public Object[] valueTable;
    public int elementSize = 0;
    int threshold;

    public HashtableOfInt() {
        this(13);
    }

    public HashtableOfInt(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.75f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.keyTable = new int[n2];
        this.valueTable = new Object[n2];
    }

    public boolean containsKey(int n) {
        int n2;
        int n3 = this.keyTable.length;
        int n4 = n % n3;
        while ((n2 = this.keyTable[n4]) != 0) {
            if (n2 == n) {
                return true;
            }
            if (++n4 != n3) continue;
            n4 = 0;
        }
        return false;
    }

    public Object get(int n) {
        int n2;
        int n3 = this.keyTable.length;
        int n4 = n % n3;
        while ((n2 = this.keyTable[n4]) != 0) {
            if (n2 == n) {
                return this.valueTable[n4];
            }
            if (++n4 != n3) continue;
            n4 = 0;
        }
        return null;
    }

    public Object put(int n, Object object) {
        int n2;
        int n3 = this.keyTable.length;
        int n4 = n % n3;
        while ((n2 = this.keyTable[n4]) != 0) {
            if (n2 == n) {
                this.valueTable[n4] = object;
                return this.valueTable[n4];
            }
            if (++n4 != n3) continue;
            n4 = 0;
        }
        this.keyTable[n4] = n;
        this.valueTable[n4] = object;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return object;
    }

    private void rehash() {
        HashtableOfInt hashtableOfInt = new HashtableOfInt(this.elementSize * 2);
        int n = this.keyTable.length;
        while (--n >= 0) {
            int n2 = this.keyTable[n];
            if (n2 == 0) continue;
            hashtableOfInt.put(n2, this.valueTable[n]);
        }
        this.keyTable = hashtableOfInt.keyTable;
        this.valueTable = hashtableOfInt.valueTable;
        this.threshold = hashtableOfInt.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String string = "";
        int n = 0;
        int n2 = this.valueTable.length;
        while (n < n2) {
            Object object = this.valueTable[n];
            if (object != null) {
                string = String.valueOf(string) + this.keyTable[n] + " -> " + object.toString() + "\n";
            }
            ++n;
        }
        return string;
    }
}

