/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;

public abstract class ECPoint {
    ECCurve curve;
    ECFieldElement x;
    ECFieldElement y;
    private static X9IntegerConverter converter = new X9IntegerConverter();

    protected ECPoint(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        this.curve = eCCurve;
        this.x = eCFieldElement;
        this.y = eCFieldElement2;
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public ECFieldElement getX() {
        return this.x;
    }

    public ECFieldElement getY() {
        return this.y;
    }

    public boolean isInfinity() {
        return this.x == null && this.y == null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ECPoint)) {
            return false;
        }
        ECPoint eCPoint = (ECPoint)object;
        if (this.isInfinity()) {
            return eCPoint.isInfinity();
        }
        return this.x.equals(eCPoint.x) && this.y.equals(eCPoint.y);
    }

    public int hashCode() {
        if (this.isInfinity()) {
            return 0;
        }
        return this.x.hashCode() ^ this.y.hashCode();
    }

    public abstract byte[] getEncoded();

    public abstract ECPoint add(ECPoint var1);

    public abstract ECPoint subtract(ECPoint var1);

    public abstract ECPoint twice();

    public abstract ECPoint multiply(BigInteger var1);

    public static class F2m
    extends ECPoint {
        private boolean withCompression;

        public F2m(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            this(eCCurve, eCFieldElement, eCFieldElement2, false);
        }

        public F2m(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl) {
            super(eCCurve, eCFieldElement, eCFieldElement2);
            if (eCFieldElement != null && eCFieldElement2 == null || eCFieldElement == null && eCFieldElement2 != null) {
                throw new IllegalArgumentException("Exactly one of the field elements is null");
            }
            if (eCFieldElement != null) {
                ECFieldElement.F2m.checkFieldElements(this.x, this.y);
                if (eCCurve != null) {
                    ECFieldElement.F2m.checkFieldElements(this.x, this.curve.getA());
                }
            }
            this.withCompression = bl;
        }

        public F2m(ECCurve eCCurve) {
            super(eCCurve, null, null);
        }

        public byte[] getEncoded() {
            byte[] byArray;
            if (this.isInfinity()) {
                throw new RuntimeException("Point at infinity cannot be encoded");
            }
            int n = converter.getByteLength(this.x);
            byte[] byArray2 = converter.integerToBytes(this.getX().toBigInteger(), n);
            if (this.withCompression) {
                byArray = new byte[n + 1];
                byArray[0] = 2;
                if (!this.getX().toBigInteger().equals(ECConstants.ZERO) && this.getY().multiply(this.getX().invert()).toBigInteger().testBit(0)) {
                    byArray[0] = 3;
                }
                System.arraycopy(byArray2, 0, byArray, 1, n);
            } else {
                byte[] byArray3 = converter.integerToBytes(this.getY().toBigInteger(), n);
                byArray = new byte[n + n + 1];
                byArray[0] = 4;
                System.arraycopy(byArray2, 0, byArray, 1, n);
                System.arraycopy(byArray3, 0, byArray, n + 1, n);
            }
            return byArray;
        }

        public ECPoint add(ECPoint eCPoint) {
            if (!this.curve.equals(eCPoint.getCurve())) {
                throw new IllegalArgumentException("Only points on the same curve can be added");
            }
            if (this.isInfinity()) {
                return eCPoint;
            }
            if (eCPoint.isInfinity()) {
                return this;
            }
            ECFieldElement.F2m.checkFieldElements(this.x, eCPoint.getX());
            ECFieldElement.F2m f2m = (ECFieldElement.F2m)eCPoint.getX();
            ECFieldElement.F2m f2m2 = (ECFieldElement.F2m)eCPoint.getY();
            if (this.x.equals(f2m)) {
                if (this.y.equals(f2m2)) {
                    return this.twice();
                }
                return this.curve.getInfinity();
            }
            ECFieldElement.F2m f2m3 = (ECFieldElement.F2m)this.y.add(f2m2).divide(this.x.add(f2m));
            ECFieldElement.F2m f2m4 = (ECFieldElement.F2m)f2m3.square().add(f2m3).add(this.x).add(f2m).add(this.curve.getA());
            ECFieldElement.F2m f2m5 = (ECFieldElement.F2m)f2m3.multiply(this.x.add(f2m4)).add(f2m4).add(this.y);
            return new F2m(this.curve, f2m4, f2m5, this.withCompression);
        }

        public ECPoint subtract(ECPoint eCPoint) {
            if (eCPoint.isInfinity()) {
                return this;
            }
            F2m f2m = new F2m(this.curve, eCPoint.x, eCPoint.x.add(eCPoint.y), this.withCompression);
            return this.add(f2m);
        }

        public ECPoint twice() {
            if (this.isInfinity()) {
                return this;
            }
            if (this.x.toBigInteger().signum() == 0) {
                return this.curve.getInfinity();
            }
            ECFieldElement.F2m f2m = (ECFieldElement.F2m)this.x.add(this.y.divide(this.x));
            ECFieldElement.F2m f2m2 = (ECFieldElement.F2m)f2m.square().add(f2m).add(this.curve.getA());
            ECFieldElement.F2m f2m3 = (ECFieldElement.F2m)this.x.square().add(f2m.multiply(f2m2)).add(f2m2);
            return new F2m(this.curve, f2m2, f2m3, this.withCompression);
        }

        public ECPoint multiply(BigInteger bigInteger) {
            ECPoint eCPoint = this;
            ECPoint eCPoint2 = this.curve.getInfinity();
            int n = bigInteger.bitLength();
            int n2 = 0;
            while (n2 < n) {
                if (bigInteger.testBit(n2)) {
                    eCPoint2 = eCPoint2.add(eCPoint);
                }
                eCPoint = ((ECPoint)eCPoint).twice();
                ++n2;
            }
            return eCPoint2;
        }
    }

    public static class Fp
    extends ECPoint {
        private boolean withCompression;

        public Fp(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            this(eCCurve, eCFieldElement, eCFieldElement2, false);
        }

        public Fp(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl) {
            super(eCCurve, eCFieldElement, eCFieldElement2);
            if (eCFieldElement != null && eCFieldElement2 == null || eCFieldElement == null && eCFieldElement2 != null) {
                throw new IllegalArgumentException("Exactly one of the field elements is null");
            }
            this.withCompression = bl;
        }

        public byte[] getEncoded() {
            int n = converter.getByteLength(this.x);
            if (this.withCompression) {
                int n2 = this.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] byArray = converter.integerToBytes(this.getX().toBigInteger(), n);
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = n2;
                System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                return byArray2;
            }
            byte[] byArray = converter.integerToBytes(this.getX().toBigInteger(), n);
            byte[] byArray3 = converter.integerToBytes(this.getY().toBigInteger(), n);
            byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
            return byArray4;
        }

        public ECPoint add(ECPoint eCPoint) {
            if (this.isInfinity()) {
                return eCPoint;
            }
            if (eCPoint.isInfinity()) {
                return this;
            }
            if (this.x.equals(eCPoint.x)) {
                if (this.y.equals(eCPoint.y)) {
                    return this.twice();
                }
                return this.curve.getInfinity();
            }
            ECFieldElement eCFieldElement = eCPoint.y.subtract(this.y).divide(eCPoint.x.subtract(this.x));
            ECFieldElement eCFieldElement2 = eCFieldElement.multiply(eCFieldElement).subtract(this.x).subtract(eCPoint.x);
            ECFieldElement eCFieldElement3 = eCFieldElement.multiply(this.x.subtract(eCFieldElement2)).subtract(this.y);
            return new Fp(this.curve, eCFieldElement2, eCFieldElement3);
        }

        public ECPoint twice() {
            if (this.isInfinity()) {
                return this;
            }
            if (this.y.toBigInteger().signum() == 0) {
                return this.curve.getInfinity();
            }
            ECFieldElement eCFieldElement = this.curve.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement eCFieldElement2 = this.curve.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement eCFieldElement3 = this.x.multiply(this.x).multiply(eCFieldElement2).add(this.curve.a).divide(this.y.multiply(eCFieldElement));
            ECFieldElement eCFieldElement4 = eCFieldElement3.multiply(eCFieldElement3).subtract(this.x.multiply(eCFieldElement));
            ECFieldElement eCFieldElement5 = eCFieldElement3.multiply(this.x.subtract(eCFieldElement4)).subtract(this.y);
            return new Fp(this.curve, eCFieldElement4, eCFieldElement5, this.withCompression);
        }

        public ECPoint subtract(ECPoint eCPoint) {
            if (eCPoint.isInfinity()) {
                return this;
            }
            return this.add(new Fp(this.curve, eCPoint.x, eCPoint.y.negate(), this.withCompression));
        }

        public ECPoint multiply(BigInteger bigInteger) {
            if (this.isInfinity()) {
                return this;
            }
            if (bigInteger.signum() == 0) {
                return this.curve.getInfinity();
            }
            BigInteger bigInteger2 = bigInteger;
            BigInteger bigInteger3 = bigInteger2.multiply(BigInteger.valueOf(3L));
            ECPoint eCPoint = this;
            int n = bigInteger3.bitLength() - 2;
            while (n > 0) {
                eCPoint = eCPoint.twice();
                if (bigInteger3.testBit(n) && !bigInteger2.testBit(n)) {
                    eCPoint = eCPoint.add(this);
                } else if (!bigInteger3.testBit(n) && bigInteger2.testBit(n)) {
                    eCPoint = eCPoint.subtract(this);
                }
                --n;
            }
            return eCPoint;
        }
    }
}

