/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.bens;

import java.util.List;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class Bem
extends ObjetoNegocio {
    public static final String NOME_CAMPO_VALOR_ANTERIOR = "Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.EXERCICIO_ANTERIOR;
    public static final String NOME_CAMPO_VALOR_ATUAL = "Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.EXERCICIO;
    private Codigo codigo = new Codigo(this, "C\u00f3digo", CadastroTabelasIRPF.recuperarTipoBens());
    private Codigo pais = new Codigo(this, "Localiza\u00e7\u00e3o(Pa\u00eds)", CadastroTabelasIRPF.recuperarPaises());
    private Alfa discriminacao = new Alfa(this, "Discrimina\u00e7\u00e3o", 510);
    private Valor valorExercicioAnterior = new Valor(this, NOME_CAMPO_VALOR_ANTERIOR);
    private Valor valorExercicioAtual = new Valor(this, NOME_CAMPO_VALOR_ATUAL);
    public static final String BRASIL = "0";
    public static final String EXTERIOR = "1";

    public Bem() {
        this.getCodigo().setColunaFiltro(1);
        this.getPais().setColunaFiltro(1);
        this.getCodigo().addValidador(new ValidadorNaoNulo(3, this.tab.msg("bem_codigo")));
        this.getDiscriminacao().addValidador(new ValidadorNaoNulo(3, this.tab.msg("bem_discriminacao")));
        this.getPais().addValidador(new ValidadorNaoNulo(3, this.tab.msg("bem_pais_branco")));
        this.getPais().addValidador(new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Bem.this.getPais().getConteudoFormatado().equals("105") ? Bem.this.getCodigo().getConteudoAtual(0).equals("62") : Bem.this.getCodigo().getConteudoAtual(0).equals("61")) {
                    return new RetornoValidacao(tab.msg("bem_pais_imcompativel"), 3);
                }
                return null;
            }
        });
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio() || informacao.getNomeCampo().equals("Localiza\u00e7\u00e3o(Pa\u00eds)")) continue;
            return false;
        }
        return true;
    }

    public Codigo getCodigo() {
        return this.codigo;
    }

    public Alfa getDiscriminacao() {
        return this.discriminacao;
    }

    public Codigo getPais() {
        return this.pais;
    }

    public Valor getValorExercicioAnterior() {
        return this.valorExercicioAnterior;
    }

    public Valor getValorExercicioAtual() {
        return this.valorExercicioAtual;
    }

    protected List recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.codigo);
        list.add(this.pais);
        list.add(this.discriminacao);
        list.add(this.valorExercicioAtual);
        list.add(this.valorExercicioAnterior);
        return list;
    }

    public List verificarPendencias(int n) {
        List list = super.verificarPendencias(n);
        if (this.getValorExercicioAtual().isVazio() && this.getValorExercicioAnterior().isVazio()) {
            Pendencia pendencia = new Pendencia(2, this.getValorExercicioAnterior(), this.getValorExercicioAnterior().getNomeCampo(), this.tab.msg("bem_valor_nao_informado"), n);
            list.add(pendencia);
        }
        return list;
    }
}

