/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.infraestrutura.util;

import java.awt.Component;
import java.awt.MenuItem;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import serpro.ppgd.infraestrutura.util.MyHelpBroker;
import serpro.ppgd.negocio.util.LogPPGD;

public class HelpUtil {
    private HelpSet hs;
    private HelpSet.Presentation pres;
    private MyHelpBroker hb;
    private JRootPane rootpane = null;
    private String defaultHelpID;
    private ActionListener contentListener;

    public HelpUtil() {
        this(null, null);
    }

    public HelpUtil(String string) {
        this(null, string);
    }

    public HelpUtil(JRootPane jRootPane) {
        this(jRootPane, null);
    }

    public HelpUtil(JRootPane jRootPane, String string) {
        this.rootpane = jRootPane;
        this.setDefaultID(string);
    }

    public void setDefaultID(String string) {
        this.defaultHelpID = string;
    }

    public String getDefaultID(String string) {
        return string;
    }

    public void setHelpSet(String string) {
        this.setHelpSet(string, null);
    }

    public void setHelpSet(String string, String string2) {
        ClassLoader classLoader = null;
        this.hs = null;
        String string3 = string;
        classLoader = Thread.currentThread().getContextClassLoader();
        URL uRL = HelpSet.findHelpSet(classLoader, string3);
        if (uRL == null) {
            LogPPGD.erro("HelpSet not found " + uRL);
        } else {
            try {
                this.hs = new HelpSet(classLoader, uRL);
            }
            catch (HelpSetException helpSetException) {
                LogPPGD.erro("Could not create HelpSet for " + uRL);
            }
            this.hb = new MyHelpBroker(this.hs);
            if (this.rootpane != null) {
                this.hb.enableHelpKey(this.rootpane, this.defaultHelpID, this.hs);
            }
        }
    }

    public void setHelpID(Component component, String string) {
        if (component instanceof JButton || component instanceof JMenuItem) {
            this.hb.enableHelpOnButton(component, string, this.hs);
        } else {
            this.enableHelpKey(component, string);
        }
    }

    public void setHelpID(MenuItem menuItem, String string) {
        this.hb.enableHelpOnButton(menuItem, string, this.hs);
    }

    public void enableHelpKey(JRootPane jRootPane, String string) {
        this.hb.enableHelpKey(jRootPane, string, this.hs);
    }

    public void enableHelpKey(Component component, String string) {
        this.hb.enableHelpKey(component, string, this.hs);
    }

    public void exibeAjuda() {
        this.hb.setDisplayed(true);
    }

    public HelpSet getHelpSet() {
        return this.hs;
    }

    public HelpBroker getHelpBroker() {
        return this.hb;
    }

    public void setNavigatorVisible(boolean bl) {
        this.hb.setViewDisplayed(bl);
    }

    public void setIcon(ImageIcon imageIcon) {
        this.hb.setHelpIcon(imageIcon);
    }

    private URL[] parseURLs(String string) {
        Object[] objectArray;
        Vector<Object[]> vector = new Vector<Object[]>();
        try {
            objectArray = new URL(string);
            vector.addElement(objectArray);
        }
        catch (Exception exception) {
            LogPPGD.erro("cannot create URL for " + string);
        }
        objectArray = new URL[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }
}

