/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.dependentes;

import java.util.List;
import serpro.ppgd.gui.xbeans.JEditObjetoNegocioItemIf;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.contribuinte.Contribuinte;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorData;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNome;

public class Dependente
extends ObjetoNegocio
implements JEditObjetoNegocioItemIf {
    public static final String PROP_CAMPO_NOME = "Nome";
    public static final String PROP_CAMPO_CPF = "CPF";
    private Codigo codigo = new Codigo(this, "C\u00f3digo", CadastroTabelasIRPF.recuperarDependencias());
    private Alfa nome = new Alfa(this, "Nome", 60);
    private CPF cpfDependente = new CPF(this, "CPF");
    private Data dataNascimento = new Data(this, "Data de Nascimento");
    private transient Contribuinte contribuinte;
    private transient IdentificadorDeclaracao identificadorDeclaracao = null;
    private String chave = "";

    public Dependente() {
        this.setFicha("Dependentes");
        this.getCodigo().setColunaFiltro(1);
        this.getCodigo().addValidador(new ValidadorNaoNulo(3, this.tab.msg("dependente_codigo")));
        this.getNome().addValidador(new ValidadorNome(3));
        this.getNome().addValidador(new ValidadorNaoNulo(3, this.tab.msg("dependente_nome")){

            public RetornoValidacao validarImplementado() {
                if (!(Dependente.this.getCodigo().isVazio() && Dependente.this.getDataNascimento().isVazio() || !Dependente.this.getNome().isVazio())) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        String string = "01/01/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 22);
        final Data data = new Data();
        data.setConteudo(string);
        String string2 = "01/01/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 20);
        final Data data2 = new Data();
        data2.setConteudo(string2);
        String string3 = "01/01/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 25);
        final Data data3 = new Data();
        data3.setConteudo(string3);
        String string4 = "31/12/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 21);
        final Data data4 = new Data();
        data4.setConteudo(string4);
        this.getCpfDependente().addValidador(new ValidadorCPF(3));
        this.getCpfDependente().addValidador(new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if ((Dependente.this.getCodigo().asString().equals("11") || Dependente.this.getCodigo().asString().equals("21") || Dependente.this.getCodigo().asString().equals("24") || Dependente.this.getCodigo().asString().equals("41") || Dependente.this.getCodigo().asString().equals("31")) && Dependente.this.getCpfDependente().isVazio() && !Dependente.this.getDataNascimento().isVazio() && Dependente.this.getDataNascimento().maisAntiga(data2)) {
                    return new RetornoValidacao(tab.msg("dependente_cpf_brancoinvalido"), 3);
                }
                return null;
            }
        });
        this.getCpfDependente().addValidador(new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if ((Dependente.this.getCodigo().asString().equals("22") || Dependente.this.getCodigo().asString().equals("25")) && Dependente.this.getCpfDependente().isVazio()) {
                    return new RetornoValidacao(tab.msg("dependente_cpf_brancoinvalido"), 3);
                }
                return null;
            }
        });
        this.getCpfDependente().addValidador(new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Dependente.this.getCpfDependente().asString().equals(Dependente.this.identificadorDeclaracao.getCpf().asString())) {
                    return new RetornoValidacao(tab.msg("add_cpf_dep"), 3);
                }
                return null;
            }
        });
        this.getDataNascimento().addValidador(new ValidadorData(3));
        this.getDataNascimento().addValidador(new ValidadorNaoNulo(3, this.tab.msg("dependente_data")){

            public RetornoValidacao validarImplementado() {
                if (!(Dependente.this.getCodigo().isVazio() && Dependente.this.getNome().isVazio() && Dependente.this.getCpfDependente().isVazio() || !Dependente.this.getDataNascimento().isVazio())) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getDataNascimento().addValidador(new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if ((Dependente.this.getCodigo().asString().equals("22") || Dependente.this.getCodigo().asString().equals("25")) && !Dependente.this.getDataNascimento().isVazio() && (Dependente.this.getDataNascimento().maisNova(data4) || Dependente.this.getDataNascimento().maisAntiga(data3))) {
                    return new RetornoValidacao(tab.msg("dependente_data_incompativel"), 3);
                }
                return null;
            }
        });
        this.getDataNascimento().addValidador(new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if ((Dependente.this.getCodigo().asString().equals("21") || Dependente.this.getCodigo().asString().equals("24") || Dependente.this.getCodigo().asString().equals("41")) && !Dependente.this.getDataNascimento().isVazio() && Dependente.this.getDataNascimento().maisAntiga(data)) {
                    return new RetornoValidacao(tab.msg("dependente_data_incompativel"), 3);
                }
                return null;
            }
        });
        this.getDataNascimento().addValidador(new ValidadorNaoNulo(2){

            public RetornoValidacao validarImplementado() {
                Data data;
                if (Dependente.this.getCodigo().asString().equals("31") && !(data = Dependente.this.getContribuinte().getDataNascimento()).isVazio()) {
                    int n = "**/**/".length();
                    String string = "" + (Integer.parseInt(data.asString().substring(n)) - 10);
                    Data data2 = new Data();
                    data2.setConteudo(String.valueOf(data.asString().substring(0, n)) + "/" + string);
                    if (!Dependente.this.getDataNascimento().maisAntiga(data2) && !Dependente.this.getDataNascimento().igual(data2)) {
                        return new RetornoValidacao(tab.msg("dependente_data_incompativel"), 2);
                    }
                }
                return null;
            }
        });
    }

    public String toString() {
        return this.nome.asString();
    }

    public Codigo getCodigo() {
        return this.codigo;
    }

    public CPF getCpfDependente() {
        return this.cpfDependente;
    }

    public Data getDataNascimento() {
        return this.dataNascimento;
    }

    public Alfa getNome() {
        return this.nome;
    }

    protected List recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.getCodigo());
        list.add(this.getCpfDependente());
        list.add(this.getDataNascimento());
        list.add(this.getNome());
        return list;
    }

    public String getConteudo(int n) {
        return this.getNome().getConteudoFormatado();
    }

    public int getTotalAtributos() {
        return 1;
    }

    public int getColunaFiltro() {
        return 0;
    }

    public String getChave() {
        return this.chave;
    }

    public void setChave(String string) {
        this.chave = string;
    }

    public IdentificadorDeclaracao getIdentificadorDeclaracao() {
        return this.identificadorDeclaracao;
    }

    public void setIdentificadorDeclaracao(IdentificadorDeclaracao identificadorDeclaracao) {
        this.identificadorDeclaracao = identificadorDeclaracao;
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio()) continue;
            return false;
        }
        return true;
    }

    public void setContribuinte(Contribuinte contribuinte) {
        this.contribuinte = contribuinte;
    }

    public Contribuinte getContribuinte() {
        return this.contribuinte;
    }

    public void addObservador(Observador observador) {
        this.getCodigo().addObservador(observador);
        this.getNome().addObservador(observador);
    }

    public void removeObservador(Observador observador) {
        this.getCodigo().removeObservador(observador);
        this.getNome().removeObservador(observador);
    }
}

