/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

import java.util.Arrays;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;

public class BranchLabel
extends Label {
    public int[] forwardReferences = new int[10];
    public int forwardReferenceCount = 0;
    public int tagBits;
    public static final int WIDE = 1;
    public static final int USED = 2;

    public BranchLabel() {
    }

    public BranchLabel(CodeStream codeStream) {
        super(codeStream);
    }

    void addForwardReference(int n) {
        int n2 = this.forwardReferenceCount;
        if (n2 >= 1) {
            int n3 = this.forwardReferences[n2 - 1];
            if (n3 < n) {
                int n4 = this.forwardReferences.length;
                if (n2 >= n4) {
                    this.forwardReferences = new int[2 * n4];
                    System.arraycopy(this.forwardReferences, 0, this.forwardReferences, 0, n4);
                }
                this.forwardReferences[this.forwardReferenceCount++] = n;
            } else if (n3 > n) {
                int[] nArray = this.forwardReferences;
                int n5 = 0;
                int n6 = this.forwardReferenceCount;
                while (n5 < n6) {
                    if (nArray[n5] == n) {
                        return;
                    }
                    ++n5;
                }
                n5 = nArray.length;
                if (n2 >= n5) {
                    this.forwardReferences = new int[2 * n5];
                    System.arraycopy(nArray, 0, this.forwardReferences, 0, n5);
                }
                this.forwardReferences[this.forwardReferenceCount++] = n;
                Arrays.sort(this.forwardReferences, 0, this.forwardReferenceCount);
            }
        } else {
            int n7 = this.forwardReferences.length;
            if (n2 >= n7) {
                this.forwardReferences = new int[2 * n7];
                System.arraycopy(this.forwardReferences, 0, this.forwardReferences, 0, n7);
            }
            this.forwardReferences[this.forwardReferenceCount++] = n;
        }
    }

    public void appendForwardReferencesFrom(BranchLabel branchLabel) {
        int n = branchLabel.forwardReferenceCount;
        if (n == 0) {
            return;
        }
        int[] nArray = new int[this.forwardReferenceCount + n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.forwardReferenceCount;
        int n6 = branchLabel.forwardReferenceCount;
        while (n4 < n5) {
            block6: {
                int n7 = this.forwardReferences[n4];
                while (n3 < n6) {
                    int n8 = branchLabel.forwardReferences[n3];
                    if (n7 < n8) {
                        nArray[n2++] = n7;
                        break block6;
                    }
                    if (n7 == n8) {
                        nArray[n2++] = n7;
                        ++n3;
                        break block6;
                    }
                    nArray[n2++] = n8;
                    ++n3;
                }
                nArray[n2++] = n7;
            }
            ++n4;
        }
        while (n3 < n6) {
            nArray[n2++] = branchLabel.forwardReferences[n3];
            ++n3;
        }
        this.forwardReferences = nArray;
        this.forwardReferenceCount = n2;
    }

    void branch() {
        this.tagBits |= 2;
        if (this.position == -1) {
            this.addForwardReference(this.codeStream.position);
            this.codeStream.position += 2;
            this.codeStream.classFileOffset += 2;
        } else {
            this.codeStream.writePosition(this);
        }
    }

    void branchWide() {
        this.tagBits |= 2;
        if (this.position == -1) {
            this.addForwardReference(this.codeStream.position);
            this.tagBits |= 1;
            this.codeStream.position += 4;
            this.codeStream.classFileOffset += 4;
        } else {
            this.codeStream.writeWidePosition(this);
        }
    }

    public void initialize(CodeStream codeStream) {
        this.codeStream = codeStream;
        this.position = -1;
        this.forwardReferenceCount = 0;
    }

    public boolean isCaseLabel() {
        return false;
    }

    public boolean isStandardLabel() {
        return true;
    }

    public void place() {
        if (this.position == -1) {
            int n;
            this.position = (this.tagBits & 2) != 0 || this.forwardReferenceCount != 0 ? this.codeStream.getPosition() : this.codeStream.position;
            this.codeStream.addLabel(this);
            int n2 = this.position;
            boolean bl = false;
            if (this.forwardReferenceCount != 0) {
                boolean bl2 = bl = this.forwardReferences[this.forwardReferenceCount - 1] + 2 == this.position && this.codeStream.bCodeStream[this.codeStream.classFileOffset - 3] == -89;
                if (bl) {
                    this.codeStream.position = this.position -= 3;
                    this.codeStream.classFileOffset -= 3;
                    --this.forwardReferenceCount;
                    n = this.codeStream.pcToSourceMapSize - 2;
                    if (this.codeStream.lastEntryPC == n2) {
                        this.codeStream.lastEntryPC = this.position;
                    }
                    if (n >= 0 && this.codeStream.pcToSourceMap[n] == this.position) {
                        this.codeStream.pcToSourceMapSize -= 2;
                    }
                    if ((this.codeStream.generateAttributes & 0xC) != 0) {
                        LocalVariableBinding[] localVariableBindingArray = this.codeStream.locals;
                        int n3 = 0;
                        int n4 = localVariableBindingArray.length;
                        while (n3 < n4) {
                            LocalVariableBinding localVariableBinding = localVariableBindingArray[n3];
                            if (localVariableBinding != null && localVariableBinding.initializationCount > 0) {
                                if (localVariableBinding.initializationPCs[(localVariableBinding.initializationCount - 1 << 1) + 1] == n2) {
                                    localVariableBinding.initializationPCs[(localVariableBinding.initializationCount - 1 << 1) + 1] = this.position;
                                }
                                if (localVariableBinding.initializationPCs[localVariableBinding.initializationCount - 1 << 1] == n2) {
                                    localVariableBinding.initializationPCs[localVariableBinding.initializationCount - 1 << 1] = this.position;
                                }
                            }
                            ++n3;
                        }
                    }
                }
            }
            n = 0;
            while (n < this.forwardReferenceCount) {
                this.codeStream.writePosition(this, this.forwardReferences[n]);
                ++n;
            }
            if (bl) {
                this.codeStream.optimizeBranch(n2, this);
            }
        }
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('@').append(Integer.toHexString(this.hashCode()));
        stringBuffer.append("(position=").append(this.position);
        stringBuffer.append(", forwards = [");
        int n = 0;
        while (n < this.forwardReferenceCount - 1) {
            stringBuffer.append(String.valueOf(this.forwardReferences[n]) + ", ");
            ++n;
        }
        if (this.forwardReferenceCount >= 1) {
            stringBuffer.append(this.forwardReferences[this.forwardReferenceCount - 1]);
        }
        stringBuffer.append("] )");
        return stringBuffer.toString();
    }
}

