/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jfree.util.Log;

public class PaintUtilities {
    private PaintUtilities() {
    }

    public static boolean equal(Paint paint, Paint paint2) {
        if (paint == null) {
            return paint2 == null;
        }
        if (paint2 == null) {
            return false;
        }
        boolean bl = false;
        if (paint instanceof GradientPaint && paint2 instanceof GradientPaint) {
            GradientPaint gradientPaint = (GradientPaint)paint;
            GradientPaint gradientPaint2 = (GradientPaint)paint2;
            bl = gradientPaint.getColor1().equals(gradientPaint2.getColor1()) && gradientPaint.getColor2().equals(gradientPaint2.getColor2()) && gradientPaint.getPoint1().equals(gradientPaint2.getPoint1()) && gradientPaint.getPoint2().equals(gradientPaint2.getPoint2()) && gradientPaint.isCyclic() == gradientPaint2.isCyclic() && gradientPaint.getTransparency() == gradientPaint.getTransparency();
        } else {
            bl = paint.equals(paint2);
        }
        return bl;
    }

    public static String colorToString(Color color) {
        Object object;
        try {
            object = Color.class.getFields();
            int n = 0;
            while (n < ((Field[])object).length) {
                Field field = object[n];
                if (Modifier.isPublic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) && Modifier.isStatic(field.getModifiers())) {
                    String string = field.getName();
                    Object object2 = field.get(null);
                    if (object2 instanceof Color && color.equals(object2)) {
                        return string;
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {}
        object = Integer.toHexString(color.getRGB() & 0xFFFFFF);
        StringBuffer stringBuffer = new StringBuffer(7);
        stringBuffer.append("#");
        int n = 6 - ((String)object).length();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("0");
            ++n2;
        }
        stringBuffer.append((String)object);
        return stringBuffer.toString();
    }

    public static Color stringToColor(String string) {
        if (string == null) {
            return Color.black;
        }
        try {
            return Color.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Field field = Color.class.getField(string);
                return (Color)field.get(null);
            }
            catch (Exception exception) {
                Log.info("No such Color : " + string);
                return Color.black;
            }
        }
    }
}

