/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.factories;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.forms.util.LayoutStyle;

public final class FormFactory {
    public static final ColumnSpec MIN_COLSPEC = new ColumnSpec(Sizes.MINIMUM);
    public static final ColumnSpec PREF_COLSPEC = new ColumnSpec(Sizes.PREFERRED);
    public static final ColumnSpec DEFAULT_COLSPEC = new ColumnSpec(Sizes.DEFAULT);
    public static final ColumnSpec GLUE_COLSPEC = new ColumnSpec(ColumnSpec.DEFAULT, Sizes.ZERO, 1.0);
    public static final ColumnSpec LABEL_COMPONENT_GAP_COLSPEC = FormFactory.createGapColumnSpec(LayoutStyle.getCurrent().getLabelComponentPadX());
    public static final ColumnSpec RELATED_GAP_COLSPEC = FormFactory.createGapColumnSpec(LayoutStyle.getCurrent().getRelatedComponentsPadX());
    public static final ColumnSpec UNRELATED_GAP_COLSPEC = FormFactory.createGapColumnSpec(LayoutStyle.getCurrent().getUnrelatedComponentsPadX());
    public static final ColumnSpec BUTTON_COLSPEC = new ColumnSpec(Sizes.bounded(Sizes.PREFERRED, LayoutStyle.getCurrent().getDefaultButtonWidth(), null));
    public static final ColumnSpec GROWING_BUTTON_COLSPEC = new ColumnSpec(ColumnSpec.DEFAULT, BUTTON_COLSPEC.getSize(), 1.0);
    public static final RowSpec MIN_ROWSPEC = new RowSpec(Sizes.MINIMUM);
    public static final RowSpec PREF_ROWSPEC = new RowSpec(Sizes.PREFERRED);
    public static final RowSpec DEFAULT_ROWSPEC = new RowSpec(Sizes.DEFAULT);
    public static final RowSpec GLUE_ROWSPEC = new RowSpec(RowSpec.DEFAULT, Sizes.ZERO, 1.0);
    public static final RowSpec RELATED_GAP_ROWSPEC = FormFactory.createGapRowSpec(LayoutStyle.getCurrent().getRelatedComponentsPadY());
    public static final RowSpec UNRELATED_GAP_ROWSPEC = FormFactory.createGapRowSpec(LayoutStyle.getCurrent().getUnrelatedComponentsPadY());
    public static final RowSpec NARROW_LINE_GAP_ROWSPEC = FormFactory.createGapRowSpec(LayoutStyle.getCurrent().getNarrowLinePad());
    public static final RowSpec LINE_GAP_ROWSPEC = FormFactory.createGapRowSpec(LayoutStyle.getCurrent().getLinePad());
    public static final RowSpec PARAGRAPH_GAP_ROWSPEC = FormFactory.createGapRowSpec(LayoutStyle.getCurrent().getParagraphPad());

    private FormFactory() {
    }

    public static FormLayout createColumnLayout(int n, int n2, ColumnSpec columnSpec) {
        return FormFactory.createColumnLayout(n, n2, columnSpec, Sizes.DLUX14, Sizes.DLUX2);
    }

    public static FormLayout createColumnLayout(int n, int n2, ColumnSpec columnSpec, ConstantSize constantSize, ConstantSize constantSize2) {
        return FormFactory.createColumnLayout(n, n2, columnSpec, PREF_COLSPEC, constantSize, Sizes.DLUX14, constantSize2);
    }

    public static FormLayout createColumnLayout(int n, int n2, ColumnSpec columnSpec, ColumnSpec columnSpec2, ConstantSize constantSize, ConstantSize constantSize2, ConstantSize constantSize3) {
        ColumnSpec columnSpec3 = FormFactory.createGapColumnSpec(constantSize2);
        ColumnSpec columnSpec4 = FormFactory.createGapColumnSpec(constantSize3);
        FormLayout formLayout = new FormLayout(new ColumnSpec[0], new RowSpec[0]);
        if (constantSize != null) {
            formLayout.appendColumn(FormFactory.createGapColumnSpec(constantSize));
        }
        int n3 = 0;
        while (n3 < n) {
            if (columnSpec != null) {
                formLayout.appendColumn(columnSpec);
                formLayout.appendColumn(RELATED_GAP_COLSPEC);
            }
            int n4 = 0;
            while (n4 < n2) {
                formLayout.appendColumn(columnSpec2);
                formLayout.addGroupedColumn(formLayout.getColumnCount());
                if (n4 < n2 - 1) {
                    formLayout.appendColumn(columnSpec4);
                }
                ++n4;
            }
            if (n3 < n - 1) {
                formLayout.appendColumn(columnSpec3);
            }
            ++n3;
        }
        return formLayout;
    }

    public static ColumnSpec createGapColumnSpec(ConstantSize constantSize) {
        return new ColumnSpec(ColumnSpec.LEFT, constantSize, 0.0);
    }

    public static RowSpec createGapRowSpec(ConstantSize constantSize) {
        return new RowSpec(RowSpec.TOP, constantSize, 0.0);
    }
}

