/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.export.TextRenderer;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.MaxFontSizeFinder;

public class TextMeasurer {
    private static final FontRenderContext FONT_RENDER_CONTEXT = TextRenderer.LINE_BREAK_FONT_RENDER_CONTEXT;
    private JRTextElement textElement = null;
    private MaxFontSizeFinder maxFontSizeFinder = null;
    private int width = 0;
    private int height = 0;
    private int topPadding = 0;
    private int leftPadding = 0;
    private int bottomPadding = 0;
    private int rightPadding = 0;
    private float lineSpacing = 0.0f;
    private float formatWidth = 0.0f;
    private int maxHeight = 0;
    private int textOffset = 0;
    private int lines = 0;
    private int fontSizeSum = 0;
    private int firstLineMaxFontSize = 0;
    private float textHeight = 0.0f;
    private float firstLineLeading = 0.0f;
    private boolean isLeftToRight = true;
    private boolean isMaxHeightReached = false;

    public TextMeasurer(JRTextElement jRTextElement) {
        this.textElement = jRTextElement;
    }

    private void initialize(int n) {
        this.width = this.textElement.getWidth();
        this.height = this.textElement.getHeight();
        this.topPadding = this.textElement.getTopPadding();
        this.leftPadding = this.textElement.getLeftPadding();
        this.bottomPadding = this.textElement.getBottomPadding();
        this.rightPadding = this.textElement.getRightPadding();
        switch (this.textElement.getRotation()) {
            case 1: {
                this.width = this.textElement.getHeight();
                this.height = this.textElement.getWidth();
                int n2 = this.topPadding;
                this.topPadding = this.leftPadding;
                this.leftPadding = this.bottomPadding;
                this.bottomPadding = this.rightPadding;
                this.rightPadding = n2;
                break;
            }
            case 2: {
                this.width = this.textElement.getHeight();
                this.height = this.textElement.getWidth();
                int n3 = this.topPadding;
                this.topPadding = this.rightPadding;
                this.rightPadding = this.bottomPadding;
                this.bottomPadding = this.leftPadding;
                this.leftPadding = n3;
                break;
            }
            case 3: {
                int n4 = this.topPadding;
                this.topPadding = this.bottomPadding;
                this.bottomPadding = n4;
                n4 = this.leftPadding;
                this.leftPadding = this.rightPadding;
                this.rightPadding = n4;
            }
        }
        switch (this.textElement.getLineSpacing()) {
            case 0: {
                this.lineSpacing = 1.0f;
                break;
            }
            case 1: {
                this.lineSpacing = 1.5f;
                break;
            }
            case 2: {
                this.lineSpacing = 2.0f;
                break;
            }
            default: {
                this.lineSpacing = 1.0f;
            }
        }
        this.maxFontSizeFinder = MaxFontSizeFinder.getInstance(this.textElement.isStyledText());
        this.formatWidth = this.width - this.leftPadding - this.rightPadding;
        this.formatWidth = this.formatWidth < 0.0f ? 0.0f : this.formatWidth;
        this.maxHeight = this.height + n - this.topPadding - this.bottomPadding;
        this.maxHeight = this.maxHeight < 0 ? 0 : this.maxHeight;
        this.textOffset = 0;
        this.lines = 0;
        this.fontSizeSum = 0;
        this.firstLineMaxFontSize = 0;
        this.textHeight = 0.0f;
        this.firstLineLeading = 0.0f;
        this.isLeftToRight = true;
        this.isMaxHeightReached = false;
    }

    public void measure(JRStyledText jRStyledText, String string, int n, int n2) {
        this.initialize(n2);
        AttributedCharacterIterator attributedCharacterIterator = jRStyledText.getAttributedString().getIterator();
        int n3 = n;
        int n4 = n;
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        while (stringTokenizer.hasMoreTokens() && !this.isMaxHeightReached) {
            String string3 = stringTokenizer.nextToken();
            if ("\n".equals(string3)) {
                this.renderParagraph(attributedCharacterIterator, n4, string2);
                n4 = n3 + (stringTokenizer.hasMoreTokens() || n3 == 0 ? 1 : 0);
                string2 = null;
            } else {
                n4 = n3;
                string2 = string3;
            }
            n3 += string3.length();
        }
        if (!this.isMaxHeightReached && n4 < n + string.length()) {
            this.renderParagraph(attributedCharacterIterator, n4, string2);
        }
    }

    private void renderParagraph(AttributedCharacterIterator attributedCharacterIterator, int n, String string) {
        AttributedCharacterIterator attributedCharacterIterator2 = null;
        attributedCharacterIterator2 = string == null ? new AttributedString(" ", new AttributedString(attributedCharacterIterator, n, n + 1).getIterator().getAttributes()).getIterator() : new AttributedString(attributedCharacterIterator, n, n + string.length()).getIterator();
        int n2 = 0;
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator2, FONT_RENDER_CONTEXT);
        while (lineBreakMeasurer.getPosition() < attributedCharacterIterator2.getEndIndex() && !this.isMaxHeightReached) {
            int n3 = lineBreakMeasurer.getPosition();
            TextLayout textLayout = lineBreakMeasurer.nextLayout(this.formatWidth);
            this.isLeftToRight = this.isLeftToRight && textLayout.isLeftToRight();
            this.textHeight += textLayout.getLeading() + this.lineSpacing * textLayout.getAscent();
            if (this.textHeight + textLayout.getDescent() <= (float)this.maxHeight) {
                ++this.lines;
                this.fontSizeSum += this.maxFontSizeFinder.findMaxFontSize(new AttributedString(attributedCharacterIterator2, n3, n3 + textLayout.getCharacterCount()).getIterator(), this.textElement.getFontSize());
                if (this.lines == 1) {
                    this.firstLineLeading = this.textHeight;
                    this.firstLineMaxFontSize = this.fontSizeSum;
                }
                n2 = lineBreakMeasurer.getPosition();
                this.textHeight += textLayout.getDescent();
                continue;
            }
            this.textHeight -= textLayout.getLeading() + this.lineSpacing * textLayout.getAscent();
            this.isMaxHeightReached = true;
        }
        this.textOffset = n + n2;
    }

    protected boolean isLeftToRight() {
        return this.isLeftToRight;
    }

    protected int getTextOffset() {
        return this.textOffset;
    }

    public float getTextHeight() {
        return this.textHeight;
    }

    public float getLineSpacingFactor() {
        if (this.lines > 0) {
            return this.textHeight / (float)this.fontSizeSum;
        }
        return 0.0f;
    }

    public float getLeadingOffset() {
        return this.firstLineLeading - (float)this.firstLineMaxFontSize * this.getLineSpacingFactor();
    }
}

