/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.IllegalAddException;
import org.jdom.Namespace;
import org.jdom.Verifier;

class AttributeList
extends AbstractList
implements List,
Serializable {
    private static final String CVS_ID = "@(#) $RCSfile: AttributeList.java,v $ $Revision: 1.23 $ $Date: 2004/02/28 03:30:27 $ $Name: jdom_1_0 $";
    private static final int INITIAL_ARRAY_SIZE = 5;
    private Attribute[] elementData;
    private int size;
    private Element parent;

    private AttributeList() {
    }

    AttributeList(Element element) {
        this.parent = element;
    }

    final void uncheckedAddAttribute(Attribute attribute) {
        attribute.parent = this.parent;
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = attribute;
        ++this.modCount;
    }

    public boolean add(Object object) {
        if (object instanceof Attribute) {
            Attribute attribute = (Attribute)object;
            int n = this.indexOfDuplicate(attribute);
            if (n < 0) {
                this.add(this.size(), attribute);
            } else {
                this.set(n, attribute);
            }
        } else {
            if (object == null) {
                throw new IllegalAddException("Cannot add null attribute");
            }
            throw new IllegalAddException("Class " + object.getClass().getName() + " is not an attribute");
        }
        return true;
    }

    public void add(int n, Object object) {
        Attribute attribute;
        if (object instanceof Attribute) {
            attribute = (Attribute)object;
            int n2 = this.indexOfDuplicate(attribute);
            if (n2 >= 0) {
                throw new IllegalAddException("Cannot add duplicate attribute");
            }
        } else {
            if (object == null) {
                throw new IllegalAddException("Cannot add null attribute");
            }
            throw new IllegalAddException("Class " + object.getClass().getName() + " is not an attribute");
        }
        this.add(n, attribute);
        ++this.modCount;
    }

    void add(int n, Attribute attribute) {
        if (attribute.getParent() != null) {
            throw new IllegalAddException("The attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"");
        }
        String string = Verifier.checkNamespaceCollision(attribute, this.parent);
        if (string != null) {
            throw new IllegalAddException(this.parent, attribute, string);
        }
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        attribute.setParent(this.parent);
        this.ensureCapacity(this.size + 1);
        if (n == this.size) {
            this.elementData[this.size++] = attribute;
        } else {
            System.arraycopy(this.elementData, n, this.elementData, n + 1, this.size - n);
            this.elementData[n] = attribute;
            ++this.size;
        }
        ++this.modCount;
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size(), collection);
    }

    /*
     * Unable to fully structure code
     */
    public boolean addAll(int var1_1, Collection var2_2) {
        block6: {
            if (var1_1 < 0 || var1_1 > this.size) {
                throw new IndexOutOfBoundsException("Index: " + var1_1 + " Size: " + this.size());
            }
            if (var2_2 == null || var2_2.size() == 0) {
                return false;
            }
            this.ensureCapacity(this.size() + var2_2.size());
            var3_3 = 0;
            try {
                for (E var5_6 : var2_2) {
                    this.add(var1_1 + var3_3, (Object)var5_6);
                    ++var3_3;
                }
                break block6;
            }
            catch (RuntimeException var4_5) {
                var5_7 = 0;
                ** while (var5_7 < var3_3)
            }
lbl-1000:
            // 1 sources

            {
                this.remove(var1_1);
                ++var5_7;
                continue;
            }
lbl20:
            // 1 sources

            throw var4_5;
        }
        return true;
    }

    public void clear() {
        if (this.elementData != null) {
            int n = 0;
            while (n < this.size) {
                Attribute attribute = this.elementData[n];
                attribute.setParent(null);
                ++n;
            }
            this.elementData = null;
            this.size = 0;
        }
        ++this.modCount;
    }

    void clearAndSet(Collection collection) {
        Attribute[] attributeArray = this.elementData;
        int n = this.size;
        this.elementData = null;
        this.size = 0;
        if (collection != null && collection.size() != 0) {
            this.ensureCapacity(collection.size());
            try {
                this.addAll(0, collection);
            }
            catch (RuntimeException runtimeException) {
                this.elementData = attributeArray;
                this.size = n;
                throw runtimeException;
            }
        }
        if (attributeArray != null) {
            int n2 = 0;
            while (n2 < n) {
                Attribute attribute = attributeArray[n2];
                attribute.setParent(null);
                ++n2;
            }
        }
        ++this.modCount;
    }

    private void ensureCapacity(int n) {
        if (this.elementData == null) {
            this.elementData = new Attribute[Math.max(n, 5)];
        } else {
            int n2 = this.elementData.length;
            if (n > n2) {
                Attribute[] attributeArray = this.elementData;
                int n3 = n2 * 3 / 2 + 1;
                if (n3 < n) {
                    n3 = n;
                }
                this.elementData = new Attribute[n3];
                System.arraycopy(attributeArray, 0, this.elementData, 0, this.size);
            }
        }
    }

    public Object get(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        return this.elementData[n];
    }

    Object get(String string, Namespace namespace) {
        int n = this.indexOf(string, namespace);
        if (n < 0) {
            return null;
        }
        return this.elementData[n];
    }

    int indexOf(String string, Namespace namespace) {
        String string2 = namespace.getURI();
        if (this.elementData != null) {
            int n = 0;
            while (n < this.size) {
                Attribute attribute = this.elementData[n];
                String string3 = attribute.getNamespaceURI();
                String string4 = attribute.getName();
                if (string3.equals(string2) && string4.equals(string)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public Object remove(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        Attribute attribute = this.elementData[n];
        attribute.setParent(null);
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = null;
        ++this.modCount;
        return attribute;
    }

    boolean remove(String string, Namespace namespace) {
        int n = this.indexOf(string, namespace);
        if (n < 0) {
            return false;
        }
        this.remove(n);
        return true;
    }

    public Object set(int n, Object object) {
        if (object instanceof Attribute) {
            Attribute attribute = (Attribute)object;
            int n2 = this.indexOfDuplicate(attribute);
            if (n2 >= 0 && n2 != n) {
                throw new IllegalAddException("Cannot set duplicate attribute");
            }
            return this.set(n, attribute);
        }
        if (object == null) {
            throw new IllegalAddException("Cannot add null attribute");
        }
        throw new IllegalAddException("Class " + object.getClass().getName() + " is not an attribute");
    }

    Object set(int n, Attribute attribute) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.size());
        }
        if (attribute.getParent() != null) {
            throw new IllegalAddException("The attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"");
        }
        String string = Verifier.checkNamespaceCollision(attribute, this.parent);
        if (string != null) {
            throw new IllegalAddException(this.parent, attribute, string);
        }
        Attribute attribute2 = this.elementData[n];
        attribute2.setParent(null);
        this.elementData[n] = attribute;
        attribute.setParent(this.parent);
        return attribute2;
    }

    private int indexOfDuplicate(Attribute attribute) {
        int n = -1;
        String string = attribute.getName();
        Namespace namespace = attribute.getNamespace();
        n = this.indexOf(string, namespace);
        return n;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        return super.toString();
    }
}

