/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.Serializable;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRAbstractCompiler;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.util.JRClassLoader;
import org.apache.commons.collections.ReferenceMap;

public abstract class JRAbstractJavaCompiler
extends JRAbstractCompiler {
    private static ThreadLocal classFromBytesRef = new ThreadLocal();
    private static Object CLASS_CACHE_NULL_KEY = new Object();
    private static Map classCache = new ReferenceMap(2, 1);

    protected JRAbstractJavaCompiler(boolean bl) {
        super(bl);
    }

    protected JREvaluator loadEvaluator(Serializable serializable, String string) throws JRException {
        JREvaluator jREvaluator = null;
        try {
            Class clazz = JRAbstractJavaCompiler.getClassFromCache(string);
            if (clazz == null) {
                clazz = JRClassLoader.loadClassFromBytes(string, (byte[])serializable);
                JRAbstractJavaCompiler.putClassInCache(string, clazz);
            }
            classFromBytesRef.set(clazz);
            jREvaluator = (JREvaluator)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new JRException("Error loading expression class : " + string, exception);
        }
        return jREvaluator;
    }

    protected static Object classCacheKey() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Object object = classLoader == null ? CLASS_CACHE_NULL_KEY : classLoader;
        return object;
    }

    protected static synchronized Class getClassFromCache(String string) {
        Object object = JRAbstractJavaCompiler.classCacheKey();
        Map map = (Map)classCache.get(object);
        Class clazz = null;
        if (map != null) {
            clazz = (Class)map.get(string);
        }
        return clazz;
    }

    protected static synchronized void putClassInCache(String string, Class clazz) {
        Object object = JRAbstractJavaCompiler.classCacheKey();
        Map map = (Map)classCache.get(object);
        if (map == null) {
            map = new ReferenceMap(0, 1);
            classCache.put(object, map);
        }
        map.put(string, clazz);
    }
}

