/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodUtils {
    private static Log log = LogFactory.getLog(MethodUtils.class);
    private static boolean loggedAccessibleWarning = false;
    private static final Class[] emptyClassArray = new Class[0];
    private static final Object[] emptyObjectArray = new Object[0];
    private static WeakHashMap cache = new WeakHashMap();

    public static Object invokeMethod(Object object, String string, Object object2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray = new Object[]{object2};
        return MethodUtils.invokeMethod(object, string, objectArray);
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        int n = objectArray.length;
        Class[] classArray = new Class[n];
        int n2 = 0;
        while (n2 < n) {
            classArray[n2] = objectArray[n2].getClass();
            ++n2;
        }
        return MethodUtils.invokeMethod(object, string, objectArray, classArray);
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (classArray == null) {
            classArray = emptyClassArray;
        }
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        if ((method = MethodUtils.getMatchingAccessibleMethod(object.getClass(), string, classArray)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, objectArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object object2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray = new Object[]{object2};
        return MethodUtils.invokeExactMethod(object, string, objectArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        int n = objectArray.length;
        Class[] classArray = new Class[n];
        int n2 = 0;
        while (n2 < n) {
            classArray[n2] = objectArray[n2].getClass();
            ++n2;
        }
        return MethodUtils.invokeExactMethod(object, string, objectArray, classArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        if (classArray == null) {
            classArray = emptyClassArray;
        }
        if ((method = MethodUtils.getAccessibleMethod(object.getClass(), string, classArray)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, objectArray);
    }

    public static Method getAccessibleMethod(Class clazz, String string, Class clazz2) {
        Class[] classArray = new Class[]{clazz2};
        return MethodUtils.getAccessibleMethod(clazz, string, classArray);
    }

    public static Method getAccessibleMethod(Class clazz, String string, Class[] classArray) {
        try {
            MethodDescriptor methodDescriptor = new MethodDescriptor(clazz, string, classArray, true);
            Method method = (Method)cache.get(methodDescriptor);
            if (method != null) {
                return method;
            }
            method = MethodUtils.getAccessibleMethod(clazz.getMethod(string, classArray));
            cache.put(methodDescriptor, method);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, method.getName(), method.getParameterTypes());
        return method;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class clazz, String string, Class[] classArray) {
        Method method = null;
        while (clazz != null) {
            Class<?>[] classArray2 = clazz.getInterfaces();
            int n = 0;
            while (n < classArray2.length) {
                if (Modifier.isPublic(classArray2[n].getModifiers())) {
                    try {
                        method = classArray2[n].getDeclaredMethod(string, classArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                    if (method != null || (method = MethodUtils.getAccessibleMethodFromInterfaceNest(classArray2[n], string, classArray)) != null) break;
                }
                ++n;
            }
            clazz = clazz.getSuperclass();
        }
        if (method != null) {
            return method;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static Method getMatchingAccessibleMethod(Class var0, String var1_1, Class[] var2_2) {
        if (MethodUtils.log.isTraceEnabled()) {
            MethodUtils.log.trace("Matching name=" + var1_1 + " on " + var0);
        }
        var3_3 = new MethodDescriptor(var0, var1_1, var2_2, false);
        try {
            var4_4 = (Method)MethodUtils.cache.get(var3_3);
            if (var4_4 != null) {
                return var4_4;
            }
            var4_4 = var0.getMethod(var1_1, var2_2);
            if (MethodUtils.log.isTraceEnabled()) {
                MethodUtils.log.trace("Found straight match: " + var4_4);
                MethodUtils.log.trace("isPublic:" + Modifier.isPublic(var4_4.getModifiers()));
            }
            try {
                var4_4.setAccessible(true);
            }
            catch (SecurityException var5_6) {
                if (!MethodUtils.loggedAccessibleWarning) {
                    var6_8 = false;
                    try {
                        var7_10 = System.getProperty("java.specification.version");
                        if (var7_10.charAt(0) == '1' && (var7_10.charAt(0) == '0' || var7_10.charAt(0) == '1' || var7_10.charAt(0) == '2' || var7_10.charAt(0) == '3')) {
                            var6_8 = true;
                        }
                    }
                    catch (SecurityException v0) {
                        var6_8 = true;
                    }
                    if (var6_8) {
                        MethodUtils.log.warn("Current Security Manager restricts use of workarounds for reflection bugs  in pre-1.4 JVMs.");
                    }
                    MethodUtils.loggedAccessibleWarning = true;
                }
                MethodUtils.log.debug("Cannot setAccessible on method. Therefore cannot use jvm access bug workaround.", var5_6);
            }
            MethodUtils.cache.put(var3_3, var4_4);
            return var4_4;
        }
        catch (NoSuchMethodException v1) {
            var4_5 = var2_2.length;
            var5_7 = var0.getMethods();
            var6_9 = 0;
            var7_11 = var5_7.length;
            ** while (var6_9 < var7_11)
        }
lbl-1000:
        // 1 sources

        {
            if (var5_7[var6_9].getName().equals(var1_1)) {
                if (MethodUtils.log.isTraceEnabled()) {
                    MethodUtils.log.trace("Found matching name:");
                    MethodUtils.log.trace(var5_7[var6_9]);
                }
                if ((var9_13 = (var8_12 = var5_7[var6_9].getParameterTypes()).length) == var4_5) {
                    var10_14 = true;
                    var11_15 = 0;
                    while (var11_15 < var9_13) {
                        if (MethodUtils.log.isTraceEnabled()) {
                            MethodUtils.log.trace("Param=" + var2_2[var11_15].getName());
                            MethodUtils.log.trace("Method=" + var8_12[var11_15].getName());
                        }
                        if (!MethodUtils.isAssignmentCompatible(var8_12[var11_15], var2_2[var11_15])) {
                            if (MethodUtils.log.isTraceEnabled()) {
                                MethodUtils.log.trace(var8_12[var11_15] + " is not assignable from " + var2_2[var11_15]);
                            }
                            var10_14 = false;
                            break;
                        }
                        ++var11_15;
                    }
                    if (var10_14) {
                        var11_16 = MethodUtils.getAccessibleMethod(var5_7[var6_9]);
                        if (var11_16 != null) {
                            if (MethodUtils.log.isTraceEnabled()) {
                                MethodUtils.log.trace(var11_16 + " accessible version of " + var5_7[var6_9]);
                            }
                            try {
                                var11_16.setAccessible(true);
                            }
                            catch (SecurityException var12_17) {
                                if (!MethodUtils.loggedAccessibleWarning) {
                                    MethodUtils.log.warn("Cannot use JVM pre-1.4 access bug workaround due to restrictive security manager.");
                                    MethodUtils.loggedAccessibleWarning = true;
                                }
                                MethodUtils.log.debug("Cannot setAccessible on method. Therefore cannot use jvm access bug workaround.", var12_17);
                            }
                            MethodUtils.cache.put(var3_3, var11_16);
                            return var11_16;
                        }
                        MethodUtils.log.trace("Couldn't find accessible method.");
                    }
                }
            }
            ++var6_9;
            continue;
        }
lbl75:
        // 1 sources

        MethodUtils.log.trace("No match found.");
        return null;
    }

    public static final boolean isAssignmentCompatible(Class clazz, Class clazz2) {
        Class clazz3;
        if (clazz.isAssignableFrom(clazz2)) {
            return true;
        }
        if (clazz.isPrimitive() && (clazz3 = MethodUtils.getPrimitiveWrapper(clazz)) != null) {
            return clazz3.equals(clazz2);
        }
        return false;
    }

    public static Class getPrimitiveWrapper(Class clazz) {
        if (Boolean.TYPE.equals(clazz)) {
            return Boolean.class;
        }
        if (Float.TYPE.equals(clazz)) {
            return Float.class;
        }
        if (Long.TYPE.equals(clazz)) {
            return Long.class;
        }
        if (Integer.TYPE.equals(clazz)) {
            return Integer.class;
        }
        if (Short.TYPE.equals(clazz)) {
            return Short.class;
        }
        if (Byte.TYPE.equals(clazz)) {
            return Byte.class;
        }
        if (Double.TYPE.equals(clazz)) {
            return Double.class;
        }
        if (Character.TYPE.equals(clazz)) {
            return Character.class;
        }
        return null;
    }

    public static Class getPrimitiveType(Class clazz) {
        if (Boolean.class.equals((Object)clazz)) {
            return Boolean.TYPE;
        }
        if (Float.class.equals((Object)clazz)) {
            return Float.TYPE;
        }
        if (Long.class.equals((Object)clazz)) {
            return Long.TYPE;
        }
        if (Integer.class.equals((Object)clazz)) {
            return Integer.TYPE;
        }
        if (Short.class.equals((Object)clazz)) {
            return Short.TYPE;
        }
        if (Byte.class.equals((Object)clazz)) {
            return Byte.TYPE;
        }
        if (Double.class.equals((Object)clazz)) {
            return Double.TYPE;
        }
        if (Character.class.equals((Object)clazz)) {
            return Character.TYPE;
        }
        if (log.isDebugEnabled()) {
            log.debug("Not a known primitive wrapper class: " + clazz);
        }
        return null;
    }

    public static Class toNonPrimitiveClass(Class clazz) {
        if (clazz.isPrimitive()) {
            Class clazz2 = MethodUtils.getPrimitiveWrapper(clazz);
            if (clazz2 != null) {
                return clazz2;
            }
            return clazz;
        }
        return clazz;
    }

    private static class MethodDescriptor {
        private Class cls;
        private String methodName;
        private Class[] paramTypes;
        private boolean exact;
        private int hashCode;

        public MethodDescriptor(Class clazz, String string, Class[] classArray, boolean bl) {
            if (clazz == null) {
                throw new IllegalArgumentException("Class cannot be null");
            }
            if (string == null) {
                throw new IllegalArgumentException("Method Name cannot be null");
            }
            if (classArray == null) {
                classArray = emptyClassArray;
            }
            this.cls = clazz;
            this.methodName = string;
            this.paramTypes = classArray;
            this.exact = bl;
            this.hashCode = string.length();
        }

        public boolean equals(Object object) {
            if (!(object instanceof MethodDescriptor)) {
                return false;
            }
            MethodDescriptor methodDescriptor = (MethodDescriptor)object;
            return this.exact == methodDescriptor.exact && this.methodName.equals(methodDescriptor.methodName) && this.cls.equals(methodDescriptor.cls) && Arrays.equals(this.paramTypes, methodDescriptor.paramTypes);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

