/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import java.util.List;
import serpro.ppgd.irpf.ColecaoIdDeclaracao;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.ModeloDeclaracao;
import serpro.ppgd.irpf.RepositorioXMLIRPF;
import serpro.ppgd.irpf.alimentandos.Alimentandos;
import serpro.ppgd.irpf.atividaderural.AtividadeRural;
import serpro.ppgd.irpf.bens.Bens;
import serpro.ppgd.irpf.comparativo.Comparativo;
import serpro.ppgd.irpf.conjuge.Conjuge;
import serpro.ppgd.irpf.contribuinte.Contribuinte;
import serpro.ppgd.irpf.dependentes.Dependentes;
import serpro.ppgd.irpf.dividas.Dividas;
import serpro.ppgd.irpf.eleicoes.Doacoes;
import serpro.ppgd.irpf.espolio.Espolio;
import serpro.ppgd.irpf.ganhosdecapital.GanhosDeCapital;
import serpro.ppgd.irpf.impostopago.ImpostoPago;
import serpro.ppgd.irpf.moedaestrangeira.MoedaEstrangeira;
import serpro.ppgd.irpf.pagamentos.Pagamentos;
import serpro.ppgd.irpf.rendIsentos.RendIsentos;
import serpro.ppgd.irpf.rendTributacaoExclusiva.RendTributacaoExclusiva;
import serpro.ppgd.irpf.rendavariavel.RendaVariavel;
import serpro.ppgd.irpf.rendpf.RendPF;
import serpro.ppgd.irpf.rendpf.RendPFDependente;
import serpro.ppgd.irpf.rendpj.ColecaoRendPJDependente;
import serpro.ppgd.irpf.rendpj.ColecaoRendPJTitular;
import serpro.ppgd.irpf.resumo.Resumo;
import serpro.ppgd.negocio.PPGDFacade;

public class IRPFFacade
implements PPGDFacade {
    private static IRPFFacade instancia = null;
    private RepositorioXMLIRPF repositorioXMLIRPF = new RepositorioXMLIRPF();

    private IRPFFacade() {
    }

    public static IRPFFacade getInstancia() {
        if (instancia == null) {
            instancia = new IRPFFacade();
        }
        return instancia;
    }

    public static void abreDeclaracao(IdentificadorDeclaracao identificadorDeclaracao) {
        try {
            IRPFFacade.getInstancia().repositorioXMLIRPF.abreDeclaracao(identificadorDeclaracao);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean existeDeclaracao(String string) {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getListaIdDeclaracoes().existeCPFCadastrado(string);
    }

    public static ColecaoIdDeclaracao getListaIdDeclaracoes() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getListaIdDeclaracoes();
    }

    public static void criarDeclaracao(IdentificadorDeclaracao identificadorDeclaracao) {
        IRPFFacade.getInstancia().repositorioXMLIRPF.criarDeclaracao(identificadorDeclaracao);
    }

    public static void excluirDeclaracao(String string) {
        IdentificadorDeclaracao identificadorDeclaracao = IRPFFacade.getInstancia().recuperarIdDeclaracao(string);
        IRPFFacade.excluirDeclaracao(identificadorDeclaracao);
    }

    public static void excluirDeclaracao(IdentificadorDeclaracao identificadorDeclaracao) {
        IRPFFacade.getInstancia().repositorioXMLIRPF.excluirDeclaracao(identificadorDeclaracao);
    }

    public static void excluirDeclaracao(List list) {
        IRPFFacade.getInstancia().repositorioXMLIRPF.excluirDeclaracao(list);
    }

    public static void salvaDeclaracaoAberta() {
        IRPFFacade.getInstancia().repositorioXMLIRPF.salvaDeclaracaoAberta();
    }

    public static void fechaDeclaracao() {
        IRPFFacade.getInstancia().repositorioXMLIRPF.fechaDeclaracao();
    }

    public Contribuinte getContribuinte() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta().getContribuinte();
    }

    public Conjuge getConjuge() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta().getConjuge();
    }

    public Espolio getEspolio() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta().getEspolio();
    }

    public Resumo getResumo() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta().getResumo();
    }

    public ImpostoPago getImpostoPago() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta().getImpostoPago();
    }

    public Dependentes getDependentes() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta().getDependentes();
    }

    public RendaVariavel getRendaVariavel() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta().getRendaVariavel();
    }

    public ColecaoRendPJDependente getColecaoRendPJDependente() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta().getColecaoRendPJDependente();
    }

    public ColecaoRendPJTitular getColecaoRendPJTitular() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta().getColecaoRendPJTitular();
    }

    public Alimentandos getAlimentandos() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta().getAlimentandos();
    }

    public Pagamentos getPagamentos() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta().getPagamentos();
    }

    public Bens getBens() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta().getBens();
    }

    public Dividas getDividas() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta().getDividas();
    }

    public AtividadeRural getAtividadeRural() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta().getAtividadeRural();
    }

    public GanhosDeCapital getGanhosDeCapital() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta().getGanhosDeCapital();
    }

    public MoedaEstrangeira getMoedaEstrangeira() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta().getMoedaEstrangeira();
    }

    public RendPF getRendPFTitular() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta().getRendPFTitular();
    }

    public Comparativo getComparativo() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta().getComparativo();
    }

    public RendPFDependente getRendPFDependente() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta().getRendPFDependente();
    }

    public RendIsentos getRendIsentos() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta().getRendIsentos();
    }

    public RendTributacaoExclusiva getRendTributacaoExclusiva() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta().getRendTributacaoExclusiva();
    }

    public Doacoes getDoacoes() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta().getDoacoes();
    }

    public ModeloDeclaracao getModelo() {
        return IRPFFacade.getDeclaracao().getModelo();
    }

    public IdentificadorDeclaracao getIdDeclaracaoAberto() {
        return this.repositorioXMLIRPF.getIdDeclaracaoAberto();
    }

    public IdentificadorDeclaracao recuperarIdDeclaracao(String string) {
        return this.repositorioXMLIRPF.getIdDeclaracao(string);
    }

    public DeclaracaoIRPF recuperarDeclaracaoIRPF(String string) {
        try {
            return this.repositorioXMLIRPF.recuperarDeclaracaoIRPF(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void salvarDeclaracao(String string) {
        try {
            this.repositorioXMLIRPF.salvarDeclaracao(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean existeDeclaracoes() {
        return IRPFFacade.getListaIdDeclaracoes().recuperarLista().size() > 0;
    }

    public static DeclaracaoIRPF getDeclaracao() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta();
    }
}

