/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.fill.calculation;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRDistinctCountExtendedIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRExtendedIncrementerFactory;

public class MeasureDefinition {
    protected final byte calculation;
    protected final JRExtendedIncrementerFactory incrementerFactory;
    protected final Class valueClass;
    protected final boolean isSystemDefined;
    protected static final AbstractValueProvider VALUE_PROVIDER = new AbstractValueProvider(){

        public Object getValue(JRCalculable jRCalculable) {
            return jRCalculable.getValue();
        }
    };

    public MeasureDefinition(Class clazz, byte by, JRExtendedIncrementerFactory jRExtendedIncrementerFactory) {
        this(clazz, by, jRExtendedIncrementerFactory, false);
    }

    protected MeasureDefinition(Class clazz, byte by, JRExtendedIncrementerFactory jRExtendedIncrementerFactory, boolean bl) {
        this.valueClass = clazz;
        this.calculation = by;
        this.incrementerFactory = jRExtendedIncrementerFactory;
        this.isSystemDefined = bl;
    }

    public static MeasureDefinition createHelperMeasure(MeasureDefinition measureDefinition, byte by) {
        return new MeasureDefinition(measureDefinition.valueClass, by, measureDefinition.incrementerFactory, true);
    }

    public static MeasureDefinition createDistinctCountHelperMeasure(MeasureDefinition measureDefinition) {
        return new MeasureDefinition(measureDefinition.valueClass, 0, JRDistinctCountExtendedIncrementerFactory.getInstance(), true);
    }

    public byte getCalculation() {
        return this.calculation;
    }

    public JRExtendedIncrementerFactory getIncrementerFactory() {
        return this.incrementerFactory;
    }

    public JRExtendedIncrementer getIncrementer() {
        return this.incrementerFactory.getExtendedIncrementer(this.calculation);
    }

    protected boolean isSystemDefined() {
        return this.isSystemDefined;
    }

    public Class getValueClass() {
        return this.valueClass;
    }

    public class MeasureValue
    implements JRCalculable {
        private Object value = null;
        private MeasureValue[] helpers = new MeasureValue[3];
        private boolean initialized;
        private JRExtendedIncrementer incrementer;

        public MeasureValue() {
            this.incrementer = MeasureDefinition.this.getIncrementer();
            this.init();
        }

        protected void init() {
            this.value = this.incrementer.initialValue();
            this.setInitialized(true);
        }

        public void addValue(Object object) throws JRException {
            this.value = this.incrementer.increment(this, object, VALUE_PROVIDER);
            this.setInitialized(false);
        }

        public void addValue(MeasureValue measureValue) throws JRException {
            if (!measureValue.isInitialized()) {
                this.value = this.incrementer.combine(this, measureValue, VALUE_PROVIDER);
                this.setInitialized(false);
            }
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.getValue());
        }

        public MeasureValue setHelper(MeasureValue measureValue, byte by) {
            MeasureValue measureValue2 = this.helpers[by];
            this.helpers[by] = measureValue;
            return measureValue2;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public Object getIncrementedValue() {
            return this.value;
        }

        public JRCalculable getHelperVariable(byte by) {
            return this.helpers[by];
        }

        public void setInitialized(boolean bl) {
            this.initialized = bl;
        }
    }
}

