/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class JRClassGenerator {
    private static final int EXPR_MAX_COUNT_PER_METHOD = 100;
    private static Map fieldPrefixMap = null;
    private static Map variablePrefixMap = null;
    private static Map methodSuffixMap = null;
    protected final JRSourceCompileTask sourceTask;
    protected Map parametersMap;
    protected Map fieldsMap;
    protected Map variablesMap;
    protected JRVariable[] variables;

    static {
        fieldPrefixMap = new HashMap();
        fieldPrefixMap.put(new Byte(1), "Old");
        fieldPrefixMap.put(new Byte(2), "");
        fieldPrefixMap.put(new Byte(3), "");
        variablePrefixMap = new HashMap();
        variablePrefixMap.put(new Byte(1), "Old");
        variablePrefixMap.put(new Byte(2), "Estimated");
        variablePrefixMap.put(new Byte(3), "");
        methodSuffixMap = new HashMap();
        methodSuffixMap.put(new Byte(1), "Old");
        methodSuffixMap.put(new Byte(2), "Estimated");
        methodSuffixMap.put(new Byte(3), "");
    }

    protected JRClassGenerator(JRSourceCompileTask jRSourceCompileTask) {
        this.sourceTask = jRSourceCompileTask;
        this.parametersMap = jRSourceCompileTask.getParametersMap();
        this.fieldsMap = jRSourceCompileTask.getFieldsMap();
        this.variablesMap = jRSourceCompileTask.getVariablesMap();
        this.variables = jRSourceCompileTask.getVariables();
    }

    public static String generateClass(JRSourceCompileTask jRSourceCompileTask) throws JRException {
        JRClassGenerator jRClassGenerator = new JRClassGenerator(jRSourceCompileTask);
        return jRClassGenerator.generateClass();
    }

    protected String generateClass() throws JRException {
        StringBuffer stringBuffer = new StringBuffer();
        this.generateClassStart(stringBuffer);
        this.generateDeclarations(stringBuffer);
        this.generateInitMethod(stringBuffer);
        this.generateInitParamsMethod(stringBuffer);
        if (this.fieldsMap != null) {
            this.generateInitFieldsMethod(stringBuffer);
        }
        this.generateInitVarsMethod(stringBuffer);
        List list = this.sourceTask.getExpressions();
        stringBuffer.append(this.generateMethod((byte)3, list));
        if (this.sourceTask.isOnlyDefaultEvaluation()) {
            ArrayList arrayList = new ArrayList();
            stringBuffer.append(this.generateMethod((byte)1, arrayList));
            stringBuffer.append(this.generateMethod((byte)2, arrayList));
        } else {
            stringBuffer.append(this.generateMethod((byte)1, list));
            stringBuffer.append(this.generateMethod((byte)2, list));
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    private void generateInitMethod(StringBuffer stringBuffer) {
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("    /**\n");
        stringBuffer.append("     *\n");
        stringBuffer.append("     */\n");
        stringBuffer.append("    public void customizedInit(\n");
        stringBuffer.append("        Map pm,\n");
        stringBuffer.append("        Map fm,\n");
        stringBuffer.append("        Map vm\n");
        stringBuffer.append("        )\n");
        stringBuffer.append("    {\n");
        stringBuffer.append("        initParams(pm);\n");
        if (this.fieldsMap != null) {
            stringBuffer.append("        initFields(fm);\n");
        }
        stringBuffer.append("        initVars(vm);\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
    }

    protected final void generateClassStart(StringBuffer stringBuffer) {
        stringBuffer.append("/*\n");
        stringBuffer.append(" * Generated by JasperReports - ");
        stringBuffer.append(new SimpleDateFormat().format(new Date()));
        stringBuffer.append("\n");
        stringBuffer.append(" */\n");
        stringBuffer.append("import net.sf.jasperreports.engine.*;\n");
        stringBuffer.append("import net.sf.jasperreports.engine.fill.*;\n");
        stringBuffer.append("\n");
        stringBuffer.append("import java.util.*;\n");
        stringBuffer.append("import java.math.*;\n");
        stringBuffer.append("import java.text.*;\n");
        stringBuffer.append("import java.io.*;\n");
        stringBuffer.append("import java.net.*;\n");
        stringBuffer.append("\n");
        String[] stringArray = this.sourceTask.getImports();
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append("import ");
                stringBuffer.append(stringArray[n]);
                stringBuffer.append(";\n");
                ++n;
            }
        }
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("/**\n");
        stringBuffer.append(" *\n");
        stringBuffer.append(" */\n");
        stringBuffer.append("public class ");
        stringBuffer.append(this.sourceTask.getUnitName());
        stringBuffer.append(" extends JREvaluator\n");
        stringBuffer.append("{\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("    /**\n");
        stringBuffer.append("     *\n");
        stringBuffer.append("     */\n");
    }

    protected final void generateDeclarations(StringBuffer stringBuffer) {
        Iterator iterator;
        Collection collection;
        if (this.parametersMap != null && this.parametersMap.size() > 0) {
            collection = this.parametersMap.keySet();
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("    private JRFillParameter parameter_");
                stringBuffer.append(JRStringUtil.getLiteral((String)iterator.next()));
                stringBuffer.append(" = null;\n");
            }
        }
        if (this.fieldsMap != null && this.fieldsMap.size() > 0) {
            collection = this.fieldsMap.keySet();
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("    private JRFillField field_");
                stringBuffer.append(JRStringUtil.getLiteral((String)iterator.next()));
                stringBuffer.append(" = null;\n");
            }
        }
        if (this.variables != null && this.variables.length > 0) {
            int n = 0;
            while (n < this.variables.length) {
                stringBuffer.append("    private JRFillVariable variable_");
                stringBuffer.append(JRStringUtil.getLiteral(this.variables[n].getName()));
                stringBuffer.append(" = null;\n");
                ++n;
            }
        }
    }

    protected final void generateInitParamsMethod(StringBuffer stringBuffer) throws JRException {
        Iterator<Object> iterator = null;
        iterator = this.parametersMap != null && this.parametersMap.size() > 0 ? this.parametersMap.keySet().iterator() : Collections.EMPTY_SET.iterator();
        this.generateInitParamsMethod(stringBuffer, iterator, 0);
    }

    protected final void generateInitFieldsMethod(StringBuffer stringBuffer) throws JRException {
        Iterator<Object> iterator = null;
        iterator = this.fieldsMap != null && this.fieldsMap.size() > 0 ? this.fieldsMap.keySet().iterator() : Collections.EMPTY_SET.iterator();
        this.generateInitFieldsMethod(stringBuffer, iterator, 0);
    }

    protected final void generateInitVarsMethod(StringBuffer stringBuffer) throws JRException {
        Iterator<Object> iterator = null;
        iterator = this.variables != null && this.variables.length > 0 ? Arrays.asList(this.variables).iterator() : Collections.EMPTY_LIST.iterator();
        this.generateInitVarsMethod(stringBuffer, iterator, 0);
    }

    private void generateInitParamsMethod(StringBuffer stringBuffer, Iterator iterator, int n) throws JRException {
        stringBuffer.append("    /**\n");
        stringBuffer.append("     *\n");
        stringBuffer.append("     */\n");
        stringBuffer.append("    private void initParams");
        if (n > 0) {
            stringBuffer.append(n);
        }
        stringBuffer.append("(Map pm)\n");
        stringBuffer.append("    {\n");
        int n2 = 0;
        while (n2 < 100 && iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append("        parameter_");
            stringBuffer.append(JRStringUtil.getLiteral(string));
            stringBuffer.append(" = (JRFillParameter)pm.get(\"");
            stringBuffer.append(string);
            stringBuffer.append("\");\n");
            ++n2;
        }
        if (iterator.hasNext()) {
            stringBuffer.append("        initParams");
            stringBuffer.append(n + 1);
            stringBuffer.append("(pm);\n");
        }
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        if (iterator.hasNext()) {
            this.generateInitParamsMethod(stringBuffer, iterator, n + 1);
        }
    }

    private void generateInitFieldsMethod(StringBuffer stringBuffer, Iterator iterator, int n) throws JRException {
        stringBuffer.append("    /**\n");
        stringBuffer.append("     *\n");
        stringBuffer.append("     */\n");
        stringBuffer.append("    private void initFields");
        if (n > 0) {
            stringBuffer.append(n);
        }
        stringBuffer.append("(Map fm)\n");
        stringBuffer.append("    {\n");
        int n2 = 0;
        while (n2 < 100 && iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append("        field_");
            stringBuffer.append(JRStringUtil.getLiteral(string));
            stringBuffer.append(" = (JRFillField)fm.get(\"");
            stringBuffer.append(string);
            stringBuffer.append("\");\n");
            ++n2;
        }
        if (iterator.hasNext()) {
            stringBuffer.append("        initFields");
            stringBuffer.append(n + 1);
            stringBuffer.append("(fm);\n");
        }
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        if (iterator.hasNext()) {
            this.generateInitFieldsMethod(stringBuffer, iterator, n + 1);
        }
    }

    private void generateInitVarsMethod(StringBuffer stringBuffer, Iterator iterator, int n) throws JRException {
        stringBuffer.append("    /**\n");
        stringBuffer.append("     *\n");
        stringBuffer.append("     */\n");
        stringBuffer.append("    private void initVars");
        if (n > 0) {
            stringBuffer.append(n);
        }
        stringBuffer.append("(Map vm)\n");
        stringBuffer.append("    {\n");
        int n2 = 0;
        while (n2 < 100 && iterator.hasNext()) {
            String string = ((JRVariable)iterator.next()).getName();
            stringBuffer.append("        variable_");
            stringBuffer.append(JRStringUtil.getLiteral(string));
            stringBuffer.append(" = (JRFillVariable)vm.get(\"");
            stringBuffer.append(string);
            stringBuffer.append("\");\n");
            ++n2;
        }
        if (iterator.hasNext()) {
            stringBuffer.append("        initVars");
            stringBuffer.append(n + 1);
            stringBuffer.append("(vm);\n");
        }
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        if (iterator.hasNext()) {
            this.generateInitVarsMethod(stringBuffer, iterator, n + 1);
        }
    }

    protected final String generateMethod(byte by, List list) throws JRException {
        StringBuffer stringBuffer = new StringBuffer();
        if (list.size() > 0) {
            stringBuffer.append(this.generateMethod(list.listIterator(), 0, by));
        } else {
            stringBuffer.append("    /**\n");
            stringBuffer.append("     *\n");
            stringBuffer.append("     */\n");
            stringBuffer.append("    public Object evaluate");
            stringBuffer.append((String)methodSuffixMap.get(new Byte(by)));
            stringBuffer.append("(int id) throws Throwable\n");
            stringBuffer.append("    {\n");
            stringBuffer.append("        return null;\n");
            stringBuffer.append("    }\n");
            stringBuffer.append("\n");
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private String generateMethod(Iterator iterator, int n, byte by) throws JRException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    /**\n");
        stringBuffer.append("     *\n");
        stringBuffer.append("     */\n");
        if (n > 0) {
            stringBuffer.append("    private Object evaluate");
            stringBuffer.append((String)methodSuffixMap.get(new Byte(by)));
            stringBuffer.append(n);
        } else {
            stringBuffer.append("    public Object evaluate");
            stringBuffer.append((String)methodSuffixMap.get(new Byte(by)));
        }
        stringBuffer.append("(int id) throws Throwable\n");
        stringBuffer.append("    {\n");
        stringBuffer.append("        Object value = null;\n");
        stringBuffer.append("\n");
        stringBuffer.append("        switch (id)\n");
        stringBuffer.append("        {\n");
        JRExpression jRExpression = null;
        int n2 = 0;
        while (iterator.hasNext() && n2 < 100) {
            jRExpression = (JRExpression)iterator.next();
            stringBuffer.append("            case ");
            stringBuffer.append(this.sourceTask.getExpressionId(jRExpression));
            stringBuffer.append(" : \n");
            stringBuffer.append("            {\n");
            stringBuffer.append("                value = (");
            stringBuffer.append(jRExpression.getValueClassName());
            stringBuffer.append(")(");
            stringBuffer.append(this.generateExpression(jRExpression, by));
            stringBuffer.append(");\n");
            stringBuffer.append("                break;\n");
            stringBuffer.append("            }\n");
            ++n2;
        }
        stringBuffer.append("           default :\n");
        stringBuffer.append("           {\n");
        if (iterator.hasNext()) {
            stringBuffer.append("               value = evaluate");
            stringBuffer.append((String)methodSuffixMap.get(new Byte(by)));
            stringBuffer.append(n + 1);
            stringBuffer.append("(id);\n");
        }
        stringBuffer.append("           }\n");
        stringBuffer.append("        }\n");
        stringBuffer.append("        \n");
        stringBuffer.append("        return value;\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        if (iterator.hasNext()) {
            stringBuffer.append(this.generateMethod(iterator, n + 1, by));
        }
        return stringBuffer.toString();
    }

    private String generateExpression(JRExpression jRExpression, byte by) {
        JRParameter jRParameter = null;
        JRField jRField = null;
        JRVariable jRVariable = null;
        StringBuffer stringBuffer = new StringBuffer();
        JRExpressionChunk[] jRExpressionChunkArray = jRExpression.getChunks();
        JRExpressionChunk jRExpressionChunk = null;
        String string = null;
        if (jRExpressionChunkArray != null && jRExpressionChunkArray.length > 0) {
            int n = 0;
            while (n < jRExpressionChunkArray.length) {
                jRExpressionChunk = jRExpressionChunkArray[n];
                string = jRExpressionChunk.getText();
                if (string == null) {
                    string = "";
                }
                switch (jRExpressionChunk.getType()) {
                    case 1: {
                        stringBuffer.append(string);
                        break;
                    }
                    case 2: {
                        jRParameter = (JRParameter)this.parametersMap.get(string);
                        stringBuffer.append("((");
                        stringBuffer.append(jRParameter.getValueClassName());
                        stringBuffer.append(")parameter_");
                        stringBuffer.append(JRStringUtil.getLiteral(string));
                        stringBuffer.append(".getValue())");
                        break;
                    }
                    case 3: {
                        jRField = (JRField)this.fieldsMap.get(string);
                        stringBuffer.append("((");
                        stringBuffer.append(jRField.getValueClassName());
                        stringBuffer.append(")field_");
                        stringBuffer.append(JRStringUtil.getLiteral(string));
                        stringBuffer.append(".get");
                        stringBuffer.append((String)fieldPrefixMap.get(new Byte(by)));
                        stringBuffer.append("Value())");
                        break;
                    }
                    case 4: {
                        jRVariable = (JRVariable)this.variablesMap.get(string);
                        stringBuffer.append("((");
                        stringBuffer.append(jRVariable.getValueClassName());
                        stringBuffer.append(")variable_");
                        stringBuffer.append(JRStringUtil.getLiteral(string));
                        stringBuffer.append(".get");
                        stringBuffer.append((String)variablePrefixMap.get(new Byte(by)));
                        stringBuffer.append("Value())");
                        break;
                    }
                    case 5: {
                        stringBuffer.append("str(\"");
                        stringBuffer.append(string);
                        stringBuffer.append("\")");
                    }
                }
                ++n;
            }
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }
}

