/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

public class JRStringUtil {
    public static String xmlEncode(String string) {
        int n = string.length();
        if (string != null && n > 0) {
            StringBuffer stringBuffer = new StringBuffer(n * 12 / 10);
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                char c = string.charAt(n3);
                switch (c) {
                    case '&': {
                        if (n2 < n3) {
                            stringBuffer.append(string.substring(n2, n3));
                        }
                        n2 = n3 + 1;
                        stringBuffer.append("&amp;");
                        break;
                    }
                    case '>': {
                        if (n2 < n3) {
                            stringBuffer.append(string.substring(n2, n3));
                        }
                        n2 = n3 + 1;
                        stringBuffer.append("&gt;");
                        break;
                    }
                    case '<': {
                        if (n2 < n3) {
                            stringBuffer.append(string.substring(n2, n3));
                        }
                        n2 = n3 + 1;
                        stringBuffer.append("&lt;");
                        break;
                    }
                    case '\"': {
                        if (n2 < n3) {
                            stringBuffer.append(string.substring(n2, n3));
                        }
                        n2 = n3 + 1;
                        stringBuffer.append("&quot;");
                        break;
                    }
                }
                ++n3;
            }
            if (n2 < n) {
                stringBuffer.append(string.substring(n2));
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static String htmlEncode(String string) {
        int n = string.length();
        if (string != null && n > 0) {
            StringBuffer stringBuffer = new StringBuffer(n * 12 / 10);
            boolean bl = true;
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                char c = string.charAt(n3);
                switch (c) {
                    case ' ': {
                        if (bl) {
                            if (n2 < n3) {
                                stringBuffer.append(string.substring(n2, n3));
                            }
                            n2 = n3 + 1;
                            stringBuffer.append("&nbsp;");
                            bl = false;
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case '&': {
                        if (n2 < n3) {
                            stringBuffer.append(string.substring(n2, n3));
                        }
                        n2 = n3 + 1;
                        stringBuffer.append("&amp;");
                        bl = false;
                        break;
                    }
                    case '>': {
                        if (n2 < n3) {
                            stringBuffer.append(string.substring(n2, n3));
                        }
                        n2 = n3 + 1;
                        stringBuffer.append("&gt;");
                        bl = false;
                        break;
                    }
                    case '<': {
                        if (n2 < n3) {
                            stringBuffer.append(string.substring(n2, n3));
                        }
                        n2 = n3 + 1;
                        stringBuffer.append("&lt;");
                        bl = false;
                        break;
                    }
                    case '\"': {
                        if (n2 < n3) {
                            stringBuffer.append(string.substring(n2, n3));
                        }
                        n2 = n3 + 1;
                        stringBuffer.append("&quot;");
                        bl = false;
                        break;
                    }
                    case '\n': {
                        if (n2 < n3) {
                            stringBuffer.append(string.substring(n2, n3));
                        }
                        n2 = n3 + 1;
                        stringBuffer.append("<br/>");
                        bl = false;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                ++n3;
            }
            if (n2 < n) {
                stringBuffer.append(string.substring(n2));
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static String getLiteral(String string) {
        if (JRStringUtil.isValidLiteral(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 5);
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n = 0;
        while (n < cArray.length) {
            if (n == 0 && !Character.isJavaIdentifierStart(cArray[n])) {
                stringBuffer.append((int)cArray[n]);
            } else if (n != 0 && !Character.isJavaIdentifierPart(cArray[n])) {
                stringBuffer.append((int)cArray[n]);
            } else {
                stringBuffer.append(cArray[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static boolean isValidLiteral(String string) {
        boolean bl = true;
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n = 0;
        while (n < cArray.length) {
            if (n == 0 && !Character.isJavaIdentifierStart(cArray[n])) {
                bl = false;
                break;
            }
            if (n != 0 && !Character.isJavaIdentifierPart(cArray[n])) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    public static String replaceDosEOL(String string) {
        if (string == null || string.length() < 2) {
            return string;
        }
        int n = string.length();
        char[] cArray = string.toCharArray();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = cArray[n3];
            if (c != '\r' || n3 + 1 >= n || cArray[n3 + 1] != '\n') {
                if (n2 > 0) {
                    cArray[n3 - n2] = c;
                }
            } else {
                ++n2;
            }
            ++n3;
        }
        return n2 > 0 ? new String(cArray, 0, n - n2) : string;
    }
}

