/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.RetornosValidacoes;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.util.TabelaMensagens;

public abstract class ValidadorDefault
implements ValidadorIf {
    private Informacao informacao;
    private Object parValidacao;
    private RetornosValidacoes retornosValidacoes;
    private byte severidade;
    private boolean verificaVazio = false;
    private boolean validadorAtivo = true;
    private String mensagemValidacao = "";
    protected static TabelaMensagens tab = TabelaMensagens.getTabelaMensagens();

    public ValidadorDefault(byte by) {
        this.severidade = by;
    }

    public void setInformacao(Informacao informacao) {
        if (informacao == null) {
            throw new IllegalArgumentException("Informacao \u00e9 null");
        }
        this.informacao = informacao;
    }

    protected Informacao getInformacao() {
        return this.informacao;
    }

    public void setParValidacao(Object object) {
        this.parValidacao = object;
    }

    protected Object getParValidacao() {
        return this.parValidacao;
    }

    public void setRetornosValidacoes(RetornosValidacoes retornosValidacoes) {
        if (retornosValidacoes == null) {
            throw new IllegalArgumentException("RetornosValidacoes \u00e9 null");
        }
        this.retornosValidacoes = retornosValidacoes;
    }

    protected RetornosValidacoes getRetornosValidacoes() {
        return this.retornosValidacoes;
    }

    public void setSeveridade(byte by) {
        this.severidade = by;
    }

    public byte getSeveridade() {
        return this.severidade;
    }

    public abstract RetornoValidacao validarImplementado();

    public void validar() {
        if (this.isValidadorAtivo() && (this.isVerificaVazio() || !this.getInformacao().isVazio())) {
            RetornoValidacao retornoValidacao = this.validarImplementado();
            if (retornoValidacao != null) {
                if (retornoValidacao.getSeveridade() > 0) {
                    retornoValidacao.setSeveridade(this.getSeveridade());
                }
                if (!this.getMensagemValidacao().trim().equals("")) {
                    retornoValidacao.setMensagemValidacao(this.getMensagemValidacao());
                }
                this.getRetornosValidacoes().add(retornoValidacao);
            } else {
                this.getRetornosValidacoes().add(new RetornoValidacao(0));
            }
        }
    }

    public void setVerificaVazio(boolean bl) {
        this.verificaVazio = bl;
    }

    public boolean isVerificaVazio() {
        return this.verificaVazio;
    }

    public boolean isValidadorAtivo() {
        return this.validadorAtivo;
    }

    public void setValidadorAtivo(boolean bl) {
        this.validadorAtivo = bl;
    }

    public String getMensagemValidacao() {
        return this.mensagemValidacao;
    }

    public void setMensagemValidacao(String string) {
        this.mensagemValidacao = string;
    }
}

