/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.debug;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JLabel;

public final class FormDebugUtils {
    private FormDebugUtils() {
    }

    public static void dumpAll(Container container) {
        if (!(container.getLayout() instanceof FormLayout)) {
            System.out.println("The container's layout is not a FormLayout.");
            return;
        }
        FormLayout formLayout = (FormLayout)container.getLayout();
        FormDebugUtils.dumpColumnSpecs(formLayout);
        FormDebugUtils.dumpRowSpecs(formLayout);
        System.out.println();
        FormDebugUtils.dumpColumnGroups(formLayout);
        FormDebugUtils.dumpRowGroups(formLayout);
        System.out.println();
        FormDebugUtils.dumpConstraints(container);
        FormDebugUtils.dumpGridBounds(container);
    }

    public static void dumpColumnSpecs(FormLayout formLayout) {
        System.out.print("COLUMN SPECS:");
        int n = 1;
        while (n <= formLayout.getColumnCount()) {
            ColumnSpec columnSpec = formLayout.getColumnSpec(n);
            System.out.print(columnSpec.toShortString());
            if (n < formLayout.getColumnCount()) {
                System.out.print(", ");
            }
            ++n;
        }
        System.out.println();
    }

    public static void dumpRowSpecs(FormLayout formLayout) {
        System.out.print("ROW SPECS:   ");
        int n = 1;
        while (n <= formLayout.getRowCount()) {
            RowSpec rowSpec = formLayout.getRowSpec(n);
            System.out.print(rowSpec.toShortString());
            if (n < formLayout.getRowCount()) {
                System.out.print(", ");
            }
            ++n;
        }
        System.out.println();
    }

    public static void dumpColumnGroups(FormLayout formLayout) {
        FormDebugUtils.dumpGroups("COLUMN GROUPS: ", formLayout.getColumnGroups());
    }

    public static void dumpRowGroups(FormLayout formLayout) {
        FormDebugUtils.dumpGroups("ROW GROUPS:    ", formLayout.getRowGroups());
    }

    public static void dumpGridBounds(Container container) {
        System.out.println("GRID BOUNDS");
        FormDebugUtils.dumpGridBounds(FormDebugUtils.getLayoutInfo(container));
    }

    public static void dumpGridBounds(FormLayout.LayoutInfo layoutInfo) {
        System.out.print("COLUMN ORIGINS: ");
        int n = 0;
        while (n < layoutInfo.columnOrigins.length) {
            System.out.print(String.valueOf(layoutInfo.columnOrigins[n]) + " ");
            ++n;
        }
        System.out.println();
        System.out.print("ROW ORIGINS:    ");
        n = 0;
        while (n < layoutInfo.rowOrigins.length) {
            System.out.print(String.valueOf(layoutInfo.rowOrigins[n]) + " ");
            ++n;
        }
        System.out.println();
    }

    public static void dumpConstraints(Container container) {
        System.out.println("COMPONENT CONSTRAINTS");
        if (!(container.getLayout() instanceof FormLayout)) {
            System.out.println("The container's layout is not a FormLayout.");
            return;
        }
        FormLayout formLayout = (FormLayout)container.getLayout();
        int n = container.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = container.getComponent(n2);
            CellConstraints cellConstraints = formLayout.getConstraints(component);
            String string = cellConstraints == null ? "no constraints" : cellConstraints.toShortString(formLayout);
            System.out.print(string);
            System.out.print("; ");
            String string2 = component.getClass().getName();
            System.out.print(string2);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                System.out.print("      \"" + jLabel.getText() + "\"");
            }
            if (component.getName() != null) {
                System.out.print("; name=");
                System.out.print(component.getName());
            }
            System.out.println();
            ++n2;
        }
        System.out.println();
    }

    private static void dumpGroups(String string, int[][] nArray) {
        System.out.print(String.valueOf(string) + " {");
        int n = 0;
        while (n < nArray.length) {
            int[] nArray2 = nArray[n];
            System.out.print(" {");
            int n2 = 0;
            while (n2 < nArray2.length) {
                System.out.print(nArray2[n2]);
                if (n2 < nArray2.length - 1) {
                    System.out.print(", ");
                }
                ++n2;
            }
            System.out.print("} ");
            if (n < nArray.length - 1) {
                System.out.print(", ");
            }
            ++n;
        }
        System.out.println("}");
    }

    public static FormLayout.LayoutInfo getLayoutInfo(Container container) {
        if (!(container.getLayout() instanceof FormLayout)) {
            throw new IllegalArgumentException("The container must use an instance of FormLayout.");
        }
        FormLayout formLayout = (FormLayout)container.getLayout();
        return formLayout.getLayoutInfo(container);
    }
}

