/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.date;

import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.jfree.date.MonthConstants;
import org.jfree.date.SpreadsheetDate;

public abstract class SerialDate
implements Comparable,
Serializable,
MonthConstants {
    private static final long serialVersionUID = -293716040467423637L;
    public static final DateFormatSymbols DATE_FORMAT_SYMBOLS = new SimpleDateFormat().getDateFormatSymbols();
    public static final int SERIAL_LOWER_BOUND = 2;
    public static final int SERIAL_UPPER_BOUND = 2958465;
    public static final int MINIMUM_YEAR_SUPPORTED = 1900;
    public static final int MAXIMUM_YEAR_SUPPORTED = 9999;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int SUNDAY = 1;
    static final int[] LAST_DAY_OF_MONTH;
    static final int[] AGGREGATE_DAYS_TO_END_OF_MONTH;
    static final int[] AGGREGATE_DAYS_TO_END_OF_PRECEDING_MONTH;
    static final int[] LEAP_YEAR_AGGREGATE_DAYS_TO_END_OF_MONTH;
    static final int[] LEAP_YEAR_AGGREGATE_DAYS_TO_END_OF_PRECEDING_MONTH;
    public static final int FIRST_WEEK_IN_MONTH = 1;
    public static final int SECOND_WEEK_IN_MONTH = 2;
    public static final int THIRD_WEEK_IN_MONTH = 3;
    public static final int FOURTH_WEEK_IN_MONTH = 4;
    public static final int LAST_WEEK_IN_MONTH = 0;
    public static final int INCLUDE_NONE = 0;
    public static final int INCLUDE_FIRST = 1;
    public static final int INCLUDE_SECOND = 2;
    public static final int INCLUDE_BOTH = 3;
    public static final int PRECEDING = -1;
    public static final int NEAREST = 0;
    public static final int FOLLOWING = 1;
    private String description;

    static {
        int[] nArray = new int[13];
        nArray[1] = 31;
        nArray[2] = 28;
        nArray[3] = 31;
        nArray[4] = 30;
        nArray[5] = 31;
        nArray[6] = 30;
        nArray[7] = 31;
        nArray[8] = 31;
        nArray[9] = 30;
        nArray[10] = 31;
        nArray[11] = 30;
        nArray[12] = 31;
        LAST_DAY_OF_MONTH = nArray;
        int[] nArray2 = new int[13];
        nArray2[1] = 31;
        nArray2[2] = 59;
        nArray2[3] = 90;
        nArray2[4] = 120;
        nArray2[5] = 151;
        nArray2[6] = 181;
        nArray2[7] = 212;
        nArray2[8] = 243;
        nArray2[9] = 273;
        nArray2[10] = 304;
        nArray2[11] = 334;
        nArray2[12] = 365;
        AGGREGATE_DAYS_TO_END_OF_MONTH = nArray2;
        int[] nArray3 = new int[14];
        nArray3[2] = 31;
        nArray3[3] = 59;
        nArray3[4] = 90;
        nArray3[5] = 120;
        nArray3[6] = 151;
        nArray3[7] = 181;
        nArray3[8] = 212;
        nArray3[9] = 243;
        nArray3[10] = 273;
        nArray3[11] = 304;
        nArray3[12] = 334;
        nArray3[13] = 365;
        AGGREGATE_DAYS_TO_END_OF_PRECEDING_MONTH = nArray3;
        int[] nArray4 = new int[13];
        nArray4[1] = 31;
        nArray4[2] = 60;
        nArray4[3] = 91;
        nArray4[4] = 121;
        nArray4[5] = 152;
        nArray4[6] = 182;
        nArray4[7] = 213;
        nArray4[8] = 244;
        nArray4[9] = 274;
        nArray4[10] = 305;
        nArray4[11] = 335;
        nArray4[12] = 366;
        LEAP_YEAR_AGGREGATE_DAYS_TO_END_OF_MONTH = nArray4;
        int[] nArray5 = new int[14];
        nArray5[2] = 31;
        nArray5[3] = 60;
        nArray5[4] = 91;
        nArray5[5] = 121;
        nArray5[6] = 152;
        nArray5[7] = 182;
        nArray5[8] = 213;
        nArray5[9] = 244;
        nArray5[10] = 274;
        nArray5[11] = 305;
        nArray5[12] = 335;
        nArray5[13] = 366;
        LEAP_YEAR_AGGREGATE_DAYS_TO_END_OF_PRECEDING_MONTH = nArray5;
    }

    protected SerialDate() {
    }

    public static boolean isValidWeekdayCode(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public static int stringToWeekdayCode(String string) {
        String[] stringArray = DATE_FORMAT_SYMBOLS.getShortWeekdays();
        String[] stringArray2 = DATE_FORMAT_SYMBOLS.getWeekdays();
        int n = -1;
        string = string.trim();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            if (string.equals(stringArray[n2])) {
                n = n2;
                break;
            }
            if (string.equals(stringArray2[n2])) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public static String weekdayCodeToString(int n) {
        String[] stringArray = DATE_FORMAT_SYMBOLS.getWeekdays();
        return stringArray[n];
    }

    public static String[] getMonths() {
        return SerialDate.getMonths(false);
    }

    public static String[] getMonths(boolean bl) {
        if (bl) {
            return DATE_FORMAT_SYMBOLS.getShortMonths();
        }
        return DATE_FORMAT_SYMBOLS.getMonths();
    }

    public static boolean isValidMonthCode(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static int monthCodeToQuarter(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return 1;
            }
            case 4: 
            case 5: 
            case 6: {
                return 2;
            }
            case 7: 
            case 8: 
            case 9: {
                return 3;
            }
            case 10: 
            case 11: 
            case 12: {
                return 4;
            }
        }
        throw new IllegalArgumentException("SerialDate.monthCodeToQuarter: invalid month code.");
    }

    public static String monthCodeToString(int n) {
        return SerialDate.monthCodeToString(n, false);
    }

    public static String monthCodeToString(int n, boolean bl) {
        if (!SerialDate.isValidMonthCode(n)) {
            throw new IllegalArgumentException("SerialDate.monthCodeToString: month outside valid range.");
        }
        String[] stringArray = bl ? DATE_FORMAT_SYMBOLS.getShortMonths() : DATE_FORMAT_SYMBOLS.getMonths();
        return stringArray[n - 1];
    }

    public static int stringToMonthCode(String string) {
        String[] stringArray = DATE_FORMAT_SYMBOLS.getShortMonths();
        String[] stringArray2 = DATE_FORMAT_SYMBOLS.getMonths();
        int n = -1;
        string = string.trim();
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {}
        if (n < 1 || n > 12) {
            int n2 = 0;
            while (n2 < stringArray2.length) {
                if (string.equals(stringArray[n2])) {
                    n = n2 + 1;
                    break;
                }
                if (string.equals(stringArray2[n2])) {
                    n = n2 + 1;
                    break;
                }
                ++n2;
            }
        }
        return n;
    }

    public static boolean isValidWeekInMonthCode(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLeapYear(int n) {
        if (n % 4 != 0) {
            return false;
        }
        if (n % 400 == 0) {
            return true;
        }
        return n % 100 != 0;
    }

    public static int leapYearCount(int n) {
        int n2 = (n - 1896) / 4;
        int n3 = (n - 1800) / 100;
        int n4 = (n - 1600) / 400;
        return n2 - n3 + n4;
    }

    public static int lastDayOfMonth(int n, int n2) {
        int n3 = LAST_DAY_OF_MONTH[n];
        if (n != 2) {
            return n3;
        }
        if (SerialDate.isLeapYear(n2)) {
            return n3 + 1;
        }
        return n3;
    }

    public static SerialDate addDays(int n, SerialDate serialDate) {
        int n2 = serialDate.toSerial() + n;
        return SerialDate.createInstance(n2);
    }

    public static SerialDate addMonths(int n, SerialDate serialDate) {
        int n2 = (12 * serialDate.getYYYY() + serialDate.getMonth() + n - 1) / 12;
        int n3 = (12 * serialDate.getYYYY() + serialDate.getMonth() + n - 1) % 12 + 1;
        int n4 = Math.min(serialDate.getDayOfMonth(), SerialDate.lastDayOfMonth(n3, n2));
        return SerialDate.createInstance(n4, n3, n2);
    }

    public static SerialDate addYears(int n, SerialDate serialDate) {
        int n2 = serialDate.getYYYY();
        int n3 = serialDate.getMonth();
        int n4 = serialDate.getDayOfMonth();
        int n5 = n2 + n;
        int n6 = Math.min(n4, SerialDate.lastDayOfMonth(n3, n5));
        return SerialDate.createInstance(n6, n3, n5);
    }

    public static SerialDate getPreviousDayOfWeek(int n, SerialDate serialDate) {
        if (!SerialDate.isValidWeekdayCode(n)) {
            throw new IllegalArgumentException("Invalid day-of-the-week code.");
        }
        int n2 = serialDate.getDayOfWeek();
        int n3 = n2 > n ? Math.min(0, n - n2) : -7 + Math.max(0, n - n2);
        return SerialDate.addDays(n3, serialDate);
    }

    public static SerialDate getFollowingDayOfWeek(int n, SerialDate serialDate) {
        if (!SerialDate.isValidWeekdayCode(n)) {
            throw new IllegalArgumentException("Invalid day-of-the-week code.");
        }
        int n2 = serialDate.getDayOfWeek();
        int n3 = n2 > n ? 7 + Math.min(0, n - n2) : Math.max(0, n - n2);
        return SerialDate.addDays(n3, serialDate);
    }

    public static SerialDate getNearestDayOfWeek(int n, SerialDate serialDate) {
        if (!SerialDate.isValidWeekdayCode(n)) {
            throw new IllegalArgumentException("Invalid day-of-the-week code.");
        }
        int n2 = serialDate.getDayOfWeek();
        int n3 = -Math.abs(n - n2);
        if (n3 >= 4) {
            n3 = 7 - n3;
        }
        if (n3 <= -4) {
            n3 += 7;
        }
        return SerialDate.addDays(n3, serialDate);
    }

    public SerialDate getEndOfCurrentMonth(SerialDate serialDate) {
        int n = SerialDate.lastDayOfMonth(serialDate.getMonth(), serialDate.getYYYY());
        return SerialDate.createInstance(n, serialDate.getMonth(), serialDate.getYYYY());
    }

    public static String weekInMonthToString(int n) {
        switch (n) {
            case 1: {
                return "First";
            }
            case 2: {
                return "Second";
            }
            case 3: {
                return "Third";
            }
            case 4: {
                return "Fourth";
            }
            case 0: {
                return "Last";
            }
        }
        return "SerialDate.weekInMonthToString(): invalid code.";
    }

    public static String relativeToString(int n) {
        switch (n) {
            case -1: {
                return "Preceding";
            }
            case 0: {
                return "Nearest";
            }
            case 1: {
                return "Following";
            }
        }
        return "ERROR : Relative To String";
    }

    public static SerialDate createInstance(int n, int n2, int n3) {
        return new SpreadsheetDate(n, n2, n3);
    }

    public static SerialDate createInstance(int n) {
        return new SpreadsheetDate(n);
    }

    public static SerialDate createInstance(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return new SpreadsheetDate(gregorianCalendar.get(5), gregorianCalendar.get(2) + 1, gregorianCalendar.get(1));
    }

    public abstract int toSerial();

    public abstract Date toDate();

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String toString() {
        return String.valueOf(this.getDayOfMonth()) + "-" + SerialDate.monthCodeToString(this.getMonth()) + "-" + this.getYYYY();
    }

    public abstract int getYYYY();

    public abstract int getMonth();

    public abstract int getDayOfMonth();

    public abstract int getDayOfWeek();

    public abstract int compare(SerialDate var1);

    public abstract boolean isOn(SerialDate var1);

    public abstract boolean isBefore(SerialDate var1);

    public abstract boolean isOnOrBefore(SerialDate var1);

    public abstract boolean isAfter(SerialDate var1);

    public abstract boolean isOnOrAfter(SerialDate var1);

    public abstract boolean isInRange(SerialDate var1, SerialDate var2);

    public abstract boolean isInRange(SerialDate var1, SerialDate var2, int var3);

    public SerialDate getPreviousDayOfWeek(int n) {
        return SerialDate.getPreviousDayOfWeek(n, this);
    }

    public SerialDate getFollowingDayOfWeek(int n) {
        return SerialDate.getFollowingDayOfWeek(n, this);
    }

    public SerialDate getNearestDayOfWeek(int n) {
        return SerialDate.getNearestDayOfWeek(n, this);
    }
}

