/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import serpro.ppgd.gui.BlinkBorder;
import serpro.ppgd.gui.ConstantesGlobaisGUI;
import serpro.ppgd.gui.EditCampo;
import serpro.ppgd.gui.editors.PPGDRadioButton;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.OpcaoLogico;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;

public class EditLogico
extends EditCampo {
    private static Logico vazio = new Logico();
    private Box box;
    private ButtonGroup group;
    private int orientacaoTexto = 0;
    private static final Color DEFAULT_FOREGROUND = new JRadioButton().getForeground();
    private static final Color DISABLED_FOREGROUND = ConstantesGlobaisGUI.COR_CINZA_CLARO;
    private boolean bloqueiaItemListener = false;
    private Map radios;
    private LinkedList listaOrdenada = new LinkedList();
    private BlinkBorder borda;

    public EditLogico() {
        super(vazio);
    }

    public EditLogico(Informacao informacao, int n) {
        super(informacao, n);
    }

    public EditLogico(Informacao informacao, int n, int n2) {
        super(informacao, n);
        this.setOrientacaoTexto(n2);
    }

    public void setFont(Font font) {
        for (JRadioButton jRadioButton : this.radios.values()) {
            jRadioButton.setFont(font);
        }
    }

    public void setForeground(Color color) {
        for (JRadioButton jRadioButton : this.radios.values()) {
            jRadioButton.setForeground(color);
        }
    }

    public void setFont(String string, Color color) {
        String string2 = ((Logico)this.getInformacao()).getLabelOpcao(string);
        if (this.radios.containsKey(string2)) {
            JRadioButton jRadioButton = (JRadioButton)this.radios.get(string2);
            jRadioButton.setForeground(color);
        }
    }

    public void setFont(String string, Font font) {
        String string2 = ((Logico)this.getInformacao()).getLabelOpcao(string);
        if (this.radios.containsKey(string2)) {
            JRadioButton jRadioButton = (JRadioButton)this.radios.get(string2);
            jRadioButton.setFont(font);
        }
    }

    public void addListener(String string, EventListener eventListener) {
        String string2 = ((Logico)this.getInformacao()).getLabelOpcao(string);
        if (this.radios.containsKey(string2)) {
            JRadioButton jRadioButton = (JRadioButton)this.radios.get(string2);
            this.adicionaListener(jRadioButton, eventListener);
        }
    }

    private void adicionaListener(JRadioButton jRadioButton, EventListener eventListener) {
        if (eventListener instanceof ActionListener) {
            jRadioButton.addActionListener((ActionListener)eventListener);
        } else if (eventListener instanceof ItemListener) {
            jRadioButton.addItemListener((ItemListener)eventListener);
        } else if (eventListener instanceof KeyListener) {
            jRadioButton.addKeyListener((KeyListener)eventListener);
        } else if (eventListener instanceof FocusListener) {
            jRadioButton.addFocusListener((FocusListener)eventListener);
        } else if (eventListener instanceof MouseListener) {
            jRadioButton.addMouseListener((MouseListener)eventListener);
        } else if (eventListener instanceof MouseMotionListener) {
            jRadioButton.addMouseMotionListener((MouseMotionListener)eventListener);
        }
    }

    public void addListener(EventListener eventListener) {
        for (JRadioButton jRadioButton : this.radios.values()) {
            this.adicionaListener(jRadioButton, eventListener);
        }
    }

    public void addValidador(ValidadorImpeditivoDefault validadorImpeditivoDefault, String string) {
    }

    public int getOrientacaoTexto() {
        return this.orientacaoTexto;
    }

    public void setOrientacaoTexto(int n) {
        this.orientacaoTexto = n;
        this.box = new Box(n);
        this.setInformacao(this.getInformacao());
    }

    public void setOpcaoHabilitada(String string, boolean bl) {
        String string2 = ((Logico)this.getInformacao()).getLabelOpcao(string);
        if (this.radios.containsKey(string2)) {
            JRadioButton jRadioButton = (JRadioButton)this.radios.get(string2);
            jRadioButton.setEnabled(bl);
            if (!bl) {
                jRadioButton.setForeground(DISABLED_FOREGROUND);
            } else {
                jRadioButton.setForeground(DEFAULT_FOREGROUND);
            }
        }
    }

    public void setInformacao(Informacao informacao) {
        this.rebuildComponente(informacao);
        this.setObservadorAtivo(false);
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, null, null, this.getInformacao().asString());
        this.implementacaoPropertyChange(propertyChangeEvent);
        this.setObservadorAtivo(true);
    }

    private void rebuildComponente(Informacao informacao) {
        this.radios = new Hashtable();
        this.listaOrdenada = new LinkedList();
        if (this.box == null) {
            this.box = new Box(this.getOrientacaoTexto());
        } else {
            this.box.removeAll();
        }
        Logico logico = (Logico)informacao;
        this.group = new ButtonGroup();
        for (OpcaoLogico opcaoLogico : logico.getListaOrdenada()) {
            PPGDRadioButton pPGDRadioButton = new PPGDRadioButton(opcaoLogico.labelOpcao, opcaoLogico.selecionado);
            pPGDRadioButton.setInformacao(informacao);
            pPGDRadioButton.setVisible(true);
            this.radios.put(pPGDRadioButton.getText(), pPGDRadioButton);
            this.listaOrdenada.addLast(pPGDRadioButton);
            pPGDRadioButton.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                }

                public void focusLost(FocusEvent focusEvent) {
                    if (focusEvent.getOppositeComponent() != null) {
                        EditLogico.this.setIdentificacaoFoco(false);
                        EditLogico.this.chamaValidacao();
                    }
                }
            });
            pPGDRadioButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1 && !EditLogico.this.isBloqueiaItemListener()) {
                        JRadioButton jRadioButton = (JRadioButton)itemEvent.getSource();
                        String string = jRadioButton.getText().trim();
                        String string2 = ((Logico)EditLogico.this.getInformacao()).getValorOpcao(string);
                        ((Logico)EditLogico.this.getInformacao()).atualizaListaValidadoresImpeditivos(string2);
                        if (EditLogico.this.getInformacao().getListaValidadoresImpeditivos().isEmpty() || EditLogico.this.verificaValidacoesImpeditivas(string2)) {
                            ((Logico)EditLogico.this.getInformacao()).setConteudo(string2);
                            EditLogico.this.chamaValidacao();
                        }
                    }
                }
            });
            if (this.getOrientacaoTexto() == 0) {
                this.box.add(new JLabel(" "));
            }
            this.box.add(pPGDRadioButton);
            if (((Logico)informacao).isSelecaoMultipla()) continue;
            this.group.add(pPGDRadioButton);
        }
        this.box.validate();
    }

    public JComponent getComponenteEditor() {
        return this.box;
    }

    public void setIdentificacaoFoco(boolean bl) {
        if (this.getComponenteEditor().getBorder() != null) {
            if (bl) {
                this.borda = new BlinkBorder(this.getComponenteEditor());
                this.borda.start();
            } else if (this.borda != null) {
                this.borda.parar();
                this.borda = null;
            }
        } else {
            super.setIdentificacaoFoco(bl);
        }
    }

    public void implementacaoPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setObservadorAtivo(false);
        if (propertyChangeEvent == null) {
            System.out.println("Evento nulo no metodo implementacaoPropertyChange da classe " + this.getClass());
        }
        if ((propertyChangeEvent.getPropertyName() == null || !propertyChangeEvent.getPropertyName().equals("ReadOnly")) && propertyChangeEvent.getNewValue() instanceof String) {
            String string = (String)propertyChangeEvent.getNewValue();
            if (string == null) {
                string = "";
            }
            if (string.equals("")) {
                this.rebuildComponente(this.getInformacao());
            } else {
                String string2 = ((Logico)this.getInformacao()).getLabelOpcao(string);
                for (final JRadioButton jRadioButton : this.radios.values()) {
                    jRadioButton.getModel();
                    if (jRadioButton.getText().equals(string2)) {
                        this.setBloqueiaItemListener(true);
                        jRadioButton.setSelected(true);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                jRadioButton.requestFocusInWindow();
                            }
                        });
                        this.setBloqueiaItemListener(false);
                        continue;
                    }
                    this.setBloqueiaItemListener(true);
                    jRadioButton.setSelected(false);
                    this.setBloqueiaItemListener(false);
                }
            }
        }
        this.setObservadorAtivo(true);
    }

    protected void readOnlyPropertyChange(boolean bl) {
        for (JRadioButton jRadioButton : this.radios.values()) {
            jRadioButton.setEnabled(!bl);
        }
    }

    protected void habilitadoPropertyChange(boolean bl) {
        for (JRadioButton jRadioButton : this.radios.values()) {
            jRadioButton.setEnabled(bl);
            jRadioButton.setForeground(ConstantesGlobaisGUI.COR_CINZA_CLARO);
        }
        this.labelCampo.setEnabled(bl);
    }

    public JComponent getComponenteFoco() {
        int n = this.radios.values().size();
        int n2 = 0;
        if (n > 0) {
            int n3 = 0;
            while (n3 < n) {
                if (((JRadioButton)this.radios.values().toArray()[n3]).isEnabled()) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
            return (JRadioButton)this.radios.values().toArray()[n2];
        }
        return null;
    }

    public Map getRadios() {
        return this.radios;
    }

    public void setRadios(Map map) {
        this.radios = map;
    }

    public LinkedList getListaRadiosOrdenada() {
        return this.listaOrdenada;
    }

    public boolean isBloqueiaItemListener() {
        return this.bloqueiaItemListener;
    }

    public void setBloqueiaItemListener(boolean bl) {
        this.bloqueiaItemListener = bl;
    }

    public void setPerdeFocoComEnter(boolean bl) {
    }
}

