/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.pagamentos;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.calculos.CalculosPagamentos;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.Valor;

public class ValidadorDeducoesDoacoes
extends ValidadorDefault {
    private static final String MSG_LIMITE_DEDUCAO_DOACAO = "<HTML>As dedu\u00e7\u00f5es relativas ao Estatuto da Crian\u00e7a, Incentivo \u00e0 Cultura e Incentivo \u00e0 Atividade Audiovisual, em <BR> conjunto, n\u00e3o podem exceder a 6% do valor do imposto.";
    private static final String MSG_FINAL_LIMITE_DEDUCAO_DOACAO = "Para  o  c\u00e1lculo do imposto devido, o  programa levar\u00e1 em considera\u00e7\u00e3o o limite legal,<BR> entretanto, nesta ficha devem ser informados os valores efetivamente pagos,<BR> independentemente do limite de dedu\u00e7\u00e3o.</HTML>";
    private Valor imposto;
    private Valor totDoacoes;
    private Valor limite;
    private Valor totAudioVisual;
    private Valor totCultura;
    private Valor totCrianca;
    private Valor totDesporto;
    private Valor totIdoso;
    private DeclaracaoIRPF declaracaoIRPF = null;
    private Pagamento pagamento = null;
    private String msg = "";

    public ValidadorDeducoesDoacoes(byte by, DeclaracaoIRPF declaracaoIRPF, Pagamento pagamento) {
        super(by);
        this.declaracaoIRPF = declaracaoIRPF;
        this.pagamento = pagamento;
    }

    public RetornoValidacao validarImplementado() {
        boolean bl;
        this.msg = "";
        boolean bl2 = bl = this.pagamento.getCodigo().asString().equals("39") || this.pagamento.getCodigo().asString().equals("40") || this.pagamento.getCodigo().asString().equals("41") || this.pagamento.getCodigo().asString().equals("42") || this.pagamento.getCodigo().asString().equals("43") || this.pagamento.getCodigo().asString().equals("44");
        if (bl) {
            this.totCrianca = CalculosPagamentos.totalizarPagamentosGlosado(this.declaracaoIRPF.getPagamentos(), new String[]{"40", "39"}, true);
            this.totCultura = CalculosPagamentos.totalizarPagamentosGlosado(this.declaracaoIRPF.getPagamentos(), new String[]{"41"}, true);
            this.totAudioVisual = CalculosPagamentos.totalizarPagamentosGlosado(this.declaracaoIRPF.getPagamentos(), new String[]{"42"}, true);
            this.totDesporto = CalculosPagamentos.totalizarPagamentosGlosado(this.declaracaoIRPF.getPagamentos(), new String[]{"43"}, true);
            this.totIdoso = CalculosPagamentos.totalizarPagamentosGlosado(this.declaracaoIRPF.getPagamentos(), new String[]{"44"}, true);
            this.limite = this.declaracaoIRPF.getPagamentos().getTotalDeducaoIncentivo();
            this.totDoacoes = new Valor();
            this.totDoacoes.append('+', this.totCrianca);
            this.totDoacoes.append('+', this.totCultura);
            this.totDoacoes.append('+', this.totAudioVisual);
            this.totDoacoes.append('+', this.totDesporto);
            this.totDoacoes.append('+', this.totIdoso);
            this.imposto = new Valor();
            this.imposto.setConteudo(this.declaracaoIRPF.getModeloCompleta().getImposto());
            if (this.totDoacoes.comparacao(">", this.limite)) {
                this.msg = "<HTML>As dedu\u00e7\u00f5es relativas ao Estatuto da Crian\u00e7a, Incentivo \u00e0 Cultura e Incentivo \u00e0 Atividade Audiovisual, em <BR> conjunto, n\u00e3o podem exceder a 6% do valor do imposto.<BR>De acordo com os dados da sua declara\u00e7\u00e3o, o total destas dedu\u00e7\u00f5es \u00e9: " + this.totDoacoes + " e o limite legal \u00e9 : " + this.limite.toString() + " conforme demosntrativo abaixo.<br><br>" + "\"Estatuto da crian\u00e7a\": " + this.totCrianca.toString() + "<br>" + "\"Estatuto do idoso\": " + this.totIdoso.toString() + "<br>" + "\"Incentivo \u00e0 cultura\": " + this.totCultura.toString() + "<br>" + "\"Incentivo \u00e0 atividade audiovisual\": " + this.totAudioVisual.toString() + "\"Incentivo ao desporto\": " + this.totDesporto.toString() + "<br>" + "\"Total de doa\u00e7\u00f5es\": " + this.totDoacoes.toString() + "<br>" + "\"Imposto\": " + this.imposto.toString() + "<br>" + "\"Dedu\u00e7\u00e3o de incentivo\": " + this.limite.toString() + "<br><br>" + MSG_FINAL_LIMITE_DEDUCAO_DOACAO;
            }
        }
        if (this.msg != null && !this.msg.equals("")) {
            RetornoValidacao retornoValidacao = new RetornoValidacao("<HTML>As dedu\u00e7\u00f5es relativas ao Estatuto da Crian\u00e7a, Estatuto do Idoso, Incentivo \u00e0 Cultura, Incentivo \u00e0 Atividade Audiovisual e Incentivo ao Desporto, em <BR> conjunto, n\u00e3o podem exceder a 6% do valor do imposto.</HTML>");
            retornoValidacao.setMensagemValidacaoExtendida(this.msg);
            return retornoValidacao;
        }
        return null;
    }
}

