/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.SQLException;
import org.xml.sax.SAXException;

public class JDOMException
extends Exception {
    private static final String CVS_ID = "@(#) $RCSfile: JDOMException.java,v $ $Revision: 1.23 $ $Date: 2004/02/27 11:32:57 $ $Name: jdom_1_0 $";
    private Throwable cause;

    public JDOMException() {
        super("Error occurred in JDOM application.");
    }

    public JDOMException(String string) {
        super(string);
    }

    public JDOMException(String string, Throwable throwable) {
        super(string);
        this.cause = throwable;
    }

    public Throwable initCause(Throwable throwable) {
        this.cause = throwable;
        return this;
    }

    public String getMessage() {
        Throwable throwable;
        String string = super.getMessage();
        Throwable throwable2 = this;
        while ((throwable = JDOMException.getNestedException(throwable2)) != null) {
            Exception exception;
            String string2 = throwable.getMessage();
            if (throwable instanceof SAXException && (exception = ((SAXException)throwable).getException()) != null && string2 != null && string2.equals(exception.getMessage())) {
                string2 = null;
            }
            if (string2 != null) {
                string = string != null ? String.valueOf(string) + ": " + string2 : string2;
            }
            if (throwable instanceof JDOMException) break;
            throwable2 = throwable;
        }
        return string;
    }

    public void printStackTrace() {
        Throwable throwable;
        super.printStackTrace();
        Throwable throwable2 = this;
        while ((throwable = JDOMException.getNestedException(throwable2)) != null) {
            System.err.print("Caused by: ");
            throwable.printStackTrace();
            if (throwable instanceof JDOMException) break;
            throwable2 = throwable;
        }
    }

    public void printStackTrace(PrintStream printStream) {
        Throwable throwable;
        super.printStackTrace(printStream);
        Throwable throwable2 = this;
        while ((throwable = JDOMException.getNestedException(throwable2)) != null) {
            printStream.print("Caused by: ");
            throwable.printStackTrace(printStream);
            if (throwable instanceof JDOMException) break;
            throwable2 = throwable;
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        Throwable throwable;
        super.printStackTrace(printWriter);
        Throwable throwable2 = this;
        while ((throwable = JDOMException.getNestedException(throwable2)) != null) {
            printWriter.print("Caused by: ");
            throwable.printStackTrace(printWriter);
            if (throwable instanceof JDOMException) break;
            throwable2 = throwable;
        }
    }

    public Throwable getCause() {
        return this.cause;
    }

    private static Throwable getNestedException(Throwable throwable) {
        if (throwable instanceof JDOMException) {
            return ((JDOMException)throwable).getCause();
        }
        if (throwable instanceof SAXException) {
            return ((SAXException)throwable).getException();
        }
        if (throwable instanceof SQLException) {
            return ((SQLException)throwable).getNextException();
        }
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        if (throwable instanceof ExceptionInInitializerError) {
            return ((ExceptionInInitializerError)throwable).getException();
        }
        if (throwable instanceof RemoteException) {
            return ((RemoteException)throwable).detail;
        }
        Throwable throwable2 = JDOMException.getNestedException(throwable, "javax.naming.NamingException", "getRootCause");
        if (throwable2 != null) {
            return throwable2;
        }
        throwable2 = JDOMException.getNestedException(throwable, "javax.servlet.ServletException", "getRootCause");
        if (throwable2 != null) {
            return throwable2;
        }
        return null;
    }

    private static Throwable getNestedException(Throwable throwable, String string, String string2) {
        try {
            Class<?> clazz = Class.forName(string);
            Class<?> clazz2 = throwable.getClass();
            if (clazz.isAssignableFrom(clazz2)) {
                Class[] classArray = new Class[]{};
                Method method = clazz.getMethod(string2, classArray);
                Object[] objectArray = new Object[]{};
                return (Throwable)method.invoke((Object)throwable, objectArray);
            }
        }
        catch (Exception exception) {}
        return null;
    }
}

