/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui.about;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import org.jfree.ui.SortableTableModel;

public class SystemPropertiesTableModel
extends SortableTableModel {
    private List properties = new ArrayList();
    private String nameColumnLabel;
    private String valueColumnLabel;

    public SystemPropertiesTableModel() {
        Object object;
        try {
            object = System.getProperties();
            for (String string : ((Properties)object).keySet()) {
                String string2 = System.getProperty(string);
                SystemProperty systemProperty = new SystemProperty(string, string2);
                this.properties.add(systemProperty);
            }
        }
        catch (SecurityException securityException) {}
        Collections.sort(this.properties, new SystemPropertyComparator(true));
        object = ResourceBundle.getBundle("org.jfree.ui.about.resources.AboutResources");
        this.nameColumnLabel = ((ResourceBundle)object).getString("system-properties-table.column.name");
        this.valueColumnLabel = ((ResourceBundle)object).getString("system-properties-table.column.value");
    }

    public boolean isSortable(int n) {
        return n == 0;
    }

    public int getRowCount() {
        return this.properties.size();
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return this.nameColumnLabel;
        }
        return this.valueColumnLabel;
    }

    public Object getValueAt(int n, int n2) {
        SystemProperty systemProperty = (SystemProperty)this.properties.get(n);
        if (n2 == 0) {
            return systemProperty.getName();
        }
        if (n2 == 1) {
            return systemProperty.getValue();
        }
        return null;
    }

    public void sortByColumn(int n, boolean bl) {
        if (this.isSortable(n)) {
            super.sortByColumn(n, bl);
            Collections.sort(this.properties, new SystemPropertyComparator(bl));
        }
    }

    protected static class SystemProperty {
        private String name;
        private String value;

        public SystemProperty(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    protected static class SystemPropertyComparator
    implements Comparator {
        private boolean ascending;

        public SystemPropertyComparator(boolean bl) {
            this.ascending = bl;
        }

        public int compare(Object object, Object object2) {
            if (object instanceof SystemProperty && object2 instanceof SystemProperty) {
                SystemProperty systemProperty = (SystemProperty)object;
                SystemProperty systemProperty2 = (SystemProperty)object2;
                if (this.ascending) {
                    return systemProperty.getName().compareTo(systemProperty2.getName());
                }
                return systemProperty2.getName().compareTo(systemProperty.getName());
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof SystemPropertyComparator)) {
                return false;
            }
            SystemPropertyComparator systemPropertyComparator = (SystemPropertyComparator)object;
            return this.ascending == systemPropertyComparator.ascending;
        }

        public int hashCode() {
            return this.ascending ? 1 : 0;
        }
    }
}

