/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;

public class JRBaseVariable
implements JRVariable,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected String name = null;
    protected String valueClassName = String.class.getName();
    protected String incrementerFactoryClassName = null;
    protected byte resetType = 1;
    protected byte incrementType = (byte)5;
    protected byte calculation = 0;
    protected boolean isSystemDefined = false;
    protected transient Class valueClass = null;
    protected transient Class incrementerFactoryClass = null;
    protected JRExpression expression = null;
    protected JRExpression initialValueExpression = null;
    protected JRGroup resetGroup = null;
    protected JRGroup incrementGroup = null;

    protected JRBaseVariable() {
    }

    protected JRBaseVariable(JRVariable jRVariable, JRBaseObjectFactory jRBaseObjectFactory) {
        jRBaseObjectFactory.put(jRVariable, this);
        this.name = jRVariable.getName();
        this.valueClassName = jRVariable.getValueClassName();
        this.incrementerFactoryClassName = jRVariable.getIncrementerFactoryClassName();
        this.resetType = jRVariable.getResetType();
        this.incrementType = jRVariable.getIncrementType();
        this.calculation = jRVariable.getCalculation();
        this.isSystemDefined = jRVariable.isSystemDefined();
        this.expression = jRBaseObjectFactory.getExpression(jRVariable.getExpression());
        this.initialValueExpression = jRBaseObjectFactory.getExpression(jRVariable.getInitialValueExpression());
        this.resetGroup = jRBaseObjectFactory.getGroup(jRVariable.getResetGroup());
        this.incrementGroup = jRBaseObjectFactory.getGroup(jRVariable.getIncrementGroup());
    }

    public String getName() {
        return this.name;
    }

    public Class getValueClass() {
        if (this.valueClass == null && this.valueClassName != null) {
            try {
                this.valueClass = JRClassLoader.loadClassForName(this.valueClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JRRuntimeException(classNotFoundException);
            }
        }
        return this.valueClass;
    }

    public String getValueClassName() {
        return this.valueClassName;
    }

    public Class getIncrementerFactoryClass() {
        if (this.incrementerFactoryClass == null && this.incrementerFactoryClassName != null) {
            try {
                this.incrementerFactoryClass = JRClassLoader.loadClassForName(this.incrementerFactoryClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JRRuntimeException(classNotFoundException);
            }
        }
        return this.incrementerFactoryClass;
    }

    public String getIncrementerFactoryClassName() {
        return this.incrementerFactoryClassName;
    }

    public byte getResetType() {
        return this.resetType;
    }

    public byte getIncrementType() {
        return this.incrementType;
    }

    public byte getCalculation() {
        return this.calculation;
    }

    public boolean isSystemDefined() {
        return this.isSystemDefined;
    }

    public JRExpression getExpression() {
        return this.expression;
    }

    public JRExpression getInitialValueExpression() {
        return this.initialValueExpression;
    }

    public JRGroup getResetGroup() {
        return this.resetGroup;
    }

    public JRGroup getIncrementGroup() {
        return this.incrementGroup;
    }
}

