/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredType;

public class RecoveredField
extends RecoveredElement {
    public FieldDeclaration fieldDeclaration;
    boolean alreadyCompletedFieldInitialization;
    public RecoveredType[] anonymousTypes;
    public int anonymousTypeCount;

    public RecoveredField(FieldDeclaration fieldDeclaration, RecoveredElement recoveredElement, int n) {
        this(fieldDeclaration, recoveredElement, n, null);
    }

    public RecoveredField(FieldDeclaration fieldDeclaration, RecoveredElement recoveredElement, int n, Parser parser) {
        super(recoveredElement, n, parser);
        this.fieldDeclaration = fieldDeclaration;
        this.alreadyCompletedFieldInitialization = fieldDeclaration.initialization != null;
    }

    public RecoveredElement add(Statement statement, int n) {
        if (this.alreadyCompletedFieldInitialization || !(statement instanceof Expression)) {
            return super.add(statement, n);
        }
        this.alreadyCompletedFieldInitialization = true;
        this.fieldDeclaration.initialization = (Expression)statement;
        this.fieldDeclaration.declarationSourceEnd = statement.sourceEnd;
        this.fieldDeclaration.declarationEnd = statement.sourceEnd;
        return this;
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int n) {
        if (this.alreadyCompletedFieldInitialization || (typeDeclaration.bits & 0x200) == 0 || this.fieldDeclaration.declarationSourceEnd != 0 && typeDeclaration.sourceStart > this.fieldDeclaration.declarationSourceEnd) {
            return super.add(typeDeclaration, n);
        }
        if (this.anonymousTypes == null) {
            this.anonymousTypes = new RecoveredType[5];
            this.anonymousTypeCount = 0;
        } else if (this.anonymousTypeCount == this.anonymousTypes.length) {
            this.anonymousTypes = new RecoveredType[2 * this.anonymousTypeCount];
            System.arraycopy(this.anonymousTypes, 0, this.anonymousTypes, 0, this.anonymousTypeCount);
        }
        RecoveredType recoveredType = new RecoveredType(typeDeclaration, (RecoveredElement)this, n);
        this.anonymousTypes[this.anonymousTypeCount++] = recoveredType;
        return recoveredType;
    }

    public ASTNode parseTree() {
        return this.fieldDeclaration;
    }

    public int sourceEnd() {
        return this.fieldDeclaration.declarationSourceEnd;
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.tabString(n));
        stringBuffer.append("Recovered field:\n");
        this.fieldDeclaration.print(n + 1, stringBuffer);
        if (this.anonymousTypes != null) {
            int n2 = 0;
            while (n2 < this.anonymousTypeCount) {
                stringBuffer.append("\n");
                stringBuffer.append(this.anonymousTypes[n2].toString(n + 1));
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public FieldDeclaration updatedFieldDeclaration() {
        if (this.anonymousTypes != null) {
            if (this.fieldDeclaration.initialization == null) {
                int n = 0;
                while (n < this.anonymousTypeCount) {
                    RecoveredType recoveredType = this.anonymousTypes[n];
                    TypeDeclaration typeDeclaration = recoveredType.typeDeclaration;
                    if (typeDeclaration.declarationSourceEnd == 0) {
                        typeDeclaration.declarationSourceEnd = this.fieldDeclaration.declarationSourceEnd;
                        typeDeclaration.bodyEnd = this.fieldDeclaration.declarationSourceEnd;
                    }
                    if (recoveredType.preserveContent) {
                        TypeDeclaration typeDeclaration2 = recoveredType.updatedTypeDeclaration();
                        this.fieldDeclaration.initialization = typeDeclaration2.allocation;
                        if (this.fieldDeclaration.declarationSourceEnd == 0) {
                            int n2;
                            this.fieldDeclaration.declarationSourceEnd = n2 = typeDeclaration2.declarationSourceEnd;
                            this.fieldDeclaration.declarationEnd = n2;
                        }
                    }
                    ++n;
                }
                if (this.anonymousTypeCount > 0) {
                    this.fieldDeclaration.bits |= 2;
                }
            } else if (this.fieldDeclaration.getKind() == 3) {
                int n = 0;
                while (n < this.anonymousTypeCount) {
                    RecoveredType recoveredType = this.anonymousTypes[n];
                    TypeDeclaration typeDeclaration = recoveredType.typeDeclaration;
                    if (typeDeclaration.declarationSourceEnd == 0) {
                        typeDeclaration.declarationSourceEnd = this.fieldDeclaration.declarationSourceEnd;
                        typeDeclaration.bodyEnd = this.fieldDeclaration.declarationSourceEnd;
                    }
                    recoveredType.updatedTypeDeclaration();
                    ++n;
                }
            }
        }
        return this.fieldDeclaration;
    }

    public RecoveredElement updateOnClosingBrace(int n, int n2) {
        if (this.bracketBalance > 0) {
            --this.bracketBalance;
            if (this.bracketBalance == 0) {
                if (this.fieldDeclaration.getKind() == 3) {
                    this.updateSourceEndIfNecessary(n2 - 1);
                    return this.parent;
                }
                this.alreadyCompletedFieldInitialization = true;
            }
            return this;
        }
        if (this.bracketBalance == 0) {
            this.alreadyCompletedFieldInitialization = true;
            this.updateSourceEndIfNecessary(n2 - 1);
        }
        if (this.parent != null) {
            return this.parent.updateOnClosingBrace(n, n2);
        }
        return this;
    }

    public RecoveredElement updateOnOpeningBrace(int n, int n2) {
        if (this.fieldDeclaration.declarationSourceEnd == 0 && (this.fieldDeclaration.type instanceof ArrayTypeReference || this.fieldDeclaration.type instanceof ArrayQualifiedTypeReference) && !this.alreadyCompletedFieldInitialization) {
            ++this.bracketBalance;
            return null;
        }
        if (this.fieldDeclaration.declarationSourceEnd == 0 && this.fieldDeclaration.getKind() == 3) {
            ++this.bracketBalance;
            return null;
        }
        this.updateSourceEndIfNecessary(n - 1, n2 - 1);
        return this.parent.updateOnOpeningBrace(n, n2);
    }

    public void updateParseTree() {
        this.updatedFieldDeclaration();
    }

    public void updateSourceEndIfNecessary(int n, int n2) {
        if (this.fieldDeclaration.declarationSourceEnd == 0) {
            this.fieldDeclaration.declarationSourceEnd = n2;
            this.fieldDeclaration.declarationEnd = n2;
        }
    }
}

