/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.gravacaorestauracao;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.txt.gravacaorestauracao.ConversorObjetosIRPF2Registros;
import serpro.ppgd.irpf.txt.gravacaorestauracao.ConversorRegistros2ObjetosIRPF;
import serpro.ppgd.irpf.txt.gravacaorestauracao.DocumentoAjusteTXT;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class RepositorioDeclaracaoCentralTxt {
    public static byte FINALIDADE_ENTREGA = 0;
    public static byte FINALIDADE_BACKUP = 1;
    private DocumentoAjusteTXT arquivo;
    private File file;
    private boolean fLido = false;
    private IdentificadorDeclaracao objIdArquivo;
    private ConversorRegistros2ObjetosIRPF conversor2ObjIRPF;
    private ConversorObjetosIRPF2Registros conversor2Registros;

    public RepositorioDeclaracaoCentralTxt(String string, File file) throws GeracaoTxtException {
        this.file = file;
        this.arquivo = new DocumentoAjusteTXT(string, file.getPath());
        this.conversor2ObjIRPF = new ConversorRegistros2ObjetosIRPF();
        this.conversor2Registros = new ConversorObjetosIRPF2Registros();
    }

    public IdentificadorDeclaracao recuperarIdDeclaracao() throws Exception {
        this.lerDeclaracao();
        Vector vector = this.arquivo.getRegistrosTxt("IR");
        Vector vector2 = this.arquivo.getRegistrosTxt("16");
        this.objIdArquivo = this.conversor2ObjIRPF.montarIdDeclaracao(vector, vector2);
        return this.objIdArquivo;
    }

    public void atualizarNroReciboTransmitida(String string) throws Exception {
        this.arquivo.atualizarNrReciboTransmitida(string);
        this.arquivo.setBKPno();
        this.arquivo.salvar();
    }

    public String recuperarNroRecibo() throws Exception {
        return this.recuperarRegistroHeader().fieldByName("NR_HASH").asString();
    }

    public IdentificadorDeclaracao recuperarIdDeclaracaoAnoAnterior() throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        Vector vector = this.arquivo.getRegistrosTxt("IR");
        Vector vector2 = this.arquivo.getRegistrosTxt("16");
        this.objIdArquivo = this.conversor2ObjIRPF.montarIdDeclaracaoAnoAnterior(vector, vector2);
        return this.objIdArquivo;
    }

    public IdentificadorDeclaracao recuperarIdDeclaracaoNaoPersistido() throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        Vector vector = this.arquivo.getRegistrosTxt("IR");
        this.objIdArquivo = this.conversor2ObjIRPF.montarIdDeclaracaoNaoPersistido(vector);
        return this.objIdArquivo;
    }

    public void recuperarDeclaracao(IdentificadorDeclaracao identificadorDeclaracao) throws GeracaoTxtException {
        this.arquivo.validarHeader(identificadorDeclaracao);
        DeclaracaoIRPF declaracaoIRPF = IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(identificadorDeclaracao.getCpf().asString());
        Vector vector = this.arquivo.getRegistrosTxt("16");
        this.conversor2ObjIRPF.montarContribuinteIRPF(vector, declaracaoIRPF.getContribuinte());
        vector = this.arquivo.getRegistrosTxt("27");
        this.conversor2ObjIRPF.montarBem(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("28");
        this.conversor2ObjIRPF.montarDividas(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("19");
        this.conversor2ObjIRPF.montarDeclaracaoCompleta(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("21");
        this.conversor2ObjIRPF.montarRendPJTitularCompleta(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("32");
        this.conversor2ObjIRPF.montarRendPJDependentesCompleta(vector, declaracaoIRPF);
        if (this.arquivo.getRegistrosTxt("21").size() == 0) {
            vector = this.arquivo.getRegistrosTxt("31");
            this.conversor2ObjIRPF.montarRendPJTitularSimplificada(vector, declaracaoIRPF);
        }
        vector = this.arquivo.getRegistrosTxt("22");
        this.conversor2ObjIRPF.montarRendimentosPF(vector, declaracaoIRPF, false);
        this.conversor2ObjIRPF.montarRendimentosPF(vector, declaracaoIRPF, true);
        vector = this.arquivo.getRegistrosTxt("23");
        this.conversor2ObjIRPF.recuperarRendIsentosNaoTributaveis(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("24");
        this.conversor2ObjIRPF.recuperarRendTributacaoExclusiva(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("97");
        this.conversor2ObjIRPF.recuperarOutrosRendimentos(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("35");
        this.conversor2ObjIRPF.montarAlimentandos(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("25");
        this.conversor2ObjIRPF.montarDependentes(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("26");
        this.conversor2ObjIRPF.montarPagamentos(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("33");
        this.conversor2ObjIRPF.montarLucrosDividendos(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("34");
        this.conversor2ObjIRPF.montarDoacoesCampanha(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("40");
        this.conversor2ObjIRPF.montarRendaVariavel(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("42");
        this.conversor2ObjIRPF.montarRendaVariavelFII(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("30");
        this.conversor2ObjIRPF.montarInventariante(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("36");
        this.conversor2ObjIRPF.montarCPFDependentesComRendPF(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("50");
        this.conversor2ObjIRPF.montarAtividadeRuralImoveis(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("54");
        this.conversor2ObjIRPF.montarAtividadeRuralBens(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("55");
        this.conversor2ObjIRPF.montarAtividadeRuralDividas(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("53");
        this.conversor2ObjIRPF.montarAtividadeRuralMovimentacaoRebanho(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("52");
        this.conversor2ObjIRPF.montarAtividadeRuralApuracaoResultado(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("51");
        this.conversor2ObjIRPF.montarAtividadeRuralReceitasDespesasBrasil(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("56");
        this.conversor2ObjIRPF.montarAtividadeRuralReceitasDespesasExterior(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("16");
        this.conversor2ObjIRPF.montarContribuinteIRPF(vector, declaracaoIRPF.getContribuinte());
        this.conversor2ObjIRPF.montarInformacoesBancarias(vector, declaracaoIRPF);
        this.conversor2ObjIRPF.montarInformacoesObrigatorias(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("80");
        this.conversor2ObjIRPF.montarRendPJTitularComExigibilidade(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("81");
        this.conversor2ObjIRPF.montarRendPJDependentesComExigibilidade(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("98");
        this.conversor2ObjIRPF.recuperarDetalhePoupanca(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("99");
        this.conversor2ObjIRPF.recuperarDetalheRendAplicFinanc(vector, declaracaoIRPF);
        declaracaoIRPF.adicionaObservadoresCalculosLate();
        IRPFFacade.getInstancia().salvarDeclaracao(identificadorDeclaracao.getCpf().asString());
    }

    public void gravarDeclaracao(IdentificadorDeclaracao identificadorDeclaracao) throws GeracaoTxtException, IOException {
        DeclaracaoIRPF declaracaoIRPF = IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(identificadorDeclaracao.getCpf().asString());
        this.atualizarDeclaracao(declaracaoIRPF, FINALIDADE_ENTREGA);
        String string = this.arquivo.calcularHash();
        Vector vector = this.conversor2Registros.montarRegistroHeader(declaracaoIRPF);
        this.arquivo.atualizaHeader(vector, string);
        vector = this.conversor2Registros.montarRecibo(declaracaoIRPF);
        this.arquivo.incluirRecibo(vector, string);
        this.arquivo.salvar();
        IRPFFacade.getInstancia().salvarDeclaracao(identificadorDeclaracao.getCpf().asString());
    }

    public void salvarDeclaracao(IdentificadorDeclaracao identificadorDeclaracao) throws GeracaoTxtException, IOException {
        DeclaracaoIRPF declaracaoIRPF = IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(identificadorDeclaracao.getCpf().asString());
        this.atualizarDeclaracao(declaracaoIRPF, FINALIDADE_BACKUP);
        String string = this.arquivo.calcularHash();
        Vector vector = this.conversor2Registros.montarRegistroHeader(declaracaoIRPF);
        this.arquivo.atualizaHeader(vector, string);
        this.arquivo.salvar();
    }

    public void atualizarDeclaracao(DeclaracaoIRPF declaracaoIRPF, byte by) throws GeracaoTxtException {
        boolean bl = declaracaoIRPF.getIdentificadorDeclaracao().isCompleta() || by == FINALIDADE_BACKUP;
        this.arquivo.clear();
        Vector vector = this.conversor2Registros.montarRegistroHeader(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarRegistroContribuinte(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        if (bl) {
            if (!declaracaoIRPF.getIdentificadorDeclaracao().isCompleta()) {
                vector = this.conversor2Registros.montarFichaSimplificada(declaracaoIRPF);
                this.arquivo.setFicha(vector);
            }
            vector = this.conversor2Registros.montarRegistroDeclaracaoCompleta(declaracaoIRPF);
            this.arquivo.setFicha(vector);
            if (by == FINALIDADE_ENTREGA) {
                vector = this.conversor2Registros.montarFichaResumoCompleta(declaracaoIRPF);
                this.arquivo.setFicha(vector);
            }
        } else {
            vector = this.conversor2Registros.montarFichaSimplificada(declaracaoIRPF);
            this.arquivo.setFicha(vector);
            vector = this.conversor2Registros.montarFichaResumoSimplificada(declaracaoIRPF);
            this.arquivo.setFicha(vector);
        }
        vector = this.conversor2Registros.montarFichaRendPJ(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaRendPF(declaracaoIRPF, false);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaRendPF(declaracaoIRPF, true);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaRendIsentos(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaRendTribExcl(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaDependentes(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaPagamentos(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaBem(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaDividas(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        if (declaracaoIRPF.getIdentificadorDeclaracao().isEspolio()) {
            vector = this.conversor2Registros.montarFichaInventariante(declaracaoIRPF);
            this.arquivo.setFicha(vector);
        }
        vector = this.conversor2Registros.montarFichaRendPJDependente(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaDetalhePensao(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaLucrosDividendos(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaDoacoesCampanha(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaAlimentandos(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaRendExterior(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaIncorpReservas(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        if (declaracaoIRPF.getIdentificadorDeclaracao().isEspolio()) {
            vector = this.conversor2Registros.montarFichaFinalEspolio(declaracaoIRPF);
            this.arquivo.setFicha(vector);
        } else if (declaracaoIRPF.getIdentificadorDeclaracao().isSaida()) {
            vector = this.conversor2Registros.montarFichaSaida(declaracaoIRPF);
            this.arquivo.setFicha(vector);
        }
        if (!declaracaoIRPF.getRendaVariavel().isVazio()) {
            vector = this.conversor2Registros.montarFichaRendaVariavel(declaracaoIRPF);
            this.arquivo.setFicha(vector);
        }
        if (!declaracaoIRPF.getRendaVariavel().isVazio()) {
            vector = this.conversor2Registros.montarFichaRendaVariavelAnual(declaracaoIRPF);
            this.arquivo.setFicha(vector);
        }
        if (!declaracaoIRPF.getRendaVariavel().getFundInvest().isVazio()) {
            vector = this.conversor2Registros.montarFichaRendaVariavelFII(declaracaoIRPF);
            this.arquivo.setFicha(vector);
        }
        if (!declaracaoIRPF.getRendaVariavel().getFundInvest().isVazio()) {
            vector = this.conversor2Registros.montarFichaRendaVariavelTotaisFII(declaracaoIRPF);
            this.arquivo.setFicha(vector);
        }
        vector = this.conversor2Registros.montarFichaRRATitular(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaRRATitularPensao(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaRRADependente(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaRRADependentePensao(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaAtividadeRuralIdentificacaoImovel(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaAtividadeRuralReceitasDespesasBrasil(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaAtividadeRuralApuracaoResultado(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaAtividadeRuralMovimentacaoRebanho(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaAtividadeRuralBens(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaAtividadeRuralDividas(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaAtividadeRuralReceitasDespesasExterior(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        if (declaracaoIRPF.getIdentificadorDeclaracao().isEspolio()) {
            vector = this.conversor2Registros.montarFichaHerdeiros(declaracaoIRPF);
            this.arquivo.setFicha(vector);
            vector = this.conversor2Registros.montarFichaPercentualBem(declaracaoIRPF);
            this.arquivo.setFicha(vector);
        }
        vector = this.conversor2Registros.montarFichaRendPJComExigibilidade(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaRendPJComExigibilidadeDependente(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaOutrosRendimentos(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaDetalhePoupanca(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        vector = this.conversor2Registros.montarFichaDetalheRendAplicFinanc(declaracaoIRPF);
        this.arquivo.setFicha(vector);
        this.arquivo.incluirTrailler(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
    }

    public void importarDeclaracaoAnoAnterior(IdentificadorDeclaracao identificadorDeclaracao) throws GeracaoTxtException {
        this.arquivo.validarHeaderAnoAnt(identificadorDeclaracao, this.getValidaHash());
        DeclaracaoIRPF declaracaoIRPF = IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(identificadorDeclaracao.getCpf().asString());
        Vector vector = this.arquivo.getRegistrosTxt("16");
        this.conversor2ObjIRPF.montarContribuinteIRPFAnoAnterior(vector, declaracaoIRPF.getContribuinte());
        vector = this.arquivo.getRegistrosTxt("27");
        this.conversor2ObjIRPF.montarBensAnoAnterior(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("28");
        this.conversor2ObjIRPF.montarDividasAnoAnterior(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("29");
        this.conversor2ObjIRPF.montarConjugeAnoAnterior(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("25");
        this.conversor2ObjIRPF.montarDependentesAnoAnterior(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("26");
        this.conversor2ObjIRPF.montarPagamentosAnoAnterior(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("30");
        this.conversor2ObjIRPF.montarInventarianteAnoAnterior(vector, declaracaoIRPF);
        identificadorDeclaracao.getDeclaracaoRetificadora().clear();
        identificadorDeclaracao.getNumReciboDecRetif().clear();
        declaracaoIRPF.getIdentificadorDeclaracao().getEnderecoDiferente().clear();
        vector = this.arquivo.getRegistrosTxt("50");
        this.conversor2ObjIRPF.montarAtividadeRuralImoveisAnoAnterior(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("54");
        this.conversor2ObjIRPF.montarAtividadeRuralBensAnoAnterior(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("55");
        this.conversor2ObjIRPF.montarAtividadeRuralDividasAnoAnterior(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("53");
        this.conversor2ObjIRPF.montarAtividadeRuralMovimentacaoRebanhoAnoAnterior(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("52");
        this.conversor2ObjIRPF.montarAtividadeRuralApuracaoResultado(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("51");
        this.conversor2ObjIRPF.montarAtividadeRuralReceitasDespesasBrasil(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("56");
        this.conversor2ObjIRPF.montarAtividadeRuralReceitasDespesasExterior(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("16");
        this.conversor2ObjIRPF.montarInformacoesBancarias(vector, declaracaoIRPF);
        this.conversor2ObjIRPF.montarInformacoesObrigatorias(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("21");
        this.conversor2ObjIRPF.montarRendPJTitularAnoAnterior(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("32");
        this.conversor2ObjIRPF.montarRendPJDependAnoAnterior(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("80");
        this.conversor2ObjIRPF.montarRendPJTitularComExigibilidade(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("81");
        this.conversor2ObjIRPF.montarRendPJDependentesComExigibilidade(vector, declaracaoIRPF);
        vector = this.arquivo.getRegistrosTxt("97");
        this.conversor2ObjIRPF.recuperarOutrosRendimentos(vector, declaracaoIRPF);
        IRPFFacade.getInstancia().salvarDeclaracao(identificadorDeclaracao.getCpf().asString());
    }

    public void validarDeclaracao() throws Exception {
        if (this.objIdArquivo == null) {
            this.objIdArquivo = this.recuperarIdDeclaracao();
        }
        this.arquivo.validarCRC();
        this.arquivo.validarHeader(this.objIdArquivo);
    }

    public void validarDeclaracaoNaoPersistido() throws GeracaoTxtException, IOException {
        if (this.objIdArquivo == null) {
            this.objIdArquivo = this.recuperarIdDeclaracaoNaoPersistido();
        }
        this.arquivo.validarCRC();
        this.arquivo.validarHeader(this.objIdArquivo);
    }

    public void lerDeclaracao() throws GeracaoTxtException, IOException {
        if (this.arquivo == null) {
            this.arquivo = new DocumentoAjusteTXT("ARQ_IRPF", this.file.getPath());
        }
        if (!this.fLido) {
            this.arquivo.ler();
        }
        this.fLido = true;
    }

    public RegistroTxt recuperarRegistroHeader() throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        Vector vector = this.arquivo.getRegistrosTxt("IR");
        return this.conversor2ObjIRPF.getRegistroHeader(vector);
    }

    public RegistroTxt recuperarRegistroRecibo() throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        Vector vector = this.arquivo.getRegistrosTxt("DR");
        return this.conversor2ObjIRPF.getRegistroRecibo(vector);
    }

    public RegistroTxt recuperarRegistroComplementoRecibo() throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        Vector vector = this.arquivo.getRegistrosTxt("RC");
        return this.conversor2ObjIRPF.getRegistroRecibo(vector);
    }

    public RegistroTxt recuperarRegistroComplementoReciboMulta() throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        Vector vector = this.arquivo.getRegistrosTxt("NC");
        if (vector.isEmpty()) {
            return null;
        }
        return this.conversor2ObjIRPF.getRegistroRecibo(vector);
    }

    public String getPath() {
        return this.file.getPath();
    }

    private boolean getValidaHash() {
        return !UtilitariosArquivo.extraiExtensaoAquivo(this.getPath()).toUpperCase().equals(".F2B");
    }

    public void validarComplementoRecibo(IdentificadorDeclaracao identificadorDeclaracao) throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        this.arquivo.validarCRCAcumulado();
        this.arquivo.validarComplRecibo(identificadorDeclaracao);
    }

    public DocumentoAjusteTXT getArquivo() {
        return this.arquivo;
    }

    public ConversorObjetosIRPF2Registros getConversor2Registros() {
        return this.conversor2Registros;
    }
}

