/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.problem;

import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.util.HashtableOfInt;
import org.eclipse.jdt.internal.compiler.util.Util;

public class DefaultProblemFactory
implements IProblemFactory {
    public HashtableOfInt messageTemplates;
    private Locale locale;
    private static HashtableOfInt DEFAULT_LOCALE_TEMPLATES;
    private static final char[] DOUBLE_QUOTES;
    private static final char[] SINGLE_QUOTE;

    static {
        DOUBLE_QUOTES = "''".toCharArray();
        SINGLE_QUOTE = "'".toCharArray();
    }

    public DefaultProblemFactory() {
        this(Locale.getDefault());
    }

    public DefaultProblemFactory(Locale locale) {
        this.locale = locale;
        if (Locale.getDefault().equals(locale)) {
            if (DEFAULT_LOCALE_TEMPLATES == null) {
                DEFAULT_LOCALE_TEMPLATES = DefaultProblemFactory.loadMessageTemplates(locale);
            }
            this.messageTemplates = DEFAULT_LOCALE_TEMPLATES;
        } else {
            this.messageTemplates = DefaultProblemFactory.loadMessageTemplates(locale);
        }
    }

    public CategorizedProblem createProblem(char[] cArray, int n, String[] stringArray, String[] stringArray2, int n2, int n3, int n4, int n5, int n6) {
        return new DefaultProblem(cArray, this.getLocalizedMessage(n, stringArray2), n, stringArray, n2, n3, n4, n5, n6);
    }

    private static final int keyFromID(int n) {
        return n + 1;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public final String getLocalizedMessage(int n, String[] stringArray) {
        StringBuffer stringBuffer;
        block11: {
            String string = (String)this.messageTemplates.get(DefaultProblemFactory.keyFromID(n & 0xFFFFFF));
            if (string == null) {
                return "Unable to retrieve the error message for problem id: " + (n & 0xFFFFFF) + ". Check compiler resources.";
            }
            char[] cArray = CharOperation.replace(string.toCharArray(), DOUBLE_QUOTES, SINGLE_QUOTE);
            if (stringArray == null) {
                return new String(cArray);
            }
            int n2 = cArray.length;
            int n3 = 0;
            int n4 = n2;
            stringBuffer = null;
            if ((n & Integer.MIN_VALUE) != 0) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(10 + n2 + stringArray.length * 20);
                }
                stringBuffer.append((String)this.messageTemplates.get(DefaultProblemFactory.keyFromID(514)));
            }
            while ((n4 = CharOperation.indexOf('{', cArray, n3)) > -1) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(n2 + stringArray.length * 20);
                }
                stringBuffer.append(cArray, n3, n4 - n3);
                n3 = CharOperation.indexOf('}', cArray, n4 + 1);
                if (n3 > -1) {
                    int n5 = -1;
                    String string2 = new String(cArray, n4 + 1, n3 - n4 - 1);
                    try {
                        n5 = Integer.parseInt(string2);
                        stringBuffer.append(stringArray[n5]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        stringBuffer.append(cArray, n4 + 1, n3 - n4);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        return "Cannot bind message for problem (id: " + (n & 0xFFFFFF) + ") \"" + string + "\" with arguments: {" + Util.toString(stringArray) + "}";
                    }
                    ++n3;
                    continue;
                }
                stringBuffer.append(cArray, n4, n2);
                break block11;
            }
            if (stringBuffer == null) {
                return new String(cArray);
            }
            stringBuffer.append(cArray, n3, n2 - n3);
        }
        return new String(stringBuffer.toString());
    }

    public final String localizedMessage(CategorizedProblem categorizedProblem) {
        return this.getLocalizedMessage(categorizedProblem.getID(), categorizedProblem.getArguments());
    }

    public static HashtableOfInt loadMessageTemplates(Locale locale) {
        ResourceBundle resourceBundle = null;
        String string = "org.eclipse.jdt.internal.compiler.problem.messages";
        try {
            resourceBundle = ResourceBundle.getBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource : " + string.replace('.', '/') + ".properties for locale " + locale);
            throw missingResourceException;
        }
        HashtableOfInt hashtableOfInt = new HashtableOfInt(700);
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            try {
                int n = Integer.parseInt(string2);
                hashtableOfInt.put(DefaultProblemFactory.keyFromID(n), resourceBundle.getString(string2));
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return hashtableOfInt;
    }
}

