/* Pagamento - Decompiled by JODE
 * Visit http://jode.sourceforge.net/
 */
package serpro.ppgd.irpf.pagamentos;
import java.util.Iterator;
import java.util.List;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.negocio.util.Validador;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNIT;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class Pagamento extends ObjetoNegocio
{
  public static final String PAGAMENTO_INSTRUCAO_BR = "01";
  public static final String PAGAMENTO_INSTRUCAO_EX = "02";
  public static final String PAGAMENTO_FONOAUDIOLOGO_BR = "09";
  public static final String PAGAMENTO_MEDICO_BR = "10";
  public static final String PAGAMENTO_DENTISTA_BR = "11";
  public static final String PAGAMENTO_PSICOLOGO_BR = "12";
  public static final String PAGAMENTO_FISIOTERAPEUTA_BR = "13";
  public static final String PAGAMENTO_TERAPEUTA_OCUPACIONAL_BR = "14";
  public static final String PAGAMENTO_MEDICO_EX = "15";
  public static final String PAGAMENTO_DENTISTA_EX = "16";
  public static final String PAGAMENTO_PSICOLOGO_EX = "17";
  public static final String PAGAMENTO_FISIOTERAPEUTA_EX = "18";
  public static final String PAGAMENTO_TERAPEUTA_OCUPACIONAL_EX = "19";
  public static final String PAGAMENTO_FONOAUDIOLOGO_EX = "20";
  public static final String PAGAMENTO_HOSPITAL_BR = "21";
  public static final String PAGAMENTO_HOSPITAL_EX = "22";
  public static final String PAGAMENTO_PLANOSAUDE_BR = "26";
  public static final String PAGAMENTO_PENSAOALIMENTICIA_BR = "30";
  public static final String PAGAMENTO_PENSAOALIMENTICIA_EX = "31";
  public static final String PAGAMENTO_PENSAODIVORCIO_BR = "33";
  public static final String PAGAMENTO_PENSAODIVORCIO_EX = "34";
  public static final String PAGAMENTO_PREVIPRIVADA = "36";
  public static final String PAGAMENTO_FUNPRESP = "37";
  public static final String PAGAMENTO_FAPI = "38";
  public static final String PAGAMENTO_CONTRIBUICAO_PATRONAL = "50";
  public static final String PAGAMENTO_ADVOGADOS = "60";
  public static final String PAGAMENTO_ADVOGADOS_TRAB = "61";
  public static final String PAGAMENTO_ADVOGADOS_HONORARIOS = "62";
  public static final String PAGAMENTO_PROFLIBERAL = "66";
  public static final String PAGAMENTO_ALUGUEIS = "70";
  public static final String PAGAMENTO_ADMINISTRADOR_IMOVEL = "71";
  public static final String PAGAMENTO_CORRETOR_IMOVEL = "72";
  public static final String PAGAMENTO_ARRENDRURAL = "76";
  public static final String PAGAMENTO_OUTROS = "99";
  public static final String PERC_LIMITE_DEDUCAO_CONTRIBUICAO_PREV_PRIV_FAPI = "0,12";
  public static final String PERC_LIMITE_DEDUCAO_INCENTIVO = "0,06";
    /* Este limite é chatinho de achar no código ofuscado, precisa
       procurar entre as classes ofuscadas que chamam getPagamentos.  */
  public static final String LIMITE_DESPESAS_INSTRUCAO = "3.561,50";
  public static final String NOME_CODIGO = "C\u00f3digo";
  public static final String NOME_TIPO = "Tipo";
  private Codigo codigo = new Codigo (this, "C\u00f3digo", CadastroTabelasIRPF.recuperarTipoPagamentos ());
  private Alfa dependenteOuAlimentando = new Alfa (this, "Dependente/Alimentando", 20);
  private Alfa nomeBeneficiario = new Alfa (this, "Nome do Benefici\u00e1rio", 60);
  private NI niBeneficiario = new NI (this, "CPF ou CNPJ do Benefici\u00e1rio");
  private Valor valorPago = new Valor (this, "Valor Pago");
  private Valor parcelaNaoDedutivel = new Valor (this, "Parcela N\u00e3o Dedut\u00edvel/Valor Reembolsado");
  private Alfa nitEmpregadoDomestico = new Alfa (this, "NIT do empregado dom\u00e9stico");
  private Alfa tipo = new Alfa (this, NOME_TIPO);
  public static String TIPO_TITULAR = "T";
  public static String TIPO_DEPENDENTE = "D";
  public static String TIPO_ALIMENTANDO = "A";
  public static String TIPO_PADRAO = TIPO_TITULAR;
  protected transient IdentificadorDeclaracao identificadorDeclaracao = null;
  
  public Pagamento (final DeclaracaoIRPF objDecl)
  {
    identificadorDeclaracao = objDecl.getIdentificadorDeclaracao ();
    getCodigo ().setColunaFiltro (1);
    tipo.addObservador (new Observador () {
	  public void notifica (Object observado, String nomePropriedade,
				Object valorAntigo, Object valorNovo) {
	    if (nomePropriedade.equals (NOME_TIPO)
		&& !((String)valorAntigo).equals (""))
	      getDependenteOuAlimentando ().clear ();
	  }
	});
    nitEmpregadoDomestico.setHabilitado (false);
    getNitEmpregadoDomestico ().addValidador (new ValidadorNIT ((byte) 3, tab.msg ("pagamento_NIT"))
    {
      public RetornoValidacao validarImplementado ()
      {
	if (getNitEmpregadoDomestico ().isHabilitado ())
	  return super.validarImplementado ();
	return null;
      }
    });
    getCodigo ().addValidador (new ValidadorNaoNulo ((byte) 3, tab.msg ("pagamento_codigo"))
    {
      public RetornoValidacao validarImplementado ()
      {
	if (identificadorDeclaracao.getTipoDeclaracao ().asString ().equals ("1"))
	  return null;
	return super.validarImplementado ();
      }
    });
    getNomeBeneficiario ().addValidador (new ValidadorNaoNulo ((byte) 3, "")
    {
      public RetornoValidacao validarImplementado ()
      {
	if (identificadorDeclaracao.getTipoDeclaracao ().asString ().equals ("1"))
	  return null;
	getNiBeneficiario ().validar ();
	if (getNomeBeneficiario ().isVazio () && getNiBeneficiario ().isValido ())
	  {
	    setSeveridade ((byte) 2);
	    return new RetornoValidacao (getCodigo ().asString ().equals (PAGAMENTO_CONTRIBUICAO_PATRONAL) ? tab.msg ("pagamento_empregado") : tab.msg ("pagamento_beneficiario"), (byte) 2);
	  }
	if (getNomeBeneficiario ().isVazio () && ! getNiBeneficiario ().isValido ())
	  {
	    setSeveridade ((byte) 3);
	    return new RetornoValidacao (getCodigo ().asString ().equals (PAGAMENTO_CONTRIBUICAO_PATRONAL) ? tab.msg ("pagamento_empregado_ni_invalido") : tab.msg ("pagamento_beneficiario_ni_invalido"), (byte) 3);
	  }
	return null;
      }
    });
    getNiBeneficiario ().addValidador (new ValidadorNaoNulo ((byte) 2)
    {
      public RetornoValidacao validarImplementado ()
      {
	if (identificadorDeclaracao.getTipoDeclaracao ().asString ().equals ("1"))
	  return null;
	String codigoPagamento = getCodigo ().getConteudoAtual (0);
	String codMensagem = null;

	if (codigoPagamento.equals (PAGAMENTO_INSTRUCAO_BR) || codigoPagamento.equals (Pagamento.PAGAMENTO_FONOAUDIOLOGO_BR) || codigoPagamento.equals (Pagamento.PAGAMENTO_MEDICO_BR) || codigoPagamento.equals (Pagamento.PAGAMENTO_DENTISTA_BR) || codigoPagamento.equals (Pagamento.PAGAMENTO_PSICOLOGO_BR) || codigoPagamento.equals (Pagamento.PAGAMENTO_FISIOTERAPEUTA_BR) || codigoPagamento.equals (Pagamento.PAGAMENTO_TERAPEUTA_OCUPACIONAL_BR) || codigoPagamento.equals (PAGAMENTO_HOSPITAL_BR) || codigoPagamento.equals (PAGAMENTO_PLANOSAUDE_BR))
	  codMensagem = "pagamento_nibeneficiario_1";
	else if (codigoPagamento.equals (PAGAMENTO_PENSAOALIMENTICIA_BR) || codigoPagamento.equals (PAGAMENTO_PENSAOALIMENTICIA_EX) || codigoPagamento.equals (PAGAMENTO_PREVIPRIVADA) || codigoPagamento.equals (PAGAMENTO_FAPI) || codigoPagamento.equals (PAGAMENTO_ADVOGADOS) || codigoPagamento.equals (PAGAMENTO_ADVOGADOS_TRAB) || codigoPagamento.equals (PAGAMENTO_ADVOGADOS_HONORARIOS) || codigoPagamento.equals (PAGAMENTO_PROFLIBERAL) || codigoPagamento.equals (PAGAMENTO_ALUGUEIS) || codigoPagamento.equals (PAGAMENTO_ADMINISTRADOR_IMOVEL) || codigoPagamento.equals (PAGAMENTO_CORRETOR_IMOVEL) || codigoPagamento.equals (PAGAMENTO_ARRENDRURAL))
	  codMensagem = "pagamento_nibeneficiario_2";
	RetornoValidacao retornoValidacao = Validador.validarNI (UtilitariosString.retiraMascara (getInformacao ().getConteudoFormatado ()));
	if ((getNiBeneficiario ().isVazio () || retornoValidacao != null) && codMensagem != null)
	  return new RetornoValidacao (tab.msg (codMensagem), (byte) 2);
	return null;
      }
    });
    getParcelaNaoDedutivel ().addValidador (new ValidadorNaoNulo ((byte) 3)
    {
      public RetornoValidacao validarImplementado ()
      {
	if (identificadorDeclaracao.getTipoDeclaracao ().asString ().equals ("1"))
	  return null;
	String codigoPagamento = getCodigo ().getConteudoAtual (0);
	if ((codigoPagamento.equals (PAGAMENTO_INSTRUCAO_BR) || codigoPagamento.equals (PAGAMENTO_INSTRUCAO_EX) || codigoPagamento.equals (PAGAMENTO_FONOAUDIOLOGO_BR) || codigoPagamento.equals (PAGAMENTO_FONOAUDIOLOGO_EX) || codigoPagamento.equals (PAGAMENTO_MEDICO_BR) || codigoPagamento.equals (PAGAMENTO_MEDICO_EX) || codigoPagamento.equals (PAGAMENTO_DENTISTA_BR) || codigoPagamento.equals (PAGAMENTO_DENTISTA_EX) || codigoPagamento.equals (PAGAMENTO_PSICOLOGO_BR) || codigoPagamento.equals (PAGAMENTO_PSICOLOGO_EX) || codigoPagamento.equals (PAGAMENTO_FISIOTERAPEUTA_BR) || codigoPagamento.equals (PAGAMENTO_FISIOTERAPEUTA_EX) || codigoPagamento.equals (PAGAMENTO_TERAPEUTA_OCUPACIONAL_BR) || codigoPagamento.equals (PAGAMENTO_TERAPEUTA_OCUPACIONAL_EX) || codigoPagamento.equals (PAGAMENTO_HOSPITAL_BR) || codigoPagamento.equals (PAGAMENTO_HOSPITAL_EX) || codigoPagamento.equals (PAGAMENTO_PLANOSAUDE_BR) || codigoPagamento.equals (PAGAMENTO_PENSAOALIMENTICIA_BR) || codigoPagamento.equals (PAGAMENTO_PENSAOALIMENTICIA_EX)) && getParcelaNaoDedutivel ().comparacao (">", getValorPago ()))
	  return new RetornoValidacao (tab.msg ("pagamento_valor_reembolsado"), (byte) 3);
	return null;
      }
    });
    getValorPago ().addValidador (new ValidadorNaoNulo ((byte) 3)
    {
      public RetornoValidacao validarImplementado ()
      {
	if (identificadorDeclaracao.getTipoDeclaracao ().asString ().equals ("1"))
	  return null;
	if (getCodigo ().isVazio () && getNomeBeneficiario ().isVazio () && getNiBeneficiario ().isVazio () && getParcelaNaoDedutivel ().isVazio ())
	  return null;
	setMensagemValidacao (getCodigo ().asString ().equals (PAGAMENTO_CONTRIBUICAO_PATRONAL) ? tab.msg ("pagamento_empregado_valor_pago") : tab.msg ("pagamento_valor_pago"));
	return super.validarImplementado ();
      }
    });
    getDependenteOuAlimentando ().addValidador (new ValidadorDefault ((byte) 3)
    {
      public RetornoValidacao validarImplementado ()
      {
	if (TIPO_TITULAR.equals (getTipo ().asString ()))
	  {
	    if (getDependenteOuAlimentando ().isVazio ())
	      return new RetornoValidacao (tab.msg ("pagamento_titular_nao_vazio"));
	  }
	else if (TIPO_DEPENDENTE.equals (getTipo ().asString ()))
	  {
	    if (! objDecl.getDependentes ().isExisteNome (getDependenteOuAlimentando ().asString ()))
	      return new RetornoValidacao (tab.msg ("pagamento_dependente_alimentando"), (byte) 3);
	  }
	else if (TIPO_ALIMENTANDO.equals (getTipo ().asString ()))
	  {
	    if (! objDecl.getAlimentandos ().isExisteNome (getDependenteOuAlimentando ().asString ()))
	      return new RetornoValidacao (tab.msg ("pagamento_dependente_alimentando"), (byte) 3);
	  }

	return null;
      }
    });
    getDependenteOuAlimentando ().addValidador (new ValidadorNaoNulo ((byte) 3, tab.msg ("pagamento_dependente_alimentando"))
    {
      public RetornoValidacao validarImplementado ()
      {
	String codigoPagamento = getCodigo ().getConteudoAtual (0);
	if (TIPO_TITULAR.equals (getTipo ().asString ())
	    || "".equals (getTipo ().asString ())
	    || " ".equals (getTipo ().asString ()))
	  return null;
	return super.validarImplementado ();
      }
    });
    getNitEmpregadoDomestico ().addValidador (new ValidadorNaoNulo ((byte) 3)
    {
      public RetornoValidacao validarImplementado ()
      {
	return null;
      }
    });
    getNiBeneficiario ().addValidador (new ValidadorNI ((byte) 3));
    getNiBeneficiario ().addValidador (new ValidadorDefault ((byte) 3)
    {
      public RetornoValidacao validarImplementado ()
      {
	if (getNiBeneficiario ().asString ().equals (identificadorDeclaracao.getCpf ().asString ()))
	  return new RetornoValidacao (tab.msg ("pagamento_cpf_beneficiario_igual"), (byte) 3);
	return null;
      }
    });
  }
  
  public Codigo getCodigo ()
  {
    return codigo;
  }
  
  public Alfa getTipo ()
  {
    return tipo;
  }
  
  public boolean ehTitularBrasil ()
  {
    if (getTipo ().asString ().equals (TIPO_TITULAR) && getCodigo ().asString ().equals (PAGAMENTO_INSTRUCAO_BR))
      return true;
    return false;
  }
  
  public boolean ehTitularExterior ()
  {
    if (getTipo ().asString ().equals (TIPO_TITULAR) && getCodigo ().asString ().equals (PAGAMENTO_INSTRUCAO_EX))
      return true;
    return false;
  }
  
  public boolean ehDependenteBrasil ()
  {
    if (getTipo ().asString ().equals (TIPO_DEPENDENTE) && getCodigo ().asString ().equals (PAGAMENTO_INSTRUCAO_BR))
      return true;
    return false;
  }
  
  public boolean ehDependenteExterior ()
  {
    if (getTipo ().asString ().equals (TIPO_DEPENDENTE) && getCodigo ().asString ().equals (PAGAMENTO_INSTRUCAO_EX))
      return true;
    return false;
  }
  
  public boolean ehAlimentandoBrasil ()
  {
    if (getTipo ().asString ().equals (TIPO_ALIMENTANDO) && getCodigo ().asString ().equals (PAGAMENTO_INSTRUCAO_BR))
      return true;
    return false;
  }
  
  public boolean ehAlimentandoExterior ()
  {
    if (getTipo ().asString ().equals (TIPO_ALIMENTANDO) && getCodigo ().asString ().equals (PAGAMENTO_INSTRUCAO_EX))
      return true;
    return false;
  }
  
  public NI getNiBeneficiario ()
  {
    return niBeneficiario;
  }
  
  public Alfa getNomeBeneficiario ()
  {
    return nomeBeneficiario;
  }
  
  public Valor getParcelaNaoDedutivel ()
  {
    return parcelaNaoDedutivel;
  }
  
  public Valor getValorPago ()
  {
    return valorPago;
  }
  
  public Alfa getDependenteOuAlimentando ()
  {
    return dependenteOuAlimentando;
  }
  
  protected List recuperarListaCamposPendencia ()
  {
    List retorno = super.recuperarListaCamposPendencia ();
    retorno.add (codigo);
    retorno.add (dependenteOuAlimentando);
    retorno.add (nomeBeneficiario);
    retorno.add (niBeneficiario);
    retorno.add (nitEmpregadoDomestico);
    retorno.add (valorPago);
    retorno.add (parcelaNaoDedutivel);
    return retorno;
  }
  
  public void setNitEmpregadoDomestico (Alfa nitEmpregadoDomestico)
  {
    this.nitEmpregadoDomestico = nitEmpregadoDomestico;
  }
  
  public Alfa getNitEmpregadoDomestico ()
  {
    return nitEmpregadoDomestico;
  }
  
  public boolean isVazio ()
  {
    Iterator iterator = recuperarCamposInformacao ().iterator ();
    while (iterator.hasNext ())
      {
	Informacao informacao = (Informacao) iterator.next ();
	if (! informacao.isVazio ())
	  return false;
      }
    return true;
  }
}
