/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.util;

import com.jgoodies.forms.util.AbstractUnitConverter;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;

public final class DefaultUnitConverter
extends AbstractUnitConverter {
    private static final Logger LOGGER = Logger.getLogger(DefaultUnitConverter.class.getName());
    private static DefaultUnitConverter instance;
    private String averageCharWidthTestString = "X";
    private Font defaultDialogFont;
    private PropertyChangeSupport changeSupport;
    private DialogBaseUnits cachedGlobalDialogBaseUnits = this.computeGlobalDialogBaseUnits();
    private Map cachedDialogBaseUnits = new HashMap();
    private Font cachedDefaultDialogFont = null;

    private DefaultUnitConverter() {
        UIManager.addPropertyChangeListener(new LookAndFeelChangeHandler());
        this.changeSupport = new PropertyChangeSupport(this);
    }

    public static DefaultUnitConverter getInstance() {
        if (instance == null) {
            instance = new DefaultUnitConverter();
        }
        return instance;
    }

    public String getAverageCharacterWidthTestString() {
        return this.averageCharWidthTestString;
    }

    public void setAverageCharacterWidthTestString(String string) {
        if (string == null) {
            throw new NullPointerException("The test string must not be null.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("The test string must not be empty.");
        }
        String string2 = this.averageCharWidthTestString;
        this.averageCharWidthTestString = string;
        this.changeSupport.firePropertyChange("averageCharacterWidthTestString", string2, string);
    }

    public Font getDefaultDialogFont() {
        return this.defaultDialogFont != null ? this.defaultDialogFont : this.getCachedDefaultDialogFont();
    }

    public void setDefaultDialogFont(Font font) {
        Font font2 = this.defaultDialogFont;
        this.defaultDialogFont = font;
        this.changeSupport.firePropertyChange("defaultDialogFont", font2, font);
    }

    @Override
    protected double getDialogBaseUnitsX(Component component) {
        return this.getDialogBaseUnits((Component)component).x;
    }

    @Override
    protected double getDialogBaseUnitsY(Component component) {
        return this.getDialogBaseUnits((Component)component).y;
    }

    private DialogBaseUnits getGlobalDialogBaseUnits() {
        if (this.cachedGlobalDialogBaseUnits == null) {
            this.cachedGlobalDialogBaseUnits = this.computeGlobalDialogBaseUnits();
        }
        return this.cachedGlobalDialogBaseUnits;
    }

    private DialogBaseUnits getDialogBaseUnits(Component component) {
        if (component == null) {
            return this.getGlobalDialogBaseUnits();
        }
        FontMetrics fontMetrics = component.getFontMetrics(this.getDefaultDialogFont());
        DialogBaseUnits dialogBaseUnits = (DialogBaseUnits)this.cachedDialogBaseUnits.get(fontMetrics);
        if (dialogBaseUnits == null) {
            dialogBaseUnits = this.computeDialogBaseUnits(fontMetrics);
            this.cachedDialogBaseUnits.put(fontMetrics, dialogBaseUnits);
        }
        return dialogBaseUnits;
    }

    private DialogBaseUnits computeDialogBaseUnits(FontMetrics fontMetrics) {
        double d = this.computeAverageCharWidth(fontMetrics, this.averageCharWidthTestString);
        int n = fontMetrics.getAscent();
        double d2 = n > 14 ? (double)n : (double)(n + (15 - n) / 3);
        DialogBaseUnits dialogBaseUnits = new DialogBaseUnits(d, d2);
        LOGGER.config("Computed dialog base units " + dialogBaseUnits + " for: " + fontMetrics.getFont());
        return dialogBaseUnits;
    }

    private DialogBaseUnits computeGlobalDialogBaseUnits() {
        LOGGER.config("Computing global dialog base units...");
        Font font = this.getDefaultDialogFont();
        FontMetrics fontMetrics = this.createDefaultGlobalComponent().getFontMetrics(font);
        DialogBaseUnits dialogBaseUnits = this.computeDialogBaseUnits(fontMetrics);
        return dialogBaseUnits;
    }

    private Font getCachedDefaultDialogFont() {
        if (this.cachedDefaultDialogFont == null) {
            this.cachedDefaultDialogFont = this.lookupDefaultDialogFont();
        }
        return this.cachedDefaultDialogFont;
    }

    private Font lookupDefaultDialogFont() {
        Font font = UIManager.getFont("Button.font");
        return font != null ? font : new JButton().getFont();
    }

    private Component createDefaultGlobalComponent() {
        return new JPanel(null);
    }

    private void invalidateCaches() {
        this.cachedGlobalDialogBaseUnits = null;
        this.cachedDialogBaseUnits.clear();
        this.cachedDefaultDialogFont = null;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    private final class LookAndFeelChangeHandler
    implements PropertyChangeListener {
        private LookAndFeelChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DefaultUnitConverter.this.invalidateCaches();
        }
    }

    private static final class DialogBaseUnits {
        final double x;
        final double y;

        DialogBaseUnits(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        public String toString() {
            return "DBU(x=" + this.x + "; y=" + this.y + ")";
        }
    }
}

