/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.common.ShadowPopup;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;

public final class Options {
    public static final String PLASTIC_NAME = "com.jgoodies.looks.plastic.PlasticLookAndFeel";
    public static final String PLASTIC3D_NAME = "com.jgoodies.looks.plastic.Plastic3DLookAndFeel";
    public static final String PLASTICXP_NAME = "com.jgoodies.looks.plastic.PlasticXPLookAndFeel";
    public static final String JGOODIES_WINDOWS_NAME = "com.jgoodies.looks.windows.WindowsLookAndFeel";
    public static final String DEFAULT_LOOK_NAME = "com.jgoodies.looks.plastic.PlasticXPLookAndFeel";
    private static final Map LAF_REPLACEMENTS = new HashMap();
    public static final String PLASTIC_FONT_POLICY_KEY = "Plastic.fontPolicy";
    public static final String PLASTIC_CONTROL_FONT_KEY = "Plastic.controlFont";
    public static final String PLASTIC_MENU_FONT_KEY = "Plastic.menuFont";
    public static final String WINDOWS_FONT_POLICY_KEY = "Windows.fontPolicy";
    public static final String WINDOWS_CONTROL_FONT_KEY = "Windows.controlFont";
    public static final String WINDOWS_MENU_FONT_KEY = "Windows.menuFont";
    public static final String USE_SYSTEM_FONTS_KEY = "swing.useSystemFontSettings";
    public static final String USE_SYSTEM_FONTS_APP_KEY = "Application.useSystemFontSettings";
    public static final String PLASTIC_MICRO_LAYOUT_POLICY_KEY = "Plastic.MicroLayoutPolicy";
    public static final String WINDOWS_MICRO_LAYOUT_POLICY_KEY = "Windows.MicroLayoutPolicy";
    public static final String DEFAULT_ICON_SIZE_KEY = "jgoodies.defaultIconSize";
    public static final String USE_NARROW_BUTTONS_KEY = "jgoodies.useNarrowButtons";
    public static final String TAB_ICONS_ENABLED_KEY = "jgoodies.tabIconsEnabled";
    public static final String POPUP_DROP_SHADOW_ENABLED_KEY = "jgoodies.popupDropShadowEnabled";
    public static final String HI_RES_GRAY_FILTER_ENABLED_KEY = "HiResGrayFilterEnabled";
    public static final String IS_ETCHED_KEY = "jgoodies.isEtched";
    public static final String HEADER_STYLE_KEY = "jgoodies.headerStyle";
    public static final String NO_ICONS_KEY = "jgoodies.noIcons";
    public static final String NO_MARGIN_KEY = "JPopupMenu.noMargin";
    public static final String TREE_LINE_STYLE_KEY = "JTree.lineStyle";
    public static final String TREE_LINE_STYLE_ANGLED_VALUE = "Angled";
    public static final String TREE_LINE_STYLE_NONE_VALUE = "None";
    public static final String NO_CONTENT_BORDER_KEY = "jgoodies.noContentBorder";
    public static final String EMBEDDED_TABS_KEY = "jgoodies.embeddedTabs";
    public static final String COMBO_POPUP_PROTOTYPE_DISPLAY_VALUE_KEY = "ComboBox.popupPrototypeDisplayValue";
    public static final String COMBO_RENDERER_IS_BORDER_REMOVABLE = "isBorderRemovable";
    public static final String HI_RES_DISABLED_ICON_CLIENT_KEY = "generateHiResDisabledIcon";
    private static final Boolean USE_SYSTEM_FONTS_SYSTEM_VALUE;
    private static final Boolean USE_NARROW_BUTTONS_SYSTEM_VALUE;
    private static final Boolean TAB_ICONS_ENABLED_SYSTEM_VALUE;
    private static final Boolean POPUP_DROP_SHADOW_ENABLED_SYSTEM_VALUE;
    private static final Dimension DEFAULT_ICON_SIZE;
    public static final String NO_REPLACEMENT = "none";

    private Options() {
    }

    public static boolean getUseSystemFonts() {
        return USE_SYSTEM_FONTS_SYSTEM_VALUE != null ? USE_SYSTEM_FONTS_SYSTEM_VALUE : !Boolean.FALSE.equals(UIManager.get(USE_SYSTEM_FONTS_APP_KEY));
    }

    public static void setUseSystemFonts(boolean bl) {
        UIManager.put(USE_SYSTEM_FONTS_APP_KEY, bl);
    }

    public static Dimension getDefaultIconSize() {
        Dimension dimension = UIManager.getDimension(DEFAULT_ICON_SIZE_KEY);
        return dimension == null ? DEFAULT_ICON_SIZE : dimension;
    }

    public static void setDefaultIconSize(Dimension dimension) {
        UIManager.put(DEFAULT_ICON_SIZE_KEY, dimension);
    }

    public static boolean getUseNarrowButtons() {
        return USE_NARROW_BUTTONS_SYSTEM_VALUE != null ? USE_NARROW_BUTTONS_SYSTEM_VALUE : !Boolean.FALSE.equals(UIManager.get(USE_NARROW_BUTTONS_KEY));
    }

    public static void setUseNarrowButtons(boolean bl) {
        UIManager.put(USE_NARROW_BUTTONS_KEY, bl);
    }

    public static boolean isTabIconsEnabled() {
        return TAB_ICONS_ENABLED_SYSTEM_VALUE != null ? TAB_ICONS_ENABLED_SYSTEM_VALUE : !Boolean.FALSE.equals(UIManager.get(TAB_ICONS_ENABLED_KEY));
    }

    public static void setTabIconsEnabled(boolean bl) {
        UIManager.put(TAB_ICONS_ENABLED_KEY, bl);
    }

    public static boolean isPopupDropShadowActive() {
        return !LookUtils.getToolkitUsesNativeDropShadows() && ShadowPopup.canSnapshot() && Options.isPopupDropShadowEnabled();
    }

    public static boolean isPopupDropShadowEnabled() {
        if (POPUP_DROP_SHADOW_ENABLED_SYSTEM_VALUE != null) {
            return POPUP_DROP_SHADOW_ENABLED_SYSTEM_VALUE;
        }
        Object object = UIManager.get(POPUP_DROP_SHADOW_ENABLED_KEY);
        return object == null ? Options.isPopupDropShadowEnabledDefault() : Boolean.TRUE.equals(object);
    }

    public static void setPopupDropShadowEnabled(boolean bl) {
        UIManager.put(POPUP_DROP_SHADOW_ENABLED_KEY, bl);
    }

    private static boolean isPopupDropShadowEnabledDefault() {
        return LookUtils.IS_OS_WINDOWS_MODERN;
    }

    public static boolean isHiResGrayFilterEnabled() {
        return !Boolean.FALSE.equals(UIManager.get(HI_RES_GRAY_FILTER_ENABLED_KEY));
    }

    public static void setHiResGrayFilterEnabled(boolean bl) {
        UIManager.put(HI_RES_GRAY_FILTER_ENABLED_KEY, bl);
    }

    public static void putLookAndFeelReplacement(String string, String string2) {
        LAF_REPLACEMENTS.put(string, string2);
    }

    public static void removeLookAndFeelReplacement(String string) {
        LAF_REPLACEMENTS.remove(string);
    }

    private static void initializeDefaultReplacements() {
        Options.putLookAndFeelReplacement("javax.swing.plaf.metal.MetalLookAndFeel", PLASTIC3D_NAME);
        Options.putLookAndFeelReplacement("com.sun.java.swing.plaf.windows.WindowsLookAndFeel", JGOODIES_WINDOWS_NAME);
        Options.putLookAndFeelReplacement("com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel", NO_REPLACEMENT);
    }

    public static String getReplacementClassNameFor(String string) {
        String string2 = (String)LAF_REPLACEMENTS.get(string);
        if (string2 == null) {
            return string;
        }
        if (string2.equals(NO_REPLACEMENT)) {
            return null;
        }
        return string2;
    }

    public static String getCrossPlatformLookAndFeelClassName() {
        return "com.jgoodies.looks.plastic.PlasticXPLookAndFeel";
    }

    public static String getSystemLookAndFeelClassName() {
        if (LookUtils.IS_OS_WINDOWS) {
            return JGOODIES_WINDOWS_NAME;
        }
        if (LookUtils.IS_OS_MAC) {
            return UIManager.getSystemLookAndFeelClassName();
        }
        return Options.getCrossPlatformLookAndFeelClassName();
    }

    static {
        Options.initializeDefaultReplacements();
        USE_SYSTEM_FONTS_SYSTEM_VALUE = LookUtils.getBooleanSystemProperty(USE_SYSTEM_FONTS_KEY, "Use system fonts");
        USE_NARROW_BUTTONS_SYSTEM_VALUE = LookUtils.getBooleanSystemProperty(USE_NARROW_BUTTONS_KEY, "Use narrow buttons");
        TAB_ICONS_ENABLED_SYSTEM_VALUE = LookUtils.getBooleanSystemProperty(TAB_ICONS_ENABLED_KEY, "Icons in tabbed panes");
        POPUP_DROP_SHADOW_ENABLED_SYSTEM_VALUE = LookUtils.getBooleanSystemProperty(POPUP_DROP_SHADOW_ENABLED_KEY, "Popup drop shadows");
        DEFAULT_ICON_SIZE = new Dimension(20, 20);
    }
}

