/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.net.URLStreamHandlerFactory;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.base.JRBaseDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactory;
import net.sf.jasperreports.engine.util.FormatFactory;
import net.sf.jasperreports.engine.util.JRQueryExecuterUtils;

public class JRDesignDataset
extends JRBaseDataset {
    private static final long serialVersionUID = 10200L;
    protected Map parametersMap = new HashMap();
    protected List parametersList = new ArrayList();
    protected Map fieldsMap = new HashMap();
    protected List fieldsList = new ArrayList();
    protected Map sortFieldsMap = new HashMap();
    protected List sortFieldsList = new ArrayList();
    protected Map variablesMap = new HashMap();
    protected List variablesList = new ArrayList();
    protected Map groupsMap = new HashMap();
    protected List groupsList = new ArrayList();
    private PropertyChangeListener queryLanguageChangeListener = new QueryLanguageChangeListener();
    private static final Object[] BUILT_IN_PARAMETERS = new Object[]{"REPORT_PARAMETERS_MAP", Map.class, "REPORT_CONNECTION", Connection.class, "REPORT_MAX_COUNT", Integer.class, "REPORT_DATA_SOURCE", JRDataSource.class, "REPORT_SCRIPTLET", JRAbstractScriptlet.class, "REPORT_LOCALE", Locale.class, "REPORT_RESOURCE_BUNDLE", ResourceBundle.class, "REPORT_TIME_ZONE", TimeZone.class, "REPORT_DATE_FORMAT_FACTORY", FormatFactory.class, "REPORT_CLASS_LOADER", ClassLoader.class, "REPORT_URL_HANDLER_FACTORY", URLStreamHandlerFactory.class};
    private static final Object[] BUILT_IN_PARAMETERS_MAIN = new Object[]{"REPORT_VIRTUALIZER", JRVirtualizer.class, "IS_IGNORE_PAGINATION", Boolean.class};

    public JRDesignDataset(boolean bl) {
        super(bl);
        this.addBuiltinParameters(BUILT_IN_PARAMETERS);
        if (bl) {
            this.addBuiltinParameters(BUILT_IN_PARAMETERS_MAIN);
        }
        try {
            if (bl) {
                this.addVariable(JRDesignDataset.createPageNumberVariable());
                this.addVariable(JRDesignDataset.createColumnNumberVariable());
            }
            this.addVariable(JRDesignDataset.createReportCountVariable());
            if (bl) {
                this.addVariable(JRDesignDataset.createPageCountVariable());
                this.addVariable(JRDesignDataset.createColumnCountVariable());
            }
        }
        catch (JRException jRException) {
            // empty catch block
        }
    }

    private static JRDesignVariable createPageCountVariable() {
        JRDesignVariable jRDesignVariable = new JRDesignVariable();
        jRDesignVariable.setName("PAGE_COUNT");
        jRDesignVariable.setValueClass(Integer.class);
        jRDesignVariable.setResetType((byte)2);
        jRDesignVariable.setCalculation((byte)1);
        jRDesignVariable.setSystemDefined(true);
        JRDesignExpression jRDesignExpression = new JRDesignExpression();
        jRDesignExpression.setValueClass(Integer.class);
        jRDesignExpression.setText("new Integer(1)");
        jRDesignVariable.setExpression(jRDesignExpression);
        jRDesignExpression = new JRDesignExpression();
        jRDesignExpression.setValueClass(Integer.class);
        jRDesignExpression.setText("new Integer(0)");
        jRDesignVariable.setInitialValueExpression(jRDesignExpression);
        return jRDesignVariable;
    }

    private static JRDesignVariable createColumnNumberVariable() {
        JRDesignVariable jRDesignVariable = new JRDesignVariable();
        jRDesignVariable.setName("COLUMN_NUMBER");
        jRDesignVariable.setValueClass(Integer.class);
        jRDesignVariable.setResetType((byte)2);
        jRDesignVariable.setCalculation((byte)8);
        jRDesignVariable.setSystemDefined(true);
        JRDesignExpression jRDesignExpression = new JRDesignExpression();
        jRDesignExpression.setValueClass(Integer.class);
        jRDesignExpression.setText("new Integer(1)");
        jRDesignVariable.setInitialValueExpression(jRDesignExpression);
        return jRDesignVariable;
    }

    private static JRDesignVariable createPageNumberVariable() {
        JRDesignVariable jRDesignVariable = new JRDesignVariable();
        jRDesignVariable.setName("PAGE_NUMBER");
        jRDesignVariable.setValueClass(Integer.class);
        jRDesignVariable.setResetType((byte)1);
        jRDesignVariable.setCalculation((byte)8);
        jRDesignVariable.setSystemDefined(true);
        JRDesignExpression jRDesignExpression = new JRDesignExpression();
        jRDesignExpression.setValueClass(Integer.class);
        jRDesignExpression.setText("new Integer(1)");
        jRDesignVariable.setInitialValueExpression(jRDesignExpression);
        return jRDesignVariable;
    }

    private static JRDesignVariable createColumnCountVariable() {
        JRDesignVariable jRDesignVariable = new JRDesignVariable();
        jRDesignVariable.setName("COLUMN_COUNT");
        jRDesignVariable.setValueClass(Integer.class);
        jRDesignVariable.setResetType((byte)3);
        jRDesignVariable.setCalculation((byte)1);
        jRDesignVariable.setSystemDefined(true);
        JRDesignExpression jRDesignExpression = new JRDesignExpression();
        jRDesignExpression.setValueClass(Integer.class);
        jRDesignExpression.setText("new Integer(1)");
        jRDesignVariable.setExpression(jRDesignExpression);
        jRDesignExpression = new JRDesignExpression();
        jRDesignExpression.setValueClass(Integer.class);
        jRDesignExpression.setText("new Integer(0)");
        jRDesignVariable.setInitialValueExpression(jRDesignExpression);
        return jRDesignVariable;
    }

    private void addBuiltinParameters(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            JRDesignParameter jRDesignParameter = new JRDesignParameter();
            jRDesignParameter.setName((String)objectArray[i++]);
            jRDesignParameter.setValueClass((Class)objectArray[i]);
            jRDesignParameter.setSystemDefined(true);
            try {
                this.addParameter(jRDesignParameter);
                continue;
            }
            catch (JRException jRException) {
                // empty catch block
            }
        }
    }

    private static JRDesignVariable createReportCountVariable() {
        JRDesignVariable jRDesignVariable = new JRDesignVariable();
        jRDesignVariable.setName("REPORT_COUNT");
        jRDesignVariable.setValueClass(Integer.class);
        jRDesignVariable.setResetType((byte)1);
        jRDesignVariable.setCalculation((byte)1);
        jRDesignVariable.setSystemDefined(true);
        JRDesignExpression jRDesignExpression = new JRDesignExpression();
        jRDesignExpression.setValueClass(Integer.class);
        jRDesignExpression.setText("new Integer(1)");
        jRDesignVariable.setExpression(jRDesignExpression);
        jRDesignExpression = new JRDesignExpression();
        jRDesignExpression.setValueClass(Integer.class);
        jRDesignExpression.setText("new Integer(0)");
        jRDesignVariable.setInitialValueExpression(jRDesignExpression);
        return jRDesignVariable;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public JRParameter[] getParameters() {
        JRParameter[] jRParameterArray = new JRParameter[this.parametersList.size()];
        this.parametersList.toArray(jRParameterArray);
        return jRParameterArray;
    }

    public List getParametersList() {
        return this.parametersList;
    }

    public Map getParametersMap() {
        return this.parametersMap;
    }

    public void addParameter(JRParameter jRParameter) throws JRException {
        if (this.parametersMap.containsKey(jRParameter.getName())) {
            throw new JRException("Duplicate declaration of parameter : " + jRParameter.getName());
        }
        this.parametersList.add(jRParameter);
        this.parametersMap.put(jRParameter.getName(), jRParameter);
    }

    public JRParameter removeParameter(String string) {
        return this.removeParameter((JRParameter)this.parametersMap.get(string));
    }

    public JRParameter removeParameter(JRParameter jRParameter) {
        if (jRParameter != null) {
            this.parametersList.remove(jRParameter);
            this.parametersMap.remove(jRParameter.getName());
        }
        return jRParameter;
    }

    public void setQuery(JRDesignQuery jRDesignQuery) {
        String string = null;
        if (this.query != null) {
            ((JRDesignQuery)this.query).removePropertyChangeListener("language", this.queryLanguageChangeListener);
            string = this.query.getLanguage();
        }
        this.query = jRDesignQuery;
        String string2 = null;
        if (jRDesignQuery != null) {
            jRDesignQuery.addPropertyChangeListener("language", this.queryLanguageChangeListener);
            string2 = jRDesignQuery.getLanguage();
        }
        this.queryLanguageChanged(string, string2);
    }

    public void setScriptletClass(String string) {
        this.scriptletClass = string;
        if (string == null) {
            ((JRDesignParameter)this.parametersMap.get("REPORT_SCRIPTLET")).setValueClass(JRAbstractScriptlet.class);
        } else {
            ((JRDesignParameter)this.parametersMap.get("REPORT_SCRIPTLET")).setValueClassName(string);
        }
    }

    @Override
    public JRField[] getFields() {
        JRField[] jRFieldArray = new JRField[this.fieldsList.size()];
        this.fieldsList.toArray(jRFieldArray);
        return jRFieldArray;
    }

    public List getFieldsList() {
        return this.fieldsList;
    }

    public Map getFieldsMap() {
        return this.fieldsMap;
    }

    public void addField(JRField jRField) throws JRException {
        if (this.fieldsMap.containsKey(jRField.getName())) {
            throw new JRException("Duplicate declaration of field : " + jRField.getName());
        }
        this.fieldsList.add(jRField);
        this.fieldsMap.put(jRField.getName(), jRField);
    }

    public JRField removeField(String string) {
        return this.removeField((JRField)this.fieldsMap.get(string));
    }

    public JRField removeField(JRField jRField) {
        if (jRField != null) {
            this.fieldsList.remove(jRField);
            this.fieldsMap.remove(jRField.getName());
        }
        return jRField;
    }

    @Override
    public JRSortField[] getSortFields() {
        JRSortField[] jRSortFieldArray = new JRSortField[this.sortFieldsList.size()];
        this.sortFieldsList.toArray(jRSortFieldArray);
        return jRSortFieldArray;
    }

    public List getSortFieldsList() {
        return this.sortFieldsList;
    }

    public void addSortField(JRSortField jRSortField) throws JRException {
        if (this.sortFieldsMap.containsKey(jRSortField.getName())) {
            throw new JRException("Duplicate declaration of sort field : " + jRSortField.getName());
        }
        this.sortFieldsList.add(jRSortField);
        this.sortFieldsMap.put(jRSortField.getName(), jRSortField);
    }

    public JRSortField removeSortField(String string) {
        return this.removeSortField((JRSortField)this.sortFieldsMap.get(string));
    }

    public JRSortField removeSortField(JRSortField jRSortField) {
        if (jRSortField != null) {
            this.sortFieldsList.remove(jRSortField);
            this.sortFieldsMap.remove(jRSortField.getName());
        }
        return jRSortField;
    }

    @Override
    public JRVariable[] getVariables() {
        JRVariable[] jRVariableArray = new JRVariable[this.variablesList.size()];
        this.variablesList.toArray(jRVariableArray);
        return jRVariableArray;
    }

    public List getVariablesList() {
        return this.variablesList;
    }

    public Map getVariablesMap() {
        return this.variablesMap;
    }

    public void addVariable(JRDesignVariable jRDesignVariable) throws JRException {
        this.addVariable(jRDesignVariable, false);
    }

    protected void addVariable(JRDesignVariable jRDesignVariable, boolean bl) throws JRException {
        if (this.variablesMap.containsKey(jRDesignVariable.getName())) {
            throw new JRException("Duplicate declaration of variable : " + jRDesignVariable.getName());
        }
        if (bl) {
            ListIterator<JRDesignVariable> listIterator = this.variablesList.listIterator();
            while (listIterator.hasNext()) {
                JRVariable jRVariable = (JRVariable)listIterator.next();
                if (jRVariable.isSystemDefined()) continue;
                listIterator.previous();
                break;
            }
            listIterator.add(jRDesignVariable);
        } else {
            this.variablesList.add(jRDesignVariable);
        }
        this.variablesMap.put(jRDesignVariable.getName(), jRDesignVariable);
    }

    public JRVariable removeVariable(String string) {
        return this.removeVariable((JRVariable)this.variablesMap.get(string));
    }

    public JRVariable removeVariable(JRVariable jRVariable) {
        if (jRVariable != null) {
            this.variablesList.remove(jRVariable);
            this.variablesMap.remove(jRVariable.getName());
        }
        return jRVariable;
    }

    @Override
    public JRGroup[] getGroups() {
        JRGroup[] jRGroupArray = new JRGroup[this.groupsList.size()];
        this.groupsList.toArray(jRGroupArray);
        return jRGroupArray;
    }

    public List getGroupsList() {
        return this.groupsList;
    }

    public Map getGroupsMap() {
        return this.groupsMap;
    }

    public void addGroup(JRDesignGroup jRDesignGroup) throws JRException {
        if (this.groupsMap.containsKey(jRDesignGroup.getName())) {
            throw new JRException("Duplicate declaration of group : " + jRDesignGroup.getName());
        }
        JRDesignVariable jRDesignVariable = new JRDesignVariable();
        jRDesignVariable.setName(jRDesignGroup.getName() + "_COUNT");
        jRDesignVariable.setValueClass(Integer.class);
        jRDesignVariable.setResetType((byte)4);
        jRDesignVariable.setResetGroup(jRDesignGroup);
        jRDesignVariable.setCalculation((byte)1);
        jRDesignVariable.setSystemDefined(true);
        JRDesignExpression jRDesignExpression = new JRDesignExpression();
        jRDesignExpression.setValueClass(Integer.class);
        jRDesignExpression.setText("new Integer(1)");
        jRDesignVariable.setExpression(jRDesignExpression);
        jRDesignExpression = new JRDesignExpression();
        jRDesignExpression.setValueClass(Integer.class);
        jRDesignExpression.setText("new Integer(0)");
        jRDesignVariable.setInitialValueExpression(jRDesignExpression);
        this.addVariable(jRDesignVariable, true);
        jRDesignGroup.setCountVariable(jRDesignVariable);
        this.groupsList.add(jRDesignGroup);
        this.groupsMap.put(jRDesignGroup.getName(), jRDesignGroup);
    }

    public JRGroup removeGroup(String string) {
        return this.removeGroup((JRGroup)this.groupsMap.get(string));
    }

    public JRGroup removeGroup(JRGroup jRGroup) {
        if (jRGroup != null) {
            this.removeVariable(jRGroup.getCountVariable());
            this.groupsList.remove(jRGroup);
            this.groupsMap.remove(jRGroup.getName());
        }
        return jRGroup;
    }

    public void setResourceBundle(String string) {
        this.resourceBundle = string;
    }

    protected void queryLanguageChanged(String string, String string2) {
        try {
            JRQueryExecuterFactory jRQueryExecuterFactory;
            Object[] objectArray;
            if (string != null && (objectArray = (jRQueryExecuterFactory = JRQueryExecuterUtils.getQueryExecuterFactory(string)).getBuiltinParameters()) != null) {
                this.removeBuiltinParameters(objectArray);
            }
            if (string2 != null && (objectArray = (jRQueryExecuterFactory = JRQueryExecuterUtils.getQueryExecuterFactory(string2)).getBuiltinParameters()) != null) {
                this.addBuiltinParameters(objectArray);
                this.sortSystemParamsFirst();
            }
        }
        catch (JRException jRException) {
            throw new JRRuntimeException(jRException);
        }
    }

    private void sortSystemParamsFirst() {
        Collections.sort(this.parametersList, new Comparator(){

            public int compare(Object object, Object object2) {
                JRParameter jRParameter = (JRParameter)object;
                JRParameter jRParameter2 = (JRParameter)object2;
                boolean bl = jRParameter.isSystemDefined();
                boolean bl2 = jRParameter2.isSystemDefined();
                return bl ? (bl2 ? 0 : -1) : (bl2 ? 1 : 0);
            }
        });
    }

    private void removeBuiltinParameters(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; i += 2) {
            String string = (String)objectArray[i];
            JRParameter jRParameter = (JRParameter)this.parametersMap.get(string);
            if (!jRParameter.isSystemDefined()) continue;
            this.removeParameter(jRParameter);
        }
    }

    public void setProperty(String string, String string2) {
        this.getPropertiesMap().setProperty(string, string2);
    }

    public void setFilterExpression(JRExpression jRExpression) {
        this.filterExpression = jRExpression;
    }

    private class QueryLanguageChangeListener
    implements PropertyChangeListener,
    Serializable {
        private static final long serialVersionUID = 10200L;

        private QueryLanguageChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JRDesignDataset.this.queryLanguageChanged((String)propertyChangeEvent.getOldValue(), (String)propertyChangeEvent.getNewValue());
        }
    }
}

