/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.export.JRExporterGridCell;

public class JRGridLayout {
    public static final ExporterElements UNIVERSAL_EXPORTER = new ExporterElements(){

        @Override
        public boolean isToExport(JRPrintElement jRPrintElement) {
            return true;
        }
    };
    public static final ExporterElements NO_IMAGES_EXPORTER = new ExporterElements(){

        @Override
        public boolean isToExport(JRPrintElement jRPrintElement) {
            return !(jRPrintElement instanceof JRPrintImage);
        }
    };
    public static final ExporterElements TEXT_EXPORTER = new ExporterElements(){

        @Override
        public boolean isToExport(JRPrintElement jRPrintElement) {
            return jRPrintElement instanceof JRPrintText;
        }
    };
    private final List elements;
    private final List alterYs;
    private final int width;
    private final int height;
    private final int offsetX;
    private final int offsetY;
    private final ExporterElements elementsExporter;
    private final boolean deep;
    private final boolean spanCells;
    private final boolean setElementIndexes;
    private final Integer[] initialIndex;
    private List xCuts;
    private List yCuts;
    private JRExporterGridCell[][] grid;
    private boolean[] isRowNotEmpty;
    private boolean[] isColNotEmpty;
    private Map boxesCache;

    public JRGridLayout(List list, List list2, int n, int n2, int n3, int n4, ExporterElements exporterElements, boolean bl, boolean bl2, boolean bl3, Integer[] integerArray) {
        this.elements = list;
        this.alterYs = list2;
        this.height = n2;
        this.offsetX = n3;
        this.offsetY = n4;
        this.width = n;
        this.elementsExporter = exporterElements;
        this.deep = bl;
        this.spanCells = bl2;
        this.setElementIndexes = bl3;
        this.initialIndex = integerArray;
        this.boxesCache = new HashMap();
        this.layoutGrid();
    }

    protected void layoutGrid() {
        this.xCuts = new SortedList();
        this.yCuts = new SortedList();
        this.xCuts.add(new Integer(0));
        this.yCuts.add(new Integer(0));
        this.createCuts(this.elements, this.alterYs, this.offsetX, this.offsetY);
        this.xCuts.add(new Integer(this.width));
        this.yCuts.add(new Integer(this.height));
        int n = this.xCuts.size() - 1;
        int n2 = this.yCuts.size() - 1;
        this.grid = new JRExporterGridCell[n2][n];
        this.isRowNotEmpty = new boolean[n2];
        this.isColNotEmpty = new boolean[n];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.grid[i][j] = new JRExporterGridCell(null, null, (Integer)this.xCuts.get(j + 1) - (Integer)this.xCuts.get(j), (Integer)this.yCuts.get(i + 1) - (Integer)this.yCuts.get(i), 1, 1);
            }
        }
        this.setGridElements(this.elements, this.alterYs, this.offsetX, this.offsetY, this.initialIndex);
    }

    protected void createCuts(List list, List list2, int n, int n2) {
        Iterator iterator = list2 == null ? null : list2.iterator();
        for (JRPrintElement jRPrintElement : list) {
            Integer n3 = iterator == null ? null : (Integer)iterator.next();
            int n4 = jRPrintElement.getX() + n;
            int n5 = n3 == null ? jRPrintElement.getY() : n3.intValue();
            int n6 = n5 + n2;
            if (this.elementsExporter.isToExport(jRPrintElement)) {
                this.xCuts.add(new Integer(n4));
                this.xCuts.add(new Integer(n4 + jRPrintElement.getWidth()));
                this.yCuts.add(new Integer(n6));
                this.yCuts.add(new Integer(n6 + jRPrintElement.getHeight()));
            }
            if (!this.deep || !(jRPrintElement instanceof JRPrintFrame)) continue;
            this.createFrameCuts((JRPrintFrame)jRPrintElement, n4, n6);
        }
    }

    protected void createFrameCuts(JRPrintFrame jRPrintFrame, int n, int n2) {
        int n3 = jRPrintFrame.getTopPadding();
        int n4 = jRPrintFrame.getLeftPadding();
        this.createCuts(jRPrintFrame.getElements(), null, n + n4, n2 + n3);
    }

    protected void setGridElements(List list, List list2, int n, int n2, Integer[] integerArray) {
        for (int i = list.size() - 1; i >= 0; --i) {
            int n3;
            int n4;
            int n5;
            JRPrintFrame jRPrintFrame;
            JRPrintElement jRPrintElement = (JRPrintElement)list.get(i);
            boolean bl = this.elementsExporter.isToExport(jRPrintElement);
            JRPrintFrame jRPrintFrame2 = jRPrintFrame = this.deep && jRPrintElement instanceof JRPrintFrame ? (JRPrintFrame)jRPrintElement : null;
            if (!bl && jRPrintFrame == null) continue;
            int n6 = list2 == null ? jRPrintElement.getY() : ((Integer)list2.get(i)).intValue();
            int n7 = jRPrintElement.getX() + n;
            int n8 = n6 + n2;
            if (jRPrintFrame != null) {
                this.setFrameGridElements(jRPrintFrame, n7, n8, i, integerArray);
            }
            if (!bl) continue;
            int n9 = this.xCuts.indexOf(new Integer(n7));
            if (!this.isOverlap(n9, n5 = this.yCuts.indexOf(new Integer(n8)), n4 = this.xCuts.indexOf(new Integer(n7 + jRPrintElement.getWidth())), n3 = this.yCuts.indexOf(new Integer(n8 + jRPrintElement.getHeight())))) {
                this.setGridElement(jRPrintElement, n9, n5, n4, n3, i, integerArray);
            }
            if (jRPrintFrame == null) continue;
            this.setFrameCellsStyle(jRPrintFrame, n9, n4, n5, n3);
        }
    }

    protected boolean isOverlap(int n, int n2, int n3, int n4) {
        boolean bl;
        if (this.spanCells) {
            bl = false;
            for (int i = n2; i < n4 && !bl; ++i) {
                for (int j = n; j < n3 && !bl; ++j) {
                    if (this.grid[i][j].element == null) continue;
                    bl = true;
                }
            }
        } else {
            bl = this.grid[n2][n].element != null;
        }
        return bl;
    }

    protected void setGridElement(JRPrintElement jRPrintElement, int n, int n2, int n3, int n4, int n5, Integer[] integerArray) {
        if (this.spanCells) {
            int n6;
            for (n6 = n2; n6 < n4; ++n6) {
                for (int i = n; i < n3; ++i) {
                    this.grid[n6][i] = JRExporterGridCell.OCCUPIED_CELL;
                }
                this.isRowNotEmpty[n6] = true;
            }
            for (n6 = n; n6 < n3; ++n6) {
                this.isColNotEmpty[n6] = true;
            }
        } else {
            this.isRowNotEmpty[n2] = true;
            this.isColNotEmpty[n] = true;
        }
        if (n3 - n != 0 && n4 - n2 != 0) {
            this.grid[n2][n] = new JRExporterGridCell(jRPrintElement, this.getElementIndex(n5, integerArray), jRPrintElement.getWidth(), jRPrintElement.getHeight(), n3 - n, n4 - n2);
            JRBox jRBox = null;
            if (jRPrintElement instanceof JRBox) {
                jRBox = (JRBox)((Object)jRPrintElement);
            }
            this.grid[n2][n].setBox(jRBox);
        }
    }

    protected Integer[] getElementIndex(int n, Integer[] integerArray) {
        Integer[] integerArray2;
        if (!this.setElementIndexes) {
            return null;
        }
        if (integerArray == null) {
            integerArray2 = new Integer[]{new Integer(n)};
        } else {
            integerArray2 = new Integer[integerArray.length + 1];
            System.arraycopy(integerArray, 0, integerArray2, 0, integerArray.length);
            integerArray2[integerArray.length] = new Integer(n);
        }
        return integerArray2;
    }

    protected void setFrameGridElements(JRPrintFrame jRPrintFrame, int n, int n2, int n3, Integer[] integerArray) {
        int n4 = jRPrintFrame.getTopPadding();
        int n5 = jRPrintFrame.getLeftPadding();
        this.setGridElements(jRPrintFrame.getElements(), null, n + n5, n2 + n4, this.getElementIndex(n3, integerArray));
    }

    protected void setFrameCellsStyle(JRPrintFrame jRPrintFrame, int n, int n2, int n3, int n4) {
        Color color = jRPrintFrame.getMode() == 1 ? jRPrintFrame.getBackcolor() : null;
        for (int i = n3; i < n4; ++i) {
            for (int j = n; j < n2; ++j) {
                boolean bl;
                JRExporterGridCell jRExporterGridCell = this.grid[i][j];
                if (jRExporterGridCell.getBackcolor() == null && jRPrintFrame.getMode() == 1) {
                    jRExporterGridCell.setBackcolor(color);
                }
                if (jRExporterGridCell.getForecolor() == null) {
                    jRExporterGridCell.setForecolor(jRPrintFrame.getForecolor());
                }
                boolean bl2 = j == n;
                boolean bl3 = j == n2 - jRExporterGridCell.colSpan;
                boolean bl4 = i == n3;
                boolean bl5 = bl = i == n4 - jRExporterGridCell.rowSpan;
                if (!bl2 && !bl3 && !bl4 && !bl) continue;
                JRBox jRBox = jRExporterGridCell.getBox();
                BoxKey boxKey = new BoxKey(jRPrintFrame, jRBox, bl2, bl3, bl4, bl);
                JRBox jRBox2 = (JRBox)this.boxesCache.get(boxKey);
                if (jRBox2 == null) {
                    jRBox2 = new JRBaseBox(jRPrintFrame, bl2, bl3, bl4, bl, jRBox);
                    this.boxesCache.put(boxKey, jRBox2);
                }
                jRExporterGridCell.setBox(jRBox2);
            }
        }
    }

    public JRExporterGridCell[][] getGrid() {
        return this.grid;
    }

    public boolean[] getIsRowNotEmpty() {
        return this.isRowNotEmpty;
    }

    public boolean[] getIsColumnNotEmpty() {
        return this.isColNotEmpty;
    }

    public List getXCuts() {
        return this.xCuts;
    }

    public List getYCuts() {
        return this.yCuts;
    }

    public int getWidth() {
        return this.width;
    }

    public static int getRowHeight(JRExporterGridCell[][] jRExporterGridCellArray, int n) {
        return JRGridLayout.getRowHeight(jRExporterGridCellArray[n]);
    }

    public static int getRowHeight(JRExporterGridCell[] jRExporterGridCellArray) {
        int n;
        if (jRExporterGridCellArray[0].rowSpan == 1 && jRExporterGridCellArray[0] != JRExporterGridCell.OCCUPIED_CELL) {
            return jRExporterGridCellArray[0].height;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = jRExporterGridCellArray.length;
        for (n = 0; n < n4; ++n) {
            JRExporterGridCell jRExporterGridCell = jRExporterGridCellArray[n];
            if (jRExporterGridCell == JRExporterGridCell.OCCUPIED_CELL) continue;
            if (jRExporterGridCell.rowSpan == 1) {
                n2 = jRExporterGridCell.height;
                break;
            }
            if (jRExporterGridCell.rowSpan >= jRExporterGridCellArray[n3].rowSpan) continue;
            n3 = n;
        }
        if (n >= n4) {
            n2 = jRExporterGridCellArray[n3].height;
        }
        return n2;
    }

    protected static class BoxKey {
        final JRBox box;
        final JRBox cellBox;
        final boolean left;
        final boolean right;
        final boolean top;
        final boolean bottom;
        final int hashCode;

        BoxKey(JRBox jRBox, JRBox jRBox2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.box = jRBox;
            this.cellBox = jRBox2;
            this.left = bl;
            this.right = bl2;
            this.top = bl3;
            this.bottom = bl4;
            int n = jRBox.hashCode();
            if (jRBox2 != null) {
                n = 31 * n + jRBox2.hashCode();
            }
            n = 31 * n + (bl ? 1231 : 1237);
            n = 31 * n + (bl2 ? 1231 : 1237);
            n = 31 * n + (bl3 ? 1231 : 1237);
            this.hashCode = n = 31 * n + (bl4 ? 1231 : 1237);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            BoxKey boxKey = (BoxKey)object;
            return boxKey.box.equals(this.box) && (boxKey.cellBox == null ? this.cellBox == null : this.cellBox != null && boxKey.cellBox.equals(this.cellBox)) && boxKey.left == this.left && boxKey.right == this.right && boxKey.top == this.top && boxKey.bottom == this.bottom;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    protected static class SortedList
    extends ArrayList {
        protected SortedList() {
        }

        @Override
        public boolean add(Object object) {
            int n = Collections.binarySearch(this, object);
            if (n >= 0) {
                return false;
            }
            this.add(-n - 1, object);
            return true;
        }

        @Override
        public int indexOf(Object object) {
            int n = Collections.binarySearch(this, object);
            if (n < 0) {
                n = -1;
            }
            return n;
        }
    }

    public static interface ExporterElements {
        public boolean isToExport(JRPrintElement var1);
    }
}

