/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRMultiAxisPlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.fill.JRFillAreaPlot;
import net.sf.jasperreports.charts.fill.JRFillBar3DPlot;
import net.sf.jasperreports.charts.fill.JRFillBarPlot;
import net.sf.jasperreports.charts.fill.JRFillCategoryDataset;
import net.sf.jasperreports.charts.fill.JRFillChartAxis;
import net.sf.jasperreports.charts.fill.JRFillHighLowDataset;
import net.sf.jasperreports.charts.fill.JRFillLinePlot;
import net.sf.jasperreports.charts.fill.JRFillMeterPlot;
import net.sf.jasperreports.charts.fill.JRFillMultiAxisPlot;
import net.sf.jasperreports.charts.fill.JRFillPie3DPlot;
import net.sf.jasperreports.charts.fill.JRFillPieDataset;
import net.sf.jasperreports.charts.fill.JRFillThermometerPlot;
import net.sf.jasperreports.charts.fill.JRFillTimePeriodDataset;
import net.sf.jasperreports.charts.fill.JRFillTimeSeriesDataset;
import net.sf.jasperreports.charts.fill.JRFillXyDataset;
import net.sf.jasperreports.charts.fill.JRFillXyzDataset;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.charts.util.PieLabelGenerator;
import net.sf.jasperreports.engine.JRAbstractChartCustomizer;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartCustomizer;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCloneable;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillHyperlinkHelper;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateImage;
import net.sf.jasperreports.engine.fill.JRTemplatePrintImage;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import net.sf.jasperreports.renderers.JFreeChartRenderer;
import net.sf.jasperreports.renderers.JRCategoryChartImageMapRenderer;
import net.sf.jasperreports.renderers.JRHighLowChartImageMapRenderer;
import net.sf.jasperreports.renderers.JRPieChartImageMapRenderer;
import net.sf.jasperreports.renderers.JRTimePeriodChartImageMapRenderer;
import net.sf.jasperreports.renderers.JRTimeSeriesChartImageMapRenderer;
import net.sf.jasperreports.renderers.JRXYChartImageMapRenderer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.chart.renderer.xy.CandlestickRenderer;
import org.jfree.chart.renderer.xy.HighLowRenderer;
import org.jfree.chart.renderer.xy.XYBubbleRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.DefaultHighLowDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;

public class JRFillChart
extends JRFillElement
implements JRChart {
    private static final Color TRANSPARENT_PAINT = new Color(0, 0, 0, 0);
    protected byte chartType = 0;
    protected JRFont titleFont = null;
    protected JRFont subtitleFont = null;
    protected JRFont legendFont = null;
    protected JRGroup evaluationGroup = null;
    protected JRFillChartDataset dataset = null;
    protected JRChartPlot plot = null;
    protected JRRenderable renderer = null;
    private String anchorName = null;
    private String hyperlinkReference = null;
    private String hyperlinkAnchor = null;
    private Integer hyperlinkPage = null;
    private String hyperlinkTooltip;
    private JRPrintHyperlinkParameters hyperlinkParameters;
    protected String customizerClass;
    protected JRChartCustomizer chartCustomizer;

    protected JRFillChart(JRBaseFiller jRBaseFiller, JRChart jRChart, JRFillObjectFactory jRFillObjectFactory) {
        super(jRBaseFiller, jRChart, jRFillObjectFactory);
        this.chartType = jRChart.getChartType();
        switch (this.chartType) {
            case 1: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getAreaPlot((JRAreaPlot)jRChart.getPlot());
                break;
            }
            case 3: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getBarPlot((JRBarPlot)jRChart.getPlot());
                break;
            }
            case 2: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getBar3DPlot((JRBar3DPlot)jRChart.getPlot());
                break;
            }
            case 4: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getXyzDataset((JRXyzDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getBubblePlot((JRBubblePlot)jRChart.getPlot());
                break;
            }
            case 5: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getHighLowDataset((JRHighLowDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getCandlestickPlot((JRCandlestickPlot)jRChart.getPlot());
                break;
            }
            case 6: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getHighLowDataset((JRHighLowDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getHighLowPlot((JRHighLowPlot)jRChart.getPlot());
                break;
            }
            case 7: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getLinePlot((JRLinePlot)jRChart.getPlot());
                break;
            }
            case 17: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getValueDataset((JRValueDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getMeterPlot((JRMeterPlot)jRChart.getPlot());
                break;
            }
            case 19: {
                this.plot = jRFillObjectFactory.getMultiAxisPlot((JRMultiAxisPlot)jRChart.getPlot());
                this.dataset = ((JRFillMultiAxisPlot)this.plot).getMainDataset();
                break;
            }
            case 9: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getPieDataset((JRPieDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getPiePlot((JRPiePlot)jRChart.getPlot());
                break;
            }
            case 8: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getPieDataset((JRPieDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getPie3DPlot((JRPie3DPlot)jRChart.getPlot());
                break;
            }
            case 10: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getXyDataset((JRXyDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getScatterPlot((JRScatterPlot)jRChart.getPlot());
                break;
            }
            case 12: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getBarPlot((JRBarPlot)jRChart.getPlot());
                break;
            }
            case 11: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getBar3DPlot((JRBar3DPlot)jRChart.getPlot());
                break;
            }
            case 18: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getValueDataset((JRValueDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getThermometerPlot((JRThermometerPlot)jRChart.getPlot());
                break;
            }
            case 16: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getTimeSeriesDataset((JRTimeSeriesDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getTimeSeriesPlot((JRTimeSeriesPlot)jRChart.getPlot());
                break;
            }
            case 13: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getXyDataset((JRXyDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getAreaPlot((JRAreaPlot)jRChart.getPlot());
                break;
            }
            case 14: {
                switch (jRChart.getDataset().getDatasetType()) {
                    case 6: {
                        this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getTimeSeriesDataset((JRTimeSeriesDataset)jRChart.getDataset()));
                        break;
                    }
                    case 5: {
                        this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getTimePeriodDataset((JRTimePeriodDataset)jRChart.getDataset()));
                        break;
                    }
                    case 3: {
                        this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getXyDataset((JRXyDataset)jRChart.getDataset()));
                    }
                }
                this.plot = jRFillObjectFactory.getBarPlot((JRBarPlot)jRChart.getPlot());
                break;
            }
            case 15: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getXyDataset((JRXyDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getLinePlot((JRLinePlot)jRChart.getPlot());
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
        if (jRChart.getTitleFont() != null) {
            this.titleFont = jRFillObjectFactory.getFont(jRChart.getTitleFont());
        }
        if (jRChart.getSubtitleFont() != null) {
            this.subtitleFont = jRFillObjectFactory.getFont(jRChart.getSubtitleFont());
        }
        if (jRChart.getLegendFont() != null) {
            this.legendFont = jRFillObjectFactory.getFont(jRChart.getLegendFont());
        }
        this.evaluationGroup = jRFillObjectFactory.getGroup(jRChart.getEvaluationGroup());
        this.customizerClass = jRChart.getCustomizerClass();
        if (this.customizerClass != null && this.customizerClass.length() > 0) {
            try {
                Class clazz = JRClassLoader.loadClassForName(this.customizerClass);
                this.chartCustomizer = (JRChartCustomizer)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new JRRuntimeException("Could not create chart customizer instance.", exception);
            }
            if (this.chartCustomizer instanceof JRAbstractChartCustomizer) {
                ((JRAbstractChartCustomizer)this.chartCustomizer).init(jRBaseFiller, this);
            }
        }
    }

    @Override
    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    @Override
    public boolean isShowLegend() {
        return ((JRChart)this.parent).isShowLegend();
    }

    @Override
    public void setShowLegend(boolean bl) {
    }

    @Override
    public byte getEvaluationTime() {
        return ((JRChart)this.parent).getEvaluationTime();
    }

    @Override
    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    @Override
    public JRBox getBox() {
        return (JRBox)((Object)this.parent);
    }

    @Override
    public JRFont getTitleFont() {
        return this.titleFont;
    }

    @Override
    public byte getTitlePosition() {
        return ((JRChart)this.parent).getTitlePosition();
    }

    @Override
    public void setTitlePosition(byte by) {
    }

    @Override
    public Color getTitleColor() {
        return ((JRChart)this.parent).getTitleColor();
    }

    @Override
    public void setTitleColor(Color color) {
    }

    @Override
    public JRFont getSubtitleFont() {
        return this.subtitleFont;
    }

    @Override
    public Color getSubtitleColor() {
        return ((JRChart)this.parent).getSubtitleColor();
    }

    @Override
    public void setSubtitleColor(Color color) {
    }

    @Override
    public Color getLegendColor() {
        return ((JRChart)this.parent).getLegendColor();
    }

    @Override
    public void setLegendColor(Color color) {
    }

    @Override
    public Color getLegendBackgroundColor() {
        return ((JRChart)this.parent).getLegendBackgroundColor();
    }

    @Override
    public void setLegendBackgroundColor(Color color) {
    }

    @Override
    public JRFont getLegendFont() {
        return this.legendFont;
    }

    @Override
    public JRExpression getTitleExpression() {
        return ((JRChart)this.parent).getTitleExpression();
    }

    @Override
    public JRExpression getSubtitleExpression() {
        return ((JRChart)this.parent).getSubtitleExpression();
    }

    @Override
    public byte getHyperlinkType() {
        return ((JRChart)this.parent).getHyperlinkType();
    }

    @Override
    public byte getHyperlinkTarget() {
        return ((JRChart)this.parent).getHyperlinkTarget();
    }

    @Override
    public JRExpression getAnchorNameExpression() {
        return ((JRChart)this.parent).getAnchorNameExpression();
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return ((JRChart)this.parent).getHyperlinkReferenceExpression();
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return ((JRChart)this.parent).getHyperlinkAnchorExpression();
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return ((JRChart)this.parent).getHyperlinkPageExpression();
    }

    @Override
    public JRChartDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(JRFillChartDataset jRFillChartDataset) {
        this.dataset = jRFillChartDataset;
    }

    @Override
    public JRChartPlot getPlot() {
        return this.plot;
    }

    protected JRRenderable getRenderer() {
        return this.renderer;
    }

    protected String getAnchorName() {
        return this.anchorName;
    }

    protected String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    protected String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    protected Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    protected String getHyperlinkTooltip() {
        return this.hyperlinkTooltip;
    }

    protected JRTemplateImage getJRTemplateImage() {
        JRStyle jRStyle = this.getStyle();
        JRTemplateImage jRTemplateImage = (JRTemplateImage)this.getTemplate(jRStyle);
        if (jRTemplateImage == null) {
            jRTemplateImage = new JRTemplateImage(this.filler.getJasperPrint().getDefaultStyleProvider(), this);
            this.registerTemplate(jRStyle, jRTemplateImage);
        }
        return jRTemplateImage;
    }

    @Override
    protected void rewind() {
    }

    @Override
    protected void evaluate(byte by) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(by);
        if ((this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) && this.getEvaluationTime() == 1) {
            this.evaluateImage(by);
        }
    }

    protected JFreeChartRenderer evaluateImage(byte by) throws JRException {
        JFreeChartRenderer jFreeChartRenderer;
        this.evaluateDatasetRun(by);
        switch (this.chartType) {
            case 1: {
                jFreeChartRenderer = this.evaluateAreaImage(by);
                break;
            }
            case 3: {
                jFreeChartRenderer = this.evaluateBarImage(by);
                break;
            }
            case 2: {
                jFreeChartRenderer = this.evaluateBar3DImage(by);
                break;
            }
            case 4: {
                jFreeChartRenderer = this.evaluateBubbleImage(by);
                break;
            }
            case 5: {
                jFreeChartRenderer = this.evaluateCandlestickImage(by);
                break;
            }
            case 6: {
                jFreeChartRenderer = this.evaluateHighLowImage(by);
                break;
            }
            case 7: {
                jFreeChartRenderer = this.evaluateLineImage(by);
                break;
            }
            case 17: {
                jFreeChartRenderer = this.evaluateMeterImage(by);
                break;
            }
            case 19: {
                jFreeChartRenderer = this.evaluateMultiAxisImage(by);
                break;
            }
            case 9: {
                jFreeChartRenderer = this.evaluatePieImage(by);
                break;
            }
            case 8: {
                jFreeChartRenderer = this.evaluatePie3DImage(by);
                break;
            }
            case 10: {
                jFreeChartRenderer = this.evaluateScatterImage(by);
                break;
            }
            case 12: {
                jFreeChartRenderer = this.evaluateStackedBarImage(by);
                break;
            }
            case 11: {
                jFreeChartRenderer = this.evaluateStackedBar3DImage(by);
                break;
            }
            case 18: {
                jFreeChartRenderer = this.evaluateThermometerImage(by);
                break;
            }
            case 16: {
                jFreeChartRenderer = this.evaluateTimeSeriesImage(by);
                break;
            }
            case 13: {
                jFreeChartRenderer = this.evaluateXyAreaImage(by);
                break;
            }
            case 14: {
                jFreeChartRenderer = this.evaluateXYBarImage(by);
                break;
            }
            case 15: {
                jFreeChartRenderer = this.evaluateXyLineImage(by);
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type " + this.getChartType() + " not supported.");
            }
        }
        if (this.chartCustomizer != null) {
            this.chartCustomizer.customize(jFreeChartRenderer.getChart(), this);
        }
        this.renderer = jFreeChartRenderer;
        this.anchorName = (String)this.evaluateExpression(this.getAnchorNameExpression(), by);
        this.hyperlinkReference = (String)this.evaluateExpression(this.getHyperlinkReferenceExpression(), by);
        this.hyperlinkAnchor = (String)this.evaluateExpression(this.getHyperlinkAnchorExpression(), by);
        this.hyperlinkPage = (Integer)this.evaluateExpression(this.getHyperlinkPageExpression(), by);
        this.hyperlinkTooltip = (String)this.evaluateExpression(this.getHyperlinkTooltipExpression(), by);
        this.hyperlinkParameters = JRFillHyperlinkHelper.evaluateHyperlinkParameters(this, this.expressionEvaluator, by);
        return jFreeChartRenderer;
    }

    @Override
    protected boolean prepare(int n, boolean bl) {
        boolean bl2 = false;
        if (this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) {
            this.setToPrint(true);
        } else {
            this.setToPrint(false);
        }
        if (!this.isToPrint()) {
            return bl2;
        }
        boolean bl3 = true;
        boolean bl4 = false;
        if (this.getEvaluationTime() == 1) {
            if (bl && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                bl3 = false;
            }
            if (bl3 && n < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
                bl3 = false;
                bl2 = true;
            }
            if (bl3 && bl && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                bl4 = true;
            }
            if (bl3 && this.isRemoveLineWhenBlank() && this.getRenderer() == null) {
                bl3 = false;
            }
        } else {
            if (bl && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                bl3 = false;
            }
            if (bl3 && n < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
                bl3 = false;
                bl2 = true;
            }
            if (bl3 && bl && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                bl4 = true;
            }
        }
        this.setToPrint(bl3);
        this.setReprinted(bl4);
        return bl2;
    }

    @Override
    protected JRPrintElement fill() {
        JRTemplatePrintImage jRTemplatePrintImage = new JRTemplatePrintImage(this.getJRTemplateImage());
        jRTemplatePrintImage.setX(this.getX());
        jRTemplatePrintImage.setY(this.getRelativeY());
        jRTemplatePrintImage.setWidth(this.getWidth());
        jRTemplatePrintImage.setHeight(this.getStretchHeight());
        byte by = this.getEvaluationTime();
        if (by == 1) {
            this.copy(jRTemplatePrintImage);
        } else {
            this.filler.addBoundElement(this, jRTemplatePrintImage, by, this.getEvaluationGroup(), this.band);
        }
        return jRTemplatePrintImage;
    }

    protected void copy(JRPrintImage jRPrintImage) {
        jRPrintImage.setRenderer(this.getRenderer());
        jRPrintImage.setAnchorName(this.getAnchorName());
        jRPrintImage.setHyperlinkReference(this.getHyperlinkReference());
        jRPrintImage.setHyperlinkAnchor(this.getHyperlinkAnchor());
        jRPrintImage.setHyperlinkPage(this.getHyperlinkPage());
        jRPrintImage.setHyperlinkTooltip(this.getHyperlinkTooltip());
        jRPrintImage.setBookmarkLevel(this.getBookmarkLevel());
        jRPrintImage.setHyperlinkParameters(this.hyperlinkParameters);
    }

    @Override
    public byte getChartType() {
        return this.chartType;
    }

    @Override
    public JRChild getCopy(JRAbstractObjectFactory jRAbstractObjectFactory) {
        return jRAbstractObjectFactory.getChart(this);
    }

    @Override
    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    @Override
    public void writeXml(JRXmlWriter jRXmlWriter) {
    }

    private void configureChart(JFreeChart jFreeChart, JRChartPlot jRChartPlot, byte by) throws JRException {
        Object object;
        Object object2;
        Object object3;
        if (this.getMode() == 1) {
            jFreeChart.setBackgroundPaint(this.getBackcolor());
        } else {
            jFreeChart.setBackgroundPaint(TRANSPARENT_PAINT);
        }
        if (jFreeChart.getTitle() != null) {
            object3 = jFreeChart.getTitle();
            ((TextTitle)object3).setPaint(this.getTitleColor());
            object2 = this.getTitleFont();
            if (object2 != null) {
                object = JRFontUtil.getNonPdfAttributes((JRFont)object2);
                ((TextTitle)object3).setFont(new Font((Map<? extends AttributedCharacterIterator.Attribute, ?>)object));
            }
        }
        if ((object3 = (String)this.evaluateExpression(this.getSubtitleExpression(), by)) != null) {
            object2 = new TextTitle((String)object3);
            ((TextTitle)object2).setPaint(this.getSubtitleColor());
            object = this.getSubtitleFont();
            if (object != null) {
                Map map = JRFontUtil.getNonPdfAttributes((JRFont)object);
                ((TextTitle)object2).setFont(new Font(map));
            }
            jFreeChart.addSubtitle((Title)object2);
        }
        if (this.getLegendColor() != null) {
            jFreeChart.getLegend().setItemPaint(this.getLegendColor());
        }
        if (this.getLegendBackgroundColor() != null) {
            jFreeChart.getLegend().setBackgroundPaint(this.getLegendBackgroundColor());
        }
        if (this.getLegendFont() != null) {
            object2 = JRFontUtil.getNonPdfAttributes(this.getLegendFont());
            jFreeChart.getLegend().setItemFont(new Font((Map<? extends AttributedCharacterIterator.Attribute, ?>)object2));
        }
        this.configurePlot(jFreeChart.getPlot(), jRChartPlot);
    }

    private void configurePlot(Plot plot, JRChartPlot jRChartPlot) {
        Paint[] paintArray;
        plot.setOutlinePaint(TRANSPARENT_PAINT);
        if (this.getPlot().getBackcolor() == null) {
            plot.setBackgroundPaint(TRANSPARENT_PAINT);
        } else {
            plot.setBackgroundPaint(this.getPlot().getBackcolor());
        }
        plot.setBackgroundAlpha(this.getPlot().getBackgroundAlpha());
        plot.setForegroundAlpha(this.getPlot().getForegroundAlpha());
        SortedSet sortedSet = this.getPlot().getSeriesColors();
        if (plot instanceof CategoryPlot) {
            paintArray = ((CategoryPlot)plot).getDomainAxis();
            double d = this.getPlot().getLabelRotation();
            if (d == 90.0) {
                paintArray.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);
            } else if (d == -90.0) {
                paintArray.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            } else if (d < 0.0) {
                paintArray.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions(-d / 180.0 * Math.PI));
            } else if (d > 0.0) {
                paintArray.setCategoryLabelPositions(CategoryLabelPositions.createDownRotationLabelPositions(d / 180.0 * Math.PI));
            }
        }
        if (sortedSet != null) {
            if (sortedSet.size() == 1) {
                paintArray = new Paint[DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE.length + 1];
                paintArray[0] = ((JRChartPlot.JRSeriesColor)sortedSet.first()).getColor();
                for (int i = 0; i < DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE.length; ++i) {
                    paintArray[i + 1] = DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE[i];
                }
                plot.setDrawingSupplier(new DefaultDrawingSupplier(paintArray, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
            } else if (sortedSet.size() > 1) {
                paintArray = new Color[sortedSet.size()];
                JRChartPlot.JRSeriesColor[] jRSeriesColorArray = new JRChartPlot.JRSeriesColor[sortedSet.size()];
                sortedSet.toArray(jRSeriesColorArray);
                for (int i = 0; i < jRSeriesColorArray.length; ++i) {
                    paintArray[i] = jRSeriesColorArray[i].getColor();
                }
                plot.setDrawingSupplier(new DefaultDrawingSupplier(paintArray, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
            }
        }
    }

    private void configureAxisSeriesColors(CategoryItemRenderer categoryItemRenderer, JRChartPlot jRChartPlot) {
        SortedSet sortedSet = jRChartPlot.getSeriesColors();
        if (sortedSet != null) {
            for (JRChartPlot.JRSeriesColor jRSeriesColor : sortedSet) {
                categoryItemRenderer.setSeriesPaint(jRSeriesColor.getSeriesOrder(), jRSeriesColor.getColor());
            }
        }
    }

    private void configureAxisSeriesColors(XYItemRenderer xYItemRenderer, JRChartPlot jRChartPlot) {
        SortedSet sortedSet = jRChartPlot.getSeriesColors();
        if (sortedSet != null) {
            for (JRChartPlot.JRSeriesColor jRSeriesColor : sortedSet) {
                xYItemRenderer.setSeriesPaint(jRSeriesColor.getSeriesOrder(), jRSeriesColor.getColor());
            }
        }
    }

    private void configureAxis(Axis axis, JRFont jRFont, Color color, JRFont jRFont2, Color color2, String string, Color color3) {
        Object object;
        if (jRFont != null) {
            object = JRFontUtil.getNonPdfAttributes(jRFont);
            axis.setLabelFont(new Font((Map<? extends AttributedCharacterIterator.Attribute, ?>)object));
        }
        if (jRFont2 != null) {
            object = JRFontUtil.getNonPdfAttributes(jRFont2);
            axis.setTickLabelFont(new Font((Map<? extends AttributedCharacterIterator.Attribute, ?>)object));
        }
        if (color != null) {
            axis.setLabelPaint(color);
        }
        if (color2 != null) {
            axis.setTickLabelPaint(color2);
        }
        if (color3 != null) {
            axis.setAxisLinePaint(color3);
            axis.setTickMarkPaint(color3);
        }
        if (string != null) {
            if (axis instanceof NumberAxis) {
                object = NumberFormat.getInstance();
                if (object instanceof DecimalFormat) {
                    ((DecimalFormat)object).applyPattern(string);
                }
                ((NumberAxis)axis).setNumberFormatOverride((NumberFormat)object);
            } else if (axis instanceof DateAxis) {
                object = null;
                object = string.equals("SHORT") || string.equals("DateFormat.SHORT") ? DateFormat.getDateInstance(3) : (string.equals("MEDIUM") || string.equals("DateFormat.MEDIUM") ? DateFormat.getDateInstance(2) : (string.equals("LONG") || string.equals("DateFormat.LONG") ? DateFormat.getDateInstance(1) : (string.equals("FULL") || string.equals("DateFormat.FULL") ? DateFormat.getDateInstance(0) : new SimpleDateFormat(string))));
                ((DateAxis)axis).setDateFormatOverride((DateFormat)object);
            }
        }
    }

    protected JFreeChartRenderer evaluateAreaImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createAreaChart((String)this.evaluateExpression(this.getTitleExpression(), by), (String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression(), by), (String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression(), by), (CategoryDataset)this.dataset.getDataset(), this.getPlot().getOrientation(), this.isShowLegend(), true, false);
        this.configureChart(jFreeChart, this.getPlot(), by);
        JRFillAreaPlot jRFillAreaPlot = (JRFillAreaPlot)this.getPlot();
        this.configureAxis(((CategoryPlot)jFreeChart.getPlot()).getDomainAxis(), jRFillAreaPlot.getCategoryAxisLabelFont(), jRFillAreaPlot.getCategoryAxisLabelColor(), jRFillAreaPlot.getCategoryAxisTickLabelFont(), jRFillAreaPlot.getCategoryAxisTickLabelColor(), jRFillAreaPlot.getCategoryAxisTickLabelMask(), jRFillAreaPlot.getCategoryAxisLineColor());
        this.configureAxis(((CategoryPlot)jFreeChart.getPlot()).getRangeAxis(), jRFillAreaPlot.getValueAxisLabelFont(), jRFillAreaPlot.getValueAxisLabelColor(), jRFillAreaPlot.getValueAxisTickLabelFont(), jRFillAreaPlot.getValueAxisTickLabelColor(), jRFillAreaPlot.getCategoryAxisTickLabelMask(), jRFillAreaPlot.getValueAxisLineColor());
        return this.getCategoryRenderer(jFreeChart);
    }

    protected JFreeChartRenderer evaluateBar3DImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createBarChart3D((String)this.evaluateExpression(this.getTitleExpression(), by), (String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getCategoryAxisLabelExpression(), by), (String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getValueAxisLabelExpression(), by), (CategoryDataset)this.dataset.getDataset(), this.getPlot().getOrientation(), this.isShowLegend(), true, false);
        this.configureChart(jFreeChart, this.getPlot(), by);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        JRFillBar3DPlot jRFillBar3DPlot = (JRFillBar3DPlot)this.getPlot();
        BarRenderer3D barRenderer3D = new BarRenderer3D(jRFillBar3DPlot.getXOffset(), jRFillBar3DPlot.getYOffset());
        categoryPlot.setRenderer(barRenderer3D);
        barRenderer3D.setBaseItemLabelGenerator(((JRFillCategoryDataset)this.getDataset()).getLabelGenerator());
        barRenderer3D.setItemLabelsVisible(jRFillBar3DPlot.isShowLabels());
        this.configureAxis(categoryPlot.getDomainAxis(), jRFillBar3DPlot.getCategoryAxisLabelFont(), jRFillBar3DPlot.getCategoryAxisLabelColor(), jRFillBar3DPlot.getCategoryAxisTickLabelFont(), jRFillBar3DPlot.getCategoryAxisTickLabelColor(), jRFillBar3DPlot.getCategoryAxisTickLabelMask(), jRFillBar3DPlot.getCategoryAxisLineColor());
        this.configureAxis(categoryPlot.getRangeAxis(), jRFillBar3DPlot.getValueAxisLabelFont(), jRFillBar3DPlot.getValueAxisLabelColor(), jRFillBar3DPlot.getValueAxisTickLabelFont(), jRFillBar3DPlot.getValueAxisTickLabelColor(), jRFillBar3DPlot.getValueAxisTickLabelMask(), jRFillBar3DPlot.getValueAxisLineColor());
        return this.getCategoryRenderer(jFreeChart);
    }

    protected JFreeChartRenderer evaluateBarImage(byte by) throws JRException {
        CategoryDataset categoryDataset = (CategoryDataset)this.dataset.getDataset();
        JFreeChart jFreeChart = ChartFactory.createBarChart((String)this.evaluateExpression(this.getTitleExpression(), by), (String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression(), by), (String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression(), by), categoryDataset, this.getPlot().getOrientation(), this.isShowLegend(), true, false);
        this.configureChart(jFreeChart, this.getPlot(), by);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        JRFillBarPlot jRFillBarPlot = (JRFillBarPlot)this.getPlot();
        categoryPlot.getDomainAxis().setTickMarksVisible(jRFillBarPlot.isShowTickMarks());
        categoryPlot.getDomainAxis().setTickLabelsVisible(jRFillBarPlot.isShowTickLabels());
        this.configureAxis(categoryPlot.getDomainAxis(), jRFillBarPlot.getCategoryAxisLabelFont(), jRFillBarPlot.getCategoryAxisLabelColor(), jRFillBarPlot.getCategoryAxisTickLabelFont(), jRFillBarPlot.getCategoryAxisTickLabelColor(), jRFillBarPlot.getCategoryAxisTickLabelMask(), jRFillBarPlot.getCategoryAxisLineColor());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(jRFillBarPlot.isShowTickMarks());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(jRFillBarPlot.isShowTickLabels());
        this.configureAxis(categoryPlot.getRangeAxis(), jRFillBarPlot.getValueAxisLabelFont(), jRFillBarPlot.getValueAxisLabelColor(), jRFillBarPlot.getValueAxisTickLabelFont(), jRFillBarPlot.getValueAxisTickLabelColor(), jRFillBarPlot.getValueAxisTickLabelMask(), jRFillBarPlot.getValueAxisLineColor());
        CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
        categoryItemRenderer.setBaseItemLabelGenerator(((JRFillCategoryDataset)this.getDataset()).getLabelGenerator());
        categoryItemRenderer.setItemLabelsVisible(jRFillBarPlot.isShowLabels());
        return this.getCategoryRenderer(jFreeChart);
    }

    protected JFreeChartRenderer evaluateBubbleImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createBubbleChart((String)this.evaluateExpression(this.getTitleExpression(), by), (String)this.evaluateExpression(((JRBubblePlot)this.getPlot()).getXAxisLabelExpression(), by), (String)this.evaluateExpression(((JRBubblePlot)this.getPlot()).getYAxisLabelExpression(), by), (XYZDataset)this.dataset.getDataset(), this.getPlot().getOrientation(), this.isShowLegend(), true, false);
        this.configureChart(jFreeChart, this.getPlot(), by);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        JRBubblePlot jRBubblePlot = (JRBubblePlot)this.getPlot();
        XYBubbleRenderer xYBubbleRenderer = new XYBubbleRenderer(jRBubblePlot.getScaleType());
        xYPlot.setRenderer(xYBubbleRenderer);
        this.configureAxis(xYPlot.getDomainAxis(), jRBubblePlot.getXAxisLabelFont(), jRBubblePlot.getXAxisLabelColor(), jRBubblePlot.getXAxisTickLabelFont(), jRBubblePlot.getXAxisTickLabelColor(), jRBubblePlot.getXAxisTickLabelMask(), jRBubblePlot.getXAxisLineColor());
        this.configureAxis(xYPlot.getRangeAxis(), jRBubblePlot.getYAxisLabelFont(), jRBubblePlot.getYAxisLabelColor(), jRBubblePlot.getYAxisTickLabelFont(), jRBubblePlot.getYAxisTickLabelColor(), jRBubblePlot.getYAxisTickLabelMask(), jRBubblePlot.getYAxisLineColor());
        return this.getXYZRenderer(jFreeChart);
    }

    protected JFreeChartRenderer evaluateCandlestickImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createCandlestickChart((String)this.evaluateExpression(this.getTitleExpression(), by), (String)this.evaluateExpression(((JRCandlestickPlot)this.getPlot()).getTimeAxisLabelExpression(), by), (String)this.evaluateExpression(((JRCandlestickPlot)this.getPlot()).getValueAxisLabelExpression(), by), (DefaultHighLowDataset)this.dataset.getDataset(), this.isShowLegend());
        this.configureChart(jFreeChart, this.getPlot(), by);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        JRCandlestickPlot jRCandlestickPlot = (JRCandlestickPlot)this.getPlot();
        CandlestickRenderer candlestickRenderer = (CandlestickRenderer)xYPlot.getRenderer();
        candlestickRenderer.setDrawVolume(jRCandlestickPlot.isShowVolume());
        this.configureAxis(xYPlot.getDomainAxis(), jRCandlestickPlot.getTimeAxisLabelFont(), jRCandlestickPlot.getTimeAxisLabelColor(), jRCandlestickPlot.getTimeAxisTickLabelFont(), jRCandlestickPlot.getTimeAxisTickLabelColor(), jRCandlestickPlot.getTimeAxisTickLabelMask(), jRCandlestickPlot.getTimeAxisLineColor());
        this.configureAxis(xYPlot.getRangeAxis(), jRCandlestickPlot.getValueAxisLabelFont(), jRCandlestickPlot.getValueAxisLabelColor(), jRCandlestickPlot.getValueAxisTickLabelFont(), jRCandlestickPlot.getValueAxisTickLabelColor(), jRCandlestickPlot.getValueAxisTickLabelMask(), jRCandlestickPlot.getValueAxisLineColor());
        return this.getHighLowRenderer(jFreeChart);
    }

    protected JFreeChartRenderer evaluateHighLowImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createHighLowChart((String)this.evaluateExpression(this.getTitleExpression(), by), (String)this.evaluateExpression(((JRHighLowPlot)this.getPlot()).getTimeAxisLabelExpression(), by), (String)this.evaluateExpression(((JRHighLowPlot)this.getPlot()).getValueAxisLabelExpression(), by), (DefaultHighLowDataset)this.dataset.getDataset(), this.isShowLegend());
        this.configureChart(jFreeChart, this.getPlot(), by);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        JRHighLowPlot jRHighLowPlot = (JRHighLowPlot)this.getPlot();
        HighLowRenderer highLowRenderer = (HighLowRenderer)xYPlot.getRenderer();
        highLowRenderer.setDrawOpenTicks(jRHighLowPlot.isShowOpenTicks());
        highLowRenderer.setDrawCloseTicks(jRHighLowPlot.isShowCloseTicks());
        this.configureAxis(xYPlot.getDomainAxis(), jRHighLowPlot.getTimeAxisLabelFont(), jRHighLowPlot.getTimeAxisLabelColor(), jRHighLowPlot.getTimeAxisTickLabelFont(), jRHighLowPlot.getTimeAxisTickLabelColor(), jRHighLowPlot.getTimeAxisTickLabelMask(), jRHighLowPlot.getTimeAxisLineColor());
        this.configureAxis(xYPlot.getRangeAxis(), jRHighLowPlot.getValueAxisLabelFont(), jRHighLowPlot.getValueAxisLabelColor(), jRHighLowPlot.getValueAxisTickLabelFont(), jRHighLowPlot.getValueAxisTickLabelColor(), jRHighLowPlot.getValueAxisTickLabelMask(), jRHighLowPlot.getValueAxisLineColor());
        return this.getHighLowRenderer(jFreeChart);
    }

    protected JFreeChartRenderer evaluateLineImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createLineChart((String)this.evaluateExpression(this.getTitleExpression(), by), (String)this.evaluateExpression(((JRLinePlot)this.getPlot()).getCategoryAxisLabelExpression(), by), (String)this.evaluateExpression(((JRLinePlot)this.getPlot()).getValueAxisLabelExpression(), by), (CategoryDataset)this.dataset.getDataset(), this.getPlot().getOrientation(), this.isShowLegend(), true, false);
        this.configureChart(jFreeChart, this.getPlot(), by);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        JRFillLinePlot jRFillLinePlot = (JRFillLinePlot)this.getPlot();
        LineAndShapeRenderer lineAndShapeRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
        lineAndShapeRenderer.setShapesVisible(jRFillLinePlot.isShowShapes());
        lineAndShapeRenderer.setLinesVisible(jRFillLinePlot.isShowLines());
        this.configureAxis(categoryPlot.getDomainAxis(), jRFillLinePlot.getCategoryAxisLabelFont(), jRFillLinePlot.getCategoryAxisLabelColor(), jRFillLinePlot.getCategoryAxisTickLabelFont(), jRFillLinePlot.getCategoryAxisTickLabelColor(), jRFillLinePlot.getCategoryAxisTickLabelMask(), jRFillLinePlot.getCategoryAxisLineColor());
        this.configureAxis(categoryPlot.getRangeAxis(), jRFillLinePlot.getValueAxisLabelFont(), jRFillLinePlot.getValueAxisLabelColor(), jRFillLinePlot.getValueAxisTickLabelFont(), jRFillLinePlot.getValueAxisTickLabelColor(), jRFillLinePlot.getValueAxisTickLabelMask(), jRFillLinePlot.getValueAxisLineColor());
        return this.getCategoryRenderer(jFreeChart);
    }

    protected JFreeChartRenderer evaluatePie3DImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createPieChart3D((String)this.evaluateExpression(this.getTitleExpression(), by), (PieDataset)this.dataset.getDataset(), this.isShowLegend(), true, false);
        this.configureChart(jFreeChart, this.getPlot(), by);
        PiePlot3D piePlot3D = (PiePlot3D)jFreeChart.getPlot();
        piePlot3D.setDepthFactor(((JRFillPie3DPlot)this.getPlot()).getDepthFactor());
        PieLabelGenerator pieLabelGenerator = ((JRFillPieDataset)this.getDataset()).getLabelGenerator();
        if (pieLabelGenerator != null) {
            piePlot3D.setLabelGenerator(pieLabelGenerator);
        }
        return this.getPieRenderer(jFreeChart);
    }

    protected JFreeChartRenderer evaluatePieImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createPieChart((String)this.evaluateExpression(this.getTitleExpression(), by), (PieDataset)this.dataset.getDataset(), this.isShowLegend(), true, false);
        this.configureChart(jFreeChart, this.getPlot(), by);
        PiePlot piePlot = (PiePlot)jFreeChart.getPlot();
        PieLabelGenerator pieLabelGenerator = ((JRFillPieDataset)this.getDataset()).getLabelGenerator();
        if (pieLabelGenerator != null) {
            piePlot.setLabelGenerator(pieLabelGenerator);
        }
        return this.getPieRenderer(jFreeChart);
    }

    protected JFreeChartRenderer evaluateScatterImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot((String)this.evaluateExpression(this.getTitleExpression(), by), (String)this.evaluateExpression(((JRScatterPlot)this.getPlot()).getXAxisLabelExpression(), by), (String)this.evaluateExpression(((JRScatterPlot)this.getPlot()).getYAxisLabelExpression(), by), (XYDataset)this.dataset.getDataset(), this.getPlot().getOrientation(), this.isShowLegend(), true, false);
        this.configureChart(jFreeChart, this.getPlot(), by);
        XYLineAndShapeRenderer xYLineAndShapeRenderer = (XYLineAndShapeRenderer)((XYPlot)jFreeChart.getPlot()).getRenderer();
        JRScatterPlot jRScatterPlot = (JRScatterPlot)this.getPlot();
        xYLineAndShapeRenderer.setLinesVisible(jRScatterPlot.isShowLines());
        xYLineAndShapeRenderer.setShapesVisible(jRScatterPlot.isShowShapes());
        this.configureAxis(jFreeChart.getXYPlot().getDomainAxis(), jRScatterPlot.getXAxisLabelFont(), jRScatterPlot.getXAxisLabelColor(), jRScatterPlot.getXAxisTickLabelFont(), jRScatterPlot.getXAxisTickLabelColor(), jRScatterPlot.getXAxisTickLabelMask(), jRScatterPlot.getXAxisLineColor());
        this.configureAxis(jFreeChart.getXYPlot().getRangeAxis(), jRScatterPlot.getYAxisLabelFont(), jRScatterPlot.getYAxisLabelColor(), jRScatterPlot.getYAxisTickLabelFont(), jRScatterPlot.getYAxisTickLabelColor(), jRScatterPlot.getYAxisTickLabelMask(), jRScatterPlot.getYAxisLineColor());
        return this.getXYRenderer(jFreeChart);
    }

    protected JFreeChartRenderer evaluateStackedBar3DImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart3D((String)this.evaluateExpression(this.getTitleExpression(), by), (String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getCategoryAxisLabelExpression(), by), (String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getValueAxisLabelExpression(), by), (CategoryDataset)this.dataset.getDataset(), this.getPlot().getOrientation(), this.isShowLegend(), true, false);
        this.configureChart(jFreeChart, this.getPlot(), by);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        JRFillBar3DPlot jRFillBar3DPlot = (JRFillBar3DPlot)this.getPlot();
        StackedBarRenderer3D stackedBarRenderer3D = new StackedBarRenderer3D(jRFillBar3DPlot.getXOffset(), jRFillBar3DPlot.getYOffset());
        categoryPlot.setRenderer(stackedBarRenderer3D);
        stackedBarRenderer3D.setBaseItemLabelGenerator(((JRFillCategoryDataset)this.getDataset()).getLabelGenerator());
        stackedBarRenderer3D.setItemLabelsVisible(jRFillBar3DPlot.isShowLabels());
        this.configureAxis(categoryPlot.getDomainAxis(), jRFillBar3DPlot.getCategoryAxisLabelFont(), jRFillBar3DPlot.getCategoryAxisLabelColor(), jRFillBar3DPlot.getCategoryAxisTickLabelFont(), jRFillBar3DPlot.getCategoryAxisTickLabelColor(), jRFillBar3DPlot.getCategoryAxisTickLabelMask(), jRFillBar3DPlot.getCategoryAxisLineColor());
        this.configureAxis(categoryPlot.getRangeAxis(), jRFillBar3DPlot.getValueAxisLabelFont(), jRFillBar3DPlot.getValueAxisLabelColor(), jRFillBar3DPlot.getValueAxisTickLabelFont(), jRFillBar3DPlot.getValueAxisTickLabelColor(), jRFillBar3DPlot.getValueAxisTickLabelMask(), jRFillBar3DPlot.getValueAxisLineColor());
        return this.getCategoryRenderer(jFreeChart);
    }

    protected JFreeChartRenderer evaluateStackedBarImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart((String)this.evaluateExpression(this.getTitleExpression(), by), (String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression(), by), (String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression(), by), (CategoryDataset)this.dataset.getDataset(), this.getPlot().getOrientation(), this.isShowLegend(), true, false);
        this.configureChart(jFreeChart, this.getPlot(), by);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        JRFillBarPlot jRFillBarPlot = (JRFillBarPlot)this.getPlot();
        categoryPlot.getDomainAxis().setTickMarksVisible(jRFillBarPlot.isShowTickMarks());
        categoryPlot.getDomainAxis().setTickLabelsVisible(jRFillBarPlot.isShowTickLabels());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(jRFillBarPlot.isShowTickMarks());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(jRFillBarPlot.isShowTickLabels());
        CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
        categoryItemRenderer.setBaseItemLabelGenerator(((JRFillCategoryDataset)this.getDataset()).getLabelGenerator());
        categoryItemRenderer.setItemLabelsVisible(((JRFillBarPlot)this.getPlot()).isShowLabels());
        this.configureAxis(categoryPlot.getDomainAxis(), jRFillBarPlot.getCategoryAxisLabelFont(), jRFillBarPlot.getCategoryAxisLabelColor(), jRFillBarPlot.getCategoryAxisTickLabelFont(), jRFillBarPlot.getCategoryAxisTickLabelColor(), jRFillBarPlot.getCategoryAxisTickLabelMask(), jRFillBarPlot.getCategoryAxisLineColor());
        this.configureAxis(categoryPlot.getRangeAxis(), jRFillBarPlot.getValueAxisLabelFont(), jRFillBarPlot.getValueAxisLabelColor(), jRFillBarPlot.getValueAxisTickLabelFont(), jRFillBarPlot.getValueAxisTickLabelColor(), jRFillBarPlot.getValueAxisTickLabelMask(), jRFillBarPlot.getValueAxisLineColor());
        return this.getCategoryRenderer(jFreeChart);
    }

    protected JFreeChartRenderer evaluateXyAreaImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createXYAreaChart((String)this.evaluateExpression(this.getTitleExpression(), by), (String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression(), by), (String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression(), by), (XYDataset)this.dataset.getDataset(), this.getPlot().getOrientation(), this.isShowLegend(), true, false);
        this.configureChart(jFreeChart, this.getPlot(), by);
        JRAreaPlot jRAreaPlot = (JRAreaPlot)this.getPlot();
        this.configureAxis(jFreeChart.getXYPlot().getDomainAxis(), jRAreaPlot.getCategoryAxisLabelFont(), jRAreaPlot.getCategoryAxisLabelColor(), jRAreaPlot.getCategoryAxisTickLabelFont(), jRAreaPlot.getCategoryAxisTickLabelColor(), jRAreaPlot.getCategoryAxisTickLabelMask(), jRAreaPlot.getCategoryAxisLineColor());
        this.configureAxis(jFreeChart.getXYPlot().getRangeAxis(), jRAreaPlot.getValueAxisLabelFont(), jRAreaPlot.getValueAxisLabelColor(), jRAreaPlot.getValueAxisTickLabelFont(), jRAreaPlot.getValueAxisTickLabelColor(), jRAreaPlot.getValueAxisTickLabelMask(), jRAreaPlot.getValueAxisLineColor());
        return this.getXYRenderer(jFreeChart);
    }

    protected JFreeChartRenderer evaluateXYBarImage(byte by) throws JRException {
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)this.dataset.getDataset();
        boolean bl = true;
        if (this.dataset.getDatasetType() == 3) {
            bl = false;
        }
        JFreeChart jFreeChart = ChartFactory.createXYBarChart((String)this.evaluateExpression(this.getTitleExpression(), by), (String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression(), by), bl, (String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression(), by), intervalXYDataset, this.getPlot().getOrientation(), this.isShowLegend(), true, false);
        this.configureChart(jFreeChart, this.getPlot(), by);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        XYItemRenderer xYItemRenderer = xYPlot.getRenderer();
        if (this.getDataset().getDatasetType() == 6) {
            xYItemRenderer.setBaseItemLabelGenerator(((JRFillTimeSeriesDataset)this.getDataset()).getLabelGenerator());
        } else if (this.getDataset().getDatasetType() == 5) {
            xYItemRenderer.setBaseItemLabelGenerator(((JRFillTimePeriodDataset)this.getDataset()).getLabelGenerator());
        } else if (this.getDataset().getDatasetType() == 3) {
            xYItemRenderer.setBaseItemLabelGenerator(((JRFillXyDataset)this.getDataset()).getLabelGenerator());
        }
        JRFillBarPlot jRFillBarPlot = (JRFillBarPlot)this.getPlot();
        xYItemRenderer.setBaseItemLabelsVisible(jRFillBarPlot.isShowLabels());
        this.configureAxis(xYPlot.getDomainAxis(), jRFillBarPlot.getCategoryAxisLabelFont(), jRFillBarPlot.getCategoryAxisLabelColor(), jRFillBarPlot.getCategoryAxisTickLabelFont(), jRFillBarPlot.getCategoryAxisTickLabelColor(), jRFillBarPlot.getCategoryAxisTickLabelMask(), jRFillBarPlot.getCategoryAxisLineColor());
        this.configureAxis(xYPlot.getRangeAxis(), jRFillBarPlot.getValueAxisLabelFont(), jRFillBarPlot.getValueAxisLabelColor(), jRFillBarPlot.getValueAxisTickLabelFont(), jRFillBarPlot.getValueAxisTickLabelColor(), jRFillBarPlot.getValueAxisTickLabelMask(), jRFillBarPlot.getValueAxisLineColor());
        return this.getXYBarRenderer(jFreeChart);
    }

    protected JFreeChartRenderer evaluateXyLineImage(byte by) throws JRException {
        JRLinePlot jRLinePlot = (JRLinePlot)this.getPlot();
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)this.evaluateExpression(this.getTitleExpression(), by), (String)this.evaluateExpression(jRLinePlot.getCategoryAxisLabelExpression(), by), (String)this.evaluateExpression(jRLinePlot.getValueAxisLabelExpression(), by), (XYDataset)this.dataset.getDataset(), jRLinePlot.getOrientation(), this.isShowLegend(), true, false);
        this.configureChart(jFreeChart, this.getPlot(), by);
        this.configureAxis(jFreeChart.getXYPlot().getDomainAxis(), jRLinePlot.getCategoryAxisLabelFont(), jRLinePlot.getCategoryAxisLabelColor(), jRLinePlot.getCategoryAxisTickLabelFont(), jRLinePlot.getCategoryAxisTickLabelColor(), jRLinePlot.getCategoryAxisTickLabelMask(), jRLinePlot.getCategoryAxisLineColor());
        this.configureAxis(jFreeChart.getXYPlot().getRangeAxis(), jRLinePlot.getValueAxisLabelFont(), jRLinePlot.getValueAxisLabelColor(), jRLinePlot.getValueAxisTickLabelFont(), jRLinePlot.getValueAxisTickLabelColor(), jRLinePlot.getValueAxisTickLabelMask(), jRLinePlot.getValueAxisLineColor());
        XYLineAndShapeRenderer xYLineAndShapeRenderer = (XYLineAndShapeRenderer)jFreeChart.getXYPlot().getRenderer();
        xYLineAndShapeRenderer.setShapesVisible(jRLinePlot.isShowShapes());
        xYLineAndShapeRenderer.setLinesVisible(jRLinePlot.isShowLines());
        return this.getXYRenderer(jFreeChart);
    }

    protected JFreeChartRenderer evaluateTimeSeriesImage(byte by) throws JRException {
        String string = (String)this.evaluateExpression(((JRTimeSeriesPlot)this.getPlot()).getTimeAxisLabelExpression(), by);
        String string2 = (String)this.evaluateExpression(((JRTimeSeriesPlot)this.getPlot()).getValueAxisLabelExpression(), by);
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart((String)this.evaluateExpression(this.getTitleExpression(), by), string, string2, (TimeSeriesCollection)this.dataset.getDataset(), this.isShowLegend(), true, false);
        this.configureChart(jFreeChart, this.getPlot(), by);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        JRTimeSeriesPlot jRTimeSeriesPlot = (JRTimeSeriesPlot)this.getPlot();
        XYLineAndShapeRenderer xYLineAndShapeRenderer = (XYLineAndShapeRenderer)xYPlot.getRenderer();
        xYLineAndShapeRenderer.setLinesVisible(((JRTimeSeriesPlot)this.getPlot()).isShowLines());
        xYLineAndShapeRenderer.setShapesVisible(((JRTimeSeriesPlot)this.getPlot()).isShowShapes());
        this.configureAxis(xYPlot.getDomainAxis(), jRTimeSeriesPlot.getTimeAxisLabelFont(), jRTimeSeriesPlot.getTimeAxisLabelColor(), jRTimeSeriesPlot.getTimeAxisTickLabelFont(), jRTimeSeriesPlot.getTimeAxisTickLabelColor(), jRTimeSeriesPlot.getTimeAxisTickLabelMask(), jRTimeSeriesPlot.getTimeAxisLineColor());
        this.configureAxis(xYPlot.getRangeAxis(), jRTimeSeriesPlot.getValueAxisLabelFont(), jRTimeSeriesPlot.getValueAxisLabelColor(), jRTimeSeriesPlot.getValueAxisTickLabelFont(), jRTimeSeriesPlot.getValueAxisTickLabelColor(), jRTimeSeriesPlot.getValueAxisTickLabelMask(), jRTimeSeriesPlot.getValueAxisLineColor());
        return this.getTimeSeriesRenderer(jFreeChart);
    }

    protected Range convertRange(JRDataRange jRDataRange, byte by) throws JRException {
        if (jRDataRange == null) {
            return null;
        }
        Number number = (Number)this.evaluateExpression(jRDataRange.getLowExpression(), by);
        Number number2 = (Number)this.evaluateExpression(jRDataRange.getHighExpression(), by);
        return new Range(number != null ? number.doubleValue() : 0.0, number2 != null ? number2.doubleValue() : 100.0);
    }

    protected MeterInterval convertInterval(JRMeterInterval jRMeterInterval, byte by) throws JRException {
        String string = jRMeterInterval.getLabel();
        if (string == null) {
            string = "";
        }
        Range range = this.convertRange(jRMeterInterval.getDataRange(), by);
        Color color = jRMeterInterval.getBackgroundColor();
        float[] fArray = color.getRGBColorComponents(null);
        Color color2 = new Color(fArray[0], fArray[1], fArray[2], (float)jRMeterInterval.getAlpha());
        return new MeterInterval(string, range, color2, null, color2);
    }

    protected JFreeChartRenderer evaluateMeterImage(byte by) throws JRException {
        Object object;
        Object object2;
        JRValueDisplay jRValueDisplay;
        JRFillMeterPlot jRFillMeterPlot = (JRFillMeterPlot)this.getPlot();
        MeterPlot meterPlot = new MeterPlot((ValueDataset)this.dataset.getDataset());
        byte by2 = jRFillMeterPlot.getShape();
        if (by2 == 0) {
            meterPlot.setDialShape(DialShape.CHORD);
        } else if (by2 == 1) {
            meterPlot.setDialShape(DialShape.CIRCLE);
        } else {
            meterPlot.setDialShape(DialShape.PIE);
        }
        meterPlot.setRange(this.convertRange(jRFillMeterPlot.getDataRange(), by));
        meterPlot.setMeterAngle(jRFillMeterPlot.getMeterAngle());
        String string = jRFillMeterPlot.getUnits();
        if (string != null && string.length() > 0) {
            meterPlot.setUnits(string);
        }
        meterPlot.setTickSize(jRFillMeterPlot.getTickInterval());
        Color color = jRFillMeterPlot.getMeterBackgroundColor();
        if (color != null) {
            meterPlot.setDialBackgroundPaint(color);
        }
        if ((color = jRFillMeterPlot.getNeedleColor()) != null) {
            meterPlot.setNeedlePaint(color);
        }
        if ((jRValueDisplay = jRFillMeterPlot.getValueDisplay()) != null) {
            if (jRValueDisplay.getColor() != null) {
                meterPlot.setValuePaint(jRValueDisplay.getColor());
            }
            if (jRValueDisplay.getMask() != null) {
                // empty if block
            }
            if (jRValueDisplay.getFont() != null) {
                object2 = JRFontUtil.getNonPdfAttributes(jRValueDisplay.getFont());
                meterPlot.setValueFont(new Font((Map<? extends AttributedCharacterIterator.Attribute, ?>)object2));
            }
        }
        if ((color = jRFillMeterPlot.getTickColor()) != null) {
            meterPlot.setTickPaint(color);
        }
        if ((object2 = jRFillMeterPlot.getIntervals()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                JRMeterInterval jRMeterInterval = (JRMeterInterval)object.next();
                meterPlot.addInterval(this.convertInterval(jRMeterInterval, by));
            }
        }
        object = new JFreeChart((String)this.evaluateExpression(this.getTitleExpression(), by), null, meterPlot, this.isShowLegend());
        this.configureChart((JFreeChart)object, this.getPlot(), by);
        return new JFreeChartRenderer((JFreeChart)object);
    }

    protected JFreeChartRenderer evaluateThermometerImage(byte by) throws JRException {
        Object object;
        JRValueDisplay jRValueDisplay;
        JRFillThermometerPlot jRFillThermometerPlot = (JRFillThermometerPlot)this.getPlot();
        ThermometerPlot thermometerPlot = new ThermometerPlot((ValueDataset)this.dataset.getDataset());
        Range range = this.convertRange(jRFillThermometerPlot.getDataRange(), by);
        thermometerPlot.setLowerBound(range.getLowerBound());
        thermometerPlot.setUpperBound(range.getUpperBound());
        thermometerPlot.setShowValueLines(jRFillThermometerPlot.isShowValueLines());
        thermometerPlot.setUnits(0);
        Color color = jRFillThermometerPlot.getMercuryColor();
        if (color != null) {
            thermometerPlot.setMercuryPaint(color);
        }
        if ((jRValueDisplay = jRFillThermometerPlot.getValueDisplay()) != null) {
            if (jRValueDisplay.getColor() != null) {
                thermometerPlot.setValuePaint(jRValueDisplay.getColor());
            }
            if (jRValueDisplay.getMask() != null) {
                thermometerPlot.setValueFormat(new DecimalFormat(jRValueDisplay.getMask()));
            }
            if (jRValueDisplay.getFont() != null) {
                object = JRFontUtil.getNonPdfAttributes(jRValueDisplay.getFont());
                thermometerPlot.setValueFont(new Font((Map<? extends AttributedCharacterIterator.Attribute, ?>)object));
            }
        }
        switch (jRFillThermometerPlot.getValueLocation()) {
            case 0: {
                thermometerPlot.setValueLocation(0);
                break;
            }
            case 1: {
                thermometerPlot.setValueLocation(2);
                break;
            }
            case 2: {
                thermometerPlot.setValueLocation(1);
                break;
            }
            default: {
                thermometerPlot.setValueLocation(3);
            }
        }
        range = this.convertRange(jRFillThermometerPlot.getLowRange(), by);
        if (range != null) {
            thermometerPlot.setSubrangeInfo(2, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jRFillThermometerPlot.getMediumRange(), by)) != null) {
            thermometerPlot.setSubrangeInfo(1, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jRFillThermometerPlot.getHighRange(), by)) != null) {
            thermometerPlot.setSubrangeInfo(0, range.getLowerBound(), range.getUpperBound());
        }
        object = new JFreeChart(thermometerPlot);
        this.configureChart((JFreeChart)object, this.getPlot(), by);
        return new JFreeChartRenderer((JFreeChart)object);
    }

    protected JFreeChartRenderer evaluateMultiAxisImage(byte by) throws JRException {
        Object object;
        JFreeChart jFreeChart = null;
        Plot plot = null;
        JRFillMultiAxisPlot jRFillMultiAxisPlot = (JRFillMultiAxisPlot)this.getPlot();
        Iterator iterator = jRFillMultiAxisPlot.getAxes().iterator();
        if (iterator.hasNext()) {
            JRFillChartAxis jRFillChartAxis = (JRFillChartAxis)iterator.next();
            object = jRFillChartAxis.getFillChart();
            jFreeChart = ((JRFillChart)object).evaluateImage(by).getChart();
            this.configureChart(jFreeChart, this.getPlot(), by);
            plot = jFreeChart.getPlot();
            if (jRFillChartAxis.getPosition() == 2) {
                if (plot instanceof CategoryPlot) {
                    ((CategoryPlot)plot).setRangeAxisLocation(0, AxisLocation.BOTTOM_OR_RIGHT);
                }
                if (plot instanceof XYPlot) {
                    ((XYPlot)plot).setRangeAxisLocation(0, AxisLocation.BOTTOM_OR_RIGHT);
                }
            } else {
                if (plot instanceof CategoryPlot) {
                    ((CategoryPlot)plot).setRangeAxisLocation(0, AxisLocation.TOP_OR_LEFT);
                }
                if (plot instanceof XYPlot) {
                    ((XYPlot)plot).setRangeAxisLocation(0, AxisLocation.TOP_OR_LEFT);
                }
            }
        }
        int n = 0;
        while (iterator.hasNext()) {
            Plot plot2;
            Plot plot3;
            ++n;
            object = (JRFillChartAxis)iterator.next();
            JRFillChart jRFillChart = ((JRFillChartAxis)object).getFillChart();
            JFreeChart jFreeChart2 = jRFillChart.evaluateImage(by).getChart();
            if (plot instanceof CategoryPlot) {
                plot3 = (CategoryPlot)plot;
                if (!(jFreeChart2.getPlot() instanceof CategoryPlot)) {
                    throw new JRException("You can not mix plot types in a MultiAxisChart");
                }
                plot2 = (CategoryPlot)jFreeChart2.getPlot();
                ((CategoryPlot)plot3).setRangeAxis(n, ((CategoryPlot)plot2).getRangeAxis());
                if (((JRFillChartAxis)object).getPosition() == 2) {
                    ((CategoryPlot)plot3).setRangeAxisLocation(n, AxisLocation.BOTTOM_OR_RIGHT);
                } else {
                    ((CategoryPlot)plot3).setRangeAxisLocation(n, AxisLocation.TOP_OR_LEFT);
                }
                ((CategoryPlot)plot3).setDataset(n, ((CategoryPlot)plot2).getDataset());
                ((CategoryPlot)plot3).mapDatasetToRangeAxis(n, n);
                ((CategoryPlot)plot3).setRenderer(n, ((CategoryPlot)plot2).getRenderer());
                this.configureAxisSeriesColors(((CategoryPlot)plot2).getRenderer(), jRFillChart.getPlot());
                continue;
            }
            if (plot instanceof XYPlot) {
                plot3 = (XYPlot)plot;
                if (!(jFreeChart2.getPlot() instanceof XYPlot)) {
                    throw new JRException("You can not mix plot types in a MultiAxisChart");
                }
                plot2 = (XYPlot)jFreeChart2.getPlot();
                ((XYPlot)plot3).setRangeAxis(n, ((XYPlot)plot2).getRangeAxis());
                if (((JRFillChartAxis)object).getPosition() == 2) {
                    ((XYPlot)plot3).setRangeAxisLocation(n, AxisLocation.BOTTOM_OR_RIGHT);
                } else {
                    ((XYPlot)plot3).setRangeAxisLocation(n, AxisLocation.TOP_OR_LEFT);
                }
                ((XYPlot)plot3).setDataset(n, ((XYPlot)plot2).getDataset());
                ((XYPlot)plot3).mapDatasetToRangeAxis(n, n);
                ((XYPlot)plot3).setRenderer(n, ((XYPlot)plot2).getRenderer());
                this.configureAxisSeriesColors(((XYPlot)plot2).getRenderer(), jRFillChart.getPlot());
                continue;
            }
            throw new JRException("MultiAxis charts only support Category and XY plots.");
        }
        return new JFreeChartRenderer(jFreeChart);
    }

    @Override
    protected void resolveElement(JRPrintElement jRPrintElement, byte by) throws JRException {
        this.evaluateImage(by);
        this.copy((JRPrintImage)jRPrintElement);
    }

    @Override
    public int getBookmarkLevel() {
        return ((JRChart)this.parent).getBookmarkLevel();
    }

    @Override
    public String getCustomizerClass() {
        return this.customizerClass;
    }

    @Override
    public byte getBorder() {
        return JRStyleResolver.getBorder(this);
    }

    @Override
    public Byte getOwnBorder() {
        return ((JRBox)((Object)this.parent)).getOwnBorder();
    }

    @Override
    public void setBorder(byte by) {
    }

    @Override
    public void setBorder(Byte by) {
    }

    @Override
    public Color getBorderColor() {
        return JRStyleResolver.getBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnBorderColor();
    }

    @Override
    public void setBorderColor(Color color) {
    }

    @Override
    public int getPadding() {
        return JRStyleResolver.getPadding(this);
    }

    @Override
    public Integer getOwnPadding() {
        return ((JRBox)((Object)this.parent)).getOwnPadding();
    }

    @Override
    public void setPadding(int n) {
    }

    @Override
    public void setPadding(Integer n) {
    }

    @Override
    public byte getTopBorder() {
        return JRStyleResolver.getTopBorder(this);
    }

    @Override
    public Byte getOwnTopBorder() {
        return ((JRBox)((Object)this.parent)).getOwnTopBorder();
    }

    @Override
    public void setTopBorder(byte by) {
    }

    @Override
    public void setTopBorder(Byte by) {
    }

    @Override
    public Color getTopBorderColor() {
        return JRStyleResolver.getTopBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnTopBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnTopBorderColor();
    }

    @Override
    public void setTopBorderColor(Color color) {
    }

    @Override
    public int getTopPadding() {
        return JRStyleResolver.getTopPadding(this);
    }

    @Override
    public Integer getOwnTopPadding() {
        return ((JRBox)((Object)this.parent)).getOwnTopPadding();
    }

    @Override
    public void setTopPadding(int n) {
    }

    @Override
    public void setTopPadding(Integer n) {
    }

    @Override
    public byte getLeftBorder() {
        return JRStyleResolver.getLeftBorder(this);
    }

    @Override
    public Byte getOwnLeftBorder() {
        return ((JRBox)((Object)this.parent)).getOwnLeftBorder();
    }

    @Override
    public void setLeftBorder(byte by) {
    }

    @Override
    public void setLeftBorder(Byte by) {
    }

    @Override
    public Color getLeftBorderColor() {
        return JRStyleResolver.getLeftBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnLeftBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnLeftBorderColor();
    }

    @Override
    public void setLeftBorderColor(Color color) {
    }

    @Override
    public int getLeftPadding() {
        return JRStyleResolver.getLeftPadding(this);
    }

    @Override
    public Integer getOwnLeftPadding() {
        return ((JRBox)((Object)this.parent)).getOwnLeftPadding();
    }

    @Override
    public void setLeftPadding(int n) {
    }

    @Override
    public void setLeftPadding(Integer n) {
    }

    @Override
    public byte getBottomBorder() {
        return JRStyleResolver.getBottomBorder(this);
    }

    @Override
    public Byte getOwnBottomBorder() {
        return ((JRBox)((Object)this.parent)).getOwnBottomBorder();
    }

    @Override
    public void setBottomBorder(byte by) {
    }

    @Override
    public void setBottomBorder(Byte by) {
    }

    @Override
    public Color getBottomBorderColor() {
        return JRStyleResolver.getBottomBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnBottomBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnBottomBorderColor();
    }

    @Override
    public void setBottomBorderColor(Color color) {
    }

    @Override
    public int getBottomPadding() {
        return JRStyleResolver.getBottomPadding(this);
    }

    @Override
    public Integer getOwnBottomPadding() {
        return ((JRBox)((Object)this.parent)).getOwnBottomPadding();
    }

    @Override
    public void setBottomPadding(int n) {
    }

    @Override
    public void setBottomPadding(Integer n) {
    }

    @Override
    public byte getRightBorder() {
        return JRStyleResolver.getRightBorder(this);
    }

    @Override
    public Byte getOwnRightBorder() {
        return ((JRBox)((Object)this.parent)).getOwnRightBorder();
    }

    @Override
    public void setRightBorder(byte by) {
    }

    @Override
    public void setRightBorder(Byte by) {
    }

    @Override
    public Color getRightBorderColor() {
        return JRStyleResolver.getRightBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnRightBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnRightBorderColor();
    }

    @Override
    public void setRightBorderColor(Color color) {
    }

    @Override
    public int getRightPadding() {
        return JRStyleResolver.getRightPadding(this);
    }

    @Override
    public Integer getOwnRightPadding() {
        return ((JRBox)((Object)this.parent)).getOwnRightPadding();
    }

    @Override
    public void setRightPadding(int n) {
    }

    @Override
    public void setRightPadding(Integer n) {
    }

    private void evaluateDatasetRun(byte by) throws JRException {
        this.dataset.evaluateDatasetRun(by);
    }

    @Override
    public JRCloneable createClone(JRFillCloneFactory jRFillCloneFactory) {
        return null;
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return ((JRChart)this.parent).getHyperlinkParameters();
    }

    @Override
    public String getLinkType() {
        return ((JRChart)this.parent).getLinkType();
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return ((JRChart)this.parent).getHyperlinkTooltipExpression();
    }

    protected JFreeChartRenderer getCategoryRenderer(JFreeChart jFreeChart) {
        JRFillCategoryDataset jRFillCategoryDataset = (JRFillCategoryDataset)this.getDataset();
        JFreeChartRenderer jFreeChartRenderer = jRFillCategoryDataset.hasItemHyperlinks() ? new JRCategoryChartImageMapRenderer(jFreeChart, jRFillCategoryDataset.getItemHyperlinks()) : new JFreeChartRenderer(jFreeChart);
        return jFreeChartRenderer;
    }

    protected JFreeChartRenderer getPieRenderer(JFreeChart jFreeChart) {
        JRFillPieDataset jRFillPieDataset = (JRFillPieDataset)this.getDataset();
        JFreeChartRenderer jFreeChartRenderer = jRFillPieDataset.hasSectionHyperlinks() ? new JRPieChartImageMapRenderer(jFreeChart, jRFillPieDataset.getSectionHyperlinks()) : new JFreeChartRenderer(jFreeChart);
        return jFreeChartRenderer;
    }

    protected JFreeChartRenderer getXYRenderer(JFreeChart jFreeChart) {
        JRFillXyDataset jRFillXyDataset = (JRFillXyDataset)this.getDataset();
        JFreeChartRenderer jFreeChartRenderer = jRFillXyDataset.hasItemHyperlinks() ? new JRXYChartImageMapRenderer(jFreeChart, jRFillXyDataset.getItemHyperlinks()) : new JFreeChartRenderer(jFreeChart);
        return jFreeChartRenderer;
    }

    protected JFreeChartRenderer getXYBarRenderer(JFreeChart jFreeChart) {
        JFreeChartRenderer jFreeChartRenderer = this.getDataset().getDatasetType() == 6 ? this.getTimeSeriesRenderer(jFreeChart) : (this.getDataset().getDatasetType() == 5 ? this.getTimePeriodRenderer(jFreeChart) : (this.getDataset().getDatasetType() == 3 ? this.getXYRenderer(jFreeChart) : new JFreeChartRenderer(jFreeChart)));
        return jFreeChartRenderer;
    }

    protected JFreeChartRenderer getXYZRenderer(JFreeChart jFreeChart) {
        JRFillXyzDataset jRFillXyzDataset = (JRFillXyzDataset)this.getDataset();
        JFreeChartRenderer jFreeChartRenderer = jRFillXyzDataset.hasItemHyperlinks() ? new JRXYChartImageMapRenderer(jFreeChart, jRFillXyzDataset.getItemHyperlinks()) : new JFreeChartRenderer(jFreeChart);
        return jFreeChartRenderer;
    }

    protected JFreeChartRenderer getHighLowRenderer(JFreeChart jFreeChart) {
        JRFillHighLowDataset jRFillHighLowDataset = (JRFillHighLowDataset)this.getDataset();
        JFreeChartRenderer jFreeChartRenderer = jRFillHighLowDataset.hasItemHyperlink() ? new JRHighLowChartImageMapRenderer(jFreeChart, jRFillHighLowDataset.getItemHyperlinks()) : new JFreeChartRenderer(jFreeChart);
        return jFreeChartRenderer;
    }

    protected JFreeChartRenderer getTimeSeriesRenderer(JFreeChart jFreeChart) {
        JRFillTimeSeriesDataset jRFillTimeSeriesDataset = (JRFillTimeSeriesDataset)this.getDataset();
        JFreeChartRenderer jFreeChartRenderer = jRFillTimeSeriesDataset.hasItemHyperlinks() ? new JRTimeSeriesChartImageMapRenderer(jFreeChart, jRFillTimeSeriesDataset.getItemHyperlinks()) : new JFreeChartRenderer(jFreeChart);
        return jFreeChartRenderer;
    }

    protected JFreeChartRenderer getTimePeriodRenderer(JFreeChart jFreeChart) {
        JRFillTimePeriodDataset jRFillTimePeriodDataset = (JRFillTimePeriodDataset)this.getDataset();
        JFreeChartRenderer jFreeChartRenderer = jRFillTimePeriodDataset.hasItemHyperlinks() ? new JRTimePeriodChartImageMapRenderer(jFreeChart, jRFillTimePeriodDataset.getItemHyperlinks()) : new JFreeChartRenderer(jFreeChart);
        return jFreeChartRenderer;
    }
}

