/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementContainer;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCrosstab;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementGroup;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillFrame;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRYComparator;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public abstract class JRFillElementContainer
extends JRFillElementGroup {
    protected JRBaseFiller filler;
    private JRFillElement[] ySortedElements = null;
    private JRFillElement[] stretchElements = null;
    private JRFillElement[] bandBottomElements = null;
    private JRFillElement[] removableElements = null;
    private boolean willOverflow = false;
    protected boolean isOverflow = false;
    private int stretchHeight = 0;
    private int firstY = 0;
    private boolean isFirstYFound = false;
    protected final JRFillExpressionEvaluator expressionEvaluator;
    protected JRFillElement[] deepElements;
    protected Set stylesToEvaluate = new HashSet();
    protected Map evaluatedStyles = new HashMap();
    protected boolean hasPrintWhenOverflowElement;

    protected JRFillElementContainer(JRBaseFiller jRBaseFiller, JRElementGroup jRElementGroup, JRFillObjectFactory jRFillObjectFactory) {
        super(jRElementGroup, jRFillObjectFactory);
        this.expressionEvaluator = jRFillObjectFactory.getExpressionEvaluator();
        this.initDeepElements();
        this.filler = jRBaseFiller;
    }

    protected JRFillElementContainer(JRFillElementContainer jRFillElementContainer, JRFillCloneFactory jRFillCloneFactory) {
        super(jRFillElementContainer, jRFillCloneFactory);
        this.expressionEvaluator = jRFillElementContainer.expressionEvaluator;
        this.initDeepElements();
        this.filler = jRFillElementContainer.filler;
    }

    private void initDeepElements() {
        if (this.elements == null) {
            this.deepElements = new JRFillElement[0];
        } else {
            ArrayList arrayList = new ArrayList(this.elements.length);
            JRFillElementContainer.collectDeepElements(this.elements, arrayList);
            this.deepElements = new JRFillElement[arrayList.size()];
            arrayList.toArray(this.deepElements);
        }
    }

    private static void collectDeepElements(JRElement[] jRElementArray, List list) {
        for (int i = 0; i < jRElementArray.length; ++i) {
            JRElement jRElement = jRElementArray[i];
            list.add(jRElement);
            if (!(jRElement instanceof JRFillFrame)) continue;
            JRFrame jRFrame = (JRFrame)jRElement;
            JRFillElementContainer.collectDeepElements(jRFrame.getElements(), list);
        }
    }

    protected final void initElements() {
        this.hasPrintWhenOverflowElement = false;
        if (this.elements != null && this.elements.length > 0) {
            ArrayList<JRFillElement> arrayList = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> arrayList2 = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> arrayList3 = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> arrayList4 = new ArrayList<JRFillElement>();
            for (int i = 0; i < this.elements.length; ++i) {
                JRFillElement jRFillElement = this.elements[i];
                arrayList.add(jRFillElement);
                if (jRFillElement.getPositionType() == 3) {
                    arrayList3.add(jRFillElement);
                }
                if (jRFillElement.getStretchType() != 0) {
                    arrayList2.add(jRFillElement);
                }
                if (jRFillElement.isRemoveLineWhenBlank()) {
                    arrayList4.add(jRFillElement);
                }
                if (!jRFillElement.isPrintWhenDetailOverflows()) continue;
                this.hasPrintWhenOverflowElement = true;
            }
            Collections.sort(arrayList, new JRYComparator());
            this.ySortedElements = new JRFillElement[this.elements.length];
            arrayList.toArray(this.ySortedElements);
            this.stretchElements = new JRFillElement[arrayList2.size()];
            arrayList2.toArray(this.stretchElements);
            this.bandBottomElements = new JRFillElement[arrayList3.size()];
            arrayList3.toArray(this.bandBottomElements);
            this.removableElements = new JRFillElement[arrayList4.size()];
            arrayList4.toArray(this.removableElements);
        }
        this.setDependentElements();
        this.setElementsBandBottomY();
    }

    protected final void setElementsBandBottomY() {
        if (this.elements != null && this.elements.length > 0) {
            for (int i = 0; i < this.elements.length; ++i) {
                this.elements[i].setBandBottomY(this.getContainerHeight() - this.elements[i].getY() - this.elements[i].getHeight());
            }
        }
    }

    private void setDependentElements() {
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            JRFillElement jRFillElement = null;
            JRFillElement jRFillElement2 = null;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.ySortedElements.length - 1; ++i) {
                jRFillElement = this.ySortedElements[i];
                for (int j = i + 1; j < this.ySortedElements.length; ++j) {
                    jRFillElement2 = this.ySortedElements[j];
                    n = Math.min(jRFillElement.getX(), jRFillElement2.getX());
                    n2 = Math.max(jRFillElement.getX() + jRFillElement.getWidth(), jRFillElement2.getX() + jRFillElement2.getWidth());
                    if (jRFillElement2.getPositionType() != 1 || jRFillElement.getY() + jRFillElement.getHeight() > jRFillElement2.getY() || jRFillElement.getWidth() + jRFillElement2.getWidth() <= n2 - n) continue;
                    jRFillElement.addDependantElement(jRFillElement2);
                }
            }
        }
    }

    protected void evaluate(byte by) throws JRException {
        JRElement[] jRElementArray = this.getElements();
        if (jRElementArray != null && jRElementArray.length > 0) {
            for (int i = 0; i < jRElementArray.length; ++i) {
                JRFillElement jRFillElement = (JRFillElement)jRElementArray[i];
                jRFillElement.setCurrentEvaluation(by);
                jRFillElement.evaluate(by);
            }
        }
    }

    protected void resetElements() {
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (int i = 0; i < this.ySortedElements.length; ++i) {
                JRFillElement jRFillElement = this.ySortedElements[i];
                jRFillElement.reset();
                if (this.isOverflow) continue;
                jRFillElement.setAlreadyPrinted(false);
            }
        }
    }

    protected boolean willOverflow() {
        return this.willOverflow;
    }

    protected void initFill() {
        this.isOverflow = this.willOverflow;
        this.firstY = 0;
        this.isFirstYFound = false;
    }

    protected void prepareElements(int n, boolean bl) throws JRException {
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.firstY = this.isOverflow ? this.getContainerHeight() : 0;
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (int i = 0; i < this.ySortedElements.length; ++i) {
                JRFillElement jRFillElement = this.ySortedElements[i];
                int n5 = this.getElementFirstY(jRFillElement);
                bl2 = jRFillElement.prepare(n + n5, this.isOverflow) || bl2;
                jRFillElement.moveDependantElements();
                if (!jRFillElement.isToPrint()) continue;
                if (this.isOverflow) {
                    if (jRFillElement.isReprinted()) {
                        this.firstY = 0;
                    } else if (!this.isFirstYFound) {
                        this.firstY = jRFillElement.getY();
                    }
                    this.isFirstYFound = true;
                }
                if ((n3 = jRFillElement.getRelativeY() + jRFillElement.getStretchHeight() - this.getContainerHeight() + jRFillElement.getBandBottomY()) <= n2) continue;
                n2 = n3;
            }
        }
        if (n2 > n + this.firstY) {
            bl2 = true;
        }
        this.stretchHeight = bl2 ? this.getContainerHeight() + n : this.getContainerHeight() + n2;
        this.willOverflow = bl2 && bl;
    }

    private int getElementFirstY(JRFillElement jRFillElement) {
        int n = !this.isOverflow || this.hasPrintWhenOverflowElement ? 0 : (jRFillElement.getY() >= this.firstY ? this.firstY : jRFillElement.getY());
        return n;
    }

    protected void setStretchHeight(int n) {
        if (n > this.stretchHeight) {
            this.stretchHeight = n;
        }
    }

    protected void stretchElements() {
        JRFillElement jRFillElement;
        int n;
        if (this.stretchElements != null && this.stretchElements.length > 0) {
            for (n = 0; n < this.stretchElements.length; ++n) {
                jRFillElement = this.stretchElements[n];
                jRFillElement.stretchElement(this.stretchHeight - this.getContainerHeight());
                jRFillElement.moveDependantElements();
            }
        }
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (n = 0; n < this.ySortedElements.length; ++n) {
                jRFillElement = this.ySortedElements[n];
                jRFillElement.stretchHeightFinal();
            }
        }
    }

    protected int getStretchHeight() {
        return this.stretchHeight;
    }

    protected void moveBandBottomElements() {
        if (this.bandBottomElements != null && this.bandBottomElements.length > 0) {
            for (int i = 0; i < this.bandBottomElements.length; ++i) {
                JRFillElement jRFillElement = this.bandBottomElements[i];
                jRFillElement.setRelativeY(jRFillElement.getY() + this.stretchHeight - this.getContainerHeight());
                jRFillElement.setToPrint(jRFillElement.isToPrint() && !this.willOverflow);
            }
        }
    }

    protected void removeBlankElements() {
        JRFillElement[] jRFillElementArray = this.removableElements;
        if (jRFillElementArray != null && jRFillElementArray.length > 0) {
            JRFillElement[] jRFillElementArray2 = this.ySortedElements;
            for (int i = 0; i < jRFillElementArray.length; ++i) {
                JRFillElement jRFillElement;
                int n;
                JRFillElement jRFillElement2 = jRFillElementArray[i];
                int n2 = jRFillElement2.isToPrint() ? jRFillElement2.getHeight() - jRFillElement2.getStretchHeight() : jRFillElement2.getHeight();
                if (n2 <= 0 || jRFillElement2.getRelativeY() + jRFillElement2.getStretchHeight() > this.stretchHeight || jRFillElement2.getRelativeY() < this.firstY) continue;
                int n3 = jRFillElement2.getRelativeY() + jRFillElement2.getHeight() - n2;
                boolean bl = true;
                for (n = 0; n < jRFillElementArray2.length; ++n) {
                    jRFillElement = jRFillElementArray2[n];
                    if (jRFillElement2 == jRFillElement || !jRFillElement.isToPrint()) continue;
                    int n4 = Math.min(n3, jRFillElement.getRelativeY());
                    int n5 = Math.max(n3 + n2, jRFillElement.getRelativeY() + jRFillElement.getStretchHeight());
                    if (n2 + jRFillElement.getStretchHeight() <= n5 - n4) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                for (n = 0; n < jRFillElementArray2.length; ++n) {
                    jRFillElement = jRFillElementArray2[n];
                    if (jRFillElement.getRelativeY() < n3 + n2) continue;
                    jRFillElement.setRelativeY(jRFillElement.getRelativeY() - n2);
                }
                this.stretchHeight -= n2;
            }
        }
    }

    protected void fillElements(JRPrintElementContainer jRPrintElementContainer) throws JRException {
        JRElement[] jRElementArray = this.getElements();
        if (jRElementArray != null && jRElementArray.length > 0) {
            for (int i = 0; i < jRElementArray.length; ++i) {
                Object object;
                JRPrintElement jRPrintElement;
                JRFillElement jRFillElement = (JRFillElement)jRElementArray[i];
                jRFillElement.setRelativeY(jRFillElement.getRelativeY() - this.firstY);
                if (jRFillElement.getRelativeY() + jRFillElement.getStretchHeight() > this.stretchHeight) {
                    jRFillElement.setToPrint(false);
                }
                jRFillElement.setAlreadyPrinted(jRFillElement.isToPrint() || jRFillElement.isAlreadyPrinted());
                if (!jRFillElement.isToPrint() || (jRPrintElement = jRFillElement.fill()) == null) continue;
                jRPrintElementContainer.addElement(jRPrintElement);
                if (jRFillElement instanceof JRFillSubreport) {
                    List list;
                    object = (JRFillSubreport)jRFillElement;
                    List list2 = ((JRFillSubreport)object).subreportFiller.getJasperPrint().getFontsList();
                    if (list2 != null) {
                        for (int j = 0; j < list2.size(); ++j) {
                            this.filler.getJasperPrint().addFont((JRReportFont)list2.get(j), true);
                        }
                    }
                    if ((list = ((JRFillSubreport)object).subreportFiller.getJasperPrint().getStylesList()) != null) {
                        for (int j = 0; j < list.size(); ++j) {
                            this.filler.getJasperPrint().addStyle((JRStyle)list.get(j), true);
                        }
                    }
                    Collection collection = ((JRFillSubreport)object).getPrintElements();
                    this.addSubElements(jRPrintElementContainer, jRFillElement, collection);
                    continue;
                }
                if (!(jRFillElement instanceof JRFillCrosstab)) continue;
                object = ((JRFillCrosstab)jRFillElement).getPrintElements();
                this.addSubElements(jRPrintElementContainer, jRFillElement, (Collection)object);
            }
        }
        jRPrintElementContainer.setHeight(this.stretchHeight - this.firstY);
    }

    protected void addSubElements(JRPrintElementContainer jRPrintElementContainer, JRFillElement jRFillElement, Collection collection) {
        if (collection != null && collection.size() > 0) {
            for (JRPrintElement jRPrintElement : collection) {
                jRPrintElement.setX(jRFillElement.getX() + jRPrintElement.getX());
                jRPrintElement.setY(jRFillElement.getRelativeY() + jRPrintElement.getY());
                jRPrintElementContainer.addElement(jRPrintElement);
            }
        }
    }

    protected void rewind() throws JRException {
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (int i = 0; i < this.ySortedElements.length; ++i) {
                JRFillElement jRFillElement = this.ySortedElements[i];
                jRFillElement.rewind();
                jRFillElement.setAlreadyPrinted(false);
            }
        }
        this.willOverflow = false;
    }

    protected int getFirstY() {
        return this.firstY;
    }

    protected abstract int getContainerHeight();

    protected void initConditionalStyles() {
        int n;
        this.collectConditionalStyle(this.filler.getDefaultStyle());
        for (n = 0; n < this.deepElements.length; ++n) {
            JRStyle jRStyle = this.deepElements[n].initStyle;
            this.collectConditionalStyle(jRStyle);
        }
        if (this.deepElements.length > 0) {
            for (n = 0; n < this.deepElements.length; ++n) {
                this.deepElements[n].setConditionalStylesContainer(this);
            }
        }
    }

    protected void collectConditionalStyle(JRStyle jRStyle) {
        if (jRStyle != null) {
            this.stylesToEvaluate.add(jRStyle);
        }
    }

    protected void evaluateConditionalStyles(byte by) throws JRException {
        Iterator iterator = this.stylesToEvaluate.iterator();
        while (iterator.hasNext()) {
            this.evaluateConditionalStyle((JRStyle)iterator.next(), by);
        }
    }

    protected JRStyle evaluateConditionalStyle(JRStyle jRStyle, byte by) throws JRException {
        JRStyle jRStyle2 = jRStyle;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList = new ArrayList();
        boolean bl = this.buildConsolidatedStyle(jRStyle, by, stringBuffer, arrayList);
        if (bl) {
            String string = jRStyle.getName() + stringBuffer.toString();
            jRStyle2 = (JRStyle)this.filler.getJasperPrint().getStylesMap().get(string);
            if (jRStyle2 == null) {
                jRStyle2 = new JRBaseStyle(string);
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    JRStyleResolver.appendStyle(jRStyle2, (JRStyle)arrayList.get(i));
                }
                this.filler.getJasperPrint().addStyle(jRStyle2, true);
            }
        }
        this.evaluatedStyles.put(jRStyle, jRStyle2);
        return jRStyle2;
    }

    protected boolean buildConsolidatedStyle(JRStyle jRStyle, byte by, StringBuffer stringBuffer, List list) throws JRException {
        boolean bl = false;
        JRConditionalStyle[] jRConditionalStyleArray = jRStyle.getConditionalStyles();
        if (jRConditionalStyleArray != null && jRConditionalStyleArray.length > 0) {
            for (int i = 0; i < jRConditionalStyleArray.length; ++i) {
                JRConditionalStyle jRConditionalStyle = jRConditionalStyleArray[i];
                Boolean bl2 = (Boolean)this.expressionEvaluator.evaluate(jRConditionalStyle.getConditionExpression(), by);
                boolean bl3 = bl2 == null ? false : bl2;
                stringBuffer.append(bl3 ? (char)'1' : '0');
                bl |= bl3;
                if (!bl3) continue;
                list.add(jRConditionalStyle);
            }
        }
        list.add(jRStyle);
        if (jRStyle.getStyle() != null) {
            bl |= this.buildConsolidatedStyle(jRStyle.getStyle(), by, stringBuffer, list);
        }
        return bl;
    }

    public JRStyle getEvaluatedConditionalStyle(JRStyle jRStyle) {
        return (JRStyle)this.evaluatedStyles.get(jRStyle);
    }
}

