/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.util.List;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractArrayConverter;

public final class ByteArrayConverter
extends AbstractArrayConverter {
    private static byte[] model = new byte[0];

    public ByteArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public ByteArrayConverter(Object object) {
        this.defaultValue = object;
        this.useDefault = true;
    }

    @Override
    public Object convert(Class clazz, Object object) {
        if (object == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (model.getClass() == object.getClass()) {
            return object;
        }
        if (strings.getClass() == object.getClass()) {
            try {
                String[] stringArray = (String[])object;
                byte[] byArray = new byte[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    byArray[i] = Byte.parseByte(stringArray[i]);
                }
                return byArray;
            }
            catch (Exception exception) {
                if (this.useDefault) {
                    return this.defaultValue;
                }
                throw new ConversionException(object.toString(), exception);
            }
        }
        try {
            List list = this.parseElements(object.toString());
            byte[] byArray = new byte[list.size()];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = Byte.parseByte((String)list.get(i));
            }
            return byArray;
        }
        catch (Exception exception) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(object.toString(), exception);
        }
    }
}

