/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jce.ECGOST3410NamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPointEncoder;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.ECUtil;
import org.bouncycastle.jce.provider.ProviderUtil;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;

public class JCEECPublicKey
implements ECPublicKey,
ECPointEncoder {
    private String algorithm = "EC";
    private ECPoint q;
    private ECParameterSpec ecSpec;
    private boolean withCompression;
    private GOST3410PublicKeyAlgParameters gostParams;

    JCEECPublicKey(String string, JCEECPublicKey jCEECPublicKey) {
        this.algorithm = string;
        this.q = jCEECPublicKey.q;
        this.ecSpec = jCEECPublicKey.ecSpec;
        this.withCompression = jCEECPublicKey.withCompression;
        this.gostParams = jCEECPublicKey.gostParams;
    }

    JCEECPublicKey(String string, ECPublicKeySpec eCPublicKeySpec) {
        this.algorithm = string;
        this.q = eCPublicKeySpec.getQ();
        if (eCPublicKeySpec.getParams() != null) {
            this.ecSpec = eCPublicKeySpec.getParams();
        } else {
            if (this.q.getCurve() == null) {
                ECParameterSpec eCParameterSpec = ProviderUtil.getEcImplicitlyCa();
                this.q = this.q instanceof ECPoint.Fp ? new ECPoint.Fp(eCParameterSpec.getCurve(), this.q.getX(), this.q.getY()) : new ECPoint.F2m(eCParameterSpec.getCurve(), this.q.getX(), this.q.getY());
            }
            this.ecSpec = null;
        }
    }

    JCEECPublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.algorithm = string;
        this.q = eCPublicKeyParameters.getQ();
        this.ecSpec = eCParameterSpec == null ? new ECParameterSpec(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed()) : eCParameterSpec;
    }

    JCEECPublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters) {
        this.algorithm = string;
        this.q = eCPublicKeyParameters.getQ();
        this.ecSpec = null;
    }

    JCEECPublicKey(ECPublicKey eCPublicKey) {
        this.q = eCPublicKey.getQ();
        this.algorithm = eCPublicKey.getAlgorithm();
        this.ecSpec = eCPublicKey.getParameters();
    }

    JCEECPublicKey(String string, ECPoint eCPoint, ECParameterSpec eCParameterSpec) {
        this.algorithm = string;
        this.q = eCPoint;
        this.ecSpec = eCParameterSpec;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    JCEECPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        void var6_14;
        Object object;
        ECCurve eCCurve;
        Object object2;
        ASN1Encodable aSN1Encodable;
        if (subjectPublicKeyInfo.getAlgorithmId().getObjectId().equals(CryptoProObjectIdentifiers.gostR3410_2001)) {
            int n;
            ASN1OctetString aSN1OctetString;
            Object object3;
            DERBitString dERBitString = subjectPublicKeyInfo.getPublicKeyData();
            this.algorithm = "ECGOST3410";
            try {
                object3 = new ASN1InputStream(dERBitString.getBytes());
                aSN1OctetString = (ASN1OctetString)((ASN1InputStream)object3).readObject();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("error recovering public key");
            }
            object3 = aSN1OctetString.getOctets();
            byte[] byArray = new byte[32];
            byte[] byArray2 = new byte[32];
            for (n = 0; n != byArray2.length; ++n) {
                byArray[n] = (byte)object3[31 - n];
            }
            for (n = 0; n != byArray.length; ++n) {
                byArray2[n] = (byte)object3[63 - n];
            }
            this.gostParams = new GOST3410PublicKeyAlgParameters((ASN1Sequence)subjectPublicKeyInfo.getAlgorithmId().getParameters());
            ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ECGOST3410NamedCurveTable.getParameterSpec(ECGOST3410NamedCurves.getName(this.gostParams.getPublicKeyParamSet()));
            this.ecSpec = eCNamedCurveParameterSpec;
            ECCurve eCCurve2 = eCNamedCurveParameterSpec.getCurve();
            if (eCCurve2 instanceof ECCurve.Fp) {
                ECCurve.Fp fp = (ECCurve.Fp)eCCurve2;
                this.q = new ECPoint.Fp(fp, new ECFieldElement.Fp(fp.getQ(), new BigInteger(1, byArray)), new ECFieldElement.Fp(fp.getQ(), new BigInteger(1, byArray2)));
                return;
            } else {
                if (!(eCCurve2 instanceof ECCurve.F2m)) throw new UnsupportedOperationException("Subclass of ECPoint " + eCCurve2.getClass().toString() + "not supported");
                ECCurve.F2m f2m = (ECCurve.F2m)eCCurve2;
                int n2 = f2m.getM();
                int n3 = f2m.getK1();
                int n4 = f2m.getK2();
                int n5 = f2m.getK3();
                this.q = new ECPoint.F2m(f2m, new ECFieldElement.F2m(n2, n3, n4, n5, new BigInteger(1, byArray)), new ECFieldElement.F2m(n2, n3, n4, n5, new BigInteger(1, byArray2)), false);
            }
            return;
        }
        X962Parameters x962Parameters = new X962Parameters((DERObject)subjectPublicKeyInfo.getAlgorithmId().getParameters());
        if (x962Parameters.isNamedCurve()) {
            aSN1Encodable = (DERObjectIdentifier)x962Parameters.getParameters();
            object2 = ECUtil.getNamedCurveByOid((DERObjectIdentifier)aSN1Encodable);
            this.ecSpec = new ECNamedCurveParameterSpec(ECUtil.getCurveName((DERObjectIdentifier)aSN1Encodable), ((X9ECParameters)object2).getCurve(), ((X9ECParameters)object2).getG(), ((X9ECParameters)object2).getN(), ((X9ECParameters)object2).getH(), ((X9ECParameters)object2).getSeed());
            eCCurve = this.ecSpec.getCurve();
        } else if (x962Parameters.isImplicitlyCA()) {
            this.ecSpec = null;
            eCCurve = ProviderUtil.getEcImplicitlyCa().getCurve();
        } else {
            aSN1Encodable = new X9ECParameters((ASN1Sequence)x962Parameters.getParameters());
            this.ecSpec = new ECParameterSpec(((X9ECParameters)aSN1Encodable).getCurve(), ((X9ECParameters)aSN1Encodable).getG(), ((X9ECParameters)aSN1Encodable).getN(), ((X9ECParameters)aSN1Encodable).getH(), ((X9ECParameters)aSN1Encodable).getSeed());
            eCCurve = this.ecSpec.getCurve();
        }
        aSN1Encodable = subjectPublicKeyInfo.getPublicKeyData();
        object2 = ((DERBitString)aSN1Encodable).getBytes();
        DEROctetString dEROctetString = new DEROctetString((byte[])object2);
        if (object2[0] == 4 && object2[1] == ((Object)object2).length - 2 && (object2[2] == 2 || object2[2] == 3)) {
            try {
                object = new ByteArrayInputStream((byte[])object2);
                ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)object);
                ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("error recovering public key");
            }
        }
        object = new X9ECPoint(eCCurve, (ASN1OctetString)var6_14);
        this.q = ((X9ECPoint)object).getPoint();
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        if (this.algorithm.equals("ECGOST3410")) {
            int n;
            GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters = null;
            gOST3410PublicKeyAlgParameters = this.gostParams != null ? this.gostParams : new GOST3410PublicKeyAlgParameters(ECGOST3410NamedCurves.getOID(((ECNamedCurveParameterSpec)this.ecSpec).getName()), CryptoProObjectIdentifiers.gostR3411_94_CryptoProParamSet);
            ASN1OctetString aSN1OctetString = (ASN1OctetString)new X9ECPoint(new ECPoint.Fp(this.getQ().getCurve(), this.getQ().getX(), this.getQ().getY(), false)).getDERObject();
            BigInteger bigInteger = this.q.getX().toBigInteger();
            BigInteger bigInteger2 = this.q.getY().toBigInteger();
            byte[] byArray = new byte[64];
            byte[] byArray2 = bigInteger.toByteArray();
            for (n = 0; n != 32; ++n) {
                byArray[n] = byArray2[byArray2.length - 1 - n];
            }
            byArray2 = bigInteger2.toByteArray();
            for (n = 0; n != 32; ++n) {
                byArray[32 + n] = byArray2[byArray2.length - 1 - n];
            }
            subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, gOST3410PublicKeyAlgParameters.getDERObject()), new DEROctetString(byArray));
        } else {
            Object object;
            Object object2;
            X962Parameters x962Parameters = null;
            if (this.ecSpec instanceof ECNamedCurveParameterSpec) {
                object2 = ECUtil.getNamedCurveOid(((ECNamedCurveParameterSpec)this.ecSpec).getName());
                x962Parameters = new X962Parameters((DERObjectIdentifier)object2);
            } else if (this.ecSpec == null) {
                x962Parameters = new X962Parameters(DERNull.INSTANCE);
            } else {
                ECPoint eCPoint;
                object2 = this.ecSpec;
                object = ((ECParameterSpec)object2).getG().getCurve();
                if (object instanceof ECCurve.Fp) {
                    eCPoint = new ECPoint.Fp(((ECParameterSpec)object2).getG().getCurve(), ((ECParameterSpec)object2).getG().getX(), ((ECParameterSpec)object2).getG().getY(), this.withCompression);
                } else if (object instanceof ECCurve.F2m) {
                    eCPoint = new ECPoint.F2m(((ECParameterSpec)object2).getG().getCurve(), ((ECParameterSpec)object2).getG().getX(), ((ECParameterSpec)object2).getG().getY(), this.withCompression);
                } else {
                    throw new UnsupportedOperationException("Subclass of ECPoint " + object.getClass().toString() + "not supported");
                }
                X9ECParameters x9ECParameters = new X9ECParameters(((ECParameterSpec)object2).getCurve(), eCPoint, ((ECParameterSpec)object2).getN(), ((ECParameterSpec)object2).getH(), ((ECParameterSpec)object2).getSeed());
                x962Parameters = new X962Parameters(x9ECParameters);
            }
            object2 = this.engineGetQ().getCurve();
            if (object2 instanceof ECCurve.Fp) {
                object = (ASN1OctetString)new X9ECPoint(new ECPoint.Fp((ECCurve)object2, this.getQ().getX(), this.getQ().getY(), this.withCompression)).getDERObject();
            } else if (object2 instanceof ECCurve.F2m) {
                object = (ASN1OctetString)new X9ECPoint(new ECPoint.F2m((ECCurve)object2, this.getQ().getX(), this.getQ().getY(), this.withCompression)).getDERObject();
            } else {
                throw new UnsupportedOperationException("Subclass of ECPoint " + object2.getClass().toString() + "not supported");
            }
            subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters.getDERObject()), ((ASN1OctetString)object).getOctets());
        }
        return subjectPublicKeyInfo.getDEREncoded();
    }

    @Override
    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    @Override
    public ECParameterSpec getParameters() {
        return this.ecSpec;
    }

    @Override
    public ECPoint getQ() {
        if (this.ecSpec == null) {
            if (this.q instanceof ECPoint.Fp) {
                return new ECPoint.Fp(null, this.q.getX(), this.q.getY());
            }
            return new ECPoint.F2m(null, this.q.getX(), this.q.getY());
        }
        return this.q;
    }

    ECPoint engineGetQ() {
        return this.q;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("EC Public Key").append(string);
        stringBuffer.append("            X: ").append(this.getQ().getX().toBigInteger().toString(16)).append(string);
        stringBuffer.append("            Y: ").append(this.getQ().getY().toBigInteger().toString(16)).append(string);
        return stringBuffer.toString();
    }

    @Override
    public void setPointFormat(String string) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(string);
    }

    ECParameterSpec engineGetSpec() {
        if (this.ecSpec != null) {
            return this.ecSpec;
        }
        return ProviderUtil.getEcImplicitlyCa();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JCEECPublicKey)) {
            return false;
        }
        JCEECPublicKey jCEECPublicKey = (JCEECPublicKey)object;
        return this.getQ().equals(jCEECPublicKey.getQ()) && this.engineGetSpec().equals(jCEECPublicKey.engineGetSpec());
    }

    public int hashCode() {
        return this.getQ().hashCode() ^ this.engineGetSpec().hashCode();
    }
}

