/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.JavadocAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.JavadocFieldReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocMessageSend;
import org.eclipse.jdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class Javadoc
extends ASTNode {
    public JavadocSingleNameReference[] paramReferences;
    public JavadocSingleTypeReference[] paramTypeParameters;
    public TypeReference[] exceptionReferences;
    public JavadocReturnStatement returnStatement;
    public Expression[] seeReferences;
    public long inheritedPositions = -1L;
    public JavadocSingleNameReference[] invalidParameters;

    public Javadoc(int n, int n2) {
        this.sourceStart = n;
        this.sourceEnd = n2;
    }

    @Override
    public StringBuffer print(int n, StringBuffer stringBuffer) {
        int n2;
        int n3;
        Javadoc.printIndent(n, stringBuffer).append("/**\n");
        if (this.paramReferences != null) {
            n3 = this.paramReferences.length;
            for (n2 = 0; n2 < n3; ++n2) {
                Javadoc.printIndent(n + 1, stringBuffer).append(" * @param ");
                this.paramReferences[n2].print(n, stringBuffer).append('\n');
            }
        }
        if (this.paramTypeParameters != null) {
            n3 = this.paramTypeParameters.length;
            for (n2 = 0; n2 < n3; ++n2) {
                Javadoc.printIndent(n + 1, stringBuffer).append(" * @param <");
                this.paramTypeParameters[n2].print(n, stringBuffer).append(">\n");
            }
        }
        if (this.returnStatement != null) {
            Javadoc.printIndent(n + 1, stringBuffer).append(" * @");
            this.returnStatement.print(n, stringBuffer).append('\n');
        }
        if (this.exceptionReferences != null) {
            n3 = this.exceptionReferences.length;
            for (n2 = 0; n2 < n3; ++n2) {
                Javadoc.printIndent(n + 1, stringBuffer).append(" * @throws ");
                this.exceptionReferences[n2].print(n, stringBuffer).append('\n');
            }
        }
        if (this.seeReferences != null) {
            n3 = this.seeReferences.length;
            for (n2 = 0; n2 < n3; ++n2) {
                Javadoc.printIndent(n + 1, stringBuffer).append(" * @see ");
                this.seeReferences[n2].print(n, stringBuffer).append('\n');
            }
        }
        Javadoc.printIndent(n, stringBuffer).append(" */\n");
        return stringBuffer;
    }

    public void resolve(ClassScope classScope) {
        int n;
        int n2;
        int n3 = this.paramReferences == null ? 0 : this.paramReferences.length;
        for (n2 = 0; n2 < n3; ++n2) {
            JavadocSingleNameReference javadocSingleNameReference = this.paramReferences[n2];
            classScope.problemReporter().javadocUnexpectedTag(javadocSingleNameReference.tagSourceStart, javadocSingleNameReference.tagSourceEnd);
        }
        this.resolveTypeParameterTags(classScope, true);
        if (this.returnStatement != null) {
            classScope.problemReporter().javadocUnexpectedTag(this.returnStatement.sourceStart, this.returnStatement.sourceEnd);
        }
        n2 = this.exceptionReferences == null ? 0 : this.exceptionReferences.length;
        for (n = 0; n < n2; ++n) {
            int n4;
            int n5;
            TypeReference typeReference;
            TypeReference typeReference2 = this.exceptionReferences[n];
            if (typeReference2 instanceof JavadocSingleTypeReference) {
                typeReference = (JavadocSingleTypeReference)typeReference2;
                n5 = typeReference.tagSourceStart;
                n4 = typeReference.tagSourceEnd;
            } else if (typeReference2 instanceof JavadocQualifiedTypeReference) {
                typeReference = (JavadocQualifiedTypeReference)typeReference2;
                n5 = ((JavadocQualifiedTypeReference)typeReference).tagSourceStart;
                n4 = ((JavadocQualifiedTypeReference)typeReference).tagSourceEnd;
            } else {
                n5 = typeReference2.sourceStart;
                n4 = typeReference2.sourceEnd;
            }
            classScope.problemReporter().javadocUnexpectedTag(n5, n4);
        }
        n = this.seeReferences == null ? 0 : this.seeReferences.length;
        for (int i = 0; i < n; ++i) {
            this.resolveReference(this.seeReferences[i], classScope);
        }
    }

    public void resolve(MethodScope methodScope) {
        int n;
        AbstractMethodDeclaration abstractMethodDeclaration = methodScope.referenceMethod();
        boolean bl = abstractMethodDeclaration == null || abstractMethodDeclaration.binding == null ? false : !abstractMethodDeclaration.binding.isStatic() && (abstractMethodDeclaration.binding.modifiers & 0x30000000) != 0;
        int n2 = this.seeReferences == null ? 0 : this.seeReferences.length;
        boolean bl2 = false;
        for (n = 0; n < n2; ++n) {
            this.resolveReference(this.seeReferences[n], methodScope);
            try {
                Expression expression;
                if (abstractMethodDeclaration == null || !abstractMethodDeclaration.isConstructor() && !bl || bl2) continue;
                if (this.seeReferences[n] instanceof JavadocMessageSend) {
                    ReferenceBinding referenceBinding;
                    expression = (JavadocMessageSend)this.seeReferences[n];
                    if (expression.binding == null || !expression.binding.isValidBinding() || !(expression.actualReceiverType instanceof ReferenceBinding) || !(referenceBinding = (ReferenceBinding)expression.actualReceiverType).isSuperclassOf(abstractMethodDeclaration.binding.declaringClass) && (!referenceBinding.isInterface() || !abstractMethodDeclaration.binding.declaringClass.implementsInterface(referenceBinding, true)) || !CharOperation.equals(expression.selector, abstractMethodDeclaration.selector) || !abstractMethodDeclaration.binding.returnType.isCompatibleWith(expression.binding.returnType)) continue;
                    if (expression.arguments == null && abstractMethodDeclaration.arguments == null) {
                        bl2 = true;
                        continue;
                    }
                    if (expression.arguments == null || abstractMethodDeclaration.arguments == null) continue;
                    bl2 = abstractMethodDeclaration.binding.areParameterErasuresEqual(expression.binding);
                    continue;
                }
                if (!(this.seeReferences[n] instanceof JavadocAllocationExpression)) continue;
                expression = (JavadocAllocationExpression)this.seeReferences[n];
                if (((JavadocAllocationExpression)expression).binding == null || !((JavadocAllocationExpression)expression).binding.isValidBinding() || !abstractMethodDeclaration.binding.declaringClass.isCompatibleWith(((JavadocAllocationExpression)expression).resolvedType)) continue;
                if (((JavadocAllocationExpression)expression).arguments == null && abstractMethodDeclaration.arguments == null) {
                    bl2 = true;
                    continue;
                }
                if (((JavadocAllocationExpression)expression).arguments == null || abstractMethodDeclaration.arguments == null) continue;
                bl2 = abstractMethodDeclaration.binding.areParametersCompatibleWith(((JavadocAllocationExpression)expression).binding.parameters);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl2 && abstractMethodDeclaration != null && abstractMethodDeclaration.annotations != null) {
            n = abstractMethodDeclaration.annotations.length;
            for (int i = 0; i < n && !bl2; ++i) {
                bl2 = (abstractMethodDeclaration.binding.tagBits & 0x1000000000000L) != 0L;
            }
        }
        int n3 = n = abstractMethodDeclaration == null || (!bl || this.inheritedPositions == -1L) && !bl2 && (abstractMethodDeclaration.binding.declaringClass == null || !abstractMethodDeclaration.binding.declaringClass.isLocalType()) ? 1 : 0;
        if (!bl && this.inheritedPositions != -1L) {
            int n4 = (int)(this.inheritedPositions >>> 32);
            int n5 = (int)this.inheritedPositions;
            methodScope.problemReporter().javadocUnexpectedTag(n4, n5);
        }
        this.resolveParamTags(methodScope, n != 0);
        this.resolveTypeParameterTags(methodScope, n != 0);
        if (this.returnStatement == null) {
            if (n != 0 && abstractMethodDeclaration != null && abstractMethodDeclaration.isMethod()) {
                MethodDeclaration methodDeclaration = (MethodDeclaration)abstractMethodDeclaration;
                if (methodDeclaration.binding.returnType != TypeBinding.VOID) {
                    methodScope.problemReporter().javadocMissingReturnTag(methodDeclaration.returnType.sourceStart, methodDeclaration.returnType.sourceEnd, abstractMethodDeclaration.binding.modifiers);
                }
            }
        } else {
            this.returnStatement.resolve(methodScope);
        }
        this.resolveThrowsTags(methodScope, n != 0);
        int n6 = this.invalidParameters == null ? 0 : this.invalidParameters.length;
        for (int i = 0; i < n6; ++i) {
            this.invalidParameters[i].resolve(methodScope, false);
        }
    }

    private void resolveReference(Expression expression, Scope scope) {
        boolean bl;
        switch (scope.kind) {
            case 2: {
                expression.resolveType((MethodScope)scope);
                break;
            }
            case 3: {
                expression.resolveType((ClassScope)scope);
            }
        }
        boolean bl2 = bl = scope.compilerOptions().sourceLevel >= 0x310000L;
        if (expression instanceof JavadocFieldReference) {
            int n;
            JavadocFieldReference javadocFieldReference = (JavadocFieldReference)expression;
            int n2 = n = javadocFieldReference.binding == null ? -1 : javadocFieldReference.binding.modifiers;
            if (javadocFieldReference.methodBinding != null) {
                if (javadocFieldReference.tagValue == 10) {
                    scope.problemReporter().javadocInvalidValueReference(javadocFieldReference.sourceStart, javadocFieldReference.sourceEnd, n);
                } else if (javadocFieldReference.receiverType != null) {
                    javadocFieldReference.superAccess = scope.enclosingSourceType().isCompatibleWith(javadocFieldReference.receiverType);
                    javadocFieldReference.methodBinding = scope.findMethod((ReferenceBinding)javadocFieldReference.receiverType, javadocFieldReference.token, new TypeBinding[0], javadocFieldReference);
                }
            } else if (bl && javadocFieldReference.binding != null && javadocFieldReference.binding.isValidBinding() && javadocFieldReference.tagValue == 10 && !javadocFieldReference.binding.isStatic()) {
                scope.problemReporter().javadocInvalidValueReference(javadocFieldReference.sourceStart, javadocFieldReference.sourceEnd, n);
            }
            return;
        }
        if (!bl) {
            return;
        }
        if (expression instanceof JavadocMessageSend) {
            int n;
            JavadocMessageSend javadocMessageSend = (JavadocMessageSend)expression;
            int n3 = n = javadocMessageSend.binding == null ? -1 : javadocMessageSend.binding.modifiers;
            if (javadocMessageSend.tagValue == 10) {
                scope.problemReporter().javadocInvalidValueReference(javadocMessageSend.sourceStart, javadocMessageSend.sourceEnd, n);
            }
        } else if (expression instanceof JavadocAllocationExpression) {
            int n;
            JavadocAllocationExpression javadocAllocationExpression = (JavadocAllocationExpression)expression;
            int n4 = n = javadocAllocationExpression.binding == null ? -1 : javadocAllocationExpression.binding.modifiers;
            if (javadocAllocationExpression.tagValue == 10) {
                scope.problemReporter().javadocInvalidValueReference(javadocAllocationExpression.sourceStart, javadocAllocationExpression.sourceEnd, n);
            }
        }
        if (expression.resolvedType != null && expression.resolvedType.isTypeVariable()) {
            scope.problemReporter().javadocInvalidReference(expression.sourceStart, expression.sourceEnd);
        }
    }

    private void resolveParamTags(MethodScope methodScope, boolean bl) {
        block9: {
            int n;
            boolean bl2;
            Statement statement;
            int n2;
            int n3;
            int n4;
            AbstractMethodDeclaration abstractMethodDeclaration;
            block8: {
                abstractMethodDeclaration = methodScope.referenceMethod();
                int n5 = n4 = this.paramReferences == null ? 0 : this.paramReferences.length;
                if (abstractMethodDeclaration == null) {
                    for (int i = 0; i < n4; ++i) {
                        JavadocSingleNameReference javadocSingleNameReference = this.paramReferences[i];
                        methodScope.problemReporter().javadocUnexpectedTag(javadocSingleNameReference.tagSourceStart, javadocSingleNameReference.tagSourceEnd);
                    }
                    return;
                }
                int n6 = n3 = abstractMethodDeclaration.arguments == null ? 0 : abstractMethodDeclaration.arguments.length;
                if (n4 != 0) break block8;
                if (!bl) break block9;
                for (int i = 0; i < n3; ++i) {
                    Argument argument = abstractMethodDeclaration.arguments[i];
                    methodScope.problemReporter().javadocMissingParamTag(argument.name, argument.sourceStart, argument.sourceEnd, abstractMethodDeclaration.binding.modifiers);
                }
                break block9;
            }
            LocalVariableBinding[] localVariableBindingArray = new LocalVariableBinding[n4];
            int n7 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                statement = this.paramReferences[n2];
                statement.resolve(methodScope);
                if (statement.binding == null || !statement.binding.isValidBinding()) continue;
                bl2 = false;
                for (n = 0; n < n7 && !bl2; ++n) {
                    if (localVariableBindingArray[n] != statement.binding) continue;
                    methodScope.problemReporter().javadocDuplicatedParamTag(statement.token, statement.sourceStart, statement.sourceEnd, abstractMethodDeclaration.binding.modifiers);
                    bl2 = true;
                }
                if (bl2) continue;
                localVariableBindingArray[n7++] = (LocalVariableBinding)statement.binding;
            }
            if (bl) {
                for (n2 = 0; n2 < n3; ++n2) {
                    statement = abstractMethodDeclaration.arguments[n2];
                    bl2 = false;
                    for (n = 0; n < n7 && !bl2; ++n) {
                        LocalVariableBinding localVariableBinding = localVariableBindingArray[n];
                        if (((Argument)statement).binding != localVariableBinding) continue;
                        bl2 = true;
                    }
                    if (bl2) continue;
                    methodScope.problemReporter().javadocMissingParamTag(((Argument)statement).name, ((Argument)statement).sourceStart, ((Argument)statement).sourceEnd, abstractMethodDeclaration.binding.modifiers);
                }
            }
        }
    }

    private void resolveTypeParameterTags(Scope scope, boolean bl) {
        block16: {
            int n;
            TypeVariableBinding[] typeVariableBindingArray;
            int n2;
            TypeVariableBinding[] typeVariableBindingArray2;
            TypeParameter[] typeParameterArray;
            int n3;
            block17: {
                n3 = this.paramTypeParameters == null ? 0 : this.paramTypeParameters.length;
                typeParameterArray = null;
                typeVariableBindingArray2 = null;
                n2 = -1;
                switch (scope.kind) {
                    case 2: {
                        AbstractMethodDeclaration abstractMethodDeclaration = ((MethodScope)scope).referenceMethod();
                        if (abstractMethodDeclaration == null) {
                            for (int i = 0; i < n3; ++i) {
                                JavadocSingleNameReference javadocSingleNameReference = this.paramReferences[i];
                                scope.problemReporter().javadocUnexpectedTag(javadocSingleNameReference.tagSourceStart, javadocSingleNameReference.tagSourceEnd);
                            }
                            return;
                        }
                        typeParameterArray = abstractMethodDeclaration.typeParameters();
                        typeVariableBindingArray2 = abstractMethodDeclaration.binding.typeVariables;
                        n2 = abstractMethodDeclaration.binding.modifiers;
                        break;
                    }
                    case 3: {
                        typeVariableBindingArray = ((ClassScope)scope).referenceContext;
                        typeParameterArray = typeVariableBindingArray.typeParameters;
                        typeVariableBindingArray2 = typeVariableBindingArray.binding.typeVariables;
                        n2 = typeVariableBindingArray.binding.modifiers;
                    }
                }
                if (typeVariableBindingArray2 == null || typeVariableBindingArray2.length == 0) {
                    for (int i = 0; i < n3; ++i) {
                        typeVariableBindingArray = this.paramTypeParameters[i];
                        scope.problemReporter().javadocUnexpectedTag(typeVariableBindingArray.tagSourceStart, typeVariableBindingArray.tagSourceEnd);
                    }
                    return;
                }
                if (typeParameterArray == null) break block16;
                n = typeParameterArray.length;
                if (n3 != 0) break block17;
                if (!bl) break block16;
                int n4 = n;
                for (int i = 0; i < n4; ++i) {
                    scope.problemReporter().javadocMissingParamTag(typeParameterArray[i].name, typeParameterArray[i].sourceStart, typeParameterArray[i].sourceEnd, n2);
                }
                break block16;
            }
            if (typeVariableBindingArray2.length == n) {
                int n5;
                Statement statement;
                int n6;
                typeVariableBindingArray = new TypeVariableBinding[n3];
                for (n6 = 0; n6 < n3; ++n6) {
                    statement = this.paramTypeParameters[n6];
                    TypeBinding typeBinding = statement.internalResolveType(scope);
                    if (typeBinding == null || !typeBinding.isValidBinding()) continue;
                    if (typeBinding.isTypeVariable()) {
                        n5 = 0;
                        for (int i = 0; i < n6 && n5 == 0; ++i) {
                            if (typeVariableBindingArray[i] != statement.resolvedType) continue;
                            scope.problemReporter().javadocDuplicatedParamTag(statement.token, statement.sourceStart, statement.sourceEnd, n2);
                            n5 = 1;
                        }
                        if (n5 != 0) continue;
                        typeVariableBindingArray[n6] = (TypeVariableBinding)statement.resolvedType;
                        continue;
                    }
                    scope.problemReporter().javadocUndeclaredParamTagName(statement.token, statement.sourceStart, statement.sourceEnd, n2);
                }
                for (n6 = 0; n6 < n; ++n6) {
                    statement = typeParameterArray[n6];
                    boolean bl2 = false;
                    for (n5 = 0; n5 < n3 && !bl2; ++n5) {
                        if (((TypeParameter)statement).binding != typeVariableBindingArray[n5]) continue;
                        bl2 = true;
                        typeVariableBindingArray[n5] = null;
                    }
                    if (bl2 || !bl) continue;
                    scope.problemReporter().javadocMissingParamTag(((TypeParameter)statement).name, ((TypeParameter)statement).sourceStart, ((TypeParameter)statement).sourceEnd, n2);
                }
                for (n6 = 0; n6 < n3; ++n6) {
                    if (typeVariableBindingArray[n6] == null) continue;
                    statement = this.paramTypeParameters[n6];
                    scope.problemReporter().javadocUndeclaredParamTagName(statement.token, statement.sourceStart, statement.sourceEnd, n2);
                }
            }
        }
    }

    private void resolveThrowsTags(MethodScope methodScope, boolean bl) {
        block15: {
            TypeBinding typeBinding;
            int n;
            Object object;
            int n2;
            int n3;
            int n4;
            int n5;
            AbstractMethodDeclaration abstractMethodDeclaration;
            block14: {
                abstractMethodDeclaration = methodScope.referenceMethod();
                int n6 = n5 = this.exceptionReferences == null ? 0 : this.exceptionReferences.length;
                if (abstractMethodDeclaration == null) {
                    for (int i = 0; i < n5; ++i) {
                        TypeReference typeReference = this.exceptionReferences[i];
                        int n7 = typeReference.sourceStart;
                        int n8 = typeReference.sourceEnd;
                        if (typeReference instanceof JavadocQualifiedTypeReference) {
                            n7 = ((JavadocQualifiedTypeReference)typeReference).tagSourceStart;
                            n8 = ((JavadocQualifiedTypeReference)typeReference).tagSourceEnd;
                        } else if (typeReference instanceof JavadocSingleTypeReference) {
                            n7 = ((JavadocSingleTypeReference)typeReference).tagSourceStart;
                            n8 = ((JavadocSingleTypeReference)typeReference).tagSourceEnd;
                        }
                        methodScope.problemReporter().javadocUnexpectedTag(n7, n8);
                    }
                    return;
                }
                n4 = abstractMethodDeclaration.binding == null || abstractMethodDeclaration.binding.thrownExceptions == null ? 0 : abstractMethodDeclaration.binding.thrownExceptions.length;
                int n9 = n3 = abstractMethodDeclaration.thrownExceptions == null ? 0 : abstractMethodDeclaration.thrownExceptions.length;
                if (n5 != 0) break block14;
                if (!bl) break block15;
                for (int i = 0; i < n4; ++i) {
                    int n10;
                    ReferenceBinding referenceBinding = abstractMethodDeclaration.binding.thrownExceptions[i];
                    if (referenceBinding == null || !referenceBinding.isValidBinding()) continue;
                    for (n10 = i; n10 < n3 && referenceBinding != abstractMethodDeclaration.thrownExceptions[n10].resolvedType; ++n10) {
                    }
                    if (n10 >= n3) continue;
                    methodScope.problemReporter().javadocMissingThrowsTag(abstractMethodDeclaration.thrownExceptions[n10], abstractMethodDeclaration.binding.modifiers);
                }
                break block15;
            }
            int n11 = 0;
            TypeReference[] typeReferenceArray = new TypeReference[n5];
            for (n2 = 0; n2 < n5; ++n2) {
                object = this.exceptionReferences[n2];
                ((Expression)object).resolve(methodScope);
                TypeBinding typeBinding2 = ((TypeReference)object).resolvedType;
                if (typeBinding2 == null || !typeBinding2.isValidBinding() || !typeBinding2.isClass()) continue;
                typeReferenceArray[n11++] = object;
            }
            for (n2 = 0; n2 < n4; ++n2) {
                object = abstractMethodDeclaration.binding.thrownExceptions[n2];
                if (object != null) {
                    object = (ReferenceBinding)((TypeBinding)object).erasure();
                }
                boolean bl2 = false;
                for (n = 0; n < n11 && !bl2; ++n) {
                    if (typeReferenceArray[n] == null || object != (typeBinding = typeReferenceArray[n].resolvedType)) continue;
                    bl2 = true;
                    typeReferenceArray[n] = null;
                }
                if (bl2 || !bl || object == null || !((Binding)object).isValidBinding()) continue;
                for (n = n2; n < n3 && object != abstractMethodDeclaration.thrownExceptions[n].resolvedType; ++n) {
                }
                if (n >= n3) continue;
                methodScope.problemReporter().javadocMissingThrowsTag(abstractMethodDeclaration.thrownExceptions[n], abstractMethodDeclaration.binding.modifiers);
            }
            for (n2 = 0; n2 < n11; ++n2) {
                object = typeReferenceArray[n2];
                if (object == null) continue;
                boolean bl3 = false;
                for (n = 0; n < n3 && !bl3; ++n) {
                    typeBinding = abstractMethodDeclaration.thrownExceptions[n].resolvedType;
                    if (typeBinding == null) continue;
                    bl3 = ((TypeReference)object).resolvedType.isCompatibleWith(typeBinding);
                }
                if (bl3 || ((TypeReference)object).resolvedType.isUncheckedException(false)) continue;
                methodScope.problemReporter().javadocInvalidThrowsClassName((TypeReference)object, abstractMethodDeclaration.binding.modifiers);
            }
        }
    }

    public ASTNode getNodeStartingAt(int n) {
        int n2 = 0;
        if (this.paramReferences != null) {
            for (JavadocSingleNameReference expression2 : this.paramReferences) {
                if (expression2.sourceStart != n) continue;
                return expression2;
            }
        }
        if (this.invalidParameters != null) {
            for (JavadocSingleNameReference javadocSingleNameReference : this.invalidParameters) {
                if (javadocSingleNameReference.sourceStart != n) continue;
                return javadocSingleNameReference;
            }
        }
        if (this.paramTypeParameters != null) {
            for (JavadocSingleTypeReference javadocSingleTypeReference : this.paramTypeParameters) {
                if (javadocSingleTypeReference.sourceStart != n) continue;
                return javadocSingleTypeReference;
            }
        }
        if (this.exceptionReferences != null) {
            for (TypeReference typeReference : this.exceptionReferences) {
                if (typeReference.sourceStart != n) continue;
                return typeReference;
            }
        }
        if (this.seeReferences != null) {
            n2 = this.seeReferences.length;
            for (int i = 0; i < n2; ++i) {
                int n3;
                int n4;
                Expression expression;
                Expression expression2 = this.seeReferences[i];
                if (expression2.sourceStart == n) {
                    return expression2;
                }
                if (expression2 instanceof JavadocAllocationExpression) {
                    expression = (JavadocAllocationExpression)this.seeReferences[i];
                    if (expression.binding == null || !expression.binding.isValidBinding() || expression.arguments == null) continue;
                    n4 = expression.arguments.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        if (expression.arguments[n3].sourceStart != n) continue;
                        return expression.arguments[n3];
                    }
                    continue;
                }
                if (!(expression2 instanceof JavadocMessageSend)) continue;
                expression = (JavadocMessageSend)this.seeReferences[i];
                if (((JavadocMessageSend)expression).binding == null || !((JavadocMessageSend)expression).binding.isValidBinding() || ((JavadocMessageSend)expression).arguments == null) continue;
                n4 = ((JavadocMessageSend)expression).arguments.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    if (((JavadocMessageSend)expression).arguments[n3].sourceStart != n) continue;
                    return ((JavadocMessageSend)expression).arguments[n3];
                }
            }
        }
        return null;
    }
}

