/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;

public class QualifiedTypeReference
extends TypeReference {
    public char[][] tokens;
    public long[] sourcePositions;

    public QualifiedTypeReference(char[][] cArray, long[] lArray) {
        this.tokens = cArray;
        this.sourcePositions = lArray;
        this.sourceStart = (int)(this.sourcePositions[0] >>> 32);
        this.sourceEnd = (int)(this.sourcePositions[this.sourcePositions.length - 1] & 0xFFFFFFFFL);
    }

    @Override
    public TypeReference copyDims(int n) {
        return new ArrayQualifiedTypeReference(this.tokens, n, this.sourcePositions);
    }

    protected TypeBinding findNextTypeBinding(int n, Scope scope, PackageBinding packageBinding) {
        LookupEnvironment lookupEnvironment = scope.environment();
        try {
            TypeBinding typeBinding;
            lookupEnvironment.missingClassFileLocation = this;
            if (this.resolvedType == null) {
                this.resolvedType = scope.getType(this.tokens[n], packageBinding);
            } else {
                this.resolvedType = scope.getMemberType(this.tokens[n], (ReferenceBinding)this.resolvedType);
                if (this.resolvedType instanceof ProblemReferenceBinding) {
                    typeBinding = (ProblemReferenceBinding)this.resolvedType;
                    this.resolvedType = new ProblemReferenceBinding(CharOperation.subarray(this.tokens, 0, n + 1), ((ProblemReferenceBinding)typeBinding).closestMatch, this.resolvedType.problemId());
                }
            }
            typeBinding = this.resolvedType;
            return typeBinding;
        }
        catch (AbortCompilation abortCompilation) {
            abortCompilation.updateContext(this, scope.referenceCompilationUnit().compilationResult);
            throw abortCompilation;
        }
        finally {
            lookupEnvironment.missingClassFileLocation = null;
        }
    }

    @Override
    public char[] getLastToken() {
        return this.tokens[this.tokens.length - 1];
    }

    @Override
    protected TypeBinding getTypeBinding(Scope scope) {
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        Binding binding = scope.getPackage(this.tokens);
        if (binding != null && !binding.isValidBinding()) {
            return (ReferenceBinding)binding;
        }
        PackageBinding packageBinding = binding == null ? null : (PackageBinding)binding;
        boolean bl = scope.kind == 3;
        TypeBinding typeBinding = null;
        int n = this.tokens.length;
        for (int i = packageBinding == null ? 0 : packageBinding.compoundName.length; i < n; ++i) {
            this.findNextTypeBinding(i, scope, packageBinding);
            if (!this.resolvedType.isValidBinding()) {
                return this.resolvedType;
            }
            if (i == 0 && this.resolvedType.isTypeVariable() && ((TypeVariableBinding)this.resolvedType).firstBound == null) {
                scope.problemReporter().illegalAccessFromTypeVariable((TypeVariableBinding)this.resolvedType, this);
                this.resolvedType = null;
                return null;
            }
            if (bl && ((ClassScope)scope).detectHierarchyCycle(this.resolvedType, this, null)) {
                return null;
            }
            ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
            if (typeBinding != null) {
                if (referenceBinding.isGenericType()) {
                    typeBinding = scope.environment().createRawType(referenceBinding, (ReferenceBinding)typeBinding);
                    continue;
                }
                boolean bl2 = typeBinding.isRawType();
                if (bl2 && !referenceBinding.isStatic()) {
                    typeBinding = scope.environment().createRawType((ReferenceBinding)referenceBinding.erasure(), (ReferenceBinding)typeBinding);
                    continue;
                }
                if ((bl2 || typeBinding.isParameterizedType()) && typeBinding.erasure() == referenceBinding.enclosingType().erasure()) {
                    typeBinding = scope.environment().createParameterizedType((ReferenceBinding)referenceBinding.erasure(), null, (ReferenceBinding)typeBinding);
                    continue;
                }
                typeBinding = referenceBinding;
                continue;
            }
            typeBinding = referenceBinding.isGenericType() ? (ReferenceBinding)scope.environment().convertToRawType(referenceBinding) : referenceBinding;
        }
        this.resolvedType = typeBinding;
        return this.resolvedType;
    }

    @Override
    public char[][] getTypeName() {
        return this.tokens;
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        for (int i = 0; i < this.tokens.length; ++i) {
            if (i > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(this.tokens[i]);
        }
        return stringBuffer;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        aSTVisitor.visit(this, classScope);
        aSTVisitor.endVisit(this, classScope);
    }
}

