/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import java.util.ArrayList;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.codegen.ObjectCache;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ExceptionHandlingFlowContext
extends FlowContext {
    public static final int BitCacheSize = 32;
    public ReferenceBinding[] handledExceptions;
    int[] isReached;
    int[] isNeeded;
    UnconditionalFlowInfo[] initsOnExceptions;
    ObjectCache indexes = new ObjectCache();
    boolean isMethodContext;
    public UnconditionalFlowInfo initsOnReturn;
    public ArrayList extendedExceptions;

    public ExceptionHandlingFlowContext(FlowContext flowContext, ASTNode aSTNode, ReferenceBinding[] referenceBindingArray, BlockScope blockScope, UnconditionalFlowInfo unconditionalFlowInfo) {
        super(flowContext, aSTNode);
        this.isMethodContext = blockScope == blockScope.methodScope();
        this.handledExceptions = referenceBindingArray;
        int n = referenceBindingArray.length;
        int n2 = n / 32 + 1;
        this.isReached = new int[n2];
        this.isNeeded = new int[n2];
        this.initsOnExceptions = new UnconditionalFlowInfo[n];
        for (int i = 0; i < n; ++i) {
            this.indexes.put(referenceBindingArray[i], i);
            int n3 = i / 32;
            int n4 = 1 << i % 32;
            if (referenceBindingArray[i].isUncheckedException(true)) {
                int n5 = n3;
                this.isReached[n5] = this.isReached[n5] | n4;
                this.initsOnExceptions[i] = unconditionalFlowInfo.unconditionalCopy();
                continue;
            }
            this.initsOnExceptions[i] = FlowInfo.DEAD_END;
        }
        System.arraycopy(this.isReached, 0, this.isNeeded, 0, n2);
        this.initsOnReturn = FlowInfo.DEAD_END;
    }

    public void complainIfUnusedExceptionHandlers(AbstractMethodDeclaration abstractMethodDeclaration) {
        MethodScope methodScope = abstractMethodDeclaration.scope;
        if ((abstractMethodDeclaration.binding.modifiers & 0x30000000) != 0 && !methodScope.compilerOptions().reportUnusedDeclaredThrownExceptionWhenOverriding) {
            return;
        }
        int n = this.handledExceptions.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = this.indexes.get(this.handledExceptions[i]);
            int n4 = n3 / 32;
            if ((this.isReached[n4] & (n2 = 1 << n3 % 32)) != 0) continue;
            methodScope.problemReporter().unusedDeclaredThrownException(this.handledExceptions[n3], abstractMethodDeclaration, abstractMethodDeclaration.thrownExceptions[n3]);
        }
    }

    public void complainIfUnusedExceptionHandlers(BlockScope blockScope, TryStatement tryStatement) {
        int n = this.handledExceptions.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = this.indexes.get(this.handledExceptions[i]);
            int n4 = n3 / 32;
            if ((this.isReached[n4] & (n2 = 1 << n3 % 32)) == 0) {
                blockScope.problemReporter().unreachableCatchBlock(this.handledExceptions[n3], tryStatement.catchArguments[n3].type);
                continue;
            }
            if ((this.isNeeded[n4] & n2) != 0) continue;
            blockScope.problemReporter().hiddenCatchBlock(this.handledExceptions[n3], tryStatement.catchArguments[n3].type);
        }
    }

    @Override
    public String individualToString() {
        StringBuffer stringBuffer = new StringBuffer("Exception flow context");
        int n = this.handledExceptions.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i / 32;
            int n3 = 1 << i % 32;
            stringBuffer.append('[').append(this.handledExceptions[i].readableName());
            if ((this.isReached[n2] & n3) != 0) {
                if ((this.isNeeded[n2] & n3) == 0) {
                    stringBuffer.append("-masked");
                } else {
                    stringBuffer.append("-reached");
                }
            } else {
                stringBuffer.append("-not reached");
            }
            stringBuffer.append('-').append(this.initsOnExceptions[i].toString()).append(']');
        }
        stringBuffer.append("[initsOnReturn -").append(this.initsOnReturn.toString()).append(']');
        return stringBuffer.toString();
    }

    public UnconditionalFlowInfo initsOnException(ReferenceBinding referenceBinding) {
        int n = this.indexes.get(referenceBinding);
        if (n < 0) {
            return FlowInfo.DEAD_END;
        }
        return this.initsOnExceptions[n];
    }

    @Override
    public UnconditionalFlowInfo initsOnReturn() {
        return this.initsOnReturn;
    }

    public void mergeUnhandledException(TypeBinding typeBinding) {
        int n;
        if (this.extendedExceptions == null) {
            this.extendedExceptions = new ArrayList(5);
            for (n = 0; n < this.handledExceptions.length; ++n) {
                this.extendedExceptions.add(this.handledExceptions[n]);
            }
        }
        n = 0;
        block5: for (int i = this.extendedExceptions.size() - 1; i >= 0; --i) {
            switch (Scope.compareTypes(typeBinding, (TypeBinding)this.extendedExceptions.get(i))) {
                case 1: {
                    this.extendedExceptions.remove(i);
                    continue block5;
                }
                case -1: {
                    n = 1;
                    continue block5;
                }
            }
        }
        if (n == 0) {
            this.extendedExceptions.add(typeBinding);
        }
    }

    public void recordHandlingException(ReferenceBinding referenceBinding, UnconditionalFlowInfo unconditionalFlowInfo, TypeBinding typeBinding, ASTNode aSTNode, boolean bl) {
        int n = this.indexes.get(referenceBinding);
        int n2 = n / 32;
        int n3 = 1 << n % 32;
        if (!bl) {
            int n4 = n2;
            this.isNeeded[n4] = this.isNeeded[n4] | n3;
        }
        int n5 = n2;
        this.isReached[n5] = this.isReached[n5] | n3;
        this.initsOnExceptions[n] = (this.initsOnExceptions[n].tagBits & 1) == 0 ? this.initsOnExceptions[n].mergedWith(unconditionalFlowInfo) : unconditionalFlowInfo.unconditionalCopy();
    }

    @Override
    public void recordReturnFrom(UnconditionalFlowInfo unconditionalFlowInfo) {
        if ((unconditionalFlowInfo.tagBits & 1) == 0) {
            this.initsOnReturn = (this.initsOnReturn.tagBits & 1) == 0 ? this.initsOnReturn.mergedWith(unconditionalFlowInfo) : (UnconditionalFlowInfo)unconditionalFlowInfo.copy();
        }
    }

    @Override
    public SubRoutineStatement subroutine() {
        if (this.associatedNode instanceof SubRoutineStatement) {
            if (this.parent.subroutine() == this.associatedNode) {
                return null;
            }
            return (SubRoutineStatement)this.associatedNode;
        }
        return null;
    }
}

