/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.impl;

import org.eclipse.jdt.internal.compiler.ast.OperatorIds;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.ByteConstant;
import org.eclipse.jdt.internal.compiler.impl.CharConstant;
import org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.eclipse.jdt.internal.compiler.impl.FloatConstant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.impl.LongConstant;
import org.eclipse.jdt.internal.compiler.impl.ShortConstant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.problem.ShouldNotImplement;
import org.eclipse.jdt.internal.compiler.util.Messages;

public abstract class Constant
implements TypeIds,
OperatorIds {
    public static final Constant NotAConstant = DoubleConstant.fromValue(Double.NaN);

    public boolean booleanValue() {
        throw new ShouldNotImplement(Messages.bind(Messages.constant_cannotCastedInto, new String[]{this.typeName(), "boolean"}));
    }

    public byte byteValue() {
        throw new ShouldNotImplement(Messages.bind(Messages.constant_cannotCastedInto, new String[]{this.typeName(), "byte"}));
    }

    public final Constant castTo(int n) {
        if (this == NotAConstant) {
            return NotAConstant;
        }
        switch (n) {
            case 0: {
                return this;
            }
            case 51: {
                return this;
            }
            case 55: {
                return ByteConstant.fromValue((byte)this.longValue());
            }
            case 52: {
                return ByteConstant.fromValue((byte)this.shortValue());
            }
            case 56: {
                return ByteConstant.fromValue((byte)this.doubleValue());
            }
            case 57: {
                return ByteConstant.fromValue((byte)this.floatValue());
            }
            case 50: {
                return ByteConstant.fromValue((byte)this.charValue());
            }
            case 58: {
                return ByteConstant.fromValue((byte)this.intValue());
            }
            case 115: {
                return LongConstant.fromValue(this.byteValue());
            }
            case 119: {
                return this;
            }
            case 116: {
                return LongConstant.fromValue(this.shortValue());
            }
            case 120: {
                return LongConstant.fromValue((long)this.doubleValue());
            }
            case 121: {
                return LongConstant.fromValue((long)this.floatValue());
            }
            case 114: {
                return LongConstant.fromValue(this.charValue());
            }
            case 122: {
                return LongConstant.fromValue(this.intValue());
            }
            case 67: {
                return ShortConstant.fromValue(this.byteValue());
            }
            case 71: {
                return ShortConstant.fromValue((short)this.longValue());
            }
            case 68: {
                return this;
            }
            case 72: {
                return ShortConstant.fromValue((short)this.doubleValue());
            }
            case 73: {
                return ShortConstant.fromValue((short)this.floatValue());
            }
            case 66: {
                return ShortConstant.fromValue((short)this.charValue());
            }
            case 74: {
                return ShortConstant.fromValue((short)this.intValue());
            }
            case 187: {
                return this;
            }
            case 131: {
                return DoubleConstant.fromValue(this.byteValue());
            }
            case 135: {
                return DoubleConstant.fromValue(this.longValue());
            }
            case 132: {
                return DoubleConstant.fromValue(this.shortValue());
            }
            case 136: {
                return this;
            }
            case 137: {
                return DoubleConstant.fromValue(this.floatValue());
            }
            case 130: {
                return DoubleConstant.fromValue(this.charValue());
            }
            case 138: {
                return DoubleConstant.fromValue(this.intValue());
            }
            case 147: {
                return FloatConstant.fromValue(this.byteValue());
            }
            case 151: {
                return FloatConstant.fromValue(this.longValue());
            }
            case 148: {
                return FloatConstant.fromValue(this.shortValue());
            }
            case 152: {
                return FloatConstant.fromValue((float)this.doubleValue());
            }
            case 153: {
                return this;
            }
            case 146: {
                return FloatConstant.fromValue(this.charValue());
            }
            case 154: {
                return FloatConstant.fromValue(this.intValue());
            }
            case 85: {
                return this;
            }
            case 35: {
                return CharConstant.fromValue((char)this.byteValue());
            }
            case 39: {
                return CharConstant.fromValue((char)this.longValue());
            }
            case 36: {
                return CharConstant.fromValue((char)this.shortValue());
            }
            case 40: {
                return CharConstant.fromValue((char)this.doubleValue());
            }
            case 41: {
                return CharConstant.fromValue((char)this.floatValue());
            }
            case 34: {
                return this;
            }
            case 42: {
                return CharConstant.fromValue((char)this.intValue());
            }
            case 163: {
                return IntConstant.fromValue(this.byteValue());
            }
            case 167: {
                return IntConstant.fromValue((int)this.longValue());
            }
            case 164: {
                return IntConstant.fromValue(this.shortValue());
            }
            case 168: {
                return IntConstant.fromValue((int)this.doubleValue());
            }
            case 169: {
                return IntConstant.fromValue((int)this.floatValue());
            }
            case 162: {
                return IntConstant.fromValue(this.charValue());
            }
            case 170: {
                return this;
            }
        }
        return NotAConstant;
    }

    public char charValue() {
        throw new ShouldNotImplement(Messages.bind(Messages.constant_cannotCastedInto, new String[]{this.typeName(), "char"}));
    }

    public static final Constant computeConstantOperation(Constant constant, int n, int n2) {
        switch (n2) {
            case 11: {
                return BooleanConstant.fromValue(!constant.booleanValue());
            }
            case 14: {
                return Constant.computeConstantOperationPLUS(IntConstant.fromValue(0), 10, constant, n);
            }
            case 13: {
                switch (n) {
                    case 9: {
                        float f = constant.floatValue();
                        if (f != 0.0f) break;
                        if (Float.floatToIntBits(f) == 0) {
                            return FloatConstant.fromValue(-0.0f);
                        }
                        return FloatConstant.fromValue(0.0f);
                    }
                    case 8: {
                        double d = constant.doubleValue();
                        if (d != 0.0) break;
                        if (Double.doubleToLongBits(d) == 0L) {
                            return DoubleConstant.fromValue(-0.0);
                        }
                        return DoubleConstant.fromValue(0.0);
                    }
                }
                return Constant.computeConstantOperationMINUS(IntConstant.fromValue(0), 10, constant, n);
            }
            case 12: {
                switch (n) {
                    case 2: {
                        return IntConstant.fromValue(~constant.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(~constant.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(~constant.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(~constant.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue(constant.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                    }
                }
                return NotAConstant;
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperation(Constant constant, int n, int n2, Constant constant2, int n3) {
        switch (n2) {
            case 2: {
                return Constant.computeConstantOperationAND(constant, n, constant2, n3);
            }
            case 0: {
                return Constant.computeConstantOperationAND_AND(constant, n, constant2, n3);
            }
            case 9: {
                return Constant.computeConstantOperationDIVIDE(constant, n, constant2, n3);
            }
            case 6: {
                return Constant.computeConstantOperationGREATER(constant, n, constant2, n3);
            }
            case 7: {
                return Constant.computeConstantOperationGREATER_EQUAL(constant, n, constant2, n3);
            }
            case 10: {
                return Constant.computeConstantOperationLEFT_SHIFT(constant, n, constant2, n3);
            }
            case 4: {
                return Constant.computeConstantOperationLESS(constant, n, constant2, n3);
            }
            case 5: {
                return Constant.computeConstantOperationLESS_EQUAL(constant, n, constant2, n3);
            }
            case 13: {
                return Constant.computeConstantOperationMINUS(constant, n, constant2, n3);
            }
            case 15: {
                return Constant.computeConstantOperationMULTIPLY(constant, n, constant2, n3);
            }
            case 3: {
                return Constant.computeConstantOperationOR(constant, n, constant2, n3);
            }
            case 1: {
                return Constant.computeConstantOperationOR_OR(constant, n, constant2, n3);
            }
            case 14: {
                return Constant.computeConstantOperationPLUS(constant, n, constant2, n3);
            }
            case 16: {
                return Constant.computeConstantOperationREMAINDER(constant, n, constant2, n3);
            }
            case 17: {
                return Constant.computeConstantOperationRIGHT_SHIFT(constant, n, constant2, n3);
            }
            case 19: {
                return Constant.computeConstantOperationUNSIGNED_RIGHT_SHIFT(constant, n, constant2, n3);
            }
            case 8: {
                return Constant.computeConstantOperationXOR(constant, n, constant2, n3);
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationAND(Constant constant, int n, Constant constant2, int n2) {
        switch (n) {
            case 5: {
                return BooleanConstant.fromValue(constant.booleanValue() & constant2.booleanValue());
            }
            case 2: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.charValue() & constant2.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.charValue() & constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.charValue() & constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.charValue() & constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.charValue() & constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.byteValue() & constant2.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.byteValue() & constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.byteValue() & constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.byteValue() & constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.byteValue() & constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.shortValue() & constant2.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.shortValue() & constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.shortValue() & constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.shortValue() & constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.shortValue() & constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.intValue() & constant2.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.intValue() & constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.intValue() & constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.intValue() & constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.intValue() & constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n2) {
                    case 2: {
                        return LongConstant.fromValue(constant.longValue() & (long)constant2.charValue());
                    }
                    case 3: {
                        return LongConstant.fromValue(constant.longValue() & (long)constant2.byteValue());
                    }
                    case 4: {
                        return LongConstant.fromValue(constant.longValue() & (long)constant2.shortValue());
                    }
                    case 10: {
                        return LongConstant.fromValue(constant.longValue() & (long)constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue(constant.longValue() & constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationAND_AND(Constant constant, int n, Constant constant2, int n2) {
        return BooleanConstant.fromValue(constant.booleanValue() && constant2.booleanValue());
    }

    public static final Constant computeConstantOperationDIVIDE(Constant constant, int n, Constant constant2, int n2) {
        switch (n) {
            case 2: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.charValue() / constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.charValue() / constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.charValue() / constant2.doubleValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.charValue() / constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.charValue() / constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.charValue() / constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.charValue() / constant2.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (n2) {
                    case 2: {
                        return FloatConstant.fromValue(constant.floatValue() / (float)constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue(constant.floatValue() / constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.floatValue() / constant2.doubleValue());
                    }
                    case 3: {
                        return FloatConstant.fromValue(constant.floatValue() / (float)constant2.byteValue());
                    }
                    case 4: {
                        return FloatConstant.fromValue(constant.floatValue() / (float)constant2.shortValue());
                    }
                    case 10: {
                        return FloatConstant.fromValue(constant.floatValue() / (float)constant2.intValue());
                    }
                    case 7: {
                        return FloatConstant.fromValue(constant.floatValue() / (float)constant2.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (n2) {
                    case 2: {
                        return DoubleConstant.fromValue(constant.doubleValue() / (double)constant2.charValue());
                    }
                    case 9: {
                        return DoubleConstant.fromValue(constant.doubleValue() / (double)constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue(constant.doubleValue() / constant2.doubleValue());
                    }
                    case 3: {
                        return DoubleConstant.fromValue(constant.doubleValue() / (double)constant2.byteValue());
                    }
                    case 4: {
                        return DoubleConstant.fromValue(constant.doubleValue() / (double)constant2.shortValue());
                    }
                    case 10: {
                        return DoubleConstant.fromValue(constant.doubleValue() / (double)constant2.intValue());
                    }
                    case 7: {
                        return DoubleConstant.fromValue(constant.doubleValue() / (double)constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.byteValue() / constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.byteValue() / constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.byteValue() / constant2.doubleValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.byteValue() / constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.byteValue() / constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.byteValue() / constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.byteValue() / constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.shortValue() / constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.shortValue() / constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.shortValue() / constant2.doubleValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.shortValue() / constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.shortValue() / constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.shortValue() / constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.shortValue() / constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.intValue() / constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.intValue() / constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.intValue() / constant2.doubleValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.intValue() / constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.intValue() / constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.intValue() / constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.intValue() / constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n2) {
                    case 2: {
                        return LongConstant.fromValue(constant.longValue() / (long)constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.longValue() / constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.longValue() / constant2.doubleValue());
                    }
                    case 3: {
                        return LongConstant.fromValue(constant.longValue() / (long)constant2.byteValue());
                    }
                    case 4: {
                        return LongConstant.fromValue(constant.longValue() / (long)constant2.shortValue());
                    }
                    case 10: {
                        return LongConstant.fromValue(constant.longValue() / (long)constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue(constant.longValue() / constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationEQUAL_EQUAL(Constant constant, int n, Constant constant2, int n2) {
        switch (n) {
            case 5: {
                if (n2 != 5) break;
                return BooleanConstant.fromValue(constant.booleanValue() == constant2.booleanValue());
            }
            case 2: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.charValue() == constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.charValue() == constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.charValue() == constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.charValue() == constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.charValue() == constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.charValue() == constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue((long)constant.charValue() == constant2.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.floatValue() == (float)constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue(constant.floatValue() == constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.floatValue() == constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.floatValue() == (float)constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.floatValue() == (float)constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.floatValue() == (float)constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue(constant.floatValue() == (float)constant2.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.doubleValue() == (double)constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue(constant.doubleValue() == (double)constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue(constant.doubleValue() == constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.doubleValue() == (double)constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.doubleValue() == (double)constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.doubleValue() == (double)constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue(constant.doubleValue() == (double)constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.byteValue() == constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.byteValue() == constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.byteValue() == constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.byteValue() == constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.byteValue() == constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.byteValue() == constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue((long)constant.byteValue() == constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.shortValue() == constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.shortValue() == constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.shortValue() == constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.shortValue() == constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.shortValue() == constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.shortValue() == constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue((long)constant.shortValue() == constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.intValue() == constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.intValue() == constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.intValue() == constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.intValue() == constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.intValue() == constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.intValue() == constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue((long)constant.intValue() == constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.longValue() == (long)constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.longValue() == constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.longValue() == constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.longValue() == (long)constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.longValue() == (long)constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.longValue() == (long)constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue(constant.longValue() == constant2.longValue());
                    }
                }
                break;
            }
            case 11: {
                if (n2 != 11) break;
                return BooleanConstant.fromValue(((StringConstant)constant).hasSameValue(constant2));
            }
            case 12: {
                if (n2 == 11) {
                    return BooleanConstant.fromValue(false);
                }
                if (n2 != 12) break;
                return BooleanConstant.fromValue(true);
            }
        }
        return BooleanConstant.fromValue(false);
    }

    public static final Constant computeConstantOperationGREATER(Constant constant, int n, Constant constant2, int n2) {
        switch (n) {
            case 2: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.charValue() > constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.charValue() > constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.charValue() > constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.charValue() > constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.charValue() > constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.charValue() > constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue((long)constant.charValue() > constant2.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.floatValue() > (float)constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue(constant.floatValue() > constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.floatValue() > constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.floatValue() > (float)constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.floatValue() > (float)constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.floatValue() > (float)constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue(constant.floatValue() > (float)constant2.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.doubleValue() > (double)constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue(constant.doubleValue() > (double)constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue(constant.doubleValue() > constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.doubleValue() > (double)constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.doubleValue() > (double)constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.doubleValue() > (double)constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue(constant.doubleValue() > (double)constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.byteValue() > constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.byteValue() > constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.byteValue() > constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.byteValue() > constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.byteValue() > constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.byteValue() > constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue((long)constant.byteValue() > constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.shortValue() > constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.shortValue() > constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.shortValue() > constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.shortValue() > constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.shortValue() > constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.shortValue() > constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue((long)constant.shortValue() > constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.intValue() > constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.intValue() > constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.intValue() > constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.intValue() > constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.intValue() > constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.intValue() > constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue((long)constant.intValue() > constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.longValue() > (long)constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.longValue() > constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.longValue() > constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.longValue() > (long)constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.longValue() > (long)constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.longValue() > (long)constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue(constant.longValue() > constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationGREATER_EQUAL(Constant constant, int n, Constant constant2, int n2) {
        switch (n) {
            case 2: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.charValue() >= constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.charValue() >= constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.charValue() >= constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.charValue() >= constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.charValue() >= constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.charValue() >= constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue((long)constant.charValue() >= constant2.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.floatValue() >= (float)constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue(constant.floatValue() >= constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.floatValue() >= constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.floatValue() >= (float)constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.floatValue() >= (float)constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.floatValue() >= (float)constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue(constant.floatValue() >= (float)constant2.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.doubleValue() >= (double)constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue(constant.doubleValue() >= (double)constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue(constant.doubleValue() >= constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.doubleValue() >= (double)constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.doubleValue() >= (double)constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.doubleValue() >= (double)constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue(constant.doubleValue() >= (double)constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.byteValue() >= constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.byteValue() >= constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.byteValue() >= constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.byteValue() >= constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.byteValue() >= constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.byteValue() >= constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue((long)constant.byteValue() >= constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.shortValue() >= constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.shortValue() >= constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.shortValue() >= constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.shortValue() >= constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.shortValue() >= constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.shortValue() >= constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue((long)constant.shortValue() >= constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.intValue() >= constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.intValue() >= constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.intValue() >= constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.intValue() >= constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.intValue() >= constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.intValue() >= constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue((long)constant.intValue() >= constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.longValue() >= (long)constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.longValue() >= constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.longValue() >= constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.longValue() >= (long)constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.longValue() >= (long)constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.longValue() >= (long)constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue(constant.longValue() >= constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationLEFT_SHIFT(Constant constant, int n, Constant constant2, int n2) {
        switch (n) {
            case 2: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.charValue() << constant2.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.charValue() << constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.charValue() << constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.charValue() << constant2.intValue());
                    }
                    case 7: {
                        return IntConstant.fromValue(constant.charValue() << (int)constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.byteValue() << constant2.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.byteValue() << constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.byteValue() << constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.byteValue() << constant2.intValue());
                    }
                    case 7: {
                        return IntConstant.fromValue(constant.byteValue() << (int)constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.shortValue() << constant2.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.shortValue() << constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.shortValue() << constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.shortValue() << constant2.intValue());
                    }
                    case 7: {
                        return IntConstant.fromValue(constant.shortValue() << (int)constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.intValue() << constant2.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.intValue() << constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.intValue() << constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.intValue() << constant2.intValue());
                    }
                    case 7: {
                        return IntConstant.fromValue(constant.intValue() << (int)constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n2) {
                    case 2: {
                        return LongConstant.fromValue(constant.longValue() << constant2.charValue());
                    }
                    case 3: {
                        return LongConstant.fromValue(constant.longValue() << constant2.byteValue());
                    }
                    case 4: {
                        return LongConstant.fromValue(constant.longValue() << constant2.shortValue());
                    }
                    case 10: {
                        return LongConstant.fromValue(constant.longValue() << constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue(constant.longValue() << (int)constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationLESS(Constant constant, int n, Constant constant2, int n2) {
        switch (n) {
            case 2: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.charValue() < constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.charValue() < constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.charValue() < constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.charValue() < constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.charValue() < constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.charValue() < constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue((long)constant.charValue() < constant2.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.floatValue() < (float)constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue(constant.floatValue() < constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.floatValue() < constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.floatValue() < (float)constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.floatValue() < (float)constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.floatValue() < (float)constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue(constant.floatValue() < (float)constant2.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.doubleValue() < (double)constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue(constant.doubleValue() < (double)constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue(constant.doubleValue() < constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.doubleValue() < (double)constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.doubleValue() < (double)constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.doubleValue() < (double)constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue(constant.doubleValue() < (double)constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.byteValue() < constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.byteValue() < constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.byteValue() < constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.byteValue() < constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.byteValue() < constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.byteValue() < constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue((long)constant.byteValue() < constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.shortValue() < constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.shortValue() < constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.shortValue() < constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.shortValue() < constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.shortValue() < constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.shortValue() < constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue((long)constant.shortValue() < constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.intValue() < constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.intValue() < constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.intValue() < constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.intValue() < constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.intValue() < constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.intValue() < constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue((long)constant.intValue() < constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.longValue() < (long)constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.longValue() < constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.longValue() < constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.longValue() < (long)constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.longValue() < (long)constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.longValue() < (long)constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue(constant.longValue() < constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationLESS_EQUAL(Constant constant, int n, Constant constant2, int n2) {
        switch (n) {
            case 2: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.charValue() <= constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.charValue() <= constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.charValue() <= constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.charValue() <= constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.charValue() <= constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.charValue() <= constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue((long)constant.charValue() <= constant2.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.floatValue() <= (float)constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue(constant.floatValue() <= constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.floatValue() <= constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.floatValue() <= (float)constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.floatValue() <= (float)constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.floatValue() <= (float)constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue(constant.floatValue() <= (float)constant2.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.doubleValue() <= (double)constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue(constant.doubleValue() <= (double)constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue(constant.doubleValue() <= constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.doubleValue() <= (double)constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.doubleValue() <= (double)constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.doubleValue() <= (double)constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue(constant.doubleValue() <= (double)constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.byteValue() <= constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.byteValue() <= constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.byteValue() <= constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.byteValue() <= constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.byteValue() <= constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.byteValue() <= constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue((long)constant.byteValue() <= constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.shortValue() <= constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.shortValue() <= constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.shortValue() <= constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.shortValue() <= constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.shortValue() <= constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.shortValue() <= constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue((long)constant.shortValue() <= constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.intValue() <= constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.intValue() <= constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.intValue() <= constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.intValue() <= constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.intValue() <= constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.intValue() <= constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue((long)constant.intValue() <= constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n2) {
                    case 2: {
                        return BooleanConstant.fromValue(constant.longValue() <= (long)constant2.charValue());
                    }
                    case 9: {
                        return BooleanConstant.fromValue((float)constant.longValue() <= constant2.floatValue());
                    }
                    case 8: {
                        return BooleanConstant.fromValue((double)constant.longValue() <= constant2.doubleValue());
                    }
                    case 3: {
                        return BooleanConstant.fromValue(constant.longValue() <= (long)constant2.byteValue());
                    }
                    case 4: {
                        return BooleanConstant.fromValue(constant.longValue() <= (long)constant2.shortValue());
                    }
                    case 10: {
                        return BooleanConstant.fromValue(constant.longValue() <= (long)constant2.intValue());
                    }
                    case 7: {
                        return BooleanConstant.fromValue(constant.longValue() <= constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationMINUS(Constant constant, int n, Constant constant2, int n2) {
        switch (n) {
            case 2: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.charValue() - constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.charValue() - constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.charValue() - constant2.doubleValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.charValue() - constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.charValue() - constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.charValue() - constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.charValue() - constant2.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (n2) {
                    case 2: {
                        return FloatConstant.fromValue(constant.floatValue() - (float)constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue(constant.floatValue() - constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.floatValue() - constant2.doubleValue());
                    }
                    case 3: {
                        return FloatConstant.fromValue(constant.floatValue() - (float)constant2.byteValue());
                    }
                    case 4: {
                        return FloatConstant.fromValue(constant.floatValue() - (float)constant2.shortValue());
                    }
                    case 10: {
                        return FloatConstant.fromValue(constant.floatValue() - (float)constant2.intValue());
                    }
                    case 7: {
                        return FloatConstant.fromValue(constant.floatValue() - (float)constant2.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (n2) {
                    case 2: {
                        return DoubleConstant.fromValue(constant.doubleValue() - (double)constant2.charValue());
                    }
                    case 9: {
                        return DoubleConstant.fromValue(constant.doubleValue() - (double)constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue(constant.doubleValue() - constant2.doubleValue());
                    }
                    case 3: {
                        return DoubleConstant.fromValue(constant.doubleValue() - (double)constant2.byteValue());
                    }
                    case 4: {
                        return DoubleConstant.fromValue(constant.doubleValue() - (double)constant2.shortValue());
                    }
                    case 10: {
                        return DoubleConstant.fromValue(constant.doubleValue() - (double)constant2.intValue());
                    }
                    case 7: {
                        return DoubleConstant.fromValue(constant.doubleValue() - (double)constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.byteValue() - constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.byteValue() - constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.byteValue() - constant2.doubleValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.byteValue() - constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.byteValue() - constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.byteValue() - constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.byteValue() - constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.shortValue() - constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.shortValue() - constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.shortValue() - constant2.doubleValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.shortValue() - constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.shortValue() - constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.shortValue() - constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.shortValue() - constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.intValue() - constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.intValue() - constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.intValue() - constant2.doubleValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.intValue() - constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.intValue() - constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.intValue() - constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.intValue() - constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n2) {
                    case 2: {
                        return LongConstant.fromValue(constant.longValue() - (long)constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.longValue() - constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.longValue() - constant2.doubleValue());
                    }
                    case 3: {
                        return LongConstant.fromValue(constant.longValue() - (long)constant2.byteValue());
                    }
                    case 4: {
                        return LongConstant.fromValue(constant.longValue() - (long)constant2.shortValue());
                    }
                    case 10: {
                        return LongConstant.fromValue(constant.longValue() - (long)constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue(constant.longValue() - constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationMULTIPLY(Constant constant, int n, Constant constant2, int n2) {
        switch (n) {
            case 2: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.charValue() * constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.charValue() * constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.charValue() * constant2.doubleValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.charValue() * constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.charValue() * constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.charValue() * constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.charValue() * constant2.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (n2) {
                    case 2: {
                        return FloatConstant.fromValue(constant.floatValue() * (float)constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue(constant.floatValue() * constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.floatValue() * constant2.doubleValue());
                    }
                    case 3: {
                        return FloatConstant.fromValue(constant.floatValue() * (float)constant2.byteValue());
                    }
                    case 4: {
                        return FloatConstant.fromValue(constant.floatValue() * (float)constant2.shortValue());
                    }
                    case 10: {
                        return FloatConstant.fromValue(constant.floatValue() * (float)constant2.intValue());
                    }
                    case 7: {
                        return FloatConstant.fromValue(constant.floatValue() * (float)constant2.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (n2) {
                    case 2: {
                        return DoubleConstant.fromValue(constant.doubleValue() * (double)constant2.charValue());
                    }
                    case 9: {
                        return DoubleConstant.fromValue(constant.doubleValue() * (double)constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue(constant.doubleValue() * constant2.doubleValue());
                    }
                    case 3: {
                        return DoubleConstant.fromValue(constant.doubleValue() * (double)constant2.byteValue());
                    }
                    case 4: {
                        return DoubleConstant.fromValue(constant.doubleValue() * (double)constant2.shortValue());
                    }
                    case 10: {
                        return DoubleConstant.fromValue(constant.doubleValue() * (double)constant2.intValue());
                    }
                    case 7: {
                        return DoubleConstant.fromValue(constant.doubleValue() * (double)constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.byteValue() * constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.byteValue() * constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.byteValue() * constant2.doubleValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.byteValue() * constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.byteValue() * constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.byteValue() * constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.byteValue() * constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.shortValue() * constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.shortValue() * constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.shortValue() * constant2.doubleValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.shortValue() * constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.shortValue() * constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.shortValue() * constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.shortValue() * constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.intValue() * constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.intValue() * constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.intValue() * constant2.doubleValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.intValue() * constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.intValue() * constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.intValue() * constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.intValue() * constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n2) {
                    case 2: {
                        return LongConstant.fromValue(constant.longValue() * (long)constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.longValue() * constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.longValue() * constant2.doubleValue());
                    }
                    case 3: {
                        return LongConstant.fromValue(constant.longValue() * (long)constant2.byteValue());
                    }
                    case 4: {
                        return LongConstant.fromValue(constant.longValue() * (long)constant2.shortValue());
                    }
                    case 10: {
                        return LongConstant.fromValue(constant.longValue() * (long)constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue(constant.longValue() * constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationOR(Constant constant, int n, Constant constant2, int n2) {
        switch (n) {
            case 5: {
                return BooleanConstant.fromValue(constant.booleanValue() | constant2.booleanValue());
            }
            case 2: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.charValue() | constant2.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.charValue() | constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.charValue() | constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.charValue() | constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.charValue() | constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.byteValue() | constant2.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.byteValue() | constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.byteValue() | constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.byteValue() | constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.byteValue() | constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.shortValue() | constant2.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.shortValue() | constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.shortValue() | constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.shortValue() | constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.shortValue() | constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.intValue() | constant2.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.intValue() | constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.intValue() | constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.intValue() | constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.intValue() | constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n2) {
                    case 2: {
                        return LongConstant.fromValue(constant.longValue() | (long)constant2.charValue());
                    }
                    case 3: {
                        return LongConstant.fromValue(constant.longValue() | (long)constant2.byteValue());
                    }
                    case 4: {
                        return LongConstant.fromValue(constant.longValue() | (long)constant2.shortValue());
                    }
                    case 10: {
                        return LongConstant.fromValue(constant.longValue() | (long)constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue(constant.longValue() | constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationOR_OR(Constant constant, int n, Constant constant2, int n2) {
        return BooleanConstant.fromValue(constant.booleanValue() || constant2.booleanValue());
    }

    public static final Constant computeConstantOperationPLUS(Constant constant, int n, Constant constant2, int n2) {
        switch (n) {
            case 1: {
                if (n2 == 11) {
                    return StringConstant.fromValue(constant.stringValue() + constant2.stringValue());
                }
            }
            case 5: {
                if (n2 != 11) break;
                return StringConstant.fromValue(constant.stringValue() + constant2.stringValue());
            }
            case 2: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.charValue() + constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.charValue() + constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.charValue() + constant2.doubleValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.charValue() + constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.charValue() + constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.charValue() + constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.charValue() + constant2.longValue());
                    }
                    case 11: {
                        return StringConstant.fromValue(constant.stringValue() + constant2.stringValue());
                    }
                }
                break;
            }
            case 9: {
                switch (n2) {
                    case 2: {
                        return FloatConstant.fromValue(constant.floatValue() + (float)constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue(constant.floatValue() + constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.floatValue() + constant2.doubleValue());
                    }
                    case 3: {
                        return FloatConstant.fromValue(constant.floatValue() + (float)constant2.byteValue());
                    }
                    case 4: {
                        return FloatConstant.fromValue(constant.floatValue() + (float)constant2.shortValue());
                    }
                    case 10: {
                        return FloatConstant.fromValue(constant.floatValue() + (float)constant2.intValue());
                    }
                    case 7: {
                        return FloatConstant.fromValue(constant.floatValue() + (float)constant2.longValue());
                    }
                    case 11: {
                        return StringConstant.fromValue(constant.stringValue() + constant2.stringValue());
                    }
                }
                break;
            }
            case 8: {
                switch (n2) {
                    case 2: {
                        return DoubleConstant.fromValue(constant.doubleValue() + (double)constant2.charValue());
                    }
                    case 9: {
                        return DoubleConstant.fromValue(constant.doubleValue() + (double)constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue(constant.doubleValue() + constant2.doubleValue());
                    }
                    case 3: {
                        return DoubleConstant.fromValue(constant.doubleValue() + (double)constant2.byteValue());
                    }
                    case 4: {
                        return DoubleConstant.fromValue(constant.doubleValue() + (double)constant2.shortValue());
                    }
                    case 10: {
                        return DoubleConstant.fromValue(constant.doubleValue() + (double)constant2.intValue());
                    }
                    case 7: {
                        return DoubleConstant.fromValue(constant.doubleValue() + (double)constant2.longValue());
                    }
                    case 11: {
                        return StringConstant.fromValue(constant.stringValue() + constant2.stringValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.byteValue() + constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.byteValue() + constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.byteValue() + constant2.doubleValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.byteValue() + constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.byteValue() + constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.byteValue() + constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.byteValue() + constant2.longValue());
                    }
                    case 11: {
                        return StringConstant.fromValue(constant.stringValue() + constant2.stringValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.shortValue() + constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.shortValue() + constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.shortValue() + constant2.doubleValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.shortValue() + constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.shortValue() + constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.shortValue() + constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.shortValue() + constant2.longValue());
                    }
                    case 11: {
                        return StringConstant.fromValue(constant.stringValue() + constant2.stringValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.intValue() + constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.intValue() + constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.intValue() + constant2.doubleValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.intValue() + constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.intValue() + constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.intValue() + constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.intValue() + constant2.longValue());
                    }
                    case 11: {
                        return StringConstant.fromValue(constant.stringValue() + constant2.stringValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n2) {
                    case 2: {
                        return LongConstant.fromValue(constant.longValue() + (long)constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.longValue() + constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.longValue() + constant2.doubleValue());
                    }
                    case 3: {
                        return LongConstant.fromValue(constant.longValue() + (long)constant2.byteValue());
                    }
                    case 4: {
                        return LongConstant.fromValue(constant.longValue() + (long)constant2.shortValue());
                    }
                    case 10: {
                        return LongConstant.fromValue(constant.longValue() + (long)constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue(constant.longValue() + constant2.longValue());
                    }
                    case 11: {
                        return StringConstant.fromValue(constant.stringValue() + constant2.stringValue());
                    }
                }
                break;
            }
            case 11: {
                switch (n2) {
                    case 2: {
                        return StringConstant.fromValue(constant.stringValue() + String.valueOf(constant2.charValue()));
                    }
                    case 9: {
                        return StringConstant.fromValue(constant.stringValue() + String.valueOf(constant2.floatValue()));
                    }
                    case 8: {
                        return StringConstant.fromValue(constant.stringValue() + String.valueOf(constant2.doubleValue()));
                    }
                    case 3: {
                        return StringConstant.fromValue(constant.stringValue() + String.valueOf(constant2.byteValue()));
                    }
                    case 4: {
                        return StringConstant.fromValue(constant.stringValue() + String.valueOf(constant2.shortValue()));
                    }
                    case 10: {
                        return StringConstant.fromValue(constant.stringValue() + String.valueOf(constant2.intValue()));
                    }
                    case 7: {
                        return StringConstant.fromValue(constant.stringValue() + String.valueOf(constant2.longValue()));
                    }
                    case 11: {
                        return StringConstant.fromValue(constant.stringValue() + constant2.stringValue());
                    }
                    case 5: {
                        return StringConstant.fromValue(constant.stringValue() + constant2.booleanValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationREMAINDER(Constant constant, int n, Constant constant2, int n2) {
        switch (n) {
            case 2: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.charValue() % constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.charValue() % constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.charValue() % constant2.doubleValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.charValue() % constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.charValue() % constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.charValue() % constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.charValue() % constant2.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (n2) {
                    case 2: {
                        return FloatConstant.fromValue(constant.floatValue() % (float)constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue(constant.floatValue() % constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.floatValue() % constant2.doubleValue());
                    }
                    case 3: {
                        return FloatConstant.fromValue(constant.floatValue() % (float)constant2.byteValue());
                    }
                    case 4: {
                        return FloatConstant.fromValue(constant.floatValue() % (float)constant2.shortValue());
                    }
                    case 10: {
                        return FloatConstant.fromValue(constant.floatValue() % (float)constant2.intValue());
                    }
                    case 7: {
                        return FloatConstant.fromValue(constant.floatValue() % (float)constant2.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (n2) {
                    case 2: {
                        return DoubleConstant.fromValue(constant.doubleValue() % (double)constant2.charValue());
                    }
                    case 9: {
                        return DoubleConstant.fromValue(constant.doubleValue() % (double)constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue(constant.doubleValue() % constant2.doubleValue());
                    }
                    case 3: {
                        return DoubleConstant.fromValue(constant.doubleValue() % (double)constant2.byteValue());
                    }
                    case 4: {
                        return DoubleConstant.fromValue(constant.doubleValue() % (double)constant2.shortValue());
                    }
                    case 10: {
                        return DoubleConstant.fromValue(constant.doubleValue() % (double)constant2.intValue());
                    }
                    case 7: {
                        return DoubleConstant.fromValue(constant.doubleValue() % (double)constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.byteValue() % constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.byteValue() % constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.byteValue() % constant2.doubleValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.byteValue() % constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.byteValue() % constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.byteValue() % constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.byteValue() % constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.shortValue() % constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.shortValue() % constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.shortValue() % constant2.doubleValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.shortValue() % constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.shortValue() % constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.shortValue() % constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.shortValue() % constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.intValue() % constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.intValue() % constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.intValue() % constant2.doubleValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.intValue() % constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.intValue() % constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.intValue() % constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.intValue() % constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n2) {
                    case 2: {
                        return LongConstant.fromValue(constant.longValue() % (long)constant2.charValue());
                    }
                    case 9: {
                        return FloatConstant.fromValue((float)constant.longValue() % constant2.floatValue());
                    }
                    case 8: {
                        return DoubleConstant.fromValue((double)constant.longValue() % constant2.doubleValue());
                    }
                    case 3: {
                        return LongConstant.fromValue(constant.longValue() % (long)constant2.byteValue());
                    }
                    case 4: {
                        return LongConstant.fromValue(constant.longValue() % (long)constant2.shortValue());
                    }
                    case 10: {
                        return LongConstant.fromValue(constant.longValue() % (long)constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue(constant.longValue() % constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationRIGHT_SHIFT(Constant constant, int n, Constant constant2, int n2) {
        switch (n) {
            case 2: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.charValue() >> constant2.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.charValue() >> constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.charValue() >> constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.charValue() >> constant2.intValue());
                    }
                    case 7: {
                        return IntConstant.fromValue(constant.charValue() >> (int)constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.byteValue() >> constant2.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.byteValue() >> constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.byteValue() >> constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.byteValue() >> constant2.intValue());
                    }
                    case 7: {
                        return IntConstant.fromValue(constant.byteValue() >> (int)constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.shortValue() >> constant2.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.shortValue() >> constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.shortValue() >> constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.shortValue() >> constant2.intValue());
                    }
                    case 7: {
                        return IntConstant.fromValue(constant.shortValue() >> (int)constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.intValue() >> constant2.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.intValue() >> constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.intValue() >> constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.intValue() >> constant2.intValue());
                    }
                    case 7: {
                        return IntConstant.fromValue(constant.intValue() >> (int)constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n2) {
                    case 2: {
                        return LongConstant.fromValue(constant.longValue() >> constant2.charValue());
                    }
                    case 3: {
                        return LongConstant.fromValue(constant.longValue() >> constant2.byteValue());
                    }
                    case 4: {
                        return LongConstant.fromValue(constant.longValue() >> constant2.shortValue());
                    }
                    case 10: {
                        return LongConstant.fromValue(constant.longValue() >> constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue(constant.longValue() >> (int)constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationUNSIGNED_RIGHT_SHIFT(Constant constant, int n, Constant constant2, int n2) {
        switch (n) {
            case 2: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.charValue() >>> constant2.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.charValue() >>> constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.charValue() >>> constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.charValue() >>> constant2.intValue());
                    }
                    case 7: {
                        return IntConstant.fromValue(constant.charValue() >>> (int)constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.byteValue() >>> constant2.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.byteValue() >>> constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.byteValue() >>> constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.byteValue() >>> constant2.intValue());
                    }
                    case 7: {
                        return IntConstant.fromValue(constant.byteValue() >>> (int)constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.shortValue() >>> constant2.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.shortValue() >>> constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.shortValue() >>> constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.shortValue() >>> constant2.intValue());
                    }
                    case 7: {
                        return IntConstant.fromValue(constant.shortValue() >>> (int)constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.intValue() >>> constant2.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.intValue() >>> constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.intValue() >>> constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.intValue() >>> constant2.intValue());
                    }
                    case 7: {
                        return IntConstant.fromValue(constant.intValue() >>> (int)constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n2) {
                    case 2: {
                        return LongConstant.fromValue(constant.longValue() >>> constant2.charValue());
                    }
                    case 3: {
                        return LongConstant.fromValue(constant.longValue() >>> constant2.byteValue());
                    }
                    case 4: {
                        return LongConstant.fromValue(constant.longValue() >>> constant2.shortValue());
                    }
                    case 10: {
                        return LongConstant.fromValue(constant.longValue() >>> constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue(constant.longValue() >>> (int)constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationXOR(Constant constant, int n, Constant constant2, int n2) {
        switch (n) {
            case 5: {
                return BooleanConstant.fromValue(constant.booleanValue() ^ constant2.booleanValue());
            }
            case 2: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.charValue() ^ constant2.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.charValue() ^ constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.charValue() ^ constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.charValue() ^ constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.charValue() ^ constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.byteValue() ^ constant2.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.byteValue() ^ constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.byteValue() ^ constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.byteValue() ^ constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.byteValue() ^ constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.shortValue() ^ constant2.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.shortValue() ^ constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.shortValue() ^ constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.shortValue() ^ constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.shortValue() ^ constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n2) {
                    case 2: {
                        return IntConstant.fromValue(constant.intValue() ^ constant2.charValue());
                    }
                    case 3: {
                        return IntConstant.fromValue(constant.intValue() ^ constant2.byteValue());
                    }
                    case 4: {
                        return IntConstant.fromValue(constant.intValue() ^ constant2.shortValue());
                    }
                    case 10: {
                        return IntConstant.fromValue(constant.intValue() ^ constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue((long)constant.intValue() ^ constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n2) {
                    case 2: {
                        return LongConstant.fromValue(constant.longValue() ^ (long)constant2.charValue());
                    }
                    case 3: {
                        return LongConstant.fromValue(constant.longValue() ^ (long)constant2.byteValue());
                    }
                    case 4: {
                        return LongConstant.fromValue(constant.longValue() ^ (long)constant2.shortValue());
                    }
                    case 10: {
                        return LongConstant.fromValue(constant.longValue() ^ (long)constant2.intValue());
                    }
                    case 7: {
                        return LongConstant.fromValue(constant.longValue() ^ constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public double doubleValue() {
        throw new ShouldNotImplement(Messages.bind(Messages.constant_cannotCastedInto, new String[]{this.typeName(), "double"}));
    }

    public float floatValue() {
        throw new ShouldNotImplement(Messages.bind(Messages.constant_cannotCastedInto, new String[]{this.typeName(), "float"}));
    }

    public boolean hasSameValue(Constant constant) {
        if (this == constant) {
            return true;
        }
        int n = this.typeID();
        if (n != constant.typeID()) {
            return false;
        }
        switch (n) {
            case 5: {
                return this.booleanValue() == constant.booleanValue();
            }
            case 3: {
                return this.byteValue() == constant.byteValue();
            }
            case 2: {
                return this.charValue() == constant.charValue();
            }
            case 8: {
                return this.doubleValue() == constant.doubleValue();
            }
            case 9: {
                return this.floatValue() == constant.floatValue();
            }
            case 10: {
                return this.intValue() == constant.intValue();
            }
            case 4: {
                return this.shortValue() == constant.shortValue();
            }
            case 7: {
                return this.longValue() == constant.longValue();
            }
            case 11: {
                String string = this.stringValue();
                return string == null ? constant.stringValue() == null : string.equals(constant.stringValue());
            }
        }
        return false;
    }

    public int intValue() {
        throw new ShouldNotImplement(Messages.bind(Messages.constant_cannotCastedInto, new String[]{this.typeName(), "int"}));
    }

    public long longValue() {
        throw new ShouldNotImplement(Messages.bind(Messages.constant_cannotCastedInto, new String[]{this.typeName(), "long"}));
    }

    public short shortValue() {
        throw new ShouldNotImplement(Messages.bind(Messages.constant_cannotConvertedTo, new String[]{this.typeName(), "short"}));
    }

    public String stringValue() {
        throw new ShouldNotImplement(Messages.bind(Messages.constant_cannotConvertedTo, new String[]{this.typeName(), "String"}));
    }

    public String toString() {
        if (this == NotAConstant) {
            return "(Constant) NotAConstant";
        }
        return super.toString();
    }

    public abstract int typeID();

    public String typeName() {
        switch (this.typeID()) {
            case 10: {
                return "int";
            }
            case 3: {
                return "byte";
            }
            case 4: {
                return "short";
            }
            case 2: {
                return "char";
            }
            case 9: {
                return "float";
            }
            case 8: {
                return "double";
            }
            case 5: {
                return "boolean";
            }
            case 7: {
                return "long";
            }
            case 11: {
                return "java.lang.String";
            }
            case 12: {
                return "null";
            }
        }
        return "unknown";
    }
}

