/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public final class ArrayBinding
extends TypeBinding {
    public static final FieldBinding ArrayLength = new FieldBinding(TypeConstants.LENGTH, TypeBinding.INT, 17, null, Constant.NotAConstant);
    public TypeBinding leafComponentType;
    public int dimensions;
    LookupEnvironment environment;
    char[] constantPoolName;
    char[] genericTypeSignature;

    public ArrayBinding(TypeBinding typeBinding, int n, LookupEnvironment lookupEnvironment) {
        this.tagBits |= 1L;
        this.leafComponentType = typeBinding;
        this.dimensions = n;
        this.environment = lookupEnvironment;
        if (typeBinding instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)typeBinding).addWrapper(this);
        } else {
            this.tagBits |= typeBinding.tagBits & 0x60000000L;
        }
    }

    @Override
    public void collectSubstitutes(Scope scope, TypeBinding typeBinding, Map map, int n) {
        if ((this.tagBits & 0x20000000L) == 0L) {
            return;
        }
        if (typeBinding == TypeBinding.NULL) {
            return;
        }
        switch (typeBinding.kind()) {
            case 68: {
                int n2 = typeBinding.dimensions();
                if (n2 == this.dimensions) {
                    this.leafComponentType.collectSubstitutes(scope, typeBinding.leafComponentType(), map, n);
                    break;
                }
                if (n2 <= this.dimensions) break;
                ArrayBinding arrayBinding = this.environment.createArrayType(typeBinding.leafComponentType(), n2 - this.dimensions);
                this.leafComponentType.collectSubstitutes(scope, arrayBinding, map, n);
                break;
            }
        }
    }

    @Override
    public char[] computeUniqueKey(boolean bl) {
        char[] cArray = new char[this.dimensions];
        for (int i = this.dimensions - 1; i >= 0; --i) {
            cArray[i] = 91;
        }
        return CharOperation.concat(cArray, this.leafComponentType.computeUniqueKey(bl));
    }

    @Override
    public char[] constantPoolName() {
        if (this.constantPoolName != null) {
            return this.constantPoolName;
        }
        char[] cArray = new char[this.dimensions];
        for (int i = this.dimensions - 1; i >= 0; --i) {
            cArray[i] = 91;
        }
        this.constantPoolName = CharOperation.concat(cArray, this.leafComponentType.signature());
        return this.constantPoolName;
    }

    @Override
    public String debugName() {
        StringBuffer stringBuffer = new StringBuffer(this.dimensions * 2);
        int n = this.dimensions;
        while (--n >= 0) {
            stringBuffer.append("[]");
        }
        return this.leafComponentType.debugName() + stringBuffer.toString();
    }

    @Override
    public int dimensions() {
        return this.dimensions;
    }

    public TypeBinding elementsType() {
        if (this.dimensions == 1) {
            return this.leafComponentType;
        }
        return this.environment.createArrayType(this.leafComponentType, this.dimensions - 1);
    }

    @Override
    public TypeBinding erasure() {
        TypeBinding typeBinding = this.leafComponentType.erasure();
        if (this.leafComponentType != typeBinding) {
            return this.environment.createArrayType(typeBinding, this.dimensions);
        }
        return this;
    }

    public LookupEnvironment environment() {
        return this.environment;
    }

    @Override
    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            char[] cArray = new char[this.dimensions];
            for (int i = this.dimensions - 1; i >= 0; --i) {
                cArray[i] = 91;
            }
            this.genericTypeSignature = CharOperation.concat(cArray, this.leafComponentType.genericTypeSignature());
        }
        return this.genericTypeSignature;
    }

    @Override
    public PackageBinding getPackage() {
        return this.leafComponentType.getPackage();
    }

    public int hashCode() {
        return this.leafComponentType == null ? super.hashCode() : this.leafComponentType.hashCode();
    }

    @Override
    public boolean isCompatibleWith(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        switch (typeBinding.kind()) {
            case 68: {
                ArrayBinding arrayBinding = (ArrayBinding)typeBinding;
                if (arrayBinding.leafComponentType.isBaseType()) {
                    return false;
                }
                if (this.dimensions == arrayBinding.dimensions) {
                    return this.leafComponentType.isCompatibleWith(arrayBinding.leafComponentType);
                }
                if (this.dimensions >= arrayBinding.dimensions) break;
                return false;
            }
            case 132: {
                return false;
            }
            case 516: {
                return ((WildcardBinding)typeBinding).boundCheck(this);
            }
            case 4100: {
                if (typeBinding.isCapture()) {
                    CaptureBinding captureBinding = (CaptureBinding)typeBinding;
                    TypeBinding typeBinding2 = captureBinding.lowerBound;
                    if (typeBinding2 != null) {
                        if (!typeBinding2.isArrayType()) {
                            return false;
                        }
                        return this.isCompatibleWith(typeBinding2);
                    }
                }
                return false;
            }
        }
        switch (typeBinding.leafComponentType().id) {
            case 1: 
            case 36: 
            case 37: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int kind() {
        return 68;
    }

    @Override
    public TypeBinding leafComponentType() {
        return this.leafComponentType;
    }

    @Override
    public int problemId() {
        return this.leafComponentType.problemId();
    }

    @Override
    public char[] qualifiedSourceName() {
        char[] cArray = new char[this.dimensions * 2];
        for (int i = this.dimensions * 2 - 1; i >= 0; i -= 2) {
            cArray[i] = 93;
            cArray[i - 1] = 91;
        }
        return CharOperation.concat(this.leafComponentType.qualifiedSourceName(), cArray);
    }

    @Override
    public char[] readableName() {
        char[] cArray = new char[this.dimensions * 2];
        for (int i = this.dimensions * 2 - 1; i >= 0; i -= 2) {
            cArray[i] = 93;
            cArray[i - 1] = 91;
        }
        return CharOperation.concat(this.leafComponentType.readableName(), cArray);
    }

    @Override
    public char[] shortReadableName() {
        char[] cArray = new char[this.dimensions * 2];
        for (int i = this.dimensions * 2 - 1; i >= 0; i -= 2) {
            cArray[i] = 93;
            cArray[i - 1] = 91;
        }
        return CharOperation.concat(this.leafComponentType.shortReadableName(), cArray);
    }

    @Override
    public char[] sourceName() {
        char[] cArray = new char[this.dimensions * 2];
        for (int i = this.dimensions * 2 - 1; i >= 0; i -= 2) {
            cArray[i] = 93;
            cArray[i - 1] = 91;
        }
        return CharOperation.concat(this.leafComponentType.sourceName(), cArray);
    }

    @Override
    public void swapUnresolved(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment) {
        if (this.leafComponentType == unresolvedReferenceBinding) {
            this.leafComponentType = lookupEnvironment.convertUnresolvedBinaryToRawType(referenceBinding);
            this.tagBits |= this.leafComponentType.tagBits & 0x60000000L;
        }
    }

    public String toString() {
        return this.leafComponentType != null ? this.debugName() : "NULL TYPE ARRAY";
    }
}

