/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.HashMap;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;

public class ClassScope
extends Scope {
    public TypeDeclaration referenceContext;
    public TypeReference superTypeReference;

    public ClassScope(Scope scope, TypeDeclaration typeDeclaration) {
        super(3, scope);
        this.referenceContext = typeDeclaration;
    }

    void buildAnonymousTypeBinding(SourceTypeBinding sourceTypeBinding, ReferenceBinding referenceBinding) {
        LocalTypeBinding localTypeBinding = this.buildLocalType(sourceTypeBinding, sourceTypeBinding.fPackage);
        SourceTypeBinding sourceTypeBinding2 = this.referenceContext.binding;
        if (referenceBinding.isInterface()) {
            sourceTypeBinding2.superclass = this.getJavaLangObject();
            sourceTypeBinding2.superInterfaces = new ReferenceBinding[]{referenceBinding};
        } else {
            sourceTypeBinding2.superclass = referenceBinding;
            sourceTypeBinding2.superInterfaces = Binding.NO_SUPERINTERFACES;
        }
        this.connectMemberTypes();
        this.buildFieldsAndMethods();
        localTypeBinding.faultInTypesForFieldsAndMethods();
        sourceTypeBinding2.verifyMethods(this.environment().methodVerifier());
    }

    private void buildFields() {
        FieldBinding fieldBinding;
        if (this.referenceContext.fields == null) {
            this.referenceContext.binding.setFields(Binding.NO_FIELDS);
            return;
        }
        FieldDeclaration[] fieldDeclarationArray = this.referenceContext.fields;
        int n = fieldDeclarationArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            switch (fieldDeclarationArray[i].getKind()) {
                case 1: 
                case 3: {
                    ++n2;
                }
            }
        }
        FieldBinding[] fieldBindingArray = new FieldBinding[n2];
        HashtableOfObject hashtableOfObject = new HashtableOfObject(n2);
        boolean bl = false;
        n2 = 0;
        for (int i = 0; i < n; ++i) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[i];
            if (fieldDeclaration.getKind() == 2) {
                if (!this.referenceContext.binding.isInterface()) continue;
                this.problemReporter().interfaceCannotHaveInitializers(this.referenceContext.binding, fieldDeclaration);
                continue;
            }
            fieldBinding = new FieldBinding(fieldDeclaration, null, fieldDeclaration.modifiers | 0x2000000, this.referenceContext.binding);
            fieldBinding.id = n2;
            this.checkAndSetModifiersForField(fieldBinding, fieldDeclaration);
            if (hashtableOfObject.containsKey(fieldDeclaration.name)) {
                bl = true;
                FieldBinding fieldBinding2 = (FieldBinding)hashtableOfObject.get(fieldDeclaration.name);
                if (fieldBinding2 != null) {
                    for (int j = 0; j < i; ++j) {
                        FieldDeclaration fieldDeclaration2 = fieldDeclarationArray[j];
                        if (fieldDeclaration2.binding != fieldBinding2) continue;
                        this.problemReporter().duplicateFieldInType(this.referenceContext.binding, fieldDeclaration2);
                        fieldDeclaration2.binding = null;
                        break;
                    }
                }
                hashtableOfObject.put(fieldDeclaration.name, null);
                this.problemReporter().duplicateFieldInType(this.referenceContext.binding, fieldDeclaration);
                fieldDeclaration.binding = null;
                continue;
            }
            hashtableOfObject.put(fieldDeclaration.name, fieldBinding);
            if (fieldBinding == null) continue;
            fieldBindingArray[n2++] = fieldBinding;
        }
        if (bl) {
            FieldBinding[] fieldBindingArray2 = new FieldBinding[fieldBindingArray.length];
            n = n2;
            n2 = 0;
            for (int i = 0; i < n; ++i) {
                fieldBinding = fieldBindingArray[i];
                if (hashtableOfObject.get(fieldBinding.name) == null) continue;
                fieldBinding.id = n2;
                fieldBindingArray2[n2++] = fieldBinding;
            }
            fieldBindingArray = fieldBindingArray2;
        }
        if (n2 != fieldBindingArray.length) {
            FieldBinding[] fieldBindingArray3 = fieldBindingArray;
            fieldBindingArray = new FieldBinding[n2];
            System.arraycopy(fieldBindingArray3, 0, fieldBindingArray, 0, n2);
        }
        this.referenceContext.binding.setFields(fieldBindingArray);
    }

    void buildFieldsAndMethods() {
        this.buildFields();
        this.buildMethods();
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        if (sourceTypeBinding.isMemberType() && !sourceTypeBinding.isLocalType()) {
            ((MemberTypeBinding)sourceTypeBinding).checkSyntheticArgsAndFields();
        }
        ReferenceBinding[] referenceBindingArray = sourceTypeBinding.memberTypes;
        int n = referenceBindingArray.length;
        for (int i = 0; i < n; ++i) {
            ((SourceTypeBinding)referenceBindingArray[i]).scope.buildFieldsAndMethods();
        }
    }

    private LocalTypeBinding buildLocalType(SourceTypeBinding sourceTypeBinding, PackageBinding packageBinding) {
        this.referenceContext.scope = this;
        this.referenceContext.staticInitializerScope = new MethodScope(this, this.referenceContext, true);
        this.referenceContext.initializerScope = new MethodScope(this, this.referenceContext, false);
        LocalTypeBinding localTypeBinding = new LocalTypeBinding(this, sourceTypeBinding, this.innermostSwitchCase());
        this.referenceContext.binding = localTypeBinding;
        this.checkAndSetModifiers();
        this.buildTypeVariables();
        ReferenceBinding[] referenceBindingArray = Binding.NO_MEMBER_TYPES;
        if (this.referenceContext.memberTypes != null) {
            int n = this.referenceContext.memberTypes.length;
            referenceBindingArray = new ReferenceBinding[n];
            int n2 = 0;
            block3: for (int i = 0; i < n; ++i) {
                TypeDeclaration typeDeclaration = this.referenceContext.memberTypes[i];
                switch (TypeDeclaration.kind(typeDeclaration.modifiers)) {
                    case 2: 
                    case 4: {
                        this.problemReporter().illegalLocalTypeDeclaration(typeDeclaration);
                        continue block3;
                    }
                    default: {
                        ReferenceBinding referenceBinding = localTypeBinding;
                        do {
                            if (!CharOperation.equals(referenceBinding.sourceName, typeDeclaration.name)) continue;
                            this.problemReporter().hidingEnclosingType(typeDeclaration);
                            continue block3;
                        } while ((referenceBinding = ((TypeBinding)referenceBinding).enclosingType()) != null);
                        for (int j = 0; j < i; ++j) {
                            if (!CharOperation.equals(this.referenceContext.memberTypes[j].name, typeDeclaration.name)) continue;
                            this.problemReporter().duplicateNestedType(typeDeclaration);
                            continue block3;
                        }
                        ClassScope classScope = new ClassScope(this, this.referenceContext.memberTypes[i]);
                        LocalTypeBinding localTypeBinding2 = classScope.buildLocalType(localTypeBinding, packageBinding);
                        localTypeBinding2.setAsMemberType();
                        referenceBindingArray[n2++] = localTypeBinding2;
                    }
                }
            }
            if (n2 != n) {
                ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2];
                System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 0, n2);
            }
        }
        localTypeBinding.memberTypes = referenceBindingArray;
        return localTypeBinding;
    }

    void buildLocalTypeBinding(SourceTypeBinding sourceTypeBinding) {
        LocalTypeBinding localTypeBinding = this.buildLocalType(sourceTypeBinding, sourceTypeBinding.fPackage);
        this.connectTypeHierarchy();
        this.buildFieldsAndMethods();
        localTypeBinding.faultInTypesForFieldsAndMethods();
        this.referenceContext.binding.verifyMethods(this.environment().methodVerifier());
    }

    private void buildMemberTypes(AccessRestriction accessRestriction) {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        ReferenceBinding[] referenceBindingArray = Binding.NO_MEMBER_TYPES;
        if (this.referenceContext.memberTypes != null) {
            int n = this.referenceContext.memberTypes.length;
            referenceBindingArray = new ReferenceBinding[n];
            int n2 = 0;
            block3: for (int i = 0; i < n; ++i) {
                TypeDeclaration typeDeclaration = this.referenceContext.memberTypes[i];
                switch (TypeDeclaration.kind(typeDeclaration.modifiers)) {
                    case 2: 
                    case 4: {
                        if (sourceTypeBinding.isNestedType() && sourceTypeBinding.isClass() && !sourceTypeBinding.isStatic()) {
                            this.problemReporter().illegalLocalTypeDeclaration(typeDeclaration);
                            continue block3;
                        }
                    }
                    default: {
                        ReferenceBinding referenceBinding = sourceTypeBinding;
                        do {
                            if (!CharOperation.equals(referenceBinding.sourceName, typeDeclaration.name)) continue;
                            this.problemReporter().hidingEnclosingType(typeDeclaration);
                            continue block3;
                        } while ((referenceBinding = referenceBinding.enclosingType()) != null);
                        for (int j = 0; j < i; ++j) {
                            if (!CharOperation.equals(this.referenceContext.memberTypes[j].name, typeDeclaration.name)) continue;
                            this.problemReporter().duplicateNestedType(typeDeclaration);
                            continue block3;
                        }
                        ClassScope classScope = new ClassScope(this, typeDeclaration);
                        referenceBindingArray[n2++] = classScope.buildType(sourceTypeBinding, sourceTypeBinding.fPackage, accessRestriction);
                    }
                }
            }
            if (n2 != n) {
                ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2];
                System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 0, n2);
            }
        }
        sourceTypeBinding.memberTypes = referenceBindingArray;
    }

    private void buildMethods() {
        int n;
        boolean bl;
        boolean bl2 = bl = TypeDeclaration.kind(this.referenceContext.modifiers) == 3;
        if (this.referenceContext.methods == null && !bl) {
            this.referenceContext.binding.setMethods(Binding.NO_METHODS);
            return;
        }
        AbstractMethodDeclaration[] abstractMethodDeclarationArray = this.referenceContext.methods;
        int n2 = abstractMethodDeclarationArray == null ? 0 : abstractMethodDeclarationArray.length;
        int n3 = -1;
        for (n = 0; n < n2; ++n) {
            if (!abstractMethodDeclarationArray[n].isClinit()) continue;
            n3 = n;
            break;
        }
        n = bl ? 2 : 0;
        MethodBinding[] methodBindingArray = new MethodBinding[(n3 == -1 ? n2 : n2 - 1) + n];
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        if (bl) {
            methodBindingArray[0] = sourceTypeBinding.addSyntheticEnumMethod(TypeConstants.VALUES);
            methodBindingArray[1] = sourceTypeBinding.addSyntheticEnumMethod(TypeConstants.VALUEOF);
        }
        for (int i = 0; i < n2; ++i) {
            MethodScope methodScope;
            MethodBinding methodBinding;
            if (i == n3 || (methodBinding = (methodScope = new MethodScope(this, abstractMethodDeclarationArray[i], false)).createMethod(abstractMethodDeclarationArray[i])) == null) continue;
            methodBindingArray[n++] = methodBinding;
        }
        if (n != methodBindingArray.length) {
            MethodBinding[] methodBindingArray2 = methodBindingArray;
            methodBindingArray = new MethodBinding[n];
            System.arraycopy(methodBindingArray2, 0, methodBindingArray, 0, n);
        }
        sourceTypeBinding.tagBits &= 0xFFFFFFFFFFFFBFFFL;
        sourceTypeBinding.setMethods(methodBindingArray);
    }

    SourceTypeBinding buildType(SourceTypeBinding sourceTypeBinding, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        Object object;
        this.referenceContext.scope = this;
        this.referenceContext.staticInitializerScope = new MethodScope(this, this.referenceContext, true);
        this.referenceContext.initializerScope = new MethodScope(this, this.referenceContext, false);
        if (sourceTypeBinding == null) {
            object = CharOperation.arrayConcat(packageBinding.compoundName, this.referenceContext.name);
            this.referenceContext.binding = new SourceTypeBinding((char[][])object, packageBinding, this);
        } else {
            object = CharOperation.deepCopy(sourceTypeBinding.compoundName);
            object[((char[][])object).length - 1] = CharOperation.concat(object[((char[][])object).length - 1], this.referenceContext.name, '$');
            this.referenceContext.binding = new MemberTypeBinding((char[][])object, this, sourceTypeBinding);
        }
        object = this.referenceContext.binding;
        this.environment().setAccessRestriction((ReferenceBinding)object, accessRestriction);
        object.fPackage.addType((ReferenceBinding)object);
        this.checkAndSetModifiers();
        this.buildTypeVariables();
        this.buildMemberTypes(accessRestriction);
        return object;
    }

    private void buildTypeVariables() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        TypeParameter[] typeParameterArray = this.referenceContext.typeParameters;
        if (typeParameterArray == null || this.compilerOptions().sourceLevel < 0x310000L) {
            sourceTypeBinding.typeVariables = Binding.NO_TYPE_VARIABLES;
            return;
        }
        sourceTypeBinding.typeVariables = Binding.NO_TYPE_VARIABLES;
        if (sourceTypeBinding.id == 1) {
            this.problemReporter().objectCannotBeGeneric(this.referenceContext);
            return;
        }
        sourceTypeBinding.typeVariables = this.createTypeVariables(typeParameterArray, sourceTypeBinding);
        sourceTypeBinding.modifiers |= 0x40000000;
    }

    private void checkAndSetModifiers() {
        int n;
        Binding binding;
        TypeIds typeIds;
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        int n2 = sourceTypeBinding.modifiers;
        if ((n2 & 0x400000) != 0) {
            this.problemReporter().duplicateModifierForType(sourceTypeBinding);
        }
        ReferenceBinding referenceBinding = sourceTypeBinding.enclosingType();
        boolean bl = sourceTypeBinding.isMemberType();
        if (bl) {
            n2 |= referenceBinding.modifiers & 0x40000800;
            if (referenceBinding.isInterface()) {
                n2 |= 1;
            }
            if (sourceTypeBinding.isEnum()) {
                if (!referenceBinding.isStatic()) {
                    this.problemReporter().nonStaticContextForEnumMemberType(sourceTypeBinding);
                } else {
                    n2 |= 8;
                }
            }
        } else if (sourceTypeBinding.isLocalType()) {
            if (sourceTypeBinding.isEnum()) {
                this.problemReporter().illegalLocalTypeDeclaration(this.referenceContext);
                sourceTypeBinding.modifiers = 0;
                return;
            }
            if (sourceTypeBinding.isAnonymousType()) {
                n2 |= 0x10;
                if (this.referenceContext.allocation.type == null) {
                    n2 |= 0x4000;
                }
            }
            Scope scope = this;
            block4: do {
                switch (scope.kind) {
                    case 2: {
                        typeIds = (MethodScope)scope;
                        if (typeIds.isInsideInitializer()) {
                            binding = ((TypeDeclaration)typeIds.referenceContext).binding;
                            if (typeIds.initializedField != null) {
                                if (!typeIds.initializedField.isViewedAsDeprecated() || sourceTypeBinding.isDeprecated()) continue block4;
                                n2 |= 0x200000;
                                break;
                            }
                            if (((ReferenceBinding)binding).isStrictfp()) {
                                n2 |= 0x800;
                            }
                            if (!((ReferenceBinding)binding).isViewedAsDeprecated() || sourceTypeBinding.isDeprecated()) continue block4;
                            n2 |= 0x200000;
                            break;
                        }
                        binding = ((AbstractMethodDeclaration)typeIds.referenceContext).binding;
                        if (binding == null) continue block4;
                        if (((MethodBinding)binding).isStrictfp()) {
                            n2 |= 0x800;
                        }
                        if (!((MethodBinding)binding).isViewedAsDeprecated() || sourceTypeBinding.isDeprecated()) continue block4;
                        n2 |= 0x200000;
                        break;
                    }
                    case 3: {
                        if (referenceBinding.isStrictfp()) {
                            n2 |= 0x800;
                        }
                        if (!referenceBinding.isViewedAsDeprecated() || sourceTypeBinding.isDeprecated()) continue block4;
                        n2 |= 0x200000;
                    }
                }
            } while ((scope = scope.parent) != null);
        }
        if (((n = n2 & 0xFFFF) & 0x200) != 0) {
            if (bl) {
                if ((n & 0xFFFFD1F0) != 0) {
                    if ((n & 0x2000) != 0) {
                        this.problemReporter().illegalModifierForAnnotationMemberType(sourceTypeBinding);
                    } else {
                        this.problemReporter().illegalModifierForMemberInterface(sourceTypeBinding);
                    }
                }
            } else if ((n & 0xFFFFD1FE) != 0) {
                if ((n & 0x2000) != 0) {
                    this.problemReporter().illegalModifierForAnnotationType(sourceTypeBinding);
                } else {
                    this.problemReporter().illegalModifierForInterface(sourceTypeBinding);
                }
            }
            n2 |= 0x400;
        } else if ((n & 0x4000) != 0) {
            if (bl) {
                if ((n & 0xFFFFB7F0) != 0) {
                    this.problemReporter().illegalModifierForMemberEnum(sourceTypeBinding);
                }
            } else if (sourceTypeBinding.isLocalType()) {
                if ((n & 0xFFFFB7EF) != 0) {
                    this.problemReporter().illegalModifierForLocalEnum(sourceTypeBinding);
                }
            } else if ((n & 0xFFFFB7FE) != 0) {
                this.problemReporter().illegalModifierForEnum(sourceTypeBinding);
            }
            if (!sourceTypeBinding.isAnonymousType()) {
                block77: {
                    if ((this.referenceContext.bits & 0x800) != 0) {
                        n2 |= 0x400;
                    } else {
                        int n3;
                        typeIds = this.referenceContext;
                        binding = ((TypeDeclaration)typeIds).fields;
                        int n4 = n3 = binding == null ? 0 : ((Binding)binding).length;
                        if (n3 != 0) {
                            int n5;
                            AbstractMethodDeclaration[] abstractMethodDeclarationArray = ((TypeDeclaration)typeIds).methods;
                            int n6 = abstractMethodDeclarationArray == null ? 0 : abstractMethodDeclarationArray.length;
                            boolean bl2 = ((TypeDeclaration)typeIds).superInterfaces != null;
                            for (n5 = 0; n5 < n6 && !bl2; ++n5) {
                                bl2 = abstractMethodDeclarationArray[n5].isAbstract();
                            }
                            if (bl2) {
                                n5 = 0;
                                for (int i = 0; i < n3; ++i) {
                                    Binding binding2 = binding[i];
                                    if (((FieldDeclaration)((Object)binding2)).getKind() != 3) continue;
                                    if (((FieldDeclaration)((Object)binding2)).initialization instanceof QualifiedAllocationExpression) {
                                        n5 = 1;
                                        continue;
                                    }
                                    break block77;
                                }
                                if (n5 != 0) {
                                    n2 |= 0x400;
                                }
                            }
                        }
                    }
                }
                typeIds = this.referenceContext;
                binding = ((TypeDeclaration)typeIds).fields;
                if (binding != null) {
                    for (Binding binding3 : binding) {
                        if (((FieldDeclaration)((Object)binding3)).getKind() != 3 || !(((FieldDeclaration)((Object)binding3)).initialization instanceof QualifiedAllocationExpression)) {
                            continue;
                        }
                        break;
                    }
                } else {
                    n2 |= 0x10;
                }
            }
        } else {
            if (bl) {
                if ((n & 0xFFFFF3E0) != 0) {
                    this.problemReporter().illegalModifierForMemberClass(sourceTypeBinding);
                }
            } else if (sourceTypeBinding.isLocalType()) {
                if ((n & 0xFFFFF3EF) != 0) {
                    this.problemReporter().illegalModifierForLocalClass(sourceTypeBinding);
                }
            } else if ((n & 0xFFFFF3EE) != 0) {
                this.problemReporter().illegalModifierForClass(sourceTypeBinding);
            }
            if ((n & 0x410) == 1040) {
                this.problemReporter().illegalModifierCombinationFinalAbstractForClass(sourceTypeBinding);
            }
        }
        if (bl) {
            if (referenceBinding.isInterface()) {
                if ((n & 6) != 0) {
                    this.problemReporter().illegalVisibilityModifierForInterfaceMemberType(sourceTypeBinding);
                    if ((n & 4) != 0) {
                        n2 &= 0xFFFFFFFB;
                    }
                    if ((n & 2) != 0) {
                        n2 &= 0xFFFFFFFD;
                    }
                }
            } else {
                int n7 = n & 7;
                if ((n7 & n7 - 1) > 1) {
                    this.problemReporter().illegalVisibilityModifierCombinationForMemberType(sourceTypeBinding);
                    if ((n7 & 1) != 0) {
                        if ((n7 & 4) != 0) {
                            n2 &= 0xFFFFFFFB;
                        }
                        if ((n7 & 2) != 0) {
                            n2 &= 0xFFFFFFFD;
                        }
                    } else if ((n7 & 4) != 0 && (n7 & 2) != 0) {
                        n2 &= 0xFFFFFFFD;
                    }
                }
            }
            if ((n & 8) == 0) {
                if (referenceBinding.isInterface()) {
                    n2 |= 8;
                }
            } else if (!referenceBinding.isStatic()) {
                this.problemReporter().illegalStaticModifierForMemberType(sourceTypeBinding);
            }
        }
        sourceTypeBinding.modifiers = n2;
    }

    private void checkAndSetModifiersForField(FieldBinding fieldBinding, FieldDeclaration fieldDeclaration) {
        int n;
        int n2 = fieldBinding.modifiers;
        ReferenceBinding referenceBinding = fieldBinding.declaringClass;
        if ((n2 & 0x400000) != 0) {
            this.problemReporter().duplicateModifierForField(referenceBinding, fieldDeclaration);
        }
        if (referenceBinding.isInterface()) {
            if (((n2 |= 0x19) & 0xFFFF) != 25) {
                if ((referenceBinding.modifiers & 0x2000) != 0) {
                    this.problemReporter().illegalModifierForAnnotationField(fieldDeclaration);
                } else {
                    this.problemReporter().illegalModifierForInterfaceField(fieldDeclaration);
                }
            }
            fieldBinding.modifiers = n2;
            return;
        }
        if (fieldDeclaration.getKind() == 3) {
            if ((n2 & 0xFFFF) != 0) {
                this.problemReporter().illegalModifierForEnumConstant(referenceBinding, fieldDeclaration);
            }
            fieldBinding.modifiers |= 0x4019;
            return;
        }
        int n3 = n2 & 0xFFFF;
        if ((n3 & 0xFFFFFF20) != 0) {
            this.problemReporter().illegalModifierForField(referenceBinding, fieldDeclaration);
            n2 &= 0xFFFF00DF;
        }
        if (((n = n3 & 7) & n - 1) > 1) {
            this.problemReporter().illegalVisibilityModifierCombinationForField(referenceBinding, fieldDeclaration);
            if ((n & 1) != 0) {
                if ((n & 4) != 0) {
                    n2 &= 0xFFFFFFFB;
                }
                if ((n & 2) != 0) {
                    n2 &= 0xFFFFFFFD;
                }
            } else if ((n & 4) != 0 && (n & 2) != 0) {
                n2 &= 0xFFFFFFFD;
            }
        }
        if ((n3 & 0x50) == 80) {
            this.problemReporter().illegalModifierCombinationFinalVolatileForField(referenceBinding, fieldDeclaration);
        }
        if (fieldDeclaration.initialization == null && (n2 & 0x10) != 0) {
            n2 |= 0x4000000;
        }
        fieldBinding.modifiers = n2;
    }

    public void checkParameterizedSuperTypeCollisions() {
        int n;
        ReferenceBinding referenceBinding;
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        ReferenceBinding[] referenceBindingArray = sourceTypeBinding.superInterfaces;
        HashMap hashMap = new HashMap(2);
        ReferenceBinding referenceBinding2 = sourceTypeBinding.isInterface() ? null : sourceTypeBinding.superclass;
        int n2 = referenceBindingArray.length;
        for (int i = 0; i < n2; ++i) {
            ReferenceBinding referenceBinding3 = referenceBindingArray[i];
            if (referenceBinding3 == null || referenceBinding2 != null && this.hasErasedCandidatesCollisions(referenceBinding2, referenceBinding3, hashMap, sourceTypeBinding, this.referenceContext)) continue;
            for (int j = 0; !(j >= i || (referenceBinding = referenceBindingArray[j]) != null && this.hasErasedCandidatesCollisions(referenceBinding3, referenceBinding, hashMap, sourceTypeBinding, this.referenceContext)); ++j) {
            }
        }
        TypeParameter[] typeParameterArray = this.referenceContext.typeParameters;
        int n3 = n = typeParameterArray == null ? 0 : typeParameterArray.length;
        block2: for (n2 = 0; n2 < n; ++n2) {
            TypeReference[] typeReferenceArray;
            TypeParameter typeParameter = typeParameterArray[n2];
            referenceBinding = typeParameter.binding;
            if (referenceBinding == null || !referenceBinding.isValidBinding() || (typeReferenceArray = typeParameter.bounds) == null) continue;
            boolean bl = ((TypeVariableBinding)referenceBinding).firstBound == ((TypeVariableBinding)referenceBinding).superclass;
            int n4 = typeReferenceArray.length;
            for (int i = 0; i < n4; ++i) {
                TypeReference typeReference = typeReferenceArray[i];
                TypeBinding typeBinding = typeReference.resolvedType;
                if (typeBinding == null || !typeBinding.isValidBinding()) continue;
                if (bl && this.hasErasedCandidatesCollisions(typeBinding, ((TypeVariableBinding)referenceBinding).superclass, hashMap, referenceBinding, typeReference)) continue block2;
                int n5 = ((TypeVariableBinding)referenceBinding).superInterfaces.length;
                while (--n5 >= 0) {
                    if (!this.hasErasedCandidatesCollisions(typeBinding, ((TypeVariableBinding)referenceBinding).superInterfaces[n5], hashMap, referenceBinding, typeReference)) continue;
                    continue block2;
                }
            }
        }
        ReferenceBinding[] referenceBindingArray2 = this.referenceContext.binding.memberTypes;
        if (referenceBindingArray2 != null && referenceBindingArray2 != Binding.NO_MEMBER_TYPES) {
            int n6 = referenceBindingArray2.length;
            for (n = 0; n < n6; ++n) {
                ((SourceTypeBinding)referenceBindingArray2[n]).scope.checkParameterizedSuperTypeCollisions();
            }
        }
    }

    private void checkForInheritedMemberTypes(SourceTypeBinding sourceTypeBinding) {
        int n;
        ReferenceBinding[] referenceBindingArray;
        int n2;
        ReferenceBinding referenceBinding = sourceTypeBinding;
        ReferenceBinding[] referenceBindingArray2 = null;
        int n3 = 0;
        do {
            if (referenceBinding.hasMemberTypes()) {
                return;
            }
            ReferenceBinding[] referenceBindingArray3 = referenceBinding.superInterfaces();
            if (referenceBindingArray3 == null || referenceBindingArray3 == Binding.NO_SUPERINTERFACES) continue;
            if (referenceBindingArray2 == null) {
                referenceBindingArray2 = referenceBindingArray3;
                n3 = referenceBindingArray2.length;
                continue;
            }
            n2 = referenceBindingArray3.length;
            if (n3 + n2 >= referenceBindingArray2.length) {
                ReferenceBinding[] referenceBindingArray4 = referenceBindingArray2;
                referenceBindingArray2 = new ReferenceBinding[n3 + n2 + 5];
                System.arraycopy(referenceBindingArray4, 0, referenceBindingArray2, 0, n3);
            }
            block1: for (int i = 0; i < n2; ++i) {
                referenceBindingArray = referenceBindingArray3[i];
                for (n = 0; n < n3; ++n) {
                    if (referenceBindingArray == referenceBindingArray2[n]) continue block1;
                }
                referenceBindingArray2[n3++] = referenceBindingArray;
            }
        } while ((referenceBinding = referenceBinding.superclass()) != null && (referenceBinding.tagBits & 0x10000L) == 0L);
        if (referenceBindingArray2 != null) {
            boolean bl = false;
            for (n2 = 0; n2 < n3; ++n2) {
                ReferenceBinding referenceBinding2 = referenceBindingArray2[n2];
                if ((referenceBinding2.tagBits & 0x10000L) != 0L) continue;
                if (referenceBinding2.hasMemberTypes()) {
                    return;
                }
                bl = true;
                referenceBindingArray = referenceBinding2.superInterfaces();
                if (referenceBindingArray == null || referenceBindingArray == Binding.NO_SUPERINTERFACES) continue;
                n = referenceBindingArray.length;
                if (n3 + n >= referenceBindingArray2.length) {
                    ReferenceBinding[] referenceBindingArray5 = referenceBindingArray2;
                    referenceBindingArray2 = new ReferenceBinding[n3 + n + 5];
                    System.arraycopy(referenceBindingArray5, 0, referenceBindingArray2, 0, n3);
                }
                block4: for (int i = 0; i < n; ++i) {
                    ReferenceBinding referenceBinding3 = referenceBindingArray[i];
                    for (int j = 0; j < n3; ++j) {
                        if (referenceBinding3 == referenceBindingArray2[j]) continue block4;
                    }
                    referenceBindingArray2[n3++] = referenceBinding3;
                }
            }
            if (bl) {
                for (n2 = 0; n2 < n3; ++n2) {
                    referenceBindingArray2[n2].tagBits |= 0x10000L;
                }
            }
        }
        referenceBinding = sourceTypeBinding;
        do {
            referenceBinding.tagBits |= 0x10000L;
        } while ((referenceBinding = referenceBinding.superclass()) != null && (referenceBinding.tagBits & 0x10000L) == 0L);
    }

    public void checkParameterizedTypeBounds() {
        ReferenceBinding[] referenceBindingArray;
        int n;
        TypeParameter[] typeParameterArray;
        int n2;
        TypeReference[] typeReferenceArray;
        TypeReference typeReference = this.referenceContext.superclass;
        if (typeReference != null) {
            typeReference.checkBounds(this);
        }
        if ((typeReferenceArray = this.referenceContext.superInterfaces) != null) {
            n2 = typeReferenceArray.length;
            for (int i = 0; i < n2; ++i) {
                typeReferenceArray[i].checkBounds(this);
            }
        }
        if ((typeParameterArray = this.referenceContext.typeParameters) != null) {
            n = typeParameterArray.length;
            for (n2 = 0; n2 < n; ++n2) {
                typeParameterArray[n2].checkBounds(this);
            }
        }
        if ((referenceBindingArray = this.referenceContext.binding.memberTypes) != null && referenceBindingArray != Binding.NO_MEMBER_TYPES) {
            int n3 = referenceBindingArray.length;
            for (n = 0; n < n3; ++n) {
                ((SourceTypeBinding)referenceBindingArray[n]).scope.checkParameterizedTypeBounds();
            }
        }
    }

    private void connectMemberTypes() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        ReferenceBinding[] referenceBindingArray = sourceTypeBinding.memberTypes;
        if (referenceBindingArray != null && referenceBindingArray != Binding.NO_MEMBER_TYPES) {
            int n = referenceBindingArray.length;
            for (int i = 0; i < n; ++i) {
                ((SourceTypeBinding)referenceBindingArray[i]).scope.connectTypeHierarchy();
            }
        }
    }

    private boolean connectSuperclass() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        if (sourceTypeBinding.id == 1) {
            sourceTypeBinding.superclass = null;
            sourceTypeBinding.superInterfaces = Binding.NO_SUPERINTERFACES;
            if (!sourceTypeBinding.isClass()) {
                this.problemReporter().objectMustBeClass(sourceTypeBinding);
            }
            if (this.referenceContext.superclass != null || this.referenceContext.superInterfaces != null && this.referenceContext.superInterfaces.length > 0) {
                this.problemReporter().objectCannotHaveSuperTypes(sourceTypeBinding);
            }
            return true;
        }
        if (this.referenceContext.superclass == null) {
            if (sourceTypeBinding.isEnum() && this.compilerOptions().sourceLevel >= 0x310000L) {
                return this.connectEnumSuperclass();
            }
            sourceTypeBinding.superclass = this.getJavaLangObject();
            return !this.detectHierarchyCycle(sourceTypeBinding, sourceTypeBinding.superclass, null);
        }
        TypeReference typeReference = this.referenceContext.superclass;
        ReferenceBinding referenceBinding = this.findSupertype(typeReference);
        if (referenceBinding != null) {
            if (!referenceBinding.isClass()) {
                this.problemReporter().superclassMustBeAClass(sourceTypeBinding, typeReference, referenceBinding);
            } else if (referenceBinding.isFinal()) {
                this.problemReporter().classExtendFinalClass(sourceTypeBinding, typeReference, referenceBinding);
            } else if ((referenceBinding.tagBits & 0x40000000L) != 0L) {
                this.problemReporter().superTypeCannotUseWildcard(sourceTypeBinding, typeReference, referenceBinding);
            } else if (referenceBinding.erasure().id == 41) {
                this.problemReporter().cannotExtendEnum(sourceTypeBinding, typeReference, referenceBinding);
            } else {
                sourceTypeBinding.superclass = referenceBinding;
                return true;
            }
        }
        sourceTypeBinding.tagBits |= 0x20000L;
        sourceTypeBinding.superclass = this.getJavaLangObject();
        if ((sourceTypeBinding.superclass.tagBits & 0x100L) == 0L) {
            this.detectHierarchyCycle(sourceTypeBinding, sourceTypeBinding.superclass, null);
        }
        return false;
    }

    private boolean connectEnumSuperclass() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        ReferenceBinding referenceBinding = this.getJavaLangEnum();
        boolean bl = this.detectHierarchyCycle(sourceTypeBinding, referenceBinding, null);
        TypeVariableBinding[] typeVariableBindingArray = referenceBinding.typeVariables();
        if (typeVariableBindingArray == Binding.NO_TYPE_VARIABLES) {
            this.problemReporter().nonGenericTypeCannotBeParameterized(null, referenceBinding, new TypeBinding[]{sourceTypeBinding});
            return false;
        }
        if (1 != typeVariableBindingArray.length) {
            this.problemReporter().incorrectArityForParameterizedType(null, referenceBinding, new TypeBinding[]{sourceTypeBinding});
            return false;
        }
        ParameterizedTypeBinding parameterizedTypeBinding = this.environment().createParameterizedType(referenceBinding, new TypeBinding[]{this.environment().convertToRawType(sourceTypeBinding)}, null);
        sourceTypeBinding.superclass = parameterizedTypeBinding;
        if (typeVariableBindingArray[0].boundCheck(parameterizedTypeBinding, sourceTypeBinding) != 0) {
            this.problemReporter().typeMismatchError(referenceBinding, typeVariableBindingArray[0], sourceTypeBinding, null);
        }
        return !bl;
    }

    private boolean connectSuperInterfaces() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        sourceTypeBinding.superInterfaces = Binding.NO_SUPERINTERFACES;
        if (this.referenceContext.superInterfaces == null) {
            if (sourceTypeBinding.isAnnotationType() && this.compilerOptions().sourceLevel >= 0x310000L) {
                ReferenceBinding referenceBinding = this.getJavaLangAnnotationAnnotation();
                boolean bl = this.detectHierarchyCycle(sourceTypeBinding, referenceBinding, null);
                sourceTypeBinding.superInterfaces = new ReferenceBinding[]{referenceBinding};
                return !bl;
            }
            return true;
        }
        if (sourceTypeBinding.id == 1) {
            return true;
        }
        boolean bl = true;
        int n = this.referenceContext.superInterfaces.length;
        ReferenceBinding[] referenceBindingArray = new ReferenceBinding[n];
        int n2 = 0;
        block0: for (int i = 0; i < n; ++i) {
            TypeReference typeReference = this.referenceContext.superInterfaces[i];
            ReferenceBinding referenceBinding = this.findSupertype(typeReference);
            if (referenceBinding == null) {
                sourceTypeBinding.tagBits |= 0x20000L;
                bl = false;
                continue;
            }
            typeReference.resolvedType = referenceBinding;
            for (int j = 0; j < i; ++j) {
                if (referenceBindingArray[j] != referenceBinding) continue;
                this.problemReporter().duplicateSuperinterface(sourceTypeBinding, typeReference, referenceBinding);
                continue block0;
            }
            if (!referenceBinding.isInterface()) {
                this.problemReporter().superinterfaceMustBeAnInterface(sourceTypeBinding, typeReference, referenceBinding);
                sourceTypeBinding.tagBits |= 0x20000L;
                bl = false;
                continue;
            }
            if (referenceBinding.isAnnotationType()) {
                this.problemReporter().annotationTypeUsedAsSuperinterface(sourceTypeBinding, typeReference, referenceBinding);
            }
            if ((referenceBinding.tagBits & 0x40000000L) != 0L) {
                this.problemReporter().superTypeCannotUseWildcard(sourceTypeBinding, typeReference, referenceBinding);
                sourceTypeBinding.tagBits |= 0x20000L;
                bl = false;
                continue;
            }
            referenceBindingArray[n2++] = referenceBinding;
        }
        if (n2 > 0) {
            if (n2 != n) {
                ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2];
                System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 0, n2);
            }
            sourceTypeBinding.superInterfaces = referenceBindingArray;
        }
        return bl;
    }

    void connectTypeHierarchy() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        if ((sourceTypeBinding.tagBits & 0x100L) == 0L) {
            sourceTypeBinding.tagBits |= 0x100L;
            boolean bl = this.connectSuperclass();
            bl &= this.connectSuperInterfaces();
            sourceTypeBinding.tagBits |= 0x200L;
            sourceTypeBinding.tagBits |= 0x40000L;
            if ((bl &= this.connectTypeVariables(this.referenceContext.typeParameters, false)) && sourceTypeBinding.isHierarchyInconsistent()) {
                this.problemReporter().hierarchyHasProblems(sourceTypeBinding);
            }
        }
        this.connectMemberTypes();
        LookupEnvironment lookupEnvironment = this.environment();
        try {
            lookupEnvironment.missingClassFileLocation = this.referenceContext;
            this.checkForInheritedMemberTypes(sourceTypeBinding);
        }
        catch (AbortCompilation abortCompilation) {
            abortCompilation.updateContext(this.referenceContext, this.referenceCompilationUnit().compilationResult);
            throw abortCompilation;
        }
        finally {
            lookupEnvironment.missingClassFileLocation = null;
        }
    }

    private void connectTypeHierarchyWithoutMembers() {
        if (this.parent instanceof CompilationUnitScope) {
            if (((CompilationUnitScope)this.parent).imports == null) {
                ((CompilationUnitScope)this.parent).checkAndSetImports();
            }
        } else if (this.parent instanceof ClassScope) {
            ((ClassScope)this.parent).connectTypeHierarchyWithoutMembers();
        }
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        if ((sourceTypeBinding.tagBits & 0x100L) != 0L) {
            return;
        }
        sourceTypeBinding.tagBits |= 0x100L;
        boolean bl = this.connectSuperclass();
        bl &= this.connectSuperInterfaces();
        sourceTypeBinding.tagBits |= 0x200L;
        sourceTypeBinding.tagBits |= 0x40000L;
        if ((bl &= this.connectTypeVariables(this.referenceContext.typeParameters, false)) && sourceTypeBinding.isHierarchyInconsistent()) {
            this.problemReporter().hierarchyHasProblems(sourceTypeBinding);
        }
    }

    public boolean detectHierarchyCycle(TypeBinding typeBinding, TypeReference typeReference, TypeBinding[] typeBindingArray) {
        if (!(typeBinding instanceof ReferenceBinding)) {
            return false;
        }
        if (typeReference == this.superTypeReference) {
            if (typeBinding.isTypeVariable()) {
                return false;
            }
            if (typeBinding.isParameterizedType()) {
                typeBinding = ((ParameterizedTypeBinding)typeBinding).type;
            }
            this.compilationUnitScope().recordSuperTypeReference(typeBinding);
            return this.detectHierarchyCycle(this.referenceContext.binding, (ReferenceBinding)typeBinding, typeReference);
        }
        if ((typeBinding.tagBits & 0x100L) == 0L && typeBinding instanceof SourceTypeBinding) {
            ((SourceTypeBinding)typeBinding).scope.connectTypeHierarchyWithoutMembers();
        }
        return false;
    }

    private boolean detectHierarchyCycle(SourceTypeBinding sourceTypeBinding, ReferenceBinding referenceBinding, TypeReference typeReference) {
        TypeReference typeReference2;
        if (referenceBinding.isRawType()) {
            referenceBinding = ((RawTypeBinding)referenceBinding).type;
        }
        if (sourceTypeBinding == referenceBinding) {
            this.problemReporter().hierarchyCircularity(sourceTypeBinding, referenceBinding, typeReference);
            sourceTypeBinding.tagBits |= 0x20000L;
            return true;
        }
        if (referenceBinding.isBinaryBinding()) {
            ReferenceBinding[] referenceBindingArray;
            boolean bl = false;
            ReferenceBinding referenceBinding2 = referenceBinding.superclass();
            if (referenceBinding2 != null) {
                if (sourceTypeBinding == referenceBinding2) {
                    this.problemReporter().hierarchyCircularity(sourceTypeBinding, referenceBinding, typeReference);
                    sourceTypeBinding.tagBits |= 0x20000L;
                    referenceBinding.tagBits |= 0x20000L;
                    return true;
                }
                if (referenceBinding2.isParameterizedType()) {
                    referenceBinding2 = ((ParameterizedTypeBinding)referenceBinding2).type;
                }
                bl |= this.detectHierarchyCycle(sourceTypeBinding, referenceBinding2, typeReference);
                if ((referenceBinding2.tagBits & 0x20000L) != 0L) {
                    sourceTypeBinding.tagBits |= 0x20000L;
                    referenceBinding2.tagBits |= 0x20000L;
                }
            }
            if ((referenceBindingArray = referenceBinding.superInterfaces()) != null && referenceBindingArray != Binding.NO_SUPERINTERFACES) {
                for (ReferenceBinding referenceBinding3 : referenceBindingArray) {
                    if (sourceTypeBinding == referenceBinding3) {
                        this.problemReporter().hierarchyCircularity(sourceTypeBinding, referenceBinding, typeReference);
                        sourceTypeBinding.tagBits |= 0x20000L;
                        referenceBinding.tagBits |= 0x20000L;
                        return true;
                    }
                    if (referenceBinding3.isParameterizedType()) {
                        referenceBinding3 = ((ParameterizedTypeBinding)referenceBinding3).type;
                    }
                    bl |= this.detectHierarchyCycle(sourceTypeBinding, referenceBinding3, typeReference);
                    if ((referenceBinding3.tagBits & 0x20000L) == 0L) continue;
                    sourceTypeBinding.tagBits |= 0x20000L;
                    referenceBinding.tagBits |= 0x20000L;
                }
            }
            return bl;
        }
        if (referenceBinding.isHierarchyBeingConnected() && (typeReference2 = ((SourceTypeBinding)referenceBinding).scope.superTypeReference) != null && (typeReference2.resolvedType == null || ((ReferenceBinding)typeReference2.resolvedType).isHierarchyBeingConnected())) {
            this.problemReporter().hierarchyCircularity(sourceTypeBinding, referenceBinding, typeReference);
            sourceTypeBinding.tagBits |= 0x20000L;
            referenceBinding.tagBits |= 0x20000L;
            return true;
        }
        if ((referenceBinding.tagBits & 0x100L) == 0L) {
            ((SourceTypeBinding)referenceBinding).scope.connectTypeHierarchyWithoutMembers();
        }
        if ((referenceBinding.tagBits & 0x20000L) != 0L) {
            sourceTypeBinding.tagBits |= 0x20000L;
        }
        return false;
    }

    private ReferenceBinding findSupertype(TypeReference typeReference) {
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        LookupEnvironment lookupEnvironment = compilationUnitScope.environment;
        try {
            ReferenceBinding referenceBinding;
            lookupEnvironment.missingClassFileLocation = typeReference;
            typeReference.aboutToResolve(this);
            compilationUnitScope.recordQualifiedReference(typeReference.getTypeName());
            this.superTypeReference = typeReference;
            ReferenceBinding referenceBinding2 = referenceBinding = (ReferenceBinding)typeReference.resolveSuperType(this);
            return referenceBinding2;
        }
        catch (AbortCompilation abortCompilation) {
            SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
            if (sourceTypeBinding.superInterfaces == null) {
                sourceTypeBinding.superInterfaces = Binding.NO_SUPERINTERFACES;
            }
            abortCompilation.updateContext(typeReference, this.referenceCompilationUnit().compilationResult);
            throw abortCompilation;
        }
        finally {
            lookupEnvironment.missingClassFileLocation = null;
            this.superTypeReference = null;
        }
    }

    @Override
    public ProblemReporter problemReporter() {
        MethodScope methodScope = this.outerMostMethodScope();
        if (methodScope == null) {
            ProblemReporter problemReporter = this.referenceCompilationUnit().problemReporter;
            problemReporter.referenceContext = this.referenceContext;
            return problemReporter;
        }
        return methodScope.problemReporter();
    }

    public TypeDeclaration referenceType() {
        return this.referenceContext;
    }

    public String toString() {
        if (this.referenceContext != null) {
            return "--- Class Scope ---\n\n" + this.referenceContext.binding.toString();
        }
        return "--- Class Scope ---\n\n Binding not initialized";
    }
}

