/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import serpro.ppgd.gui.ConstantesGlobaisGUI;
import serpro.ppgd.gui.EditCampo;
import serpro.ppgd.gui.editors.PPGDFormattedTextField;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.UtilitariosString;

public class EditValor
extends EditCampo {
    private static Valor vazio = new Valor(null, "EditValor");
    private static String maskara = "###.###.##0,00";
    protected JFormattedTextField componente;
    protected boolean aceitaNumerosNegativos = false;

    public EditValor() {
        this(vazio);
    }

    public EditValor(Informacao informacao) {
        super(informacao, maskara.length());
    }

    protected EditValor(Informacao informacao, int n) {
        super(informacao, n);
    }

    public boolean isAceitaNumerosNegativos() {
        return this.aceitaNumerosNegativos;
    }

    public void setAceitaNumerosNegativos(boolean bl) {
        this.aceitaNumerosNegativos = bl;
    }

    @Override
    public void setInformacao(Informacao informacao) {
        if (this.componente == null) {
            this.componente = new PPGDFormattedTextField();
            this.componente.setHorizontalAlignment(11);
            this.componente.setFont(ConstantesGlobaisGUI.FONTE_9_NORMAL);
            this.componente.setHorizontalAlignment(4);
            this.componente.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    if (EditValor.this.isSelecionaTextoOnFocusGained()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                EditValor.this.componente.selectAll();
                            }
                        });
                    }
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (focusEvent.getOppositeComponent() != null) {
                        EditValor.this.setIdentificacaoFoco(false);
                        if (EditValor.this.getInformacao().getListaValidadoresImpeditivos().isEmpty() || EditValor.this.verificaValidacoesImpeditivas(EditValor.this.componente.getText())) {
                            EditValor.this.getInformacao().setConteudo(EditValor.this.componente.getText());
                            EditValor.this.componente.setText(EditValor.this.getInformacao().getConteudoFormatado());
                            EditValor.this.chamaValidacao();
                        }
                    }
                }
            });
            this.componente.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    EditValor.this.trataEventoKeyTyped(keyEvent);
                }
            });
        }
        ((PPGDFormattedTextField)this.componente).setInformacao(this.getInformacao());
        this.implementacaoPropertyChange(null);
    }

    protected void trataEventoKeyTyped(KeyEvent keyEvent) {
        boolean bl;
        boolean bl2 = bl = (keyEvent.getKeyChar() == '\t' || keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\b' || keyEvent.getKeyChar() == '\u007f' || keyEvent.getKeyChar() == '%' || keyEvent.getKeyChar() == '\'') && !String.valueOf(keyEvent.getKeyChar()).equals("%") && !String.valueOf(keyEvent.getKeyChar()).equals("'");
        if (!bl) {
            boolean bl3;
            char c;
            int n;
            String string = this.componente.getText();
            int n2 = UtilitariosString.retiraMascara(string).length();
            boolean bl4 = false;
            Valor valor = (Valor)this.getInformacao();
            int n3 = string.indexOf(44);
            if (n3 != -1) {
                n = valor.getMaximoDigitosParteInteira() + valor.getCasasDecimais();
                String string2 = string.substring(n3 + 1);
                if (string2.length() == valor.getCasasDecimais() && this.componente.getCaretPosition() > n3 && this.componente.getSelectedText() == null) {
                    bl4 = true;
                }
            } else {
                n = valor.getMaximoDigitosParteInteira();
            }
            if (keyEvent.getKeyChar() == ',') {
                n = valor.getMaximoDigitosParteInteira() + valor.getCasasDecimais();
            }
            boolean bl5 = (c = keyEvent.getKeyChar()) != '\t' && c != '\n' && c != '\b' && c != '\u007f' && c != '%' && c != '\'';
            boolean bl6 = false;
            if (this.componente.getText().trim().indexOf("-") != -1) {
                bl6 = true;
            }
            boolean bl7 = false;
            if (this.componente.getText().trim().indexOf(",") != -1) {
                bl7 = true;
            }
            boolean bl8 = bl3 = !Character.isDigit(keyEvent.getKeyChar()) && keyEvent.getKeyChar() != '-' && keyEvent.getKeyChar() != '.' && keyEvent.getKeyChar() != ',' && keyEvent.getKeyChar() != ' ';
            if (n2 >= n && bl5 && this.componente.getSelectedText() == null || keyEvent.getKeyChar() == '-' && !this.aceitaNumerosNegativos || Character.isLetter(keyEvent.getKeyChar()) || bl4 || keyEvent.getKeyChar() == '-' && bl6 || bl6 && n2 + 1 >= n || keyEvent.getKeyChar() == '\'' || keyEvent.getKeyChar() == '\"' || String.valueOf(keyEvent.getKeyChar()).equals("\u00b4") || String.valueOf(keyEvent.getKeyChar()).equals("`") || String.valueOf(keyEvent.getKeyChar()).equals("^") || String.valueOf(keyEvent.getKeyChar()).equals("@") || String.valueOf(keyEvent.getKeyChar()).equals("~") || String.valueOf(keyEvent.getKeyChar()).equals("'") || String.valueOf(keyEvent.getKeyChar()).equals("%") || keyEvent.getKeyChar() == ',' && bl7 || keyEvent.getKeyChar() == ',' && valor.getCasasDecimais() == 0 || bl3) {
                keyEvent.setKeyChar('\uffff');
                keyEvent.consume();
                UIManager.getLookAndFeel().provideErrorFeedback(this.componente);
            }
        }
    }

    @Override
    public void implementacaoPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.componente.setText(this.getInformacao().getConteudoFormatado());
    }

    @Override
    public JComponent getComponenteEditor() {
        return this.componente;
    }

    @Override
    protected void readOnlyPropertyChange(boolean bl) {
        if (bl) {
            this.componente.setEditable(false);
        } else {
            this.componente.setEditable(true);
        }
    }

    @Override
    protected void habilitadoPropertyChange(boolean bl) {
        this.componente.setEnabled(bl);
        this.labelCampo.setEnabled(bl);
    }

    @Override
    public JComponent getComponenteFoco() {
        return this.componente;
    }

    @Override
    public void setPerdeFocoComEnter(boolean bl) {
        this.isPerdeFocoComEnter = bl;
        if (this.isPerdeFocoComEnter()) {
            this.aplicaTransfereFocoEnter();
        } else {
            this.removeTransfereFocoEnter();
        }
    }
}

