/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.espolio;

import java.util.List;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.espolio.EscrituracaoPublica;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNome;

public class Espolio
extends ObjetoNegocio {
    protected transient IdentificadorDeclaracao identificadorDeclaracao = null;
    private CPF cpfInventariante = new CPF(this, "CPF");
    private Alfa nomeInventariante = new Alfa(this, "Nome", 60);
    private Alfa endInventariante = new Alfa(this, "Endere\u00e7o", 70);
    private EscrituracaoPublica escrituracaoPublica = new EscrituracaoPublica();

    public Espolio(IdentificadorDeclaracao identificadorDeclaracao) {
        this.identificadorDeclaracao = identificadorDeclaracao;
        this.setFicha("Esp\u00f3lio");
        this.getCpfInventariante().addValidador(new ValidadorCPF(3));
        this.getCpfInventariante().addValidador(new ValidadorDefault(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Espolio.this.getCpfInventariante().asString().equals(Espolio.this.identificadorDeclaracao.getCpf().asString())) {
                    return new RetornoValidacao(tab.msg("espolio_cpf"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getNomeInventariante().addValidador(new ValidadorNaoNulo(3, this.tab.msg("espolio_nome_branco")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Espolio.this.getCpfInventariante().isVazio()) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getCpfInventariante().addValidador(new ValidadorNaoNulo(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (!Espolio.this.getNomeInventariante().isVazio() && Espolio.this.getCpfInventariante().isVazio()) {
                    return new RetornoValidacao(tab.msg("espolio_cpf_branco"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getNomeInventariante().addValidador(new ValidadorNome(3));
    }

    public void setCpfInventariante(CPF cPF) {
        this.cpfInventariante = cPF;
    }

    public CPF getCpfInventariante() {
        return this.cpfInventariante;
    }

    public void setNomeInventariante(Alfa alfa) {
        this.nomeInventariante = alfa;
    }

    public Alfa getNomeInventariante() {
        return this.nomeInventariante;
    }

    public void setEndInventariante(Alfa alfa) {
        this.endInventariante = alfa;
    }

    public Alfa getEndInventariante() {
        return this.endInventariante;
    }

    @Override
    protected List recuperarListaCamposPendencia() {
        List list = this.recuperarCamposInformacao();
        return list;
    }

    public EscrituracaoPublica getEscrituracaoPublica() {
        return this.escrituracaoPublica;
    }
}

