/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.util;

import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import serpro.ppgd.gui.pendencia.MapeamentoInformacaoEditCampo;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.treeview.ArvoreGenerica;
import serpro.ppgd.infraestrutura.treeview.NoGenerico;
import serpro.ppgd.infraestrutura.util.PainelCacher;
import serpro.ppgd.infraestrutura.util.ProcessoSwing;
import serpro.ppgd.infraestrutura.util.Tarefa;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.gui.comparativo.PainelComparativo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.TabelaMensagens;

public class IRPFUtil {
    public static final int EM_PREENCHIMENTO = 0;
    public static final int EM_PENDENCIA = 1;
    private static int estadoSistema = 0;
    public static String[] listaComponentesAbrirFechar = new String[]{"btnFechar", "btnFichaAnterior", "btnFichaProxima", "btnExibeTree", "btnVerPendencias", "mnuFechar", "mnuVerPendencias", "mnuConverter"};
    private static String[] listaComponentesTemDeclaracao = new String[]{"btnAbrir", "mnuAbrir", "btnGravarEntrega", "mnuGravarEntrega", "mnuGravarCopia", "mnuImprimirDeclaracao", "mnuImprimirDarf", "popUpImprimirDeclaracao", "popUpImprimirDARF"};
    public static boolean temDeclaracaoAberta = false;
    public static String DIR_DADOS = FabricaUtilitarios.getPathCompletoDirDadosAplicacao();

    public static void abrirDeclaracao(final IdentificadorDeclaracao identificadorDeclaracao, boolean bl) {
        if (bl) {
            ProcessoSwing.executa(new Tarefa(){

                @Override
                public Object run() {
                    PlataformaPPGD.getPlataforma().getJanelaPrincipal().setEnabled(false);
                    IRPFFacade.abreDeclaracao(identificadorDeclaracao);
                    PlataformaPPGD.getPlataforma().getJanelaPrincipal().setEnabled(true);
                    return null;
                }
            });
        } else {
            PlataformaPPGD.getPlataforma().getJanelaPrincipal().setEnabled(false);
            IRPFFacade.abreDeclaracao(identificadorDeclaracao);
            PlataformaPPGD.getPlataforma().getJanelaPrincipal().setEnabled(true);
        }
        temDeclaracaoAberta = true;
        PainelCacher.getInstance().inicia();
        JSplitPane jSplitPane = (JSplitPane)PlataformaPPGD.getPlataforma().getComponent("splitPPGD");
        jSplitPane.setVisible(true);
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().validate();
        PlataformaPPGD.getPlataforma().habilitaComponentes(listaComponentesAbrirFechar);
        PlataformaPPGD.getPlataforma().getComponent("mnuFichas").setVisible(true);
        PlataformaPPGD.getPlataforma().getComponent("mnuPreenchimento").setVisible(true);
        IRPFUtil.atualizaTituloDeclaracaoAberta();
        IRPFUtil.atualizaTreeMenu();
        ArvoreGenerica arvoreGenerica = (ArvoreGenerica)PlataformaPPGD.getPlataforma().getComponent("ppgdarvore");
        arvoreGenerica.selecionaNodoInicial();
    }

    public static void atualizaTituloDeclaracaoAberta() {
        String string = FabricaUtilitarios.getProperties().getProperty("titulo");
        String string2 = null;
        string2 = IRPFFacade.getInstancia().getIdDeclaracaoAberto().getTipoDeclaracao().asString().equals("1") ? TabelaMensagens.getTabelaMensagens().msg("dec_simplificada") : TabelaMensagens.getTabelaMensagens().msg("dec_completa");
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().setTitle(string + " - " + IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf().getConteudoFormatado() + " - " + IRPFFacade.getInstancia().getIdDeclaracaoAberto().getNome().getConteudoFormatado() + " - " + string2);
    }

    public static void atualizaTreeMenu() {
        TabelaMensagens tabelaMensagens = TabelaMensagens.getTabelaMensagens();
        boolean bl = IRPFFacade.getInstancia().getIdDeclaracaoAberto().getTipoDeclaracao().asString().equals("1");
        ArvoreGenerica arvoreGenerica = (ArvoreGenerica)PlataformaPPGD.getPlataforma().getComponent("ppgdarvore");
        NoGenerico noGenerico = null;
        if (arvoreGenerica.getSelectionPath() != null && arvoreGenerica.getSelectionPath().getLastPathComponent() != null) {
            noGenerico = (NoGenerico)arvoreGenerica.getSelectionPath().getLastPathComponent();
        }
        if (bl) {
            arvoreGenerica.setNodoVisivel(tabelaMensagens.msg("tree_rend_tributaveis_deducoes"), false);
        } else {
            arvoreGenerica.setNodoVisivel(tabelaMensagens.msg("tree_rend_tributaveis_deducoes"), true);
            arvoreGenerica.setNodoVisivel(tabelaMensagens.msg("tree_calculo_imposto"), false);
            arvoreGenerica.setNodoVisivel(tabelaMensagens.msg("tree_calculo_imposto"), true);
            arvoreGenerica.setNodoVisivel(tabelaMensagens.msg("tree_outras_informacoes"), false);
            arvoreGenerica.setNodoVisivel(tabelaMensagens.msg("tree_outras_informacoes"), true);
            arvoreGenerica.setNodoVisivel(tabelaMensagens.msg("tree_comparativo"), false);
            arvoreGenerica.setNodoVisivel(tabelaMensagens.msg("tree_comparativo"), true);
        }
        if (noGenerico != null) {
            arvoreGenerica.selecionarNodo(noGenerico.getNome());
            arvoreGenerica.expandPath(arvoreGenerica.encontrarObjetoNaTree(arvoreGenerica.getVctNos().get(noGenerico.getNome())));
        }
        JMenuItem jMenuItem = (JMenuItem)PlataformaPPGD.getPlataforma().getComponent("mnuConverter");
        jMenuItem.setText(bl ? tabelaMensagens.msg("opcao_converter_dec_completa") : tabelaMensagens.msg("opcao_converter_dec_simplificada"));
    }

    public static void excluirDeclaracao(List list) {
        IRPFFacade.excluirDeclaracao(list);
    }

    public static void fecharDeclaracao() {
        Object object;
        Object object2;
        if (temDeclaracaoAberta) {
            Class<JPanel> clazz;
            IRPFFacade.getInstancia();
            object2 = IRPFFacade.getDeclaracao();
            object = new Class[1];
            int n = 0;
            object[n] = clazz = JPanel.class;
            ((ObjetoNegocio)object2).removeObservadores((Class[])object);
            IRPFFacade.salvaDeclaracaoAberta();
        }
        temDeclaracaoAberta = false;
        PainelCacher.getInstance().encerra();
        object2 = (JSplitPane)PlataformaPPGD.getPlataforma().getComponent("splitPPGD");
        ((JComponent)object2).setVisible(false);
        PlataformaPPGD.getPlataforma().desabilitaComponentes(listaComponentesAbrirFechar);
        PlataformaPPGD.getPlataforma().getComponent("mnuFichas").setVisible(false);
        PlataformaPPGD.getPlataforma().getComponent("mnuPreenchimento").setVisible(false);
        object = FabricaUtilitarios.getProperties().getProperty("titulo");
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().setTitle((String)object);
        MapeamentoInformacaoEditCampo.limpaAssociacoes();
        IRPFFacade.fechaDeclaracao();
    }

    public static void habilitaComponentesAbrirFechar() {
        PlataformaPPGD.getPlataforma().habilitaComponentes(listaComponentesAbrirFechar);
    }

    public static void habilitaComponentesTemDeclaracao() {
        if (IRPFFacade.getInstancia().existeDeclaracoes()) {
            PlataformaPPGD.getPlataforma().habilitaComponentes(listaComponentesTemDeclaracao);
        } else {
            PlataformaPPGD.getPlataforma().desabilitaComponentes(listaComponentesTemDeclaracao);
        }
    }

    public static void converterDeclaracao(DeclaracaoIRPF declaracaoIRPF) {
        if (!declaracaoIRPF.getIdentificadorDeclaracao().isCompleta()) {
            declaracaoIRPF.getIdentificadorDeclaracao().getTipoDeclaracao().setConteudo("0");
        } else {
            declaracaoIRPF.getIdentificadorDeclaracao().getTipoDeclaracao().setConteudo("1");
        }
        if (temDeclaracaoAberta) {
            PainelCacher painelCacher = PainelCacher.getInstance();
            Class<PainelComparativo> clazz = PainelComparativo.class;
            PainelComparativo painelComparativo = (PainelComparativo)painelCacher.obtemUrgentemente(clazz.getName());
            painelComparativo.atualizaBotaoOpcao();
            IRPFUtil.atualizaTituloDeclaracaoAberta();
            IRPFUtil.atualizaTreeMenu();
        }
    }

    public static void setEstadoSistema(int n) {
        estadoSistema = n;
    }

    public static int getEstadoSistema() {
        return estadoSistema;
    }

    static {
        String string = System.getProperty("ppgd.jws");
        if (string != null && string.trim().equals("true")) {
            DIR_DADOS = System.getProperty("user.home") + "/IRPF" + ConstantesGlobais.EXERCICIO + "/aplicacao/dados";
        }
    }
}

